//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QIcon>
#include <QtGui/QGridLayout>
#include <QDebug>
#include "../core/diskcore.h"
#include "../core/diskdevice.h"
#include "const.h"
#include "choosemountpointwidget.h"
#include "widgetformount.h"

WidgetForMount::WidgetForMount(DiskCore *diskCore) {
	core = diskCore;

	headerLabel = new QLabel;
	
	mountPointLabel = new QLabel(tr("Choose mount point, please") + ":");
	mountPointLine = new ChooseMountPointWidget;
	mountPointLine->setReadOnly(false);
	
	optionsLabel = new QLabel(tr("Options") + ":");
	optionsLine = new QLineEdit;

	hideButton = new QPushButton;
	hideButton->setIcon(QIcon(ICONS_PATH"cancel.png"));
	hideButton->setFlat(true);
	connect(hideButton,SIGNAL(clicked()),this,SLOT(hide()));
	
	mountButton = new QPushButton(tr("Mount"));
	mountButton->setIcon(QIcon(ICONS_PATH"mount.png"));
	connect(mountButton,SIGNAL(clicked()),this,SLOT(mount()));
	connect(mountPointLine,SIGNAL(mountPointValidSignal(bool)),mountButton,SLOT(setEnabled(bool)));
	mountButton->setEnabled(false);
	
	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->setMargin(0);

	QHBoxLayout *buttonsLayout = new QHBoxLayout;
	buttonsLayout->addStretch();
	buttonsLayout->addWidget(mountButton);

	QHBoxLayout *hideButtonLayout = new QHBoxLayout;
	hideButtonLayout->setMargin(0);
	hideButtonLayout->addWidget(headerLabel);
	hideButtonLayout->addStretch();
	hideButtonLayout->addWidget(hideButton);

	mainLayout->addLayout(hideButtonLayout,0,0,1,2);
	mainLayout->addWidget(mountPointLabel,1,0);
	mainLayout->addWidget(mountPointLine,1,1);
	mainLayout->addWidget(optionsLabel,2,0);
	mainLayout->addWidget(optionsLine,2,1);
	mainLayout->addLayout(buttonsLayout,3,0,1,2);
	mainLayout->addWidget(new QLabel("<hr>"),4,0,1,2);
	mainLayout->setColumnStretch(1,1);
	
	setLayout(mainLayout);
}

WidgetForMount::~WidgetForMount() {
	delete mountPointLabel;
	delete mountPointLine;
	delete optionsLabel;
	delete optionsLine;

	delete hideButton;
	delete mountButton;
}

void WidgetForMount::setOptionsForMount(const QString& blockName,const QString& mountPoint,const QString& fileSystem,const QString& options) {
	headerLabel->setText("<b><font size=4>" + tr("Mounting of partition %1").arg(blockName) + "</font></b>");
	mountPointLine->setMountPoint(mountPoint);
	if (options.isEmpty())
		optionsLine->setText("defaults");
	else
		optionsLine->setText(options);
	currentFileSystem = fileSystem;
	currentBlockName = blockName;
}

void WidgetForMount::mount() {	
	qDebug() << "[I] Mount the partition" << currentBlockName << "with options" << optionsLine->text() << "to" << mountPointLine->mountPoint();
	core->mount(currentBlockName,mountPointLine->mountPoint(),currentFileSystem,optionsLine->text());
	hide();
}
