//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QLabel>
#include <QHBoxLayout>
#include <QPushButton>
#include "usbmanagerfscellwidget.h"
#include "const.h"

UsbManagerFsCellWidget::UsbManagerFsCellWidget(int index) {
	cellIndex = index;

	fileSystemLabel = new QLabel;
	optionsLabel = new QLabel;
	
	editButton = new QPushButton;
	editButton->setIcon(QIcon(ICONS_PATH"set_auto_mount.png"));
	connect(editButton,SIGNAL(clicked()),this,SIGNAL(editFsOptionsSignal()));
	
	QFrame *verticalFrame1 = new QFrame;
	verticalFrame1->setFrameStyle(QFrame::VLine|QFrame::Sunken);
	QFrame *verticalFrame2 = new QFrame;
	verticalFrame2->setFrameStyle(QFrame::VLine|QFrame::Sunken);
	
	QHBoxLayout *mainLayout = new QHBoxLayout;
	mainLayout->addWidget(fileSystemLabel);
	mainLayout->addWidget(verticalFrame1);
	mainLayout->addWidget(optionsLabel);
	mainLayout->addStretch();
	mainLayout->addWidget(verticalFrame2);
	mainLayout->addWidget(editButton);
	mainLayout->setMargin(5);
	mainLayout->setSpacing(3);
	setLayout(mainLayout);
}

UsbManagerFsCellWidget::~UsbManagerFsCellWidget() {
	delete fileSystemLabel;
	delete optionsLabel;
	delete editButton;
}

void UsbManagerFsCellWidget::setOptions(const QString &options) {
	optionsLabel->setText(options);
}

void UsbManagerFsCellWidget::setFileSystem(const QString &fs) {
	fileSystemLabel->setText(fs);
}

void UsbManagerFsCellWidget::setIdentifier(const QString &ind) {
	cellIdentifier = ind;
}

const QString& UsbManagerFsCellWidget::identifier() const {
	return cellIdentifier;
}

void UsbManagerFsCellWidget::setRow(int row) {
	cellRow = row;
}

int UsbManagerFsCellWidget::row() const {
	return cellRow;
}

QString UsbManagerFsCellWidget::fileSystem() const {
	return fileSystemLabel->text();
}

int UsbManagerFsCellWidget::index() const {
	return cellIndex;
}