//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef OPTIONSTABLE_H
#define OPTIONSTABLE_H

#include <QtGui/QTableWidget>
#include <QtCore/QList>

class Option;
class PopupWindow;
class QCheckBox;
class QComboBox;
class QSpinBox;
class PermissionsWidget;
class QLabel;
class DiskDevice;

struct WidgetRow {
	QWidget *cellWidget;
	int type;
	QCheckBox *checkBox;
	QComboBox *comboBox;
	QLabel *label;
	// For spin box option
	QLabel *extraLabel;
	QSpinBox *spinBox;
	PermissionsWidget *permWidget;
	QString source;
	int row;
	Option *option;
};

class OptionsTable : public QTableWidget
{
	Q_OBJECT
	signals:
		void optionChanged();
	private:
		PopupWindow *popup;
		DiskDevice *device;

		QList<WidgetRow *> widgetRows;
		
		enum OptionType { CheckBox, ComboBox, SpinBox, Perm };

		QString currentFilter;
		QString currentTypeFilter;
		QStringList fixedFilter;
		
		void addCheckBoxOption(Option *option,const QString& source);
		void addComboBoxOption(Option *option,const QString& source);
		void addSpinBoxOption(Option *option,const QString& source);
		void addPermOption(Option *option,const QString &source);
	public:
		OptionsTable(DiskDevice *device,PopupWindow *popupWindow);
		~OptionsTable();
		
		void addOptions(const QList<Option *>& options,const QString& source);

		void setFilter(const QString &filterText);
		void setFixedFilter(const QString& filter);
		void setFixedFilter(QStringList filters);
		
		void showOptionsFromSource(QString source);
		QString options(bool includeDefaultOptions);
};

#endif
