//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Documentation panel"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QDockWidget>
#include <QtGui/QTextBrowser>
#include <QtGui/QAction>
#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtCore/QLocale>
#include <QtPlugin>
#include "documentationpanel.h"
#include "../../sources/gui/const.h"

DocumentationPanel::DocumentationPanel(QWidget *parent) {
	
	language = QLocale().name();
	language = language.remove(language.indexOf("_"),language.length());
	documentationPath = DOC_PATH + language + '/';

	QFile file;
	file.close();
	file.setFileName(documentationPath + "General/mount_point.html");
	QTextStream stream(&file);
	file.open(QIODevice::ReadOnly);
	mountPointDocText = stream.readAll();
	file.close();
	file.setFileName(documentationPath + "General/dump.html");
	file.open(QIODevice::ReadOnly);
	dumpDocText = stream.readAll();
	file.close();
	file.setFileName(documentationPath + "General/fsck.html");
	file.open(QIODevice::ReadOnly);
	fsckDocText = stream.readAll();
	
	mainWidget = new QDockWidget(parent);
	mainWidget->setObjectName("DocumentationPanel");
	mainWidget->setWindowTitle(tr("Documentation"));
	mainWidget->setAllowedAreas(Qt::RightDockWidgetArea);
	textBrowser = new QTextBrowser;
	mainWidget->setWidget(textBrowser);

	QAction *action = mainWidget->toggleViewAction();
	action->setText(tr("Documentation panel"));
	actions.append(action);
}

DocumentationPanel::~DocumentationPanel() {
	foreach (QAction *action,actions)
		delete action;
	delete textBrowser;
	delete mainWidget;
}

void DocumentationPanel::setParent(QObject *parent) {
	connect(parent,SIGNAL(currentDeviceFsChanged(const QString &)),this,SLOT(setFileSystem(const QString &)));
}

const QString DocumentationPanel::pluginName() const {
	return tr("Documentation");
}

const QString DocumentationPanel::pluginDescription() const {
	return tr("Dinamic documentation panel, where you can read information about file system and other things");
}

QDialog* DocumentationPanel::dialog() const {
	return 0;
}

QDockWidget* DocumentationPanel::dockWidget() const {
	return mainWidget;
}

QMenu* DocumentationPanel::menu() const {
	return 0;
}

QToolBar* DocumentationPanel::toolBar() const {
	return 0;
}

Actions DocumentationPanel::menuActions() const {
	return actions;
}

void DocumentationPanel::updateTextBrowser() {
	QString docText;
	QFile fsFile(documentationPath + "FileSystems/" + currentFileSystem + ".html");
	fsFile.open(QIODevice::ReadOnly);
	QTextStream fsStream(&fsFile);
	docText += fsStream.readAll();
	docText += mountPointDocText;
	docText += dumpDocText;
	docText += fsckDocText;
	textBrowser->setHtml(docText);
}

void DocumentationPanel::setFileSystem(const QString &fileSystem) {
	currentFileSystem = fileSystem;
	updateTextBrowser();
}

Q_EXPORT_PLUGIN2(documentationpanel,DocumentationPanel)
