/*	video.h
 *
 *	Include file for video.c
 *      Copyright 2000 by Jeroen Vreeken (pe1rxq@amsat.org)
 *      This software is distributed under the GNU public license version 2
 *      See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_VIDEO_H
#define _INCLUDE_VIDEO_H

#define _LINUX_TIME_H 1
#ifndef WITHOUT_V4L
#include <linux/videodev.h>
#endif

/* video4linux stuff */
#define NORM_DEFAULT    0
#define NORM_PAL        0
#define NORM_NTSC       1
#define NORM_SECAM      2
#define NORM_PAL_NC	3
#define IN_DEFAULT      8
#define IN_TV           0
#define IN_COMPOSITE    1
#define IN_COMPOSITE2   2
#define IN_SVIDEO       3

#define VIDEO_DEVICE "/dev/video0"

struct video_dev {
	int fd;
	char *video_device;
	int input;
	int width;
	int height;
	unsigned long freq;

	pthread_mutex_t mutex;
	pthread_mutexattr_t attr;
	int owner;
	int frames;
	
	/* Device type specific stuff: */
#ifndef WITHOUT_V4L	
	/* v4l */
	int v4l_fmt;
	int v4l_read_img;
	unsigned char *v4l_buffers[2];
	int v4l_curbuffer;
	int v4l_maxbuffer;
	int v4l_bufsize;
#endif
};

/* video functions, video.c */
int vid_start (struct context *, int width, int height, int input, int norm, unsigned long frequency);
char *vid_next (struct context *, int dev, char *map, int width, int height);
#ifndef WITHOUT_V4L
void vid_init(void);
int vid_startpipe (char *devname, int width, int height, int);
int vid_putpipe (int dev, char *image, int);
void vid_autobright (struct config *, int dev, char *image, int width, int height);
void vid_close(void);
void vid_cleanup(void);
#endif

#ifdef HAVE_CURL
/* Network camera functions, netcam.c */
int netcam_start (struct context *);
unsigned char *netcam_next (struct context *, char *);
#endif /* HAVE_CURL */

#endif /* _INCLUDE_VIDEO_H */
