#include "rotate.h"
#include "stdlib.h"
#include "string.h"

int rotate_map(char* map, int size, int width, int height, int deg)
{
	/* Palette is YUV 4:2:0 planar (really?), so the pixel data
	 * is laid out like this:
	 *	Y   - width x height bytes
	 *	U   - width x height / 4 bytes
	 *	V   - as U
	 */

	int wh, wh4, w2, h2;
	int i, j;
	char* map_end;    /* pointer to end of map */
	char* rot_map;    /* temporary map for rotated version */
	char* y_src;      /* source pointer for Y */
	char* u_src;      /* source pointer for U */
	char* v_src;      /* source pointer for V */
	char* y_dst;      /* dest pointer for Y */
	char* u_dst;      /* dest pointer for U */
	char* v_dst;      /* dest pointer for V */

	if((deg % 90) > 0) /* entry guard */
		return 1;

	deg %= 360;

	/* pre-calculate some stuff */
	wh = width * height;
	wh4 = (width * height) / 4;
	w2 = width / 2;
	h2 = height / 2;
	
	/* allocate memory and setup pointers */
	map_end = map + size;
	rot_map = malloc(size);

	switch(deg)
	{
		case 90:

			/* first do the Y part */
			y_dst = rot_map;
			for(i = 0; i < width; i++) /* for each column... */
			{
				y_src = map + wh - width + 1 + i;
				for(j = 0; j < height; j++) /* do <height> times */
				{
					*y_dst++ = *y_src;
					y_src -= width;
				}
			}

			/* then do U and V */
			u_dst = rot_map + wh;
			v_dst = u_dst + wh4;
			for(i = 0; i < w2; i++) /* for each block-column */
			{
				u_src = map + wh + w2 * h2 - w2 + 1 + i;
				v_src = u_src + wh4;
				for(j = 0; j < h2; j++) /* do <height>/2 times */
				{
					*u_dst++ = *u_src;
					*v_dst++ = *v_src;
					u_src -= w2;
					v_src -= w2;
				}
			}

			break;
			
		case 180:
			/* 180 degrees is easy - just reverse the data within
			 * Y, U and V.
			 */
			y_src = map;
			u_src = y_src + wh;
			v_src = u_src + wh4;
	
			/* first do the Y part */
			y_dst = rot_map + wh - 1;
			while(y_src < u_src)
				*y_dst-- = *y_src++;

			/* then do U and V */
			u_dst = rot_map + wh + wh4 - 1;
			v_dst = u_dst + wh4;
			while(v_src < map_end) 
			{
				*u_dst-- = *u_src++;
				*v_dst-- = *v_src++;
			}

			break;

		case 270:

			/* first do the Y part */
			y_dst = rot_map;
			for(i = 0; i < width; i++) /* for each column... */
			{
				y_src = map + width - i;
				for(j = 0; j < height; j++) /* do <height> times */
				{
					*y_dst++ = *y_src;
					y_src += width;
				}
			}

			/* then do U and V */
			u_dst = rot_map + wh;
			v_dst = u_dst + wh4;
			for(i = 0; i < w2; i++) /* for each block-column */
			{
				u_src = map + wh + w2 - i;
				v_src = u_src + wh4;
				for(j = 0; j < h2; j++) /* do <height>/2 times */
				{
					*u_dst++ = *u_src;
					*v_dst++ = *v_src;
					u_src += w2;
					v_src += w2;
				}
			}

			break;
			
		default:
			/* do nothing */
			;
	}
	
	/* Copy the rotated map to the original map and free the rotated 
	 * map. 
	 */
	memcpy(map, rot_map, size); 
	free(rot_map);

	return 0;
}
