/*	motion.h
 *
 *	Include file for motion.c
 *      Copyright 2000 by Jeroen Vreeken (pe1rxq@amsat.org)
 *      This software is distributed under the GNU public license version 2
 *      See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_MOTION_H
#define _INCLUDE_MOTION_H

/* Includes */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <syslog.h>
#include <limits.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>

#define _LINUX_TIME_H 1
#if (!defined(WITHOUT_V4L)) && (!defined (__freebsd__))
#include <linux/videodev.h>
#endif

#include <pthread.h>

#ifdef HAVE_MYSQL
#include <mysql.h>
#endif

#ifdef HAVE_PGSQL
#include <libpq-fe.h>
#endif

#include "conf.h"
#include "webcam.h"
#include "control.h"

#if defined(WITHOUT_V4L) || defined(__freebsd__)
 
#define VIDEO_PALETTE_GREY      1       /* Linear greyscale */
#define VIDEO_PALETTE_HI240     2       /* High 240 cube (BT848) */
#define VIDEO_PALETTE_RGB565    3       /* 565 16 bit RGB */
#define VIDEO_PALETTE_RGB24     4       /* 24bit RGB */
#define VIDEO_PALETTE_RGB32     5       /* 32bit RGB */
#define VIDEO_PALETTE_RGB555    6       /* 555 15bit RGB */
#define VIDEO_PALETTE_YUV422    7       /* YUV422 capture */
#define VIDEO_PALETTE_YUYV      8
#define VIDEO_PALETTE_UYVY      9       /* The great thing about standards is ... */
#define VIDEO_PALETTE_YUV420    10
#define VIDEO_PALETTE_YUV411    11      /* YUV411 capture */
#define VIDEO_PALETTE_RAW       12      /* RAW capture (BT848) */
#define VIDEO_PALETTE_YUV422P   13      /* YUV 4:2:2 Planar */
#define VIDEO_PALETTE_YUV411P   14      /* YUV 4:1:1 Planar */
#define VIDEO_PALETTE_YUV420P   15      /* YUV 4:2:0 Planar */
#define VIDEO_PALETTE_YUV410P   16      /* YUV 4:1:0 Planar */
#define VIDEO_PALETTE_PLANAR    13      /* start of planar entries */
#define VIDEO_PALETTE_COMPONENT 7       /* start of component entries */
#endif

/* Default picture settings */
#define DEF_WIDTH              352
#define DEF_HEIGHT             288
#define DEF_QUALITY             75
#define DEF_CHANGES           1500

#define DEF_MAXFRAMERATE       100
#define DEF_NOISELEVEL          32

/* Minimum time between two 'actions' (email, sms, external) */
#define DEF_GAP                 60  /* 1 minutes */
#define DEF_MAXMPEGTIME       3600  /* 60 minutes */

#define DEF_FFMPEG_BPS      400000
#define DEF_FFMPEG_VBR           0
#define DEF_FFMPEG_CODEC   "mpeg1"

#define DEF_PREDICT_THRESHOLD   90
#define THRESHOLD_TUNE_LENGTH  256

#define DEF_MAXSTREAMS          10  /* Maximum number of webcam clients per camera */
#define DEF_MAXWEBQUEUE         10  /* Maximum number of webcam client in queue */

#define DEF_TIMESTAMP      "%Y-%m-%d\\n%T"

#define DEF_SNAPPATH       "%v-%Y%m%d%H%M%S-snapshot"
#define DEF_JPEGPATH       "%v-%Y%m%d%H%M%S-%q"
#define DEF_MPEGPATH       "%v-%Y%m%d%H%M%S"
#define DEF_TIMEPATH       "%Y%m%d-timelapse"
#define DEF_PREDICTPATH    "%v-%Y%m%d%H%M%S"

#define DEF_TIMELAPSE_MODE "daily"

/* Filetype defines */
#define FTYPE_IMAGE            1
#define FTYPE_IMAGE_SNAPSHOT   2
#define FTYPE_IMAGE_MOTION     4
#define FTYPE_MPEG             8
#define FTYPE_MPEG_MOTION     16
#define FTYPE_MPEG_TIMELAPSE  32
#define FTYPE_PREDICT         64

#define FTYPE_MPEG_ANY    (FTYPE_MPEG | FTYPE_MPEG_MOTION | FTYPE_MPEG_TIMELAPSE)
#define FTYPE_IMAGE_ANY   (FTYPE_IMAGE | FTYPE_IMAGE_SNAPSHOT | FTYPE_IMAGE_MOTION)

/* swap two variables using the xor algorithm */
#define myswap(x, y) do { x = ((x) ^ (y)); y = ((x) ^ (y)); x = ((x) ^ (y)); } while(0) 

/* date/time drawing, draw.c */
int draw_text (char *image, int startx, int starty, int height, int width, char *text);

struct images {
	unsigned char *new;
	unsigned char *ref;
	unsigned char *out;
	unsigned char *mask;
	int *labels;
	int *labelsize;
	int width;
	int height;
	int type;
	int size;
	int motionsize;
	int total_labels;
	int labelsize_max;
	int largest_label;
	time_t *timestamp;
	int *shotstamp;
};

#include "track.h"

/*
	these used to be global variables but now each thread will have its
	own context
 */
struct context {
	char conf_filename[2048];
	int threadnr;
	int daemon;

	struct config conf;
	struct images imgs;
	struct trackoptions track;
	int precap_nr;
	int precap_cur;

	int noise;
	int threshold;
	int diffs_last[THRESHOLD_TUNE_LENGTH];

	int snapshot;
	int makemovie;
	int finish;

	int event_nr;
	int prev_event;

	int shots;
	struct tm *currenttime;
	time_t currenttimep;
	time_t lasttime;
	time_t eventtime;
	time_t lastshot;

	int lastrate;
	int filesc;
	int filesmc;
	char **files;
	char **filesm;
	int *filesrate;
	int *filesmrate;
	int moved;
	int switched;
	int pause;
#ifdef __freebsd__
	int tuner_dev;
#endif
	int video_dev;
	int pipe;
	int mpipe;

	struct webcam webcam;
	int stream_count;
	
#if defined(HAVE_MYSQL) || defined(HAVE_PGSQL)
	int sql_mask;
#endif

#ifdef HAVE_MYSQL
	MYSQL *database;
#endif

#ifdef HAVE_PGSQL
	PGconn *database_pg;
#endif

#ifdef HAVE_FFMPEG
	struct ffmpeg *ffmpeg_new;
	struct ffmpeg *ffmpeg_motion;
	struct ffmpeg *ffmpeg_timelapse;
	char newfilename[255];
	char motionfilename[255];
	char timelapsefilename[255];
#endif

	struct coord predict_lastbox;
	int last_diffs;
	struct predict predict;
	struct predict_set *predict_sets;
};

extern int threads_running;

void myperror(char *format, ...);
int http_bindsock(int, int);
void * mymalloc(size_t size);
void * myrealloc(void *ptr, size_t size, char *desc);
FILE * myfopen(char *path, char *mode);
size_t mystrftime(char *s, size_t max, char *userformat,
                  const struct tm *tm, int event_nr, int shots);
int create_path(char *);

#endif /* _INCLUDE_MOTION_H */
