/*
 *	netcam.c
 *
 *	Copyright 2002 by Jeroen Vreeken (pe1rxq@amsat.org)
 *	This software is distributed under the GNU Public License Version 2
 *	See also the file 'COPYING'.
 *
 */
 
#ifdef HAVE_CURL

#include "motion.h"
#include "video.h"
#include <curl/curl.h>
#include <jpeglib.h>

int netcam_start (struct context *cnt)
{
	CURL *curl;
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;
	FILE *jpegfile;

	if ((jpegfile=tmpfile())==NULL)
		return -1;

	curl=curl_easy_init();
	if (curl) {
		curl_easy_setopt(curl, CURLOPT_FILE, jpegfile);
		curl_easy_setopt(curl, CURLOPT_URL, cnt->conf.netcam_url);
		if (cnt->conf.netcam_userpass) {
			curl_easy_setopt(curl, CURLOPT_USERPWD, cnt->conf.netcam_userpass);
		}

		if (curl_easy_perform(curl)) {
			perror("Error getting netcam image");
			fclose(jpegfile);
			return -1;
		}

		rewind(jpegfile);

		cinfo.err=jpeg_std_error(&jerr);
		jpeg_create_decompress(&cinfo);
		jpeg_stdio_src(&cinfo, jpegfile);
		jpeg_read_header(&cinfo, TRUE);
		
		cnt->conf.width=cinfo.image_width;
		cnt->conf.height=cinfo.image_height;
		cnt->imgs.width=cinfo.image_width;
		cnt->imgs.height=cinfo.image_height;
		cnt->imgs.size=cnt->imgs.width*cnt->imgs.height*3;
		cnt->imgs.motionsize=cnt->imgs.size;
		cnt->imgs.type=VIDEO_PALETTE_RGB24;

		curl_easy_cleanup(curl);
	}
	fclose(jpegfile);
	return 0;
}

unsigned char *netcam_next (struct context *cnt)
{
	CURL *curl;
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;
	FILE *jpegfile;
	unsigned char *line, *pic;
	int i, line_size;
	JSAMPROW row[1];

	if ((jpegfile=tmpfile())==NULL)
		return NULL;

	curl=curl_easy_init();
	if (curl) {
		curl_easy_setopt(curl, CURLOPT_FILE, jpegfile);
		curl_easy_setopt(curl, CURLOPT_URL, cnt->conf.netcam_url);
		if (cnt->conf.netcam_userpass) {
			curl_easy_setopt(curl, CURLOPT_USERPWD, cnt->conf.netcam_userpass);
		}
		if (curl_easy_perform(curl)) {
			perror("Error getting netcam image");
		}
		curl_easy_cleanup(curl);
	}
	rewind(jpegfile);

	cinfo.err=jpeg_std_error(&jerr);
	jpeg_create_decompress(&cinfo);
	jpeg_stdio_src(&cinfo, jpegfile);
	jpeg_read_header(&cinfo, TRUE);
	
	cinfo.out_color_space=JCS_RGB;
	
	jpeg_start_decompress(&cinfo);
	line_size=cnt->conf.width*3;
	
	if ((line=malloc(cnt->conf.width*3))==NULL)
		return NULL;
	pic=cnt->imgs.new;
	
	row[0]=line;
	while(cinfo.output_scanline<cnt->conf.height) {
		jpeg_read_scanlines(&cinfo, row, 1);
		for (i=0; i<line_size; i+=3) {
			pic[i]=line[i+2];
			pic[i+1]=line[i+1];
			pic[i+2]=line[i];
		}
		pic+=line_size;
	}
	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);
	free(line);
	fclose(jpegfile);

	return cnt->imgs.new;
}
#endif /* HAVE_CURL */
