/*
  **
  ** conf.h - function prototypes for the config handling routines
  **
  ** Originally written for the dproxy package by Matthew Pratt.
  **
  ** Copyright 2000 Jeroen Vreeken (pe1rxq@chello.nl)
  **
  ** This software is licensed under the terms of the GNU General
  ** Public License (GPL). Please see the file COPYING for details.
  **
  **
*/

#ifndef _INCLUDE_CONF_H
#define _INCLUDE_CONF_H

/* 
    more parameters may be added later.
 */
struct config {
        int width;
        int height;
	int quality;
	int max_changes;
	int always_diff;
	int new_img;
	int motion_img;
	int snap_overwrite;
	int gap;
	int maxmpegtime;
	int locate;
	int input;
	int norm;
	int frame_limit;
	int mpeg;
        int quiet;
	int ppm;
	int noise;
	int mingap;
	int lightswitch;
	int jpg_cleanup;
	int nightcomp;
	int adjustrate;
	int realmotion;
	int oldlayout;
	int low_cpu;
	int nochild;
	int autobright;
	int roundrobing_frames;
	int roundrobing_skip;
	int post_capture;
	int switchfilter;
	int ffmpeg_cap_new;
	int ffmpeg_cap_motion;
	int ffmpeg_bps;
	int webcam_port;
	int webcam_quality;
	int webcam_motion;
	int webcam_maxrate;
	int frequency;
	int timelaps;
	char *device;
	char *vidpipe;
	char *mail_address;
	char *sms_nr;
	char *filepath;
	char *externcommand;
	char *mask_file;
	char *mysql_db;
	char *mysql_host;
	char *mysql_user;
	char *mysql_password;
	char *onsavecommand;
	char *onmpegcommand;
	char *motionvidpipe;
	char *netcam_url;
	char *netcam_userpass;
	char *pgsql_db;
	char *pgsql_host;
	char *pgsql_user;
	char *pgsql_password;
	int pgsql_port;
	char *mpeg_encode_bin;
	int drawtext_changes;
	int drawtext_shots;
	char *drawtext_user;
	int argc;
	char **argv;
};

extern struct config conf;

/** 
 * typedef for a param copy function. 
 */
typedef struct context ** (* conf_copy_func)(struct context **, char *, int) ;

/**
 * description for parameters in the config file
 */
typedef struct {
  char * param_name;	/* name for this parameter             */
  int conf_value;	/* pointer to a field in struct context */
  conf_copy_func  copy;	/* a function to set the value in 'config'*/
} config_param; 


//extern struct config config;
struct context **conf_load (struct context **);
//void conf_process (FILE *fp);

#endif /* _INCLUDE_CONF_H */
