import sys
import os
import os.path
import glob
import shutil


try:
    from epydoc.cli import cli
except ImportError:
    print "You need Epydoc to Generate the API reference, even with pydoctor"
    sys.exit(1)

def clean(folder):
    for element in glob.glob(os.path.join('docs', 'api', folder,'*')):
        if os.path.isfile(element):
            os.remove(element)
        elif os.path.isdir(element):
            shutil.rmtree(element)

def display_error_message_and_exit():
    print "To generate the API reference, please specify an API documentation generator:"
    print "       python elisa-core/builddoc.py epydoc"
    print "    OR python elisa-core/builddoc.py pydoctor"
    sys.exit(1)
    

if __name__ == '__main__':
    
    if len(sys.argv) != 2:
        display_error_message_and_exit()
    else:
        if sys.argv[1] == "epydoc":
            # GENERATE EPYDOC
            clean('epydoc')
            config_file = os.path.join("elisa-core", "data", "epydoc.cfg")
            args = ["epydoc", "-v", "--config", config_file]
            sys.argv = args

            # Start Generation
            cli()
            sys.exit(0)
        elif sys.argv[1] == "pydoctor":
            # GENERATE PYDOCTOR
            clean('pydoctor')
            try:
                from pydoctor.driver import main
            except ImportError:
                print "You need Pydoctor to generate the API reference with Pydoctor"
                sys.exit(1)
            config_file = os.path.join("elisa-core", "data", "pydoctor.cfg")
            args = ["--make-html", "-c" + config_file]

            # Start Generation
            sys.exit(main(args))
        else:
            display_error_message_and_exit()
