/*
 * fullscreen.h: the xaml for the fullscreen message.
 *
 * Contact:
 *   Moonlight List (moonlight-list@lists.ximian.com)
 *
 * Copyright 2007 Novell, Inc. (http://www.novell.com)
 *
 * See the LICENSE file included with the distribution for details.
 * 
 */
#define FULLSCREEN_MESSAGE \
"<Canvas " \
	"xmlns=\"http://schemas.microsoft.com/client/2007\" " \
	"xmlns:x=\"http://schemas.microsoft.com/winfx/2006/xaml\" " \
	"Width=\"500\" Height=\"68\" " \
	"x:Name=\"FullScreenMessage\" " \
	"Visibility=\"Visible\" " \
	"Opacity=\"1\" " \
	">" \
	"<Canvas.Triggers>" \
		"<EventTrigger RoutedEvent=\"Canvas.Loaded\">" \
			"<BeginStoryboard>" \
				"<Storyboard x:Name=\"FadeOut\">" \
					"<DoubleAnimationUsingKeyFrames BeginTime=\"00:00:00\" Storyboard.TargetName=\"FullScreenMessage\" Storyboard.TargetProperty=\"(UIElement.Opacity)\">" \
						"<SplineDoubleKeyFrame KeyTime=\"00:00:04.6000000\" Value=\"1\"/>" \
						"<SplineDoubleKeyFrame KeyTime=\"00:00:05\" Value=\"0\"/>" \
					"</DoubleAnimationUsingKeyFrames>" \
				"</Storyboard>" \
			"</BeginStoryboard>" \
		"</EventTrigger>" \
	"</Canvas.Triggers>" \
	"<Canvas.RenderTransform>" \
		"<TranslateTransform X=\"0\" Y=\"0\"/>" \
	"</Canvas.RenderTransform>" \
	"<Rectangle Width=\"500\" Height=\"68\" Stroke=\"#FF000000\" StrokeThickness=\"0\" RadiusX=\"8\" RadiusY=\"8\">" \
		"<Rectangle.Fill>" \
			"<LinearGradientBrush EndPoint=\"0,1\" StartPoint=\"0,0\">" \
				"<GradientStop Color=\"#FF242323\" Offset=\"0\"/>" \
				"<GradientStop Color=\"#FF515151\" Offset=\"1\"/>" \
			"</LinearGradientBrush>" \
		"</Rectangle.Fill>" \
	"</Rectangle>" \
	"<TextBlock Width=\"458\" Height=\"27\" Canvas.Left=\"124\" Canvas.Top=\"14\" TextWrapping=\"Wrap\" FontWeight=\"Normal\" Foreground=\"#FFFFFFFF\" FontSize=\"14\" Text=\"Press &quot;Esc&quot; to exit full-screen mode.\" x:Name=\"message\"/>" \
	"<TextBlock Width=\"458\" Height=\"20\" Canvas.Left=\"193\" Canvas.Top=\"34\" Text=\"&lt;url: file://&gt;\" TextWrapping=\"Wrap\" x:Name=\"url\" Foreground=\"#FFC8C4C4\" FontSize=\"13\" FontStretch=\"Normal\"/>" \
"</Canvas>" \
""

