#include <stdio.h>
#include <moomethod.h>

#include "socket.c"

/* Remove curlies from the text. */
char *uncurly (char *text) {
	char *s;
	while ((s = strchr(text, '{'))) {
		s[0] = ' ';
	}
	while ((s = strchr(text, '}'))) {
		s[0] = ' ';
	}
	return text;
}

/* Remove xml tags from the text. <sender> is supported; marked up
 * in bold, all else are ignored. Also handle entities. */
char *dexml (char *text) {
	char *ret, *s, *e, *a = NULL;
	int senderunterm=0;
	int len = strlen(text);

	if (len == 0)
		return text;
	else
		ret = malloc(len + 1);
	ret[0] = '\0';
	
	while ((s = strchr(text, '<')) || (a = strchr(text, '&'))) {
		if (a) {
			a[0] = '\0';
			a++;
			strcat(ret, text);
			
			e = strchr(a, ';');
			if (! e) {
				strcat(ret, "&");
				text=a;
			}
			else {
				e[0] = '\0';
				if (strcmp(a, "lt") == 0)
					strcat(ret, "<");
				else if (strcmp(a, "gt") == 0)
					strcat(ret, ">");
				else if (strcmp(a, "amp") == 0)
					strcat(ret, "&");
				text=e+1;
			}

			a=NULL;
		}
		else {
			s[0] = '\0';
			s++;
			/* XXX should really escape entities in
			 * here.. */
			strcat(ret, text);
		
			e = strchr(s, '>');
			if (! e) { /* unterminated */
				strcat(ret, text);
				return ret;
			}

			e[0]='\0';
			if (strcmp(s, "sender") == 0) {
				strcat(ret, "{");
				senderunterm=1;
			}
			else if (strcmp(s, "/sender") == 0) {
				strcat(ret, "}");
				senderunterm=0;
			}
		
			text=e+1;
		}
	}

	if (senderunterm)
		strcat(ret, "}");
		
	strcat(ret, text);
	return ret;
}

int main (int argc, char **argv) {
	char **lines;
	int i;
	FILE *f;
	
	methinit();
	lines=getallvals();
	
	f = setupsocket();
	fprintf(f, "o\n");
	for (i = 0; lines[i] != NULL; i++) {
		fprintf(f, "%s\n", dexml(uncurly(lines[i])));
	}
	fflush(f);
	exit(0);
}
