#include <moomethod.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

FILE *openfield (const char *field) {
	FILE *f;
	f = fopen(field, "w");
	if (! f) {
		/* It may have failed because the field is a symlink. */
		unlink(field);
		f = fopen(field, "w");
		if (! f) {
			exit(1);
		}
	}
	return f;
}

int main () {
	char *field, *p, *start, *oldref = NULL;
	int nump = 0, allrefs = 1;
	FILE *f = NULL;
	
	methinit();
	field = getvalue();
	if (! field) {
		exit(1);
	}
	
	while ((p = unescape(mooix_getline(stdin, 0)))) {
		/* Keep track of whether every value is a reference. */
		if (allrefs && strncmp("mooix:", p, strlen("mooix:")) != 0) {
			allrefs = 0;
		}
		
		nump++;
		if (allrefs && nump == 1) {
			/* Don't do anything with first reference,
			 * until we know if there are more. */
			oldref = p;
		}
		else {
			/* Save values to file. */
			if (! f) {
				f = openfield(field);
			}
			if (oldref && nump == 2) {
				/* The old reference just goes to the start
				 * of the file. */
				fprintf(f, "%s", oldref);
				free(oldref);
			}
			/* Strip off leading and trailing quotes, if any. */
			start = p;
			if (p[0] == '"') {
				char *end = p + strlen(p) - 1;
				if (end[0] == '"') {
					start++;
					end[0]='\0';
				}
			}
			if (nump > 1)
				fprintf(f, "\n");
			fprintf(f, "%s", start);
			printf("%s\n", start);

			free(p);
		}
	}

	/* If there are no parameters, make an empty file. */
	if (nump == 0) {
		f = openfield(field);
	}
	/* If all params were references, either make the file sticky,
	 * or make a symlink */
	else if (allrefs) {
		if (nump == 1) {
			char *start = oldref + strlen("mooix:");
			unlink(field);
			if (symlink(start, field) != 0) {
				//perror("symlink");
				exit(1);
			}
			printf("%s\n", oldref);
		}
		else {
			if (chmod(field, 01644) != 0) {
				//perror("chmod");
				exit(2);
			}
		}
	}

	exit(0);
}
