#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <moomethod.h>

void onchange () {
	char *file, *onchange;

	file = fieldfile(getobj("."), "onchange");
	if (! file)
		return;

	onchange = getfield(file);
	if (onchange) {
		runmethod(getobj("owner"), onchange, NULL);
	}
}

int main (int argc, char **argv) {
	param *p;
	object *obj = NULL;
	object *item;
	FILE *list;
	struct stat item_st;
	
	methinit();
	while ((p = getparam())) {
		if (strcmp(p->name, "object") == 0) {
			obj = derefobj(p->value);
		}
	}

	if (! obj) {
		fprintf(stderr, "object field required\n");
		exit(1);
	}

	/* A bit expensive.. */
	list = runmethod(getobj("."), "list", NULL);
	if (! list) {
		perror("list");
		exit(1);
	}
	
	while ((item = derefobj(fgetvalue(list)))) {
		if (objcmp(item, obj) == 0) {
			if (lstat(item->dir, &item_st) == 0 &&
			    S_ISLNK(item_st.st_mode)) {
				/* It's a symlink so just remove it. */
				if (unlink(item->dir) != 0) {
					perror("unlink");
					exit(1);
				}
			}
			else {
				FILE *destroy;
				char *ret;
				/* It's a directory, so destroy it. */
				/* The problem here is that the destroy
				 * method runs stackless and only checks to
				 * ake sure that we run it. So it's really
				 * up to this method to do permission
				 * checking. It's only ok so do so if the
				 * callstack allows writing to this object.
				 * Well, so try writing to this object,
				 * then.. */
				if (open(".test", O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR) == -1) {
					perror("permission denied destroying encapsulated object");
					exit(1);
				}
				if (unlink(".test") == -1) {
					perror("unlink .test");
					exit(1);
				}
				/* The return code of the destroy method is
				 * inverted; it returns 1 on failure. */
				destroy = runmethod(item, "destroy", NULL);
				ret = fgetvalue(destroy);
				if (! ret && strcmp(ret, "1") == 0) {
					perror("destroy failed!");
					exit(1);
				}
				
			}

			onchange();
			printf("1\n"); // success
			exit(0);
		}
	}

	printf("0\n"); // failure
	exit(0);
}
