#include <stdio.h>
#include <libgen.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <moomethod.h>

void onchange () {
	char *file, *onchange;

	file = fieldfile(getobj("."), "onchange");
	if (! file)
		return;

	onchange = getfield(file);
	if (onchange) {
		runmethod(getobj("owner"), onchange, NULL);
	}
}
	
int main (int argc, char **argv) {
	param *p;
	FILE *f;
	char *id;
	char *hint = "";
	object *obj = NULL;
	char *params[3];

	methinit();
	while ((p = getparam())) {
		if (strcmp(p->name, "hint") == 0) {
			hint = strdup(p->value);
		}
		else if (strcmp(p->name, "object") == 0) {
			obj = derefobj(p->value);
		}
	}

	if (! obj) {
		fprintf(stderr, "object field required\n");
		exit(1);
	}
		
	params[0] = "hint";
	params[1] = hint;
	params[2] = NULL;
	f = runmethod(getobj("."), "newid", params);
	if (! f) {
		perror("newid");
		exit(1);
	}
	id = basename(fgetvalue(f));

	if (symlink(obj->dir, id) != 0) {
		perror("symlink");
		exit(1);
	}

	onchange();
	
	printf("mooix:%s/%s\n", getenv("THIS"), id);
	exit(0);
}
