#include <stdlib.h>
#include <string.h>
#include <moomethod.h>

int main (int argc, char **argv) {
	FILE *list;
	char *key, *val;
	char *listfile;
	char *params[2];
	object *session, *onlyto_session = NULL;
	
	methinit();

	/* This argument processing is not exactly robust, but
	 * maybe it's a little bit faster this way? */
	while ((key = mooix_getline(stdin, 1)) &&
	       (val = mooix_getline(stdin, 0))) {
		if (strcmp(key, "session") == 0) {
			onlyto_session=derefobj(val);
		}
		else if (strcmp(key, "message") == 0) {
			params[0] = val; /* raw, already escaped value */
			params[1] = NULL;
			
			if (! onlyto_session) {
				listfile = fieldfile(getobj("sessions"), "list");
				if (listfile && (list = fopen(listfile, "r"))) {
					while ((session = derefobj(fgetvalue(list)))) {
						/* The only reason to get
						 * the values is that that
						 * makes this method pause
						 * until the write method
						 * exits. Thus, it doesn't
						 * fork off a ton of them
						 * if there are meny
						 * sessions, which might
						 * cause more contention.
						 * This also makes it more
						 * predictable when
						 * benchmarking. */
						fgetallvals(runmethod(session, "write", params));
					}
				}
			}
			else {
				fgetallvals(runmethod(onlyto_session, "write", params));
			}
			
			exit(0);
		}
	}
	exit(0);
}
