# This spec file makes a rpm that is as close to lsb compliant as we can
# get. However, mooix needs some libraries and programs that are not in the
# lsb.
Summary: Unix is the MOO.
Name: mooix
Packager: Joey Hess <joey@mooix.net>
Version: 1.0rc5.pre5
Release: 1
Source: mooix_%{version}.tar.gz
Copyright: mixed BSD, GPL, LGPL
URL: http://mooix.net/
Group: Environments/Moo
Requires: perl, lsb, perl-Parse-RecDescent, 
BuildRoot: %{_builddir}/%{name}/rpm-build-root

%description
Mooix is a MOO, an object-oriented multi-user virtual world that users can
log into and explore. Each user takes control of a computerized avatar. You
can walk around, chat with other people, solve puzzles, and even extend and
change the world by creating new places and items and adding your own code.
 
Mooix is programming language independent; methods can be coded in any
language, including perl, python, ruby, and C. It features a powerful
natural language processor so users can talk to it in plain English. Mooix
uses special techniques to allow the core of the MOO to be upgraded easily
while retaining your modifications. It ships with a fairly complete set of
more than fifty basic objects, everything you'll need to get started
creating your own custom MOO. And every bit of it is extensively documented
with online help.
 
Most MOOs run off in a corner of a unix system, as a single process. They
re-invent their own programming languages, which are often not very
expressive or powerful, their own object oriented database systems, their
own multiuser support, and essentially everything you'd find on a unix
system. Mooix turns this on its head, and rather than trying to reinvent
unix inside a MOO, it turns the unix system into the MOO. It uses every
unix strength possible to the advantage of the MOO; its multiuser nature,
preemptive multitasking, disk caching, device abstraction, numerous
programming languages, editors, libraries, etc. With Mooix, unix is the
MOO.

WARNING: This is an experimental rpm of mooix.

You may need to force some of this package's dependencies to install it,
but you must have a LSB compliant distribution plus perl, readline, and
the Parse::RecDescent perl module to install this package.

After you install, see the ADDONS file for some other software you cna
install to enhance mooix.

%post
#!/bin/sh
. /etc/mooix.conf || true

# Set proper umask for touching the moo object tree.
umask 022

# See if this is a new install, not an upgrade.
if [ "$1" = 1 ]; then
	# Create all the moo's users and groups.
	groupadd $MOOADMIN
	useradd -g $MOOADMIN -d $MOOROOT -s /bin/sh $MOOADMIN
	groupadd $MOOENTRYGROUP
	useradd -g $MOOENTRYGROUP -d $MOOROOT -s /bin/sh $MOOENTRYGROUP
	# Create the MOOROOT itself. It's not shipped as a whole directory
	# in the rpm, cause it should not be deleted on removal, probably.
	mkdir -p $MOOROOT
fi

# Programs that must be suid+sgid to created users.
# Not sure if this is the best way to do it.
chown $MOOADMIN:$MOOENTRYGROUP /usr/bin/moo /usr/bin/mooscript
chmod ug+s /usr/bin/moo /usr/bin/mooscript
# Programs that must be sgid.
chown 0:$MOOENTRYGROUP /usr/bin/moologin
chmod g+s /usr/bin/moologin

ldconfig

# Update/create the system object tree. Note that this fixes up
# relative symlinks in the DISTOBJ tree, which are relative because
# RPM suckily forces them relative at build time.
/usr/sbin/splittree $DISTOBJ $MOOROOT $DISTOBJ $MOOROOT $MOOADMIN

# Bring up the moo daemon, but not the moo as a whole, to do upgrade and so
# on. Check first to see if it is already running.
# Use the LSB init functions.
. /lib/lsb/init-functions
DAEMON=mood
if [ -z "$(pidofproc $DAEMON)" ]; then
	start_daemon $DAEMON
fi

# Run upgrade.
/usr/sbin/mooupgrade -q -r -s "$DISTOBJ"

# Record the currently installed db version, don't want this field to be
# inherited as that would allow the value to change on upgrade.
if [ ! -e $MOOROOT/system/mooinfo/dbversion ]; then
	cp $MOOROOT/system/mooinfo/parent/dbversion \
	   $MOOROOT/system/mooinfo/dbversion
	chown $MOOADMIN:$MOOADMIN $MOOROOT/system/mooinfo/dbversion
fi

# Compile the parser grammar, to make sure it is compiled even if there is
# clock skew, and so that the first person to log in doesn't have to sit
# through this.
cd $MOOROOT/mixin/parser && runmeth compilegrammar >/dev/null

# Bring down the moo daemon, but don't run the stophook stuff.
killproc $DAEMON
rm -f /var/run/mood.pid # probably only needed on debian or unneeded

/usr/lib/lsb/install_initd mooix

# I guess that in the rpm world, starting a daemon on install/upgrade is
# not how things are done. If I did want to start it here:
#/etc/init.d/mooix start

%pre
#!/bin/sh
# On upgrade, stop first.
if [ "$1" != 1 ]; then
	/etc/init.d/mooix stop || true
fi

%preun
#!/bin/sh
/etc/init.d/mooix stop || true
/usr/lib/lsb/remove_initd mooix

# Detect removal of package (not just upgrade), and remove the users and
# groups.
if [ "$1" = 0 ]; then
	. /etc/mooix.conf || true
	userdel $MOOADMIN
	userdel $MOOENTRYGROUP
	rm -rf /var/run/mooix
	rm -f /var/run/mood
	# For some reason rpm leaves behind empty directories here.
	rm -rf /usr/lib/mooix
fi

%postun
#!/bin/sh
ldconfig

%prep
%setup -n mooix
./configure --prefix=/usr --mandir=/usr/share/man \
	--localstatedir=/var --sysconfdir=/etc \
	--without-embedded-python --without-embedded-ruby \
	--with-perl-stdout-flush-hack
# Leaving out embedded python and ruby because that's one less library
# dependency to worry about. Perl is left in because mooix requres
# embedded perl.
# The perl stdout flush hack is necessary on Mandrake 9.1, may not be on
# other distros.

%build
make INSTALLDIRS=vendor EXTRA_CFLAGS="$RPM_OPT_FLAGS" build test

%install
make PREFIX=$RPM_BUILD_ROOT install

# See debian/rules for full explanation.
rm -rf $RPM_BUILD_ROOT/var/lib/mooix/

install -d $RPM_BUILD_ROOT/etc/init.d
install lsb/init $RPM_BUILD_ROOT/etc/init.d/mooix

# The sed makes it work after man pages get compressed. The bs file
# exclusion is because rpm on mandrake deletes it after and gets
# confused or something.
find $RPM_BUILD_ROOT -not -type d -printf "/%%P\n" | \
	sed '/\/man\//s/$/\*/' | egrep -v '.bs$' | \
	grep -v /usr/sbin/mooregister | grep -v /usr/sbin/moopasswd | \
	grep -v /usr/sbin/mooix-pty-helper > manifest
echo /var/run/mooix >> manifest
%files -f manifest
%defattr(-,root,root)
%attr(4755,root,root) /usr/sbin/mooregister
%attr(4755,root,root) /usr/sbin/moopasswd
%attr(4755,root,root) /usr/sbin/mooix-pty-helper
%doc ADDONS README TODO TODO-LATER UPGRADING WISHLIST NEWS CONTRIBUTING TASKS doc/*.txt
