/*
 * embedding ruby into mood speeds execution of ruby methods
 *
 * Copyright 2003 by Nick Borko <nick@dd.revealed.net>
 * And Nolan J. Darilek <nolan@thewordnerd.info>
 * under the terms of the GNU GPL.
 */
#ifdef EMBED_RUBY

#include <stdlib.h>
#include <ruby.h>

/*ruby.h doesn't make this available, but we need it.*/
extern void ruby_init_loadpath();

void init_ruby(void) {
	ruby_init();

	/* require Mooix here; slightly more efficient */
	ruby_init_loadpath();
	rb_require("mooix");
	rb_require("mooix/thing");
	rb_require("mooix/thinglist");
}

void run_ruby(int my_argc, char **my_argv, const char *this,
              const char *moosock, const char *method,
	      const char *mooix_debug) {
	/* Statement to be rb_eval'd.*/
	/* I'm sure there's a better way to do this . . . */
	char *s = malloc(8192);
	
	/* we have to set environment variables in Ruby manually, since
	  ENV was already set up in ruby_init.  Note that this
	  *doesn't* change the actual environment, so you have to do that
	  separately */
	setenv("THIS", this, 1);
	strcat(s, "ENV['THIS'] = '");
	strcat(s, (const char *)this);
	strcat(s, "'\n");

	setenv("MOOSOCK", moosock, 1);
	strcat(s, "ENV['MOOSOCK'] = '");
	strcat(s, (const char *)moosock);
	strcat(s, "'\n");

	setenv("METHOD", my_argv[0], 1);
	strcat(s, "ENV['METHOD'] = '");
	strcat(s, (const char *)my_argv[0]);
	strcat(s, "'\n");
	if (mooix_debug) {
		setenv("MOOIX_DEBUG", mooix_debug, 1);
		strcat(s, "ENV['MOOIX_DEBUG'] = '");
		strcat(s, (const char *)mooix_debug);
		strcat(s, "'\n");
	}

	rb_eval_string(s);
	free(s);
	
	/* run the method, using argv */
	/* the interpreter needs to be the first argument */
	my_argv[1] = my_argv[0];
        my_argv[0] = "ruby";

	ruby_options(my_argc, my_argv);
	ruby_script(my_argv[1]);
	ruby_run();
}

#endif /* EMBED_RUBY */
