/*
 * Mooix proxy wrapper library.
 * Replacement functions for libc.
 *
 * Copyright 2001-2003 by Joey Hess <joey@mooix.net>
 * under the terms of the modified BSD license given in full in the
 * file COPYRIGHT.
 * 
 * Including libc headers into this file is tricky, since if they define
 * any of the libc functions below in a different way, the compiler will
 * gripe. That's why the bodies of the function, which do need a lot of
 * headers, are split into a separate file.
 */

/* Still, a few includes are needed for data types. */
#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>
#include "do.h"

/*
 * Wrap the open family of calls so that read/write attempts on moo
 * objects get the right permissions.
 */
int open (const char *name, int flags, mode_t mode) {
	return do_open(name, flags, mode);
}
int _open (char *name, int flags, mode_t mode) {
	return open(name, flags, mode);
}
int __open (char *name, int flags, mode_t mode) {
	return open(name, flags, mode);
}
int open64 (char *name, int flags, mode_t mode) {
	return open(name, flags, mode);
}
int _open64 (char *name, int flags, mode_t mode) {
	return open(name, flags, mode);
}
int __open64 (char *name, int flags, mode_t mode) {
	return open(name, flags, mode);
}
int creat (const char *pathname, mode_t mode) {
	return do_creat(pathname, mode);
}
int creat64 (const char *pathname, mode_t mode) {
	return do_creat(pathname, mode);
}

/* Keep track of changes to the umask. */
mode_t umask (mode_t themask) {
	return do_umask(themask);
}

int chdir (const char *path) {
	return do_chdir(path);
}

int fchdir (int fd) {
	return do_fchdir(fd);
}

int unlink (const char *pathname) {
	return do_unlink(pathname);
}

int symlink (const char *oldpath, const char *newpath) {
	return do_symlink(oldpath, newpath);
}

int mkdir (const char *pathname, mode_t mode) {
	return do_mkdir(pathname, mode);
}

int rmdir (const char *pathname) {
	return do_rmdir(pathname);
}

int chmod (char *path, mode_t mode) {
	return do_chmod(path, mode);
}

int rename (const char *oldpath, const char *newpath) {
	return do_rename(oldpath, newpath);
}

int connect (int sockfd, void *serv_addr, int addrlen) {
	return do_connect(sockfd, serv_addr, addrlen);
}

/* Kill is wrapped so that kills sent to the process group are actually
 * sent in to the moo, and to every method of the object. */
int kill (pid_t pid, int sig) {
	return do_kill(pid, sig);
}

/* Fork is wrapped only so the child can be set to not use the same
 * socket to talk to mood as does the parent. This is necessary so mood can
 * do proper reference counting of the number of clients it has. */
pid_t fork (void) {
	return do_fork();
}

/* exec*() are wrapped so that calls to moo methods can be run as other users. */
int execve (const char *filename, char * const argv[], char * const envp[]) {
	return do_execve(filename, argv, envp);
}

int execle (const char *path, const char *arg, ... /* , char * const envp[] */) {
	va_list ap;
	int ret;

	/* To pass the variadic args, pass a va_list. Like vprintf.. */
	va_start(ap, arg);
	ret = do_vexecle(path, arg, ap);
	va_end(ap);
	return ret;
}

int execl (const char *path, const char *arg, ...) {
	va_list ap;
	int ret;

	va_start(ap, arg);
	ret = do_vexecl(path, arg, ap);
	va_end(ap);
	return ret;
}

int execvp (const char *file, char *const argv[]) {
	return do_execvp(file, argv);
}

int execlp (const char *file, const char *arg, ...) {
	int ret;
	va_list ap;
	
	va_start(ap, arg);
	ret = do_vexeclp(file, arg, ap);
	va_end(ap);
	return ret;
}

int execv (const char *path, char *const argv[]) {
	return do_execv(path, argv);
}
