# copyright (C) 1997-2004 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: network.tcl,v 1.21 2004/01/01 11:39:06 jfontain Exp $

package provide network [lindex {$Revision: 1.21 $} 1]


namespace eval network {

    proc parseRemoteLocator {string} {                                                        ;# return protocol, user and host list
        regexp {^(([^:]*)://)?(([^@]*)@)?(.*)$} [string trim $string] dummy dummy protocol dummy user host
        if {[string length $protocol] == 0} {
            set protocol rsh
        }
        switch $protocol {
            rsh - ssh {}
            default {
                error "unsupported protocol: $protocol"
            }
        }
        if {[string length $user] == 0} {
            set user $::tcl_platform(user)
        }
        return [list $protocol $user $host]
    }

if {[string equal $::tcl_platform(platform) unix]} {

    proc checkRemoteOutputEmptiness {command user host} {
        catch "exec $command -n -l $user $host :" output
        if {[string length $output] > 0} {
            error "remote host \"$host\" error:\n$output"
        }
    }

} else {                                                                                                                  ;# windows

    proc checkRemoteOutputEmptiness {command user host} {
        catch "exec plink -batch $host :" output
        if {[string length $output] > 0} {
            error "remote host \"$host\" error:\n$output"
        }
    }

}

}
