# copyright (C) 1997-2004 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: html.tcl,v 1.48 2004/01/19 14:53:59 jfontain Exp $


proc displayHelpWindow {topLevelName name title} {
    upvar 1 $topLevelName toplevel

    # child of common parent so that user interaction can be limited to 2 windows (print dialog box and main help for example)
    set toplevel .grabber.help${name}
    if {[winfo exists $toplevel]} {
        wm deiconify $toplevel
        raise $toplevel
        return 0
    }
    toplevel $toplevel
    wm group $toplevel .                                             ;# for proper window manager (windowmaker for example) behavior
    wm title $toplevel $title
    frame $toplevel.bound                     ;# create a frame for bindings that otherwise would propagate to all toplevel children
    return 1
}

proc generalHelpWindow {{url {}}} {
    static bottom

    if {[displayHelpWindow toplevel moodss {moodss: Global Help}]} {
        package require moodsshelp                                                           ;# load huge HTML data only when needed

        set panes [new panner $toplevel -panes 2]                                    ;# split window in 2 for contents and help data
        pack $widget::($panes,path) -fill both -expand 1

        set top [new htmlViewer $panner::($panes,frame1)]
        composite::configure $top base -height 100 -width 500
        pack $widget::($top,path) -fill both -expand 1
        set bottom [new htmlViewer $panner::($panes,frame2)]
        composite::configure $top -linkto $bottom
        composite::configure $bottom base -height 400
        focus $htmlViewer::($bottom,textPath)                             ;# so that scrolling with keyboard is immediately possible
        pack $widget::($bottom,path) -fill both -expand 1
        bind $toplevel.bound <Destroy> "delete $bottom $top $panes"
        set button [button $toplevel.close -text Close -command "destroy $toplevel"]
        place $button -in $htmlViewer::($top,textPath) -relx 1 -anchor ne  ;# place inside text area so as not to obstruct scrollbar

        busy 1 $htmlViewer::($top,textPath)                            ;# force busy cursor on contents while bottom pane is loading
        composite::configure $top -data $::htmlHelpContents
        if {![winfo exists $toplevel]} return                       ;# user may have destroyed the window through the window manager
        composite::configure $bottom -data $::htmlHelpData
        catch {busy 0 $htmlViewer::($top,textPath)}                                        ;# window may have been destroyed by user
    }
    if {([string length $url] > 0) && [info exists bottom]} {                                ;# viewer may not have been created yet
        htmlViewer::goTo $bottom $url
    }
}

proc moduleHelpWindow {name text} {
    if {![displayHelpWindow toplevel $name "moodss: $name module help"]} return
    set viewer [new htmlViewer $toplevel]
    composite::configure $viewer base -height 300 -width 500
    pack $widget::($viewer,path) -fill both -expand 1
    bind $toplevel.bound <Destroy> "delete $viewer"
    composite::configure $viewer -data $text
    set button [button $toplevel.close -text Close -command "destroy $toplevel"]
    place $button -in $htmlViewer::($viewer,textPath) -relx 1 -anchor ne   ;# place inside text area so as not to obstruct scrollbar
}
