%token FORMAT_VERSION
%token NEW_MANIFEST OLD_REVISION OLD_MANIFEST
%token PATCH
%token CONTENT FROM TO
%token ADD_FILE ADD_DIR
%token DELETE DELETE_FILE DELETE_DIR
%token RENAME RENAME_FILE RENAME_DIR
%token CLEAR SET ATTR VALUE
%token EOF
%token <string> ID STRING

%start revision_set pre_rosters_revision_set
%type <Revision_types.t> revision_set
%type <Revision_types.t> pre_rosters_revision_set

%%
revision_set:
    FORMAT_VERSION STRING 
    NEW_MANIFEST ID 
    edge_list                           { ($4, Q.to_list $5) }
;

edge_list:
    edge                                { Q.push Q.empty $1 }
  | edge_list edge                      { Q.push $1 $2 }
;

edge:
    OLD_REVISION ID change_set_opt      { { Revision_types.old_revision = $2 ; 
					    Revision_types.change_set = Q.to_list $3 } }
;

change_set_opt:
    /* empty */                         { Q.empty }
  | change_set                          { $1 }
;

change_set:
  | change                              { Q.push Q.empty $1 }
  | change_set change                   { Q.push $1 $2 }
;

change:
  | PATCH STRING FROM ID TO ID          { Revision_types.PATCH ($2, $4, $6) }
  | ADD_FILE STRING                     { Revision_types.ADD_FILE ($2, "") }
  | ADD_FILE STRING CONTENT ID          { Revision_types.ADD_FILE ($2, $4) }
  | ADD_DIR STRING                      { Revision_types.ADD_DIR $2 }
  | DELETE STRING                       { Revision_types.DELETE_FILE $2 }
  | DELETE_FILE STRING                  { Revision_types.DELETE_FILE $2 }
  | DELETE_DIR STRING                   { Revision_types.DELETE_DIR $2 }
  | RENAME STRING TO STRING             { Revision_types.RENAME_FILE ($2, $4) }
  | RENAME_FILE STRING TO STRING        { Revision_types.RENAME_FILE ($2, $4) }
  | RENAME_DIR STRING TO STRING         { Revision_types.RENAME_DIR ($2, $4) }
  | CLEAR STRING ATTR STRING            { Revision_types.ATTR_CLEAR ($4, $2) }
  | SET STRING ATTR STRING VALUE STRING { Revision_types.ATTR_SET ($4, $2, $6) }
;




pre_rosters_revision_set:
    NEW_MANIFEST ID 
    pre_rosters_edge_list               { ($2, Q.to_list $3) }
;

pre_rosters_edge_list:
    pre_rosters_edge                    { Q.push Q.empty $1 }
  | pre_rosters_edge_list 
    pre_rosters_edge                    { Q.push $1 $2 }
;

pre_rosters_edge:
    OLD_REVISION ID 
    OLD_MANIFEST ID change_set_opt      { { Revision_types.old_revision = $2 ; 
					    Revision_types.change_set = Q.to_list $5 } }
;
