(* This file is an excerpt from ocamlnet 0.97.1, module Netstring.Base64 
   (C) 2001, Patrick Doane and Gerd Stolpmann
*)

val encode : 
  ?pos:int -> ?len:int -> ?linelength:int -> ?crlf:bool -> string -> string
      (* Compute the "base 64" encoding of the given string argument.
       * Note that the result is a string that only contains the characters
       * a-z, A-Z, 0-9, +, /, =, and optionally spaces, CR and LF characters.
       *
       * If pos and/or len are passed, only the substring starting at
       * pos (default: 0) with length len (default: rest of the string)
       * is encoded.
       *
       * The result is divided up into lines not longer than 'linelength' 
       * (without counting the line separator); default: do not divide lines.
       * If 'linelength' is smaller than 4, no line division is performed.
       * If 'linelength' is not divisible by 4, the produced lines are a 
       * bit shorter than 'linelength'.
       *
       * If 'crlf' (default: false) the lines are ended by CRLF; otherwise 
       * they are only ended by LF.
       * (You need the crlf option to produce correct MIME messages.)
       * 
       *)

val url_encode :
  ?pos:int -> ?len:int -> ?linelength:int -> ?crlf:bool -> string -> string
      (* Same as 'encode' but use slightly different characters that can be
       * part of URLs without additional encodings.
       * The encoded string consists only of the characters a-z, A-Z, 0-9, 
       * -, /, .
       * 'url_encode' does NOT implement the Base 64 encoding as described
       * in the standard!
       *)

val decode :
  ?pos:int ->
  ?len:int -> ?url_variant:bool -> ?accept_spaces:bool -> string -> string
      (* Decodes the given string argument. 
       *
       * If pos and/or len are passed, only the substring starting at
       * pos (default: 0) with length len (default: rest of the string)
       * is decoded.
       * 
       * If url_variant (default: true) is set, the functions also
       * accepts the characters '-' and '.' as produced by 'url_encode'.
       *
       * If accept_spaces (default: false) is set, the function ignores
       * white space contained in the string to decode (otherwise the
       * function fails if it finds white space). Furthermore, the character
       * '>' is considered as "space", too (so you don't have trouble with
       * mbox mailboxes that accidentally quote "From").
       *)
