<?php
// Copyright 2003-2004 Won-Kyu Park <wkpark at kldp.org>
// All rights reserved. Distributable under GPL see COPYING
// a DisMol macro plugin for the MoniWiki
//
// $Id: Img.php,v 1.1 2003/08/10 08:20:36 wkpark Exp $

function macro_DisMol($formatter,$value) {
    global $DBInfo;

    $params='';
    $mode='sticks';
    if (!$value)
        return '<div class="message"><b>You need to provide a PDB file name!</b></div>';
    else {
        $dum=explode(',',$value);
        if (in_array('sticks',$dum)) $mode='sticks';
        else if (in_array('ball&stick',$dum)) $mode='ball&stick';
        else if (in_array('wireframe',$dum)) $mode='wireframe';
        else if (in_array('spacefill',$dum)) $mode='spacefill';
    }

    if ($mode) $params.='<param name="mode" value="'.$mode.'" />';
 
    $molpath = $DBInfo->upload_dir.'/'.$formatter->page->urlname.'/'.$value;
    $pubpath = $formatter->url_prefix.'/applets/DismolPlugin';

    if (file_exists($molpath))
        return <<<APP
<applet width='300' height='300' archive='$pubpath/dismol.zip' codebase='$pubpath' code='DisMol.class'>
  <param name='model' value="$formatter->url_prefix/$molpath" />
  $params
  DisMol applet
</applet>
APP;
    return $formatter->link_to("?action=UploadFile&name=$value", sprintf(_('Upload New Molecular File "%s"'),$value));
}
// vim:et:sts=4:sw=4:

?>
