/***************************************************************************
mondo-rstr-newt.c  -  description
-----------------

begin: Fri Apr 19 16:40:35 EDT 2002
copyright : (C) 2002 Mondo  Hugo Rabson
email	  : Hugo Rabson <hugo@firstlinux.net>
edited by : by Stan Benoit 4/2002
email     : troff@nakedsoul.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* mondo-rstr-newt.c               Hugo Rabson


07/02
- modified calls to popup_and_get_string()

06/05
- cleaned up get_isodir_info()

04/25
- cleaned up some mis-typed pointers (as in char*, not void*)

04/08/2003
- commented out call to sort_mountlist_by_device(), in case it's futzing
  with LVM/RAID users

08/21/2002
- fix MOUNTLIST_FNAME and RAIDTAB_FNAME if Reload button finds them empty

08/19
- fixed what_number_cd_is_this() to take bkpinfo as parameter

07/01 - 07/31
- renamed from mondo-newt.c to mondo-rstr-newt.c
- moved lots of subroutines to libmondo-newt.c
- added hooks to libmondo
- better handling of yes/no/YES/NO
- better "% done" feedback (Philippe de Muyter)

05/01 - 06/30
- trim trailing \n from fgets() in a couple of functions
- expanded "May I write mountlist?" message
- replace scanf() with a properly restricted fgets() (Troff)

02/01 - 02/28/2002
- allow up to 50 chars in popup_and_get_string()'s input field
- if g_current_progress > g_maximum_progress then g_current_progress=g_max...
  to stop the progress bar from shooting off the RHS of the screen :)
- beefed up the RAID-related logging a bit
- don't complain if partition format is a number (1-255)
- if hard disk does not exist then warn user when editing mountlist
- when running 'eject -t', log its output

[...]

08/09/2001
- created
*/

#include "mondo-rstr-newt.h"


extern char MOUNTLIST_FNAME[MAX_STR_LEN];

extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];

/*************************************************************************
 * add_disklist_entry() -- Hugo Rabson 													         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
add_disklist_entry (struct list_of_disks *disklist, char *raid_device,
		    struct mountlist_itself *unallocated_raid_partitions)
{
	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];

	/** newt **************************************************************/
  newtComponent myForm;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent partitionsListbox;
	newtComponent headerMsg;
	
  /** prototypes *********************************************************/
  void *keylist[ARBITRARY_MAXIMUM];
  void *curr_choice;

	/** int ****************************************************************/
  int i = 0;
	int index = 0;
	int currline = 0;
	int items = 0;


  newtPushHelpLine
    ("   Add one of the following unallocated RAID partitions to this RAID device.");
  sprintf (tmp, "%-26s %s", "Device", "Size");
  headerMsg = newtLabel (1, 1, tmp);
  partitionsListbox =
    newtListbox (1, 2, 6, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
  redraw_unallocpartnslist (unallocated_raid_partitions, keylist,
			    partitionsListbox);
  i = 7;
  bOK = newtCompactButton (i, 9, "  OK  ");
  bCancel = newtCompactButton (i += 9, 9, "Cancel");
  newtOpenWindow (22, 6, 36, 10, "Unallocated RAID partitions");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, headerMsg, partitionsListbox, bOK, bCancel,
			 NULL);
  b_res = newtRunForm (myForm);
  if (b_res != bCancel)
    {
      curr_choice = newtListboxGetCurrent (partitionsListbox);
      for (currline = 0;
	   currline < unallocated_raid_partitions->entries
	   && keylist[currline] != curr_choice; currline++);
      if (currline == unallocated_raid_partitions->entries
	  && unallocated_raid_partitions->entries > 0)
	{
	  log_it ("I don't know what this button does");
	}
      else
	{
	  index = find_next_free_index_in_disklist (disklist);
	
	  items = disklist->entries;
	  strcpy (disklist->el[items].device,
		  unallocated_raid_partitions->el[currline].device);
	  disklist->el[items].index = index;
	  disklist->entries = ++items;
	
	}
    }
  newtFormDestroy (myForm);
  newtPopWindow ();
  newtPopHelpLine ();
}




/*************************************************************************
 * add_mountlist_entry() -- Hugo Rabson 												         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
add_mountlist_entry (struct mountlist_itself *mountlist,
		     struct raidlist_itself *raidlist, newtComponent listbox,
		     int currline, void *keylist[])
{

	/** int **************************************************************/
  int i	= 0;
	int num_to_add = 0;

	/** newt *************************************************************/
  newtComponent myForm;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent mountpointComp;
	newtComponent label0;
	newtComponent label1;
	newtComponent label2;
	newtComponent label3;
	newtComponent sizeComp;
	newtComponent deviceComp;
	newtComponent formatComp;

	/** buffers **********************************************************/
  char drive_to_add[MAX_STR_LEN];
	char mountpoint_str[MAX_STR_LEN];
	char size_str[MAX_STR_LEN];
  char device_str[MAX_STR_LEN];
	char format_str[MAX_STR_LEN];

	/** pointers *********************************************************/
	char *mountpoint_here;
	char *size_here;
	char *device_here;
	char *format_here;



	strcpy (device_str, "/dev/");
	strcpy (mountpoint_str, "/");
  strcpy (format_str, "ext2");
  size_str[0] = '\0';
  /* sprintf(size_str,""); */
  newtOpenWindow (20, 5, 40, 10, "Add entry");
  label0 = newtLabel (2, 1, "Device:    ");
  label1 = newtLabel (2, 2, "Mountpoint:");
  label2 = newtLabel (2, 3, "Size (MB): ");
  label3 = newtLabel (2, 4, "Format:    ");
  deviceComp = newtEntry (14, 1, device_str, 22, (void*)&device_here, 0);
  mountpointComp = newtEntry (14, 2, mountpoint_str, 22, (void*)&mountpoint_here, 0);
  formatComp = newtEntry (14, 4, format_str, 10, (void*)&format_here, 0);
  sizeComp = newtEntry (14, 3, size_str, 8, (void*)&size_here, 0);
  bOK = newtButton (5, 6, "  OK  ");
  bCancel = newtButton (17, 6, "Cancel");
  newtPushHelpLine
    ("To add an entry to the mountlist, please fill in these fields and then hit 'OK'");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, deviceComp, mountpointComp, sizeComp,
			 formatComp, label0, label1, label2, label3, bOK,
			 bCancel, NULL);
  for (b_res = NULL; b_res != bOK && b_res != bCancel;)
    {
      b_res = newtRunForm (myForm);
      strcpy (device_str, device_here);
      strcpy (mountpoint_str, mountpoint_here);
      strcpy (format_str, format_here);
      strcpy (size_str, size_here);
//      log_it ("Originals = %s,%s,%s,%s", device_str, mountpoint_str, format_str, size_str);
      strip_spaces (device_str);
      strip_spaces (mountpoint_str);
      strip_spaces (format_str);
      strip_spaces (size_str);
//      log_it ("Modified = %s,%s,%s,%s", device_str, mountpoint_str, format_str, size_str);
      if (b_res == bOK)
	{
	  if (device_str[strlen (device_str) - 1] == '/')
	    {
	      popup_and_OK ("You left the device nearly blank!");
	      b_res = NULL;
	    }
	  if (size_of_specific_device_in_mountlist (mountlist, device_str) >= 0)
	    {
	      popup_and_OK ("Can't add this - you've got one already!");
	      b_res = NULL;
	    }
	}
    }
  newtFormDestroy (myForm);
  newtPopHelpLine ();
  newtPopWindow ();
  if (b_res == bCancel)
    {
      return;
    }
  strcpy (drive_to_add, device_str);
  for (i = strlen (drive_to_add); isdigit (drive_to_add[i - 1]); i--);
  num_to_add = atoi (drive_to_add + i);
  drive_to_add[i] = '\0';
  currline = mountlist->entries;
  strcpy (mountlist->el[currline].device, device_str);
  strcpy (mountlist->el[currline].mountpoint, mountpoint_str);
  strcpy (mountlist->el[currline].format, format_str);
  mountlist->el[currline].size = atol (size_str) * 1024;
  mountlist->entries++;
  if (strstr (mountlist->el[currline].device, "/dev/md"))
    {
      initiate_new_raidlist_entry (raidlist, mountlist, currline, device_str);
    }
  redraw_mountlist (mountlist, keylist, listbox);
}



/*************************************************************************
 * add_varslist_entry() -- Hugo Rabson 													         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
add_varslist_entry (struct raid_device_record *raidrec)
{

	/** buffers ***********************************************************/
  char sz_out[MAX_STR_LEN];

	/** int ****************************************************************/
  int items	= 0;
	int i = 0;


  sz_out[0] = '\0';
  if (popup_and_get_string
      ("Add variable", "Enter the name of the variable to add", sz_out, MAX_STR_LEN))
    {
      strip_spaces (sz_out);
      items = raidrec->additional_vars.entries;
      for (i = 0;
	   i < items && strcmp (raidrec->additional_vars.el[i].label, sz_out);
	   i++);
      if (i < items)
	{
	  popup_and_OK
	    ("No need to add that variable. It is already listed here.");
	}
      else
	{
	  strcpy (raidrec->additional_vars.el[items].label, sz_out);
	  edit_varslist_entry (raidrec, items);
	  raidrec->additional_vars.entries = ++items;
	}
    }
}


/*************************************************************************
 * calculate_raid_device_size() -- Hugo Rabson 									         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
long
calculate_raid_device_size (struct mountlist_itself *mountlist,
			    struct raidlist_itself *raidlist,
			    char *raid_device)
{

	/** structures ********************************************************/
  struct raid_device_record *raidrec;

	/** int ***************************************************************/
  int i = 0;
	int noof_partitions = 0;

	/** long **************************************************************/
  long total_size = 0;
	long smallest_partition = 999999999;
	long sp = 0;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];




  for (i = 0;
       i < raidlist->entries
       && strcmp (raidlist->el[i].raid_device, raid_device); i++);
  if (i == raidlist->entries)
    {
      sprintf (tmp,
	       "Cannot calc size of raid device %s - cannot find it in raidlist",
	       raid_device);
      log_it (tmp);
      return (999999999);
    }
  raidrec = &raidlist->el[i];
  noof_partitions = raidrec->data_disks.entries;
  if (raidrec->raid_level == -1 || raidrec->raid_level == 0)
    {
      for (total_size = 0, i = 0; i < noof_partitions; i++)
	{
	  total_size +=
	    size_of_specific_device_in_mountlist (mountlist,
				     raidrec->data_disks.el[i].device);
	}
    }
  else
    {
      for (i = 0; i < noof_partitions; i++)
	{
	  sp =
	    size_of_specific_device_in_mountlist (mountlist,
				     raidrec->data_disks.el[i].device);
	  if (smallest_partition > sp)
	    {
	      smallest_partition = sp;
	    }
	}
      total_size = smallest_partition * (noof_partitions - 1);
    }
  sprintf (tmp, "I have calculated %s's real size to be %ld", raid_device,
	   (long) total_size);
  log_it (tmp);
  return (total_size);
}



/*************************************************************************
 * choose_raid_level() -- Hugo Rabson 													         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
choose_raid_level (struct raid_device_record *raidrec)
{

	/** int ***************************************************************/
  int res = 0;
	int out = 0;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];
	char personalities[MAX_STR_LEN];
	char prompt[MAX_STR_LEN];
	char sz[MAX_STR_LEN];




  system
    ("cat /proc/mdstat | grep Pers > /tmp/raid-personalities.txt 2> /dev/null");
  strcpy (personalities, last_line_of_file ("/tmp/raid-personalities.txt"));
  sprintf (prompt, "Please enter the RAID level you want. %s", personalities);
  if (raidrec->raid_level == -1)
    {
      strcpy (tmp, "linear");
    }
  else
    {
      sprintf (tmp, "%d", raidrec->raid_level);
    }
  for (out = 999;
       out != -1 && out != 0 && out != 1 && out != 4 && out != 5
       && out != 10;)
    {
      res = popup_and_get_string ("Specify RAID level", prompt, tmp, MAX_STR_LEN);
      if (!res)
	{
	  return;
	}
      strip_spaces (tmp);
      if (tmp[0] == '[' && tmp[strlen (tmp) - 1] == ']')
	{
	  strcpy (sz, tmp);
	  strncpy (tmp, sz + 1, strlen (sz) - 2);
	  tmp[strlen (sz) - 2] = '\0';
	}
      if (!strcmp (tmp, "linear"))
	{
	  out = -1;
	}
      else if (!strncmp (tmp, "raid", 4))
	{
	  out = atoi (tmp + 4);
	}
      else
	{
	  out = atoi (tmp);
	}
      log_it (tmp);
      if (is_this_raid_personality_registered (out))
	{
	  log_it
	    ("Groovy. You've picked a RAID personality which is registered.");
	}
      else
	{
	  if (ask_me_yes_or_no
	      ("You have chosen a RAID personality which is not registered with the kernel. Make another selection?"))
	    {
	      out = 999;
	    }
	}
    }
  raidrec->raid_level = out;
}



/*************************************************************************
 * del_partns_listd_in_disklist() -- Hugo Rabson 	  						         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
del_partns_listed_in_disklist (struct mountlist_itself *mountlist,
			       struct raidlist_itself *raidlist,
			       struct list_of_disks *disklist)
{

	/** int ***************************************************************/
  int i = 0;
	int pos = 0;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];



  for (i = 0; i < disklist->entries; i++)
    {
      for (pos = 0;
	   pos < mountlist->entries
	   && strcmp (mountlist->el[pos].device, disklist->el[i].device);
	   pos++);
      if (pos < mountlist->entries)
	{
	  sprintf (tmp,
		   "Deleting partition %s cos it was part of a now-defunct RAID",
		   mountlist->el[pos].device);
	  log_it (tmp);
	  memcpy ((void *) &mountlist->el[pos],
		  (void *) &mountlist->el[mountlist->entries - 1],
		  sizeof (struct mountlist_line));
	  mountlist->entries--;
	}
    }
}



/*************************************************************************
 * delete_disklist_entry() -- Hugo Rabson												         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
delete_disklist_entry (struct list_of_disks *disklist, char *raid_device,
		       int currline)
{

	/** int ***************************************************************/
  int pos = 0;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];



  sprintf (tmp, "Delete %s from RAID device %s - are you sure?",
	   disklist->el[currline].device, raid_device);
  if (!ask_me_yes_or_no (tmp))
    {
      return;
    }
  for (pos = currline; pos < disklist->entries - 1; pos++)
    {
      /* memcpy((void*)&disklist->el[pos], (void*)&disklist->el[pos+1], sizeof(struct s_disk)); */
      strcpy (disklist->el[pos].device, disklist->el[pos + 1].device);
    }
  disklist->entries--;
}



/*************************************************************************
 * delete_mountlist_entry() -- Hugo Rabson 	  									         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
delete_mountlist_entry (struct mountlist_itself *mountlist,
			struct raidlist_itself *raidlist,
			newtComponent listbox, int currline, void *keylist[])
{

	/** int ***************************************************************/
  int pos = 0;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];
	char device[MAX_STR_LEN];



  pos =
    which_raid_device_is_using_this_partition (raidlist,
					       mountlist->el[currline].
					       device);
  if (pos >= 0)
    {
      sprintf (tmp, "Cannot delete %s: it is in use by RAID device %s",
	       mountlist->el[currline].device, raidlist->el[pos].raid_device);
      popup_and_OK (tmp);
      return;
    }
  sprintf (tmp, "Delete %s - are you sure?", mountlist->el[currline].device);
  if (!ask_me_yes_or_no (tmp))
    {
      return;
    }
  if (strstr (mountlist->el[currline].device, "/dev/md"))
    {
      strcpy (device, mountlist->el[currline].device);
      delete_raidlist_entry (mountlist, raidlist, device);
      for (currline = 0;
	   currline < mountlist->entries
	   && strcmp (mountlist->el[currline].device, device); currline++);
      if (currline == mountlist->entries)
	{
	  log_it ("Dev is gone. I can't delete it. Ho-hum");
	  return;
	}
    }
  memcpy ((void *) &mountlist->el[currline],
	  (void *) &mountlist->el[mountlist->entries - 1],
	  sizeof (struct mountlist_line));
  mountlist->entries--;
  redraw_mountlist (mountlist, keylist, listbox);
}

/*************************************************************************
 * delete_raidlist_entry() -- Hugo Rabson   										         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
delete_raidlist_entry (struct mountlist_itself *mountlist,
		       struct raidlist_itself *raidlist, char *device)
{
	
	/** int ***************************************************************/
  int i = 0;
	int items =0;

	/** bool **************************************************************/
  bool delete_partitions_too;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];

  i = find_raid_device_in_raidlist (raidlist, device);
  if (i < 0)
    {
      return;
    }
  sprintf (tmp, "Do you want me to delete %s's partitions, too?", device);
  delete_partitions_too = ask_me_yes_or_no (tmp);
  if (delete_partitions_too)
    {
      del_partns_listed_in_disklist (mountlist, raidlist,
				     &raidlist->el[i].data_disks);
      del_partns_listed_in_disklist (mountlist, raidlist,
				     &raidlist->el[i].spare_disks);
      del_partns_listed_in_disklist (mountlist, raidlist,
				     &raidlist->el[i].parity_disks);
      del_partns_listed_in_disklist (mountlist, raidlist,
				     &raidlist->el[i].failed_disks);
    }
  items = raidlist->entries;
  if (items == 1)
    {
      items = 0;
    }
  else
    {
      log_it (tmp);
      memcpy ((void *) &raidlist->el[i], (void *) &raidlist->el[items - 1],
	      sizeof (struct raid_device_record));
      items--;
    }
  raidlist->entries = items;
}



/*************************************************************************
 * delete_varslist_entry() -- Hugo Rabson 											         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
delete_varslist_entry (struct raid_device_record *raidrec, int lino)
{

	/** buffers ************************************************************/
  char tmp[MAX_STR_LEN];

	/** structures *********************************************************/
  struct additional_raid_variables *av;



  av = &raidrec->additional_vars;
  sprintf (tmp, "Delete %s - are you sure?", av->el[lino].label);
  if (ask_me_yes_or_no (tmp))
    {
      if (!strcmp (av->el[lino].label, "persistent-superblock")
	  || !strcmp (av->el[lino].label, "chunk-size"))
	{
	  sprintf (tmp, "%s must not be deleted. It would be bad.",
		   av->el[lino].label);
	  popup_and_OK (tmp);
	}
      else
	{
	  memcpy ((void *) &av->el[lino], (void *) &av->el[av->entries--],
		  sizeof (struct raid_var_line));
	}
    }
}

/*************************************************************************
 * redraw_filelist() -- Hugo Rabson               							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
redraw_filelist (struct s_node *filelist, void *keylist[ARBITRARY_MAXIMUM],
		 newtComponent listbox)
{

	/** int ***************************************************************/
  static int lines_in_flist_window = 0;
  static int depth = 0;
  int i = 0;

	/** structures *******************************************************/
  struct s_node *node;

	/** buffers **********************************************************/
  static char current_filename[MAX_STR_LEN];
  char tmp[MAX_STR_LEN + 2];

	/** bool *************************************************************/
	/*  void*dummyptr; */
  bool dummybool;
  static bool warned_already;



  if (depth == 0)
    {
      lines_in_flist_window = 0;
      warned_already = FALSE;
      for (i = 0; i < ARBITRARY_MAXIMUM; i++)
	{
	  g_strings_of_flist_window[i][0] = '\0';
	  g_is_path_selected[i] = FALSE;
	}
    }
  for (node = filelist; node != NULL; node = node->right)
    {
      current_filename[depth] = node->ch;
      if (node->down)
	{
	  depth++;
	  i = redraw_filelist (node->down, keylist, listbox);
	  depth--;
	}
      if (node->ch == '\0' && node->expanded)
	{
	  if (lines_in_flist_window == ARBITRARY_MAXIMUM)
	    {
	      if (!warned_already)
		{
		  warned_already = TRUE;
		  sprintf (tmp,
			   "Too many lines. Displaying first %d entries only. Close a directory to see more.",
			   ARBITRARY_MAXIMUM);
		  popup_and_OK (tmp);
		}
	    }
	  else
	    {
	      strcpy (g_strings_of_flist_window[lines_in_flist_window],
		      current_filename);
	      g_is_path_selected[lines_in_flist_window] = node->selected;
	      lines_in_flist_window++;
	    }
	}
    }
  if (depth == 0)
    {
      if (lines_in_flist_window > ARBITRARY_MAXIMUM)
	{
	  lines_in_flist_window = ARBITRARY_MAXIMUM;
	}
/* do an elementary sort */
      for (i = 1; i < lines_in_flist_window; i++)
	{
	  if (strcmp
	      (g_strings_of_flist_window[i],
	       g_strings_of_flist_window[i - 1]) < 0)
	    {
	      strcpy (tmp, g_strings_of_flist_window[i]);
	      strcpy (g_strings_of_flist_window[i],
		      g_strings_of_flist_window[i - 1]);
	      strcpy (g_strings_of_flist_window[i - 1], tmp);
	      dummybool = g_is_path_selected[i];
	      g_is_path_selected[i] = g_is_path_selected[i - 1];
	      g_is_path_selected[i - 1] = dummybool;
	      i = 0;
	    }
	}
/* write list to screen */
      newtListboxClear (listbox);
      for (i = 0; i < lines_in_flist_window; i++)
	{
	  sprintf (tmp, "%c%c %-80s", (g_is_path_selected[i] ? '*' : ' '),
		   (g_is_path_expanded[i] ? '+' : '-'),
		   g_strings_of_flist_window[i]);
	  tmp[70] = '\0';
	  keylist[i] = (void *) i;
	  newtListboxAppendEntry (listbox, tmp, keylist[i]);
	}
      return (lines_in_flist_window);
    }
  else
    {
      return (0);
    }
}



/*************************************************************************
 * edit_filelist() -- Hugo Rabson                 							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
edit_filelist (struct s_node *filelist)
{

	/** newt **************************************************************/
  newtComponent myForm;
	newtComponent bLess;
	newtComponent bMore;
	newtComponent bToggle;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent filelistListbox;
	newtComponent bRegex;

	/** int ***************************************************************/
	int finished = FALSE;
	int lines_in_flist_window = 0;
	int indexno = 0;
	int j = 0;

	/** ???? **************************************************************/
  void *curr_choice;
  void *keylist[ARBITRARY_MAXIMUM];

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];

	/** bool **************************************************************/
  bool dummybool;

/*  struct s_node *node; */

  log_to_screen ("Editing filelist");
  newtPushHelpLine
    ("   Please edit the filelist to your satisfaction, then click OK or Cancel.");
  j = 4;
  bLess = newtCompactButton (j, 17, " Less ");
  bMore = newtCompactButton (j += 12, 17, " More ");
  bToggle = newtCompactButton (j += 12, 17, "Toggle");
  bRegex = newtCompactButton (j += 12, 17, "RegEx");
  bCancel = newtCompactButton (j += 12, 17, "Cancel");
  bOK = newtCompactButton (j += 12, 17, "  OK  ");
  filelistListbox =
    newtListbox (2, 1, 15, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
  toggle_all_root_dirs_on (filelist);
  lines_in_flist_window =
    redraw_filelist (filelist, keylist, filelistListbox);
  newtOpenWindow (1, 3, 77, 18, "Editing filelist");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, filelistListbox, bLess, bMore, bToggle,
			 bRegex, bCancel, bOK, NULL);
  while (!finished)
    {
      b_res = newtRunForm (myForm);
      if (b_res == bOK)
	{
	  finished =
	    ask_me_yes_or_no ("Are you happy with your file selection?");
	}
      else if (b_res == bCancel)
	{
	  finished = TRUE;
	}
      else if (b_res == bRegex)
	{
	  popup_and_OK ("I haven't implemented this yet...");
	}
      else
	{
	  curr_choice = newtListboxGetCurrent (filelistListbox);
	  for (indexno = 0;
	       indexno < lines_in_flist_window
	       && keylist[indexno] != curr_choice; indexno++);
	  if (indexno == lines_in_flist_window)
	    {
	      log_it
		("I don't know what this button does; assuming I am to toggle 1st entry");
	      indexno = 0;
	    }
	  sprintf (tmp, "You selected '%s'",
		   g_strings_of_flist_window[indexno]);
	  log_it (tmp);
	  if (b_res == bMore)
	    {
	      g_is_path_expanded[indexno] = TRUE;
	      toggle_path_expandability (filelist,
					 g_strings_of_flist_window[indexno],
					 TRUE);
	      lines_in_flist_window =
		redraw_filelist (filelist, keylist, filelistListbox);
	      newtListboxSetCurrentByKey (filelistListbox, curr_choice);
	    }
	  else if (b_res == bLess)
	    {
	      g_is_path_expanded[indexno] = FALSE;
	      toggle_path_expandability (filelist,
					 g_strings_of_flist_window[indexno],
					 FALSE);
	      lines_in_flist_window =
		redraw_filelist (filelist, keylist, filelistListbox);
	      newtListboxSetCurrentByKey (filelistListbox, curr_choice);
	    }
	  else
	    {
	      if (!strcmp (g_strings_of_flist_window[indexno], "/"))
		{
		  dummybool = !g_is_path_selected[indexno];
		  for (j = 1; j < lines_in_flist_window; j++)
		    {
		      toggle_path_selection (filelist,
					     g_strings_of_flist_window[j],
					     dummybool);
		    }
		}
	      else
		{
		  toggle_path_selection (filelist,
					 g_strings_of_flist_window[indexno],
					 !g_is_path_selected[indexno]);
		  lines_in_flist_window =
		    redraw_filelist (filelist, keylist, filelistListbox);
		}
	      newtListboxSetCurrentByKey (filelistListbox, curr_choice);
	    }
	  for (indexno = 0;
	       indexno < lines_in_flist_window
	       && keylist[indexno] != curr_choice; indexno++);
	  if (indexno == lines_in_flist_window)
	    {
	      log_it
		("Layout of table has changed. Y pointer is reverting to zero.");
	      indexno = 0;
	    }
	}
    }
  newtFormDestroy (myForm);
  newtPopWindow ();
  newtPopHelpLine ();
  if (b_res == bOK)
    {
      return (0);
    }
  else
    {
/*    popup_and_OK("You pushed 'cancel'. I shall now abort."); */
      return (1);
    }
}


/*************************************************************************
 * edit_mountlist_entry() -- Hugo Rabson          							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
edit_mountlist_entry (struct mountlist_itself *mountlist,
		      struct raidlist_itself *raidlist, newtComponent listbox,
		      int currline, void *keylist[])
{

	/** structures ********************************************************/
  struct raidlist_itself bkp_raidlist;

	/** newt **************************************************************/
  newtComponent myForm;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent mountpointComp;
	newtComponent label0;
	newtComponent label1;
	newtComponent label2;
	newtComponent label3;
	newtComponent sizeComp;
	newtComponent deviceComp;
	newtComponent formatComp;
	newtComponent b_raid = NULL;

  /** buffers ***********************************************************/
	char device_str[MAX_STR_LEN];
	char mountpoint_str[MAX_STR_LEN];
	char size_str[MAX_STR_LEN];
	char format_str[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];
  char device_used_to_be[MAX_STR_LEN];
	char mountpt_used_to_be[MAX_STR_LEN];

	/** pointers **********************************************************/
	char *device_here;
	char *mountpoint_here;
	char *size_here;
	char *format_here;

	/** int ***************************************************************/
  int j = 0;




  memcpy ((void *) &bkp_raidlist, (void *) raidlist,
	  sizeof (struct raidlist_itself));
  strcpy (device_str, mountlist->el[currline].device);
  strcpy (device_used_to_be, mountlist->el[currline].device);
  strcpy (mountpoint_str, mountlist->el[currline].mountpoint);
  strcpy (mountpt_used_to_be, mountlist->el[currline].mountpoint);
  strcpy (format_str, mountlist->el[currline].format);
  sprintf (size_str, "%ld", mountlist->el[currline].size / 1024);
  newtOpenWindow (20, 5, 40, 10, "Edit entry");
  label0 = newtLabel (2, 1, "Device:");
  label1 = newtLabel (2, 2, "Mountpoint:");
  label2 = newtLabel (2, 3, "Size (MB): ");
  label3 = newtLabel (2, 4, "Format:    ");
  deviceComp = newtEntry (14, 1, device_str, 22, (void*)&device_here, 0);
  mountpointComp = newtEntry (14, 2, mountpoint_str, 22, (void*)&mountpoint_here, 0);
  formatComp = newtEntry (14, 4, format_str, 10, (void*)&format_here, 0);
  if (strstr (mountlist->el[currline].device, "/dev/md")
      || !strcmp (mountlist->el[currline].mountpoint, "image"))
    {
      sizeComp = newtLabel (14, 3, size_str);
    }
  else
    {
      sizeComp = newtEntry (14, 3, size_str, 8, (void*)&size_here, 0);
    }
  bOK = newtButton (2, 6, "  OK  ");
  bCancel = newtButton (14, 6, "Cancel");
  if (strstr (mountlist->el[currline].device, "/dev/md"))
    {
      b_raid = newtButton (26, 6, "RAID..");
    }
  newtPushHelpLine
    ("       Edit this partition's mountpoint, size and format; then click 'OK'.");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, deviceComp, mountpointComp, sizeComp,
			 formatComp, label0, label1, label2, label3, bOK,
			 bCancel, b_raid, NULL);
  for (b_res = NULL; b_res != bOK && b_res != bCancel;)
    {
      b_res = newtRunForm (myForm);
      strcpy (device_str, device_here);
      strip_spaces (device_str);
      strcpy (mountpoint_str, mountpoint_here);
      strip_spaces (mountpoint_str);
      strcpy (format_str, format_here);
      strip_spaces (format_str);
      if (b_res == bOK && strstr (device_str, "/dev/md")
	  && strstr (device_used_to_be, "/dev/md")
	  && strcmp (device_str, device_used_to_be))
	{
	  popup_and_OK ("You can't change /dev/mdX to /dev/mdY.");
	  b_res = NULL;
	  continue;
	}
      else if (b_res == bOK && !strcmp (mountpoint_str, "image")
	       && strcmp (mountpt_used_to_be, "image"))
	{
	  popup_and_OK ("You can't change a regular device to an image.");
	  b_res = NULL;
	  continue;
	}
      if (!strstr (mountlist->el[currline].device, "/dev/md")
	  && strcmp (mountlist->el[currline].mountpoint, "image"))
	{
	  strcpy (size_str, size_here);
	  strip_spaces (size_str);
	}
      else
	{
	  sprintf (size_str, "%ld",
		   calculate_raid_device_size (mountlist, raidlist,
					       mountlist->el[currline].
					       device) / 1024);
	  newtLabelSetText (sizeComp, size_str);
	}
      /* do not let user click RAID button if user has changed device_str */
      if (b_res == b_raid)
	{
	  if (strcmp (device_str, mountlist->el[currline].device))
	    {
	      /*
	         can't change mountlist's entry from /dex/mdX to /dev/mdY: it would ugly 
	         when you try to map the changes over to the raidtab list, trust me
	       */
	      popup_and_OK
		("You cannot edit the RAID settings until you have OK'd your change to the device node.");
	    }
	  else
	    {
	      j =
		find_raid_device_in_raidlist (raidlist,
					      mountlist->el[currline].device);
	      if (j < 0)
		{
		  sprintf (tmp,
			   "/etc/raidtab does not have an entry for %s; please delete it and add it again",
			   mountlist->el[currline].device);
		  popup_and_OK (tmp);
		}
	      else
		{
		  log_it ("edit_raidlist_entry - calling");
		  edit_raidlist_entry (mountlist, raidlist, &raidlist->el[j],
				       currline);
		}
	    }
	}
    }
  newtFormDestroy (myForm);
  newtPopHelpLine ();
  newtPopWindow ();
  if (b_res == bCancel)
    {
      memcpy ((void *) raidlist, (void *) &bkp_raidlist,
	      sizeof (struct raidlist_itself));
      return;
    }
  strcpy (mountlist->el[currline].device, device_str);
  strcpy (mountlist->el[currline].mountpoint, mountpoint_str);
  strcpy (mountlist->el[currline].format, format_str);
  if (strstr (mountlist->el[currline].device, "/dev/md")
      || !strcmp (mountlist->el[currline].mountpoint, "image"))
    {
      mountlist->el[currline].size =
	calculate_raid_device_size (mountlist, raidlist,
				    mountlist->el[currline].device);
    }
  else
    {
      mountlist->el[currline].size = atol (size_str) * 1024;
    }
  newtListboxSetEntry (listbox, (int) keylist[currline],
		       mountlist_entry_to_string (mountlist, currline));
  /* if new /dev/md RAID device then do funky stuff */
  if (strstr (mountlist->el[currline].device, "/dev/md")
      && !strstr (device_used_to_be, "/dev/md"))
    {
      initiate_new_raidlist_entry (raidlist, mountlist, currline, device_str);
    }
  /* if moving from RAID to non-RAID then do funky stuff */
  else if (strstr (device_used_to_be, "/dev/md")
	   && !strstr (device_str, "/dev/md"))
    {
      delete_raidlist_entry (mountlist, raidlist, device_str);
    }
  /* if moving a non-RAID to another non-RAID then re-jig any RAID disks, if necessary */
  else if (!strstr (device_used_to_be, "/dev/md")
	   && !strstr (device_str, "/dev/md"))
    {
      rejig_partition_name_in_raidlist_if_necessary (raidlist,
						     device_used_to_be,
						     device_str);
    }
/* else, moving a RAID to another RAID; bad idea, or so I thought */
  else if (strcmp (device_used_to_be, device_str))
    {
      popup_and_OK
	("You are renaming a RAID device as another RAID device. I don't like it but I'll allow it.");
    }
  redraw_mountlist (mountlist, keylist, listbox);
}




/*************************************************************************
 * edit_raidlist_entry() -- Hugo Rabson           							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
edit_raidlist_entry (struct mountlist_itself *mountlist,
		     struct raidlist_itself *raidlist,
		     struct raid_device_record *raidrec, int currline)
{

	/** structures ********************************************************/
  struct raid_device_record bkp_raidrec;


	/** buffers ***********************************************************/
  char title_of_editraidForm_window[MAX_STR_LEN];
	char sz_raid_level[MAX_STR_LEN];
	char sz_data_disks[MAX_STR_LEN];
	char sz_spare_disks[MAX_STR_LEN];
	char sz_parity_disks[MAX_STR_LEN];
	char sz_failed_disks[MAX_STR_LEN];

	/** newt **************************************************************/
  newtComponent editraidForm;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent bAdditional;
	newtComponent bChangeRaid;
	newtComponent bSelectData;
	newtComponent bSelectSpare;
	newtComponent bSelectParity;
	newtComponent bSelectFailed;
	newtComponent b_res;



  log_it ("Started edit_raidlist_entry");
  memcpy ((void *) &bkp_raidrec, (void *) raidrec,
	  sizeof (struct raid_device_record));
  sprintf (title_of_editraidForm_window, "%s", raidrec->raid_device);
  newtOpenWindow (20, 5, 40, 14, title_of_editraidForm_window);
  for (;;)
    {
      sprintf (title_of_editraidForm_window, "Edit %s", raidrec->raid_device);
      strcpy (sz_raid_level,
	      turn_raid_level_number_to_string (raidrec->raid_level));
      strcpy (sz_data_disks,
	      number_of_disks_as_string (raidrec->data_disks.entries,
					 "data"));
      strcpy (sz_spare_disks,
	      number_of_disks_as_string (raidrec->spare_disks.entries,
					 "spare"));
      strcpy (sz_parity_disks,
	      number_of_disks_as_string (raidrec->parity_disks.entries,
					 "parity"));
      strcpy (sz_failed_disks,
	      number_of_disks_as_string (raidrec->failed_disks.entries,
					 "failed"));
      bSelectData = newtButton (1, 1, sz_data_disks);
      bSelectSpare = newtButton (20, 1, sz_spare_disks);
      bSelectParity = newtButton (1, 5, sz_parity_disks);
      bSelectFailed = newtButton (20, 5, sz_failed_disks);
      bChangeRaid = newtButton (1, 9, sz_raid_level);
      bOK = newtButton (16 + (raidrec->raid_level == -1), 9, "  OK  ");
      bCancel = newtButton (28, 9, "Cancel");
      bAdditional =
	newtCompactButton (1, 13, "Additional settings and information");
      newtPushHelpLine
	("  Edit the RAID device's settings to your heart's content, then hit OK/Cancel.");
      editraidForm = newtForm (NULL, NULL, 0);
      newtFormAddComponents (editraidForm, bSelectData, bSelectParity,
			     bChangeRaid, bSelectSpare, bSelectFailed, bOK,
			     bCancel, bAdditional);
      b_res = newtRunForm (editraidForm);
      if (b_res == bChangeRaid)
	{
	  choose_raid_level (raidrec);
	}
      else if (b_res == bSelectData)
	{
	  select_raid_disks (mountlist, raidlist, raidrec, "data",
			     &raidrec->data_disks);
	}
      else if (b_res == bSelectSpare)
	{
	  select_raid_disks (mountlist, raidlist, raidrec, "spare",
			     &raidrec->spare_disks);
	}
      else if (b_res == bSelectParity)
	{
	  select_raid_disks (mountlist, raidlist, raidrec, "parity",
			     &raidrec->parity_disks);
	}
      else if (b_res == bSelectFailed)
	{
	  select_raid_disks (mountlist, raidlist, raidrec, "failed",
			     &raidrec->failed_disks);
	}
      else if (b_res == bAdditional)
	{
	  edit_raidrec_additional_vars (raidrec);
	}
      newtFormDestroy (editraidForm);
      if (b_res == bOK || b_res == bCancel)
	{
	  break;
	}
    }
  if (b_res == bCancel)
    {
      memcpy ((void *) raidrec, (void *) &bkp_raidrec,
	      sizeof (struct raid_device_record));
    }
  newtPopHelpLine ();
  newtPopWindow ();
  mountlist->el[currline].size =
    calculate_raid_device_size (mountlist, raidlist, raidrec->raid_device);
}


/*************************************************************************
 * edit_varslist_entry() -- Hugo Rabson           							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
edit_varslist_entry (struct raid_device_record *raidrec, int lino)
{

	/** buffers ***********************************************************/
  char header[MAX_STR_LEN];
	char comment[MAX_STR_LEN];
	char sz_out[MAX_STR_LEN];

  strcpy (sz_out, raidrec->additional_vars.el[lino].value);
  sprintf (header, "Edit %s", raidrec->additional_vars.el[lino].label);
  sprintf (comment, "Please set %s's value (currently '%s')",
	   raidrec->additional_vars.el[lino].label, sz_out);
  if (popup_and_get_string (header, comment, sz_out, MAX_STR_LEN))
    {
      strip_spaces (sz_out);
      strcpy (raidrec->additional_vars.el[lino].value, sz_out);
    }
}


/* I'm not racist against white people. I just don't like people who think Liberia is near Spain.       - Hugo, 09/01/2001 */



/*************************************************************************
 * edit_mountlist() -- Hugo Rabson                							         *
 *                                                                       *
 * Purpose:   To confuse the heck out of Troff :^)                       *
 * Called by: The unholy powers of evil C coding                         *
 * returns:   Desolation and perdition, muahahaha!                       *
 *************************************************************************/
int
edit_mountlist (struct mountlist_itself *mountlist,
		struct raidlist_itself *raidlist)
{

	/** newt **************************************************************/
  newtComponent myForm;
	newtComponent bAdd;
	newtComponent bEdit;
	newtComponent bDelete;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent partitionsListbox;
	newtComponent headerMsg;
	newtComponent flawsLabelA;
	newtComponent flawsLabelB;
	newtComponent flawsLabelC;
	newtComponent bReload;

	/** ???? *************************************************************/
  void *curr_choice;
  void *keylist[ARBITRARY_MAXIMUM];

	/** int **************************************************************/
  int i	= 0;
	int currline = 0;
	int finished = FALSE;

	/** buffers **********************************************************/
	char tmp[MAX_STR_LEN];
	char flaws_str_A[MAX_STR_LEN];
	char flaws_str_B[MAX_STR_LEN];
	char flaws_str_C[MAX_STR_LEN];


  strcpy (flaws_str_A, "xxxxxxxxx");
  strcpy (flaws_str_B, "xxxxxxxxx");
  strcpy (flaws_str_C, "xxxxxxxxx");
  if (mountlist->entries > ARBITRARY_MAXIMUM)
    {
      log_to_screen ("Arbitrary limits suck, man!");
      finish (1);
    }
  newtPushHelpLine
    ("   Please edit the mountlist to your satisfaction, then click OK or Cancel.");
  i = 4;
  bAdd = newtCompactButton (i, 17, " Add ");
  bEdit = newtCompactButton (i += 11, 17, " Edit ");
  bDelete = newtCompactButton (i += 12, 17, "Delete");
  bReload = newtCompactButton (i += 12, 17, "Reload");
  bCancel = newtCompactButton (i += 12, 17, "Cancel");
  bOK = newtCompactButton (i += 12, 17, "  OK  ");
  sprintf (tmp, "%-24s %-24s %-8s  %s", "Device", "Mountpoint", "Format",
	   "Size (MB)");
  headerMsg = newtLabel (2, 1, tmp);
  flawsLabelA = newtLabel (2, 13, flaws_str_A);
  flawsLabelB = newtLabel (2, 14, flaws_str_B);
  flawsLabelC = newtLabel (2, 15, flaws_str_C);
  partitionsListbox =
    newtListbox (2, 2, 10, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
  redraw_mountlist (mountlist, keylist, partitionsListbox);
  newtOpenWindow (1, 3, 77, 18, "Editing mountlist");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, headerMsg, partitionsListbox, flawsLabelA,
			 flawsLabelB, flawsLabelC, bAdd, bEdit, bDelete,
			 bReload, bCancel, bOK, NULL);
  while (!finished)
    {
      evaluate_mountlist (mountlist, flaws_str_A, flaws_str_B, flaws_str_C);
      newtLabelSetText (flawsLabelA, flaws_str_A);
      newtLabelSetText (flawsLabelB, flaws_str_B);
      newtLabelSetText (flawsLabelC, flaws_str_C);
      b_res = newtRunForm (myForm);
      if (b_res == bOK)
	{
	  if (!evaluate_mountlist
	      (mountlist, flaws_str_A, flaws_str_B, flaws_str_C))
	    {
	      finished =
		ask_me_yes_or_no
		("Your mountlist might not work. Continue anyway?");
	    }
	  else
	    {
	      finished =
		ask_me_yes_or_no
		("Are you sure you want to save your mountlist and continue? (No changes will be made to your partition table at this time.)");
	    }
	}
      else if (b_res == bCancel)
	{
	  finished = TRUE;
	}
      else if (b_res == bReload)
	{
	  if (ask_me_yes_or_no ("Reload original mountlist?"))
	    {
	      if (!MOUNTLIST_FNAME[0])
		{
                  strcpy(MOUNTLIST_FNAME, "/tmp/mountlist.txt");
		  log_it("Warning - mountlist_fname is blank. Assuming %s", MOUNTLIST_FNAME);
		}
	      if (!RAIDTAB_FNAME[0])
		{
                  strcpy(RAIDTAB_FNAME, "/etc/raidtab");
 		  log_it("Warning - raidtab_fname is blank. Assuming %s", RAIDTAB_FNAME);
		}
	      load_mountlist (mountlist, MOUNTLIST_FNAME);
	      load_raidtab_into_raidlist (raidlist, RAIDTAB_FNAME);
	      redraw_mountlist (mountlist, keylist, partitionsListbox);
	    }
	}
      else
	{
	  curr_choice = newtListboxGetCurrent (partitionsListbox);
	  for (i = 0; i < mountlist->entries && keylist[i] != curr_choice;
	       i++);
	  if (i == mountlist->entries && mountlist->entries > 0)
	    {
	      log_to_screen ("I don't know what that button does!");
	    }
	  else
	    {
	      currline = i;
	      if (b_res == bAdd)
		{
		  add_mountlist_entry (mountlist, raidlist, partitionsListbox,
				       currline, keylist);
		}
	      else if (b_res == bDelete)
		{
		  delete_mountlist_entry (mountlist, raidlist,
					  partitionsListbox, currline,
					  keylist);
		}
	      else
		{
		  if (mountlist->entries > 0)
		    {
		      edit_mountlist_entry (mountlist, raidlist,
					    partitionsListbox, currline,
					    keylist);
		    }
		  else
		    {
		      popup_and_OK
			("Please add an entry. Then press ENTER to edit it.");
		    }
		}
	    }
	}
    }
  newtFormDestroy (myForm);
  newtPopWindow ();
  newtPopHelpLine ();
  if (b_res == bOK)
    {
      log_it("You pushed 'OK'. I shall now continue.");
      return (0);
    }
  else
    {
      /* popup_and_OK("You pushed 'cancel'. I shall now abort."); */
      return (1);
    }
}



/*************************************************************************
 * edit_raidrec_additional_vars() Hugo Rabson      							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
edit_raidrec_additional_vars (struct raid_device_record *raidrec)
{

	/** structure *********************************************************/
  struct raid_device_record bkp_raidrec;

	/** newt **************************************************************/
  newtComponent myForm;
	newtComponent bAdd;
	newtComponent bEdit;
	newtComponent bDelete;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent varsListbox;
	newtComponent headerMsg;

	/** ?? ***************************************************************/
  void *keylist[ARBITRARY_MAXIMUM], *curr_choice;

	/** buffers **********************************************************/
  char title_of_window[MAX_STR_LEN];

	/** int **************************************************************/
  int i = 0;
	int currline = 0;



  memcpy ((void *) &bkp_raidrec, (void *) raidrec,
	  sizeof (struct raid_device_record));
  sprintf (title_of_window, "Additional variables");
  newtPushHelpLine
    ("  Edit the additional fields to your heart's content, then click OK or Cancel.");
  headerMsg = newtLabel (1, 1, "Label                            Value");
  varsListbox =
    newtListbox (1, 2, 6, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
  i = 1;
  bAdd = newtCompactButton (i, 9, " Add ");
  bEdit = newtCompactButton (i += 8, 9, " Edit ");
  bDelete = newtCompactButton (i += 9, 9, "Delete");
  bOK = newtCompactButton (i += 9, 9, "  OK  ");
  bCancel = newtCompactButton (i += 9, 9, "Cancel");
  newtOpenWindow (17, 7, 46, 10, title_of_window);
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, headerMsg, varsListbox, bAdd, bEdit, bDelete,
			 bOK, bCancel, NULL);
  insert_essential_additionalvars (raidrec);
  redraw_varslist (&raidrec->additional_vars, keylist, varsListbox);
  for (b_res = NULL; b_res != bOK && b_res != bCancel;)
    {
      b_res = newtRunForm (myForm);
      curr_choice = newtListboxGetCurrent (varsListbox);
      for (currline = 0;
	   currline < raidrec->additional_vars.entries
	   && keylist[currline] != curr_choice; currline++);
      if (currline == raidrec->additional_vars.entries
	  && raidrec->additional_vars.entries > 0)
	{
	  log_it ("Warning - I don't know what this button does");
	}
      if (b_res == bOK)
	{			/* do nothing */
	}
      else if (b_res == bCancel)
	{			/* do nothing */
	}
      else if (b_res == bAdd)
	{
	  add_varslist_entry (raidrec);
	}
      else if (b_res == bDelete)
	{
	  delete_varslist_entry (raidrec, currline);
	}
      else
	{
	  edit_varslist_entry (raidrec, currline);
	}
      redraw_varslist (&raidrec->additional_vars, keylist, varsListbox);
    }
  remove_essential_additionalvars (raidrec);
  newtFormDestroy (myForm);
  newtPopWindow ();
  newtPopHelpLine ();
  if (b_res == bCancel)
    {
      memcpy ((void *) raidrec, (void *) &bkp_raidrec,
	      sizeof (struct raid_device_record));
    }
  return;
}



/*************************************************************************
 * find_next_free_index_in_disklist() -- Hugo Rabson 						         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
find_next_free_index_in_disklist (struct list_of_disks *disklist)
{

	/** int ***************************************************************/
  int index = -1;
	int pos = 0;
	
  /** bool **************************************************************/
  bool done;


  for (done = FALSE; !done;)
    {
      for (pos = 0;
	   pos < disklist->entries && disklist->el[pos].index <= index;
	   pos++);
      if (pos >= disklist->entries)
	{
	  done = TRUE;
	}
      else
	{
	  index = disklist->el[pos].index;
	}
    }
  return (index + 1);
}




/*************************************************************************
 * find_raid_device_in_raidlist() -- Hugo Rabson   							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
find_raid_device_in_raidlist (struct raidlist_itself *raidlist, char *device)
{

	/** int ***************************************************************/
  int i = 0;


  for (i = 0;
       strcmp (raidlist->el[i].raid_device, device) && i < raidlist->entries;
       i++);
  if (i == raidlist->entries)
    {
      return (-1);
    }
  else
    {
      return (i);
    }
}




/*************************************************************************
 * get_isodir_info() -- Hugo Rabson                							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
bool
get_isodir_info (char *isodir_device, char *isodir_format, char *isodir_path, bool nuke_me_please)
{

	/** initialize ********************************************************/

  log_it("%d - AAA - isodir_path = %s", isodir_path);
  isodir_format[0] = '\0';
  if (isodir_device[0]=='\0') { strcpy (isodir_device, "/dev/"); }
  if (isodir_path[0]=='\0') { strcpy (isodir_path, "/"); }
  if (does_file_exist ("/tmp/NFS-SERVER-PATH"))
    {
      strcpy (isodir_device, last_line_of_file ("/tmp/NFS-SERVER-MOUNT"));
      strcpy (isodir_format, "nfs");
      strcpy (isodir_path, last_line_of_file ("/tmp/NFS-SERVER-PATH"));
    }
  if (nuke_me_please) { return(TRUE); }

  if (popup_and_get_string
      ("ISO Mode - device", "On what device do the ISO files live?",
       isodir_device, MAX_STR_LEN/4))
    {
      if (popup_and_get_string
	  ("ISO Mode - format",
	   "What is the disk format of the device? (Hit ENTER if you don't know.)",
	   isodir_format, 16))
	{
	  if (popup_and_get_string
	      ("ISO Mode - path",
	       "At what path on this device can the ISO files be found?",
	       isodir_path, MAX_STR_LEN/4))
	    {
	      strip_spaces (isodir_device);
	      strip_spaces (isodir_format);
	      strip_spaces (isodir_path);
  log_it("%d - BBB - isodir_path = %s", isodir_path);
	      return (TRUE);
	    }
	}
    }
  return (FALSE);
}


/*************************************************************************
 * initiate_new_raidlist_entry() -- Hugo Rabson    							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
initiate_new_raidlist_entry (struct raidlist_itself *raidlist,
			     struct mountlist_itself *mountlist, int currline,
			     char *device)
{

	/** structure *********************************************************/
  struct raid_device_record *raidrec;

	/** int ***************************************************************/
  int pos_in_raidlist = 0;

  pos_in_raidlist =
    find_raid_device_in_raidlist (raidlist, mountlist->el[currline].device);
  if (pos_in_raidlist >= 0)
    {
      fatal_error ("Sorry, that RAID device already exists. Weird.");
    }
  pos_in_raidlist = raidlist->entries++;
  raidrec = &raidlist->el[pos_in_raidlist];
  initialize_raidrec (raidrec);
  strcpy (raidrec->raid_device, device);
  choose_raid_level (raidrec);
  select_raid_disks (mountlist, raidlist, raidrec, "data",
		     &raidrec->data_disks);
  edit_raidlist_entry (mountlist, raidlist, raidrec, currline);
}



/*************************************************************************
 * insert_essential_additionalvars() -- Hugo Rabson  						         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
insert_essential_additionalvars (struct raid_device_record *raidrec)
{

	/** int **************************************************************/
  int items = 0;



  items = raidrec->additional_vars.entries;
  write_variableINT_to_raid_var_line (raidrec, items++,
				      "persistent-superblock",
				      raidrec->persistent_superblock);
  write_variableINT_to_raid_var_line (raidrec, items++, "chunk-size",
				      raidrec->chunk_size);
  raidrec->additional_vars.entries = items;
}




/*************************************************************************
 * nuke_mode_dummy() -- Hugo Rabson               							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
nuke_mode_dummy ()
{

	/** newt *************************************************************/
  newtComponent myForm;
	newtComponent b1;
	newtComponent b2;
	newtComponent b3;
	newtComponent b_res;


  newtPushHelpLine
    ("This is where I nuke your hard drives. Mhahahahaha. No-one can stop Mojo Jojo!");
  newtOpenWindow (24, 3, 32, 13, "Nuking");
  b1 = newtButton (7, 1, "Slowly");
  b2 = newtButton (7, 5, "Medium");
  b3 = newtButton (7, 9, "Quickly");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, b1, b2, b3, NULL);
  b_res = newtRunForm (myForm);
  newtFormDestroy (myForm);
  newtPopWindow ();
  newtPopHelpLine ();
}



/*************************************************************************
 * redraw_disklist() -- Hugo Rabson               							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
redraw_disklist (struct list_of_disks *disklist,
		 void *keylist[ARBITRARY_MAXIMUM], newtComponent listbox)
{

	/** int *************************************************************/
  int i = 0;

  newtListboxClear (listbox);

  for (i = 0; i < ARBITRARY_MAXIMUM; i++)
    {
      keylist[i] = (void *) i;
    }
  for (i = 0; i < disklist->entries; i++)
    {
      newtListboxAppendEntry (listbox, disklist_entry_to_string (disklist, i),
			      keylist[i]);
    }
}


/*************************************************************************
 * redraw_mountlist() -- Hugo Rabson              							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
redraw_mountlist (struct mountlist_itself *mountlist,
		  void *keylist[ARBITRARY_MAXIMUM], newtComponent listbox)
{
	
	/** int **************************************************************/
  int i = 0;


  newtListboxClear (listbox);
//  sort_mountlist_by_device (mountlist);
  for (i = 0; i < ARBITRARY_MAXIMUM; i++)
    {
      keylist[i] = (void *) i;
    }
  for (i = 0; i < mountlist->entries; i++)
    {
      newtListboxAppendEntry (listbox,
			      mountlist_entry_to_string (mountlist, i),
			      keylist[i]);
    }
}




/*************************************************************************
 * redraw_unallocpartnslist() -- Hugo Rabson       							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
redraw_unallocpartnslist (struct mountlist_itself
			  *unallocated_raid_partitions,
			  void *keylist[ARBITRARY_MAXIMUM],
			  newtComponent listbox)
{

	/** int **************************************************************/
  int i = 0;

	/** buffers **********************************************************/
  char tmp[MAX_STR_LEN];


  newtListboxClear (listbox);
  for (i = 0; i < ARBITRARY_MAXIMUM; i++)
    {
      keylist[i] = (void *) i;
    }
  for (i = 0; i < unallocated_raid_partitions->entries; i++)
    {
      sprintf (tmp, "%-22s %8ld", unallocated_raid_partitions->el[i].device,
	       unallocated_raid_partitions->el[i].size / 1024);
      newtListboxAppendEntry (listbox, tmp, keylist[i]);
    }
}


/*************************************************************************
 * redraw_varslist() -- Hugo Rabson               							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
redraw_varslist (struct additional_raid_variables *additional_vars,
		 void *keylist[], newtComponent listbox)
{
	/** int *************************************************************/
  int i	= 0;

	/** buffers *********************************************************/
  char tmp[MAX_STR_LEN];


  newtListboxClear (listbox);

  for (i = 0; i < ARBITRARY_MAXIMUM; i++)
    {
      keylist[i] = (void *) i;
    }
  for (i = 0; i < additional_vars->entries; i++)
    {
      sprintf (tmp, "%-32s %-8s", additional_vars->el[i].label,
	       additional_vars->el[i].value);
      newtListboxAppendEntry (listbox, tmp, keylist[i]);
    }
}



/*************************************************************************
 * read_variableINT_and_remove_from_radivars() -- Hugo Rabson            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
read_variableINT_and_remove_from_raidvars (struct raid_device_record *raidrec,
					   char *label)
{
	/** int ***************************************************************/
  int i	= 0;
	int res = 0;


  for (i = 0;
       i < raidrec->additional_vars.entries
       && strcmp (raidrec->additional_vars.el[i].label, label); i++);
  if (i == raidrec->additional_vars.entries)
    {
      res = -1;
    }
  else
    {
      res = atoi (raidrec->additional_vars.el[i].value);
      for (i++; i < raidrec->additional_vars.entries; i++)
	{
	  memcpy ((void *) &raidrec->additional_vars.el[i - 1],
		  (void *) &raidrec->additional_vars.el[i],
		  sizeof (struct raid_var_line));
	}
      raidrec->additional_vars.entries--;
    }
  return (res);
}

/*************************************************************************
 * rejig_partition_name_in_raidlist_if_necessary()  -- Hugo Rabson       *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
rejig_partition_name_in_raidlist_if_necessary (struct raidlist_itself
					       *raidlist, char *old_dev,
					       char *new_dev)
{
	/** buffers ********************************************************/
  char tmp[MAX_STR_LEN];

	/** int ************************************************************/
  int pos = 0;
	int j = 0;

  pos = which_raid_device_is_using_this_partition (raidlist, old_dev);
  if (pos < 0)
    {
      sprintf (tmp, "No need to rejig %s in raidlist: it's not listed.",
	       old_dev);
      log_it (tmp);
    }
  else
    {
      if ((j =
	   where_in_drivelist_is_drive (&raidlist->el[pos].data_disks,
					old_dev)) >= 0)
	{
	  strcpy (raidlist->el[pos].data_disks.el[j].device, new_dev);
	}
      else
	if ((j =
	     where_in_drivelist_is_drive (&raidlist->el[pos].spare_disks,
					  old_dev)) >= 0)
	{
	  strcpy (raidlist->el[pos].spare_disks.el[j].device, new_dev);
	}
      else
	if ((j =
	     where_in_drivelist_is_drive (&raidlist->el[pos].parity_disks,
					  old_dev)) >= 0)
	{
	  strcpy (raidlist->el[pos].parity_disks.el[j].device, new_dev);
	}
      else
	if ((j =
	     where_in_drivelist_is_drive (&raidlist->el[pos].failed_disks,
					  old_dev)) >= 0)
	{
	  strcpy (raidlist->el[pos].failed_disks.el[j].device, new_dev);
	}
      else
	{
	  sprintf (tmp,
		   "%s is supposed to be listed in this raid dev but it's not...",
		   old_dev);
	  log_it (tmp);
	}
    }
}



/*************************************************************************
 * remove_essential_additionalvars() -- Hugo Rabson                      *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
remove_essential_additionalvars (struct raid_device_record *raidrec)
{

	/** int **************************************************************/
  int res = 0;


res =
    read_variableINT_and_remove_from_raidvars (raidrec,
					       "persistent-superblock");
  if (res > 0)
    {
      raidrec->persistent_superblock = res;
    }
  res = read_variableINT_and_remove_from_raidvars (raidrec, "chunk-size");
  if (res > 0)
    {
      raidrec->chunk_size = res;
    }
  res = read_variableINT_and_remove_from_raidvars (raidrec, "block-size");
}


/*************************************************************************
 * select_raid_disks() -- Hugo Rabson                                    *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
select_raid_disks (struct mountlist_itself *mountlist_dontedit,
		   struct raidlist_itself *raidlist,
		   struct raid_device_record *raidrec,
		   char *description_of_list, struct list_of_disks *disklist)
{

	/** ??? ***************************************************************/
  void *curr_choice;

	/** structures ********************************************************/
  struct raidlist_itself bkp_raidlist;
  struct raid_device_record bkp_raidrec;
  struct list_of_disks bkp_disklist;
  struct mountlist_itself URP, *unallocated_raid_partitions;

	/** newt **************************************************************/
  newtComponent myForm;
  newtComponent bAdd;
	newtComponent bDelete;
	newtComponent bOK;
	newtComponent bCancel;
	newtComponent b_res;
	newtComponent partitionsListbox;
	newtComponent headerMsg;

	/** buffers **********************************************************/
  void *keylist[ARBITRARY_MAXIMUM];
  char tmp[MAX_STR_LEN];
	char help_text[MAX_STR_LEN];
	char title_of_window[MAX_STR_LEN];
	char sz_res[MAX_STR_LEN];
	char header_text[MAX_STR_LEN];

	/** int **************************************************************/
  int i	= 0;
	int currline = 0;

  memcpy ((void *) &bkp_raidlist, (void *) raidlist,
	  sizeof (struct raidlist_itself));
  memcpy ((void *) &bkp_raidrec, (void *) raidrec,
	  sizeof (struct raid_device_record));
  memcpy ((void *) &bkp_disklist, (void *) disklist,
	  sizeof (struct list_of_disks));
  unallocated_raid_partitions = &URP;
  strcpy (help_text,
	  "   Edit this RAID device's list of partitions. Choose OK or Cancel when done.");
  sprintf (header_text, "%-24s    %s", "Device", "Index");
  sprintf (title_of_window, "%s contains...", raidrec->raid_device);
  newtPushHelpLine (help_text);
  for (b_res = (newtComponent) 12345; b_res != bOK && b_res != bCancel;)
    {
      headerMsg = newtLabel (1, 1, header_text);
      partitionsListbox =
	newtListbox (1, 2, 6, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
      redraw_disklist (disklist, keylist, partitionsListbox);
      i = 1;
      bAdd = newtCompactButton (i, 9, " Add ");
      bDelete = newtCompactButton (i += 8, 9, "Delete");
      bOK = newtCompactButton (i += 9, 9, "  OK  ");
      bCancel = newtCompactButton (i += 9, 9, "Cancel");
      newtOpenWindow (21, 7, 38, 10, title_of_window);
      myForm = newtForm (NULL, NULL, 0);
      if (disklist->entries == 0)
	{
	  newtFormAddComponents (myForm, headerMsg, bAdd, bDelete, bOK,
				 bCancel, NULL);
	}
      else
	{
	  newtFormAddComponents (myForm, headerMsg, partitionsListbox, bAdd,
				 bDelete, bOK, bCancel, NULL);
	}
      b_res = newtRunForm (myForm);
      if (b_res == bOK || b_res == bCancel)
	{			/* do nothing */
// That's OK. At the end of this subroutine (after this do/while loop),
// we'll throw away the changes if Cancel was pushed.
	}
      else
	{
	  curr_choice = newtListboxGetCurrent (partitionsListbox);
	  for (i = 0; i < disklist->entries && keylist[i] != curr_choice;
	       i++);
	  if (i == disklist->entries && disklist->entries > 0)
	    {
	      log_to_screen ("I don't know what that button does!");
	    }
	  else
	    {
	      currline = i;
	      if (b_res == bAdd)
		{
		  log_it ("Making list of unallocated RAID slices");
		  make_list_of_unallocated_raid_partitions
		    (unallocated_raid_partitions, mountlist_dontedit,
		     raidlist);
		  if (unallocated_raid_partitions->entries <= 0)
		    {
		      popup_and_OK
			("There are no unallocated partitions marked for RAID.");
		    }
		  else
		    {
		      log_it
			("Done. The user may add one or more of the above to RAID device");
		      add_disklist_entry (disklist, raidrec->raid_device,
					  unallocated_raid_partitions);
		      log_it ("I have finished adding a disklist entry.");
		      redraw_disklist (disklist, keylist, partitionsListbox);
		    }
		}
	      else if (b_res == bDelete)
		{
		  delete_disklist_entry (disklist, raidrec->raid_device,
					 currline);
		  redraw_disklist (disklist, keylist, partitionsListbox);
		}
	      else
		{
		  sprintf (tmp, "%s's index is %d. What should it be?",
			   raidrec->raid_device,
			   disklist->el[currline].index);
		  sprintf (sz_res, "%d", disklist->el[currline].index);
		  if (popup_and_get_string ("Set index", tmp, sz_res, 8))
		    {
		      disklist->el[currline].index = atoi (sz_res);
		    }
		  redraw_disklist (disklist, keylist, partitionsListbox);
		}
	    }
	}
      newtFormDestroy (myForm);
      newtPopWindow ();
    }
  newtPopHelpLine ();
  if (b_res == bCancel)
    {
      memcpy ((void *) raidlist, (void *) &bkp_raidlist,
	      sizeof (struct raidlist_itself));
      memcpy ((void *) raidrec, (void *) &bkp_raidrec,
	      sizeof (struct raid_device_record));
      memcpy ((void *) disklist, (void *) &bkp_disklist,
	      sizeof (struct list_of_disks));
    }
}




/*************************************************************************
 * which_restore_mode() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
char
which_restore_mode ()
{

	/** char *************************************************************/
	  char output;


	/** newt *************************************************************/

  newtComponent b1;
	newtComponent b2;
	newtComponent b3;
	newtComponent b4;
	newtComponent b_res;
	newtComponent myForm;

  newtPushHelpLine
    ("   Do you want to 'nuke' your system, restore interactively, or just compare?");
  newtOpenWindow (24, 3, 32, 17, "How should I restore?");
  b1 = newtButton (7, 1, "Automatically");
  b2 = newtButton (7, 5, "Interactively");
  b3 = newtButton (7, 9, "Compare only!");
  b4 = newtButton (7, 13, "Exit to shell");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, b1, b2, b3, b4, NULL);
  b_res = newtRunForm (myForm);
  newtFormDestroy (myForm);
  newtPopWindow ();
  if (b_res == b1)
    {
      output = 'N';
    }
  if (b_res == b2)
    {
      output = 'I';
    }
  if (b_res == b3)
    {
      output = 'C';
    }
  if (b_res == b4)
    {
      output = 'E';
    }
  newtPopHelpLine ();
  return (output);
}










