/*        mondo-restore.c               Hugo Rabson


08/26
- added code to nuke_mode() to make sure NFS 
  (backup) share is mounted in Nuke Mode

08/01
- fixed bugs in extract_config_file_from_ramdisk()
  and get_cfg_file_from_archive() which
  stopped fape+floppy users from being able to
  boot from floppy and leave floppy in drive :)

08/01
- fixed bugs in extract_config_file_from_ramdisk() which
  stopped fape+floppy users from being able to
  boot from floppy and leave floppy in drive :)

07/02
- modified calls to popup_and_get_string()

06/09
- added support for "LABEL=/1" - workaround for SME users

05/06
- back-ported mount_cdrom() from 1.7x
- fixed ISO mode-related silly in read_cfg_file_into_bkpinfo()

05/02
- better calling of post-nuke

04/30
- don't resize mountlist if "noresize" present in /proc/cmdline
- delete /var/lock/subsys/ * when nuking

04/27
- replace newtFinished() and newtInit() with
  newtSuspend() and newtResume()

04/26
- drop -c from calls to afio (restoring)
- line 3478 --- if post-nuke not found then don't run it :)

04/22
- added ! in front of ask_me_yes_or_no("LILO failed. Re-edit system files?");
- copy log to /mnt/RESTORING/root/ at end
- read_cfg_file_into_bkpinfo() --- read iso-dev and isodir if bkptype==iso
- line 844 --- delete ramdisk file after extracting config info

04/08
- don't sort mountlist anywhere anymore except _locally_ in
  mount_all_devices() and unmount_all_devices()
- edit fstab, grub.conf _after_ stabgrub-me if it fails

04/07
- added iso_fiddly_bits()
- added make_hole_for_file() at line 811

04/05
- fixed post-nuke support
- always eject CD at end, unless bkpinfo->please_dont_...

04/03
- fixing nfs support
- changed /mnt/isodir to /tmp/isodir
- cleaned up mount_cdrom()
- afio uses -c (1024L*1024L)/TAPE_BLOCK_SIZE now
  instead of -c 1024

03/15
- commented out sort_... line (BB)

02/20
- afio uses 4MB buffer instead of 16MB, to shut the low-mem users up

02/12
- added code for LVM and SW Raid (Brian Borgeson)

02/10
- fixed read_cfg_file_into_bkpinfo()'s setting of ISO size (Troff)
- added -e (do not eject when restoring) flag

01/14
- line 814 - added -p to 'mkdir -p tmp'
- mount_cdrom() - calls find_cdrom_device() if
  bkpinfo->media_device is blank (to fill it)

12/19/2002
- mount_cdrom() better at handling multiple CD drives

12/10
- minor clean-up in restore_a_tarball_from_CD()

11/29
- if --live-from-cd then assume restoring live from CD

11/28
- tweaked it to run better w/ ArkLinux

11/26
- create /mnt/RESTORING/mnt/.boot.d for Gentoo users
  after restoring

11/25
- cleaned up iso_mode(); no longer asks for NFS info 3 times
- mount_cdrom() was trying to mount /mnt/isodir/%s/%d.iso;
  is now just %s/%d.iso
- mount/unmount /boot if necessary (Gentoo)

11/22
- added RAW MBR support; added run_raw_mbr() for the purpose
- unmount & remount supermounts at start/end of live restore

11/20
- copy /tmp/mountlist.txt to /tmp/mountlist.txt.orig at start
- cleaned up string-handling in get_cfg_info_from_archives()
- fixed run_grub() to call new stabgrub-me script
- popup list of changed files after Compare Mode

11/18
- permit mondorestore --edit-mountlist even if live mode
- create a repaired copy of grub-install which is RAID-friendly;
  use it when initializing boot sector with run_grub()
- use grub-MR instead of grub-install

11/09
- fixed read_cfg_file_into_bkpinfo() to ignore cfg file's backup_media_type
  if user has already specified a backup media type interactively

10/01 - 10/31
- run_grub() will let you specify the boot device as well as edit the system
  files, if grub-install fails
- fixed bug in fwrite() call in restore_biggiefile_from_CD()
- fixed bug affecting restoration of bigfiles from CD's w/0 compression
- run_grub() will run 'grub-install {boot device}' instead of
  'grub-install (hd0)'

09/01 - 09/30
- use /tmp/tmpfs/mondo.tmp instead of /tmp/mondo.tmp
- initialize MOUNTLIST_FNAME at start of main()
- differential-related cleanup
- better handling of CD-ROM drives which aren't /dev/cdrom :)
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- always load config file from archive before operating on it
- moved some subroutines around; now closer to alphabetical order
- changed mount.mindi to mount.bootisk
- mount disks readonly if in Compare Mode
- set /dev/null's permissions to 777, just in case it somehow gets mangled
  ...which apparently happen with some devfs-based Linux distributions
- remove /var/run/ *.pid after restoring
- move spurious lockfiles from /home/ * to /home/ * /.disabled
- if Interactive Mode then ask user which media, etc. (i.e. catchall mode
  is now same as Interactive Mode)

08/01 - 08/30
- use data structure to store the fname, checksum, mods & perms of each bigfile
  ... biggiestruct :)
- if a filelist is tiny (2 bytes or less) then ignore it
- insist_on_this_cd_number() --- now takes 2 params, not 1
- re-enabled 'g_current_media_number = 1' in restore_everything()
- added same to compare_mode()
- replaced lots of global char[]'s with malloc()'s
- if differential backup then don't permit formatting or fdisking,
  whether Interactive or Nuke mode
- added call to register_pid() at start of main()
- if Nuke Mode & it succeeds then ask user if they have contributed yet
- changed tape-size to media-size (config file)
- changed using_* to backup_media_type
- changed *_from_tape to *_from_stream

07/01 - 07/31
- added find_and_mount_actual_cdrom()
- temp dir is always random
- skip tarballs if they don't contain files we're looking for
  (used to read the whole thing & _then_ skip)
- use media_size[1] instead of media_size[0]
- fixed serious bug in line 1546 - should have been !=, not ==; stopped
  mondorestore from correctly restoring big files
- bigfile piping enhancements (Philippe de Muyter)
- unmount CD-ROM after restoring from live filesystem
- TAPE_BLOCK_SIZE treated as %ld, not %d

06/01 - 06/30
- added signal-trapping
- disabled 'nr-failed-disks' flag
- fixed problem w/selective restore
- don't change /tmp's permissions unless it doesn't exist & must be created
- fixed bug in --mbr
- is_file_in_list() enhanced to exclude /mnt/RESTORING or whatever
- added support for uncompressed archives
- --monitas-live now accepts path-to-restore_to_, not just path to restore
- added some debugging/tracking code to the NFS section
- various monitas-related enhancements
- added --isonuke and --mbr switches
- better logging in run_grub()
- improved --monitas-live
- mkdir -p /mnt/RESTORING/var/run/console just in case user excludes it
- afio now uses 16MB buffer instead of 8MB
- always use bkpinfo->media_size[0], now that -s has been expanded
- popup and ask where to restore data, if restoring selectively

05/01 - 05/31
- add '--monitas' flag
- don't run chmod -R 1777 /mnt/RESTORING/tmp before unmounting unless
  restoring at the time...

04/01 - 04/30
- delete old /tmp/filelist.full,biggielist.txt if found when restoring to
  live filesystem
- replace MONDO_VERSION #define with VERSION from ../config.h
- write fname of bigfile to screen when having trouble reading/comparing it
- if restoring to live filesystem then wipe /tmp/tmpfs/ * afterwards
- removed spurious finish(0) from main()

03/01 - 03/31/2002
- if /tmp/mondo-restore.cfg not found then assume live restore; restore
  to / instead of /mnt/RESTORING
- clean up is_file_in_list() to deal with the /mnt/RESTORING/ prefix
- exclude leading '/' from filelist.restore-these
- if /tmp/fstab.new exists then use _it_ instead of /tmp/fstab to label
  ext2 or ext3 partitions
- improved logging

[...]

07/10/01 --- first incarnation
*/


#include <pthread.h>
#include "../common/my-stuff.h"
#include "../common/config.h"
#include "../common/mondostructures.h"
#include "../common/libmondo.h"
#include "mr-externs.h"
#include "mondo-restore.h"


#define BIGGIELIST "/mnt/cdrom/archives/biggielist.txt"
#define ARCHIVES_PATH "/mnt/cdrom/archives"
#define COMPAQ_PROLIANTS_SUCK "Partition and format your disk using Compaq's disaster recovery CD. After you've done that, please reboot with your Mondo CD/floppy in Interactive Modey."

char	*BIGGIELIST_TXT, *FILELIST_FULL, *BIGGIELIST_FULL, *BIGGIELIST_POT,
	*FILELIST_POTENTIAL, *FILELIST_IMAGEDEVS, *FILELIST_RESTTHESE,
	*BIGGIELIST_RESTTHESE, *IMAGEDEVS_POT, *IMAGEDEVS_RESTTHESE,
	*MONDO_CFG_FILE, *MOUNTLIST_FNAME, *g_mondo_home;


/* global vase - er, vars */
extern long g_maximum_progress, g_current_progress, g_start_time;
extern int g_currentY, g_current_media_number;
/* g_current_media_number is initialized as 1 in mondo-tools.c's var declaration */
/* for tape users */

extern FILE *g_tape_stream;
extern long long g_tape_posK;

//char g_tape_device[MAX_STR_LEN];
bool g_ISO_restore_mode=FALSE; /* are we in Iso Mode? */
char g_isodir_device[MAX_STR_LEN], g_isodir_format[MAX_STR_LEN];
extern bool g_cd_recovery;
bool I_have_just_nuked=FALSE;
extern bool g_text_mode;
extern bool g_restoring_live_from_cd;
char g_tmpfs_mountpt[MAX_STR_LEN]; // not uwsed


int iso_fiddly_bits(struct s_bkpinfo *bkpinfo, bool nuke_me_please);


int mount_cdrom(struct s_bkpinfo *bkpinfo);



bool g_sigpipe_caught=FALSE;




/* externs */

/* ----------------------------------------------------------------------- */



int read_cfg_file_into_bkpinfo( char* cfg_file, struct s_bkpinfo *bkpinfo);
int get_cfg_file_from_archive(struct s_bkpinfo *bkpinfo);
int save_raidlist_to_raidtab(struct raidlist_itself *raidlist, char*fname);
void kill_petris(void);
void save_raidrec_to_file(struct raid_device_record *raidrec, FILE*fout);




void free_global_stuff()
{
  free ( BIGGIELIST_TXT );
  free ( FILELIST_FULL );
  free ( BIGGIELIST_POT );
  free ( FILELIST_POTENTIAL );
  free ( FILELIST_IMAGEDEVS );
  free ( FILELIST_RESTTHESE );
  free ( BIGGIELIST_RESTTHESE );
  free ( IMAGEDEVS_POT );
  free ( IMAGEDEVS_RESTTHESE );
  free ( MONDO_CFG_FILE );
  free ( MOUNTLIST_FNAME );
  free ( g_mondo_home );
}


void add_disk_to_raid_device(struct list_of_disks *disklist, char*device_to_add, int index)
{
  int items;
  items = disklist->entries;
  strcpy(disklist->el[items].device, device_to_add);
  disklist->el[items].index = index;
  items++;
  disklist->entries = items;
}



bool partition_table_contains_Compaq_diagnostic_partition(struct mountlist_itself *mountlist)
{
  int i;

  for(i=0; i<mountlist->entries; i++)
    {
      if (strstr(mountlist->el[i].format, "ompaq"))
	{
	  log_it("mountlist[%d] (%s) is %s (Compaq alert!)", i, mountlist->el[i].device, mountlist->el[i].format);
	  return(TRUE);
	}
    }
  return(FALSE);
}


void offer_to_abort_because_Compaq_Proliants_suck(void)
{
  popup_and_OK(COMPAQ_PROLIANTS_SUCK);
  if (ask_me_yes_or_no("Would you like to reboot and use your Compaq CD to prep your hard drive?"))
    { fatal_error("Aborting. Please reboot and prep your hard drive with your Compaq CD."); }
}


void ask_about_these_imagedevs(char*infname, char*outfname)
{
  FILE*fin,*fout;
  char incoming[MAX_STR_LEN], question[MAX_STR_LEN];
  if (!(fin=fopen(infname,"r")))  {fatal_error("Cannot openin infname");}
  if (!(fout=fopen(outfname,"w"))){fatal_error("Cannot openin outfname");}
  for(fgets(incoming,MAX_STR_LEN,fin); !feof(fin); fgets(incoming,MAX_STR_LEN,fin))
    {
      strip_spaces(incoming);
      if (incoming[0]=='\0') { continue; }
      sprintf(question,"Should I restore the image of %s ?",incoming);
      if (ask_me_yes_or_no(question))
        {
          fprintf(fout,"%s\n",incoming);
        }
    }
  fclose(fout);
  fclose(fin);
}



int catchall_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself*raidlist)
{
  char c;
   int retval=0;
  char tmp[MAX_STR_LEN];
  
  c=which_restore_mode();
  if (c=='I' || c=='N' || c=='C')
    { interactively_obtain_media_parameters_from_user(bkpinfo, FALSE); }

  if (bkpinfo->backup_media_type == iso)
    {
      if (iso_fiddly_bits(bkpinfo, (c=='N')?TRUE:FALSE))
        { log_it("catchall_mode --- iso_fiddly_bits returned w/ error"); return(1); }
      else
        { log_it("catchall_mode --- iso_fiddly_bits ok"); }
    }

  if (c=='I') { log_it("IM selected"); retval+=interactive_mode(bkpinfo,mountlist,raidlist); }
  else if (c=='N') { log_it("NM selected"); retval+=nuke_mode(bkpinfo,mountlist,raidlist); }
  else if (c=='C') { log_it("CM selected"); retval+=compare_mode(bkpinfo,mountlist,raidlist); }
  else
    {
      popup_and_OK("No restoring or comparing will take place today.");
      if (is_this_device_mounted("/mnt/cdrom")) { run_program_and_log_output("umount /mnt/cdrom", FALSE); }
      if (g_ISO_restore_mode) { run_program_and_log_output("umount /tmp/isodir 2> /dev/null", FALSE); }
      free_global_stuff();
      free ( bkpinfo );
      finish(0);
    }
  return(retval);
}



int compare_a_biggiefile(struct s_bkpinfo*bkpinfo, long bigfileno)
{
  FILE*fin,*fout;
  char checksum[MAX_STR_LEN],original_cksum[MAX_STR_LEN],bigfile_fname[MAX_STR_LEN],tmp[MAX_STR_LEN],command[MAX_STR_LEN],*p;
  int i,retval=0;
  struct s_filename_and_lstat_info biggiestruct;

  if (!does_file_exist(slice_fname(bigfileno,0,ARCHIVES_PATH,"")))
    {
      if (does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST"))
	  {
          insist_on_this_cd_number(bkpinfo, (++g_current_media_number));
        }
      else
	  {
	    sprintf(tmp,"No CD's left. No biggiefiles left. No prob, Bob.");
	    log_it(tmp);
	    return(0);
        }
    }
  if (!(fin=fopen(slice_fname(bigfileno,0,ARCHIVES_PATH,""),"r")))
    {
      sprintf(tmp,"Cannot open bigfile %ld (%s)'s info file", bigfileno+1, bigfile_fname);
      log_to_screen(tmp);
      return(1);
    }
  fread((void*)&biggiestruct, 1, sizeof(biggiestruct), fin);
  fclose(fin);
  strcpy(checksum, biggiestruct.checksum);
  strcpy(bigfile_fname, biggiestruct.filename);
  log_it("biggiestruct.filename = %s", biggiestruct.filename);
  log_it("biggiestruct.checksum = %s", biggiestruct.checksum);
  sprintf(tmp,"Comparing %s",bigfile_fname);
  newtDrawRootText(0,22,tmp); newtRefresh();
  if (!checksum[0]) {log_it("Warning - %s has no checksum", bigfile_fname); }
  if (!strncmp(bigfile_fname,"/dev/",5))
    {
      strcpy(original_cksum,"IGNORE");
    }
  else
    {
      sprintf(command,"md5sum \"/mnt/RESTORING%s\" > /tmp/md5sum.txt 2> /tmp/errors.txt", bigfile_fname);
    }
  log_it(command);
  system("cat /tmp/errors >> /tmp/mondo-restore.log 2> /dev/null");
  if (system(command))
    {
      log_it("Warning - command failed");
      original_cksum[0]='\0';
      return(1);
    }
  else
    {
      if (!(fin=fopen("/tmp/md5sum.txt", "r")))
	{
	  log_it("Unable to open /tmp/md5sum.txt; can't get live checksum");
	  original_cksum[0]='\0';
	  return(1);
	}
      else
	{
	  fgets(original_cksum,MAX_STR_LEN-1,fin);
	  fclose(fin);
	  for(i=strlen(original_cksum); i>0 && original_cksum[i-1]<32; i--);
	  original_cksum[i]='\0';
	  p=(char*)strchr(original_cksum,' ');
	  if (p) { *p='\0'; }
	}
    }
  sprintf(tmp,"bigfile #%ld ('%s') ", bigfileno+1, bigfile_fname);
  if (!strcmp(checksum,original_cksum)!=0)
    { strcat(tmp," ... OK"); }
  else
    { strcat(tmp,"... changed"); retval++; }
  log_it(tmp);
  if (retval)
    {
      if (!(fout=fopen("/tmp/changed.txt", "a"))) {fatal_error("Cannot openout changed.txt");}
      fprintf(fout,"%s\n",bigfile_fname);
      fclose(fout);
    }
  return(retval);
}



int compare_all_biggiefiles(struct s_bkpinfo*bkpinfo)
{
  int retval=0,res;
  long noof_biggiefiles,bigfileno=0;
  char tmp[MAX_STR_LEN];

  log_it("Comparing biggiefiles");
  if (length_of_file(BIGGIELIST)<6)
    { log_it("OK, really teeny-tiny biggielist; not comparing biggiefiles"); return(0); }
  noof_biggiefiles=count_lines_in_file(BIGGIELIST);
  if (noof_biggiefiles<=0)
    {log_it("OK, no biggiefiles; not comparing biggiefiles");return(0);}
  mvaddstr_and_log_it(g_currentY,0,"Comparing large files                                                  ");
  open_progress_form("Comparing large files", "I am now comparing the large files" , "against the filesystem. Please wait.", "", noof_biggiefiles);
  for(bigfileno=0;bigfileno<noof_biggiefiles;bigfileno++)
    {
      sprintf(tmp,"Comparing big file #%ld",bigfileno+1);
      log_it(tmp);
      update_progress_form(tmp);
      res=compare_a_biggiefile(bkpinfo, bigfileno);
      retval+=res;
      g_current_progress++;
    }
  close_progress_form();
  return(0);
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}



int compare_a_tarball(char *tarball_fname, int current_tarball_number)
{
  int retval=0,res;
  long noof_lines, afio_errors;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN], filelist_name[MAX_STR_LEN], logfile[MAX_STR_LEN], executable[MAX_STR_LEN];

  sprintf(logfile,"/tmp/afio.log.%d",current_tarball_number);
  sprintf(filelist_name,"/mnt/cdrom/archives/filelist.%d",current_tarball_number);
  noof_lines=count_lines_in_file(filelist_name);
 if (strstr(tarball_fname,".bz2"))
    { strcpy(executable,"bzip2"); }
  else
    { strcpy(executable,"lzop"); }
  sprintf(tmp,"which %s > /dev/null 2> /dev/null",executable);
  if (system(tmp))
    { log_to_screen("compression program not found - oh no!"); finish(1); }
  // -c %ld, (1024L*1024L)/TAPE_BLOCK_SIZE
  sprintf(command,"afio -r -b %ld -M 4m -P %s -Z %s > %s 2> %s",TAPE_BLOCK_SIZE, executable,tarball_fname,logfile,logfile);
  res=system(command);
  retval+=res;
  if (res)
    {
      log_it(tmp);
      sprintf(tmp,"Warning - afio returned error=%d",res);
      log_it(tmp);
    }
  sprintf(command,"cat %s | sed s/': \\\"'/\\|/ | sed s/'\\\": '/\\|/ | cut -d'|' -f2 | sort | uniq >> /tmp/changed.txt",logfile);
  if (system(command)) { log_it("Failed to generate changed.txt"); }
  if (length_of_file(logfile)>5)
    { afio_errors=count_lines_in_file(logfile); }
  else
    { afio_errors=0; }
  sprintf(tmp,"%ld differences in fileset #%d          ",afio_errors,current_tarball_number);
  if (afio_errors)
    {
      sprintf(tmp,"Differences found while processing fileset #%d       ",current_tarball_number);
      log_it(tmp);
    }
  unlink(logfile);
  return(retval);
}




int compare_all_tarballs(struct s_bkpinfo*bkpinfo)
{
  int retval=0,res;
  int current_tarball_number=0;
  char tarball_fname[MAX_STR_LEN], progress_str[MAX_STR_LEN], tmp[MAX_STR_LEN];
  long max_val;
  mvaddstr_and_log_it(g_currentY,0,"Comparing archives");
  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
  max_val=atol(tmp);
  sprintf(progress_str,"Comparing with CD #%d ",g_current_media_number);
  open_progress_form("Comparing files", "Comparing tarballs against filesystem.", "Please wait. This may take some time.",progress_str,max_val);
  log_to_screen(progress_str);
  for(;;)
    {
      insist_on_this_cd_number(bkpinfo, g_current_media_number);
      update_progress_form(progress_str);
      sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.bz2",current_tarball_number);
      if (!does_file_exist(tarball_fname)) {sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.lzo",current_tarball_number);}
      if (!does_file_exist(tarball_fname)) {sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.",current_tarball_number);}
      if (!does_file_exist(tarball_fname))
	{
	  if (!does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST") || system("find /mnt/cdrom/archives/slice* > /dev/null 2> /dev/null")==0)
	    {
	      log_it("OK, I think I'm done with tarballs...");
	      break;
	    }
	  log_it("OK, I think it's time for another CD...");
	  g_current_media_number++;
	  sprintf(progress_str,"Comparing with CD #%d ",g_current_media_number);
	  log_to_screen(progress_str);
	}
      else
	{
	  res=compare_a_tarball(tarball_fname,current_tarball_number);
	  /*	  retval+=res; */
	  g_current_progress++;
	  current_tarball_number++;
	}
    }
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}




int compare_to_CD(struct s_bkpinfo*bkpinfo)
{
  char tmp[MAX_STR_LEN],cwd[MAX_STR_LEN],new[MAX_STR_LEN],command[MAX_STR_LEN];
  int resA=0,resB=0;
  long noof_changed_files;

  getcwd(cwd,MAX_STR_LEN-1);
  chdir(bkpinfo->restore_path);
  getcwd(new,MAX_STR_LEN-1);
  sprintf(tmp,"new path is %s",new);
  insist_on_this_cd_number(bkpinfo, g_current_media_number);
  unlink("/tmp/changed.txt");
  resA=compare_all_tarballs(bkpinfo);
  resB=compare_all_biggiefiles(bkpinfo);
  chdir(cwd);
  noof_changed_files=count_lines_in_file("/tmp/changed.txt");
  if (noof_changed_files)
    {
      sprintf(tmp,"%ld files do not match the backup            ",noof_changed_files);
      mvaddstr_and_log_it(g_currentY++,0,tmp);
      sprintf(command,"cat /tmp/changed.txt >> %s",MONDO_LOGFILE);
      system(command);
    }
  else
    {
      sprintf(tmp,"All files match the backup                     ");
      mvaddstr_and_log_it(g_currentY++,0,tmp);
      log_to_screen(tmp);
    }
  if (count_lines_in_file("/tmp/changed.txt") > 0)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Differences found while files were being compared.");
      streamline_changes_file("/tmp/changed.files", "/tmp/changed.txt");
      if (count_lines_in_file("/tmp/changed.files") <= 0)
        { mvaddstr_and_log_it(g_currentY++,0,"...but they were logfiles and temporary files. Your archives are fine."); }
      else
        {
	  sprintf(tmp, "of which, %ld were significant", count_lines_in_file("/tmp/changed.files"));
	  mvaddstr_and_log_it(g_currentY++, 0, tmp);
	  strcpy(tmp,"Type 'less /tmp/changed.files' for a list of non-matching files");
	  mvaddstr_and_log_it(g_currentY++,0,tmp);
	  log_to_screen(tmp);
	}
    }
  else
    {
      log_to_screen("No differences were found. Your backup is perfect.");
    }
  return(resA+resB);
}




int compare_mode(struct s_bkpinfo *bkpinfo,struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int retval=0;
//  char tmp[MAX_STR_LEN];

  log_it("compare_mode --- starting");
  while(get_cfg_file_from_archive(bkpinfo)) // also deletes tmp/filelist.full & tmp/biggielist.txt _and_ tries to restore them from start of tape, if available
    {
      if (!ask_me_yes_or_no("Failed to find config file/archives. Choose another source?"))
	{ fatal_error("Unable to find config file/archives. Aborting."); }
      interactively_obtain_media_parameters_from_user(bkpinfo, FALSE);
    }
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  g_current_media_number=1;
  mvaddstr_and_log_it(1,30,"Comparing Automatically");

  retval=mount_all_devices(mountlist, FALSE);
  if (retval)
    { unmount_all_devices(mountlist); return(retval); }
  if (bkpinfo->backup_media_type == tape || bkpinfo->backup_media_type == udev)
    { retval+=compare_to_tape(bkpinfo); }
  else if (bkpinfo->backup_media_type == cdstream)
    { retval+=compare_to_cdstream(bkpinfo); }
  else
    { retval+=compare_to_CD(bkpinfo); }
  if (retval)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Warning - differences found during the compare phase");
    }
  retval+=unmount_all_devices(mountlist);
  kill_petris();
  return(retval);
}




int compare_to_cdstream(struct s_bkpinfo *bkpinfo)
{
  int res;
  char dir[MAX_STR_LEN], command[MAX_STR_LEN];

  getcwd(dir,MAX_STR_LEN);
  chdir(bkpinfo->restore_path);
  sprintf(command, "cp -f /tmp/LAST-FILELIST-NUMBER %s/tmp", bkpinfo->restore_path);
  run_program_and_log_output(command, FALSE);
  mvaddstr_and_log_it(g_currentY,0,"Verifying archives against filesystem");
//  strcpy(bkpinfo->media_device, "/dev/cdrom");
  find_cdrom_device(bkpinfo->media_device);
  res=verify_tape_backups(bkpinfo);
  chdir(dir);
  if (length_of_file ("/tmp/changed.files") > 2)
    {
      log_it("Type 'less /tmp/changed.files' to see which files don't match the archives");
      log_it("Calling popup_changelist_from_file()");
      popup_changelist_from_file("/tmp/changed.txt");
      log_it("Returned from popup_changelist_from_file()");
    }

  /*
  if (res) {
    mvaddstr_and_log_it(g_currentY++,74,"Failed.");
    }
  else
    {
  */

      mvaddstr_and_log_it(g_currentY++,74,"Done.");

      /*
    }
      */
  return(res);
}



int compare_to_tape(struct s_bkpinfo *bkpinfo)
{
  int res;
  char dir[MAX_STR_LEN], command[MAX_STR_LEN];
  getcwd(dir,MAX_STR_LEN);
  chdir(bkpinfo->restore_path);
  sprintf(command, "cp -f /tmp/LAST-FILELIST-NUMBER %s/tmp", bkpinfo->restore_path);
  run_program_and_log_output(command, FALSE);
  mvaddstr_and_log_it(g_currentY,0,"Verifying archives against filesystem");
  res=verify_tape_backups(bkpinfo);
  chdir(dir);
  if (res) {
    mvaddstr_and_log_it(g_currentY++,74,"Failed.");
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  return(res);
}






int extract_config_file_from_ramdisk(struct s_bkpinfo *bkpinfo, char *ramdisk_fname, char*output_cfg_file, char*output_mountlist_file)
{
  char mountpt[MAX_STR_LEN];
  char command[MAX_STR_LEN];
  char orig_fname[MAX_STR_LEN];

  sprintf(mountpt, "%s/mount.bootdisk", bkpinfo->tmpdir);
  sprintf(command, "mkdir -p %s", mountpt);
  system(command);
  sprintf(command, "gzip -dc %s > %s/mindi.rd 2> /dev/null", ramdisk_fname, bkpinfo->tmpdir);
  system(command);
  sprintf(command, "umount %s", mountpt);
  run_program_and_log_output(command, FALSE);
  sprintf(command, "mount -o loop %s/mindi.rd -t ext2 %s", bkpinfo->tmpdir, mountpt);
  run_program_and_log_output(command, FALSE);
  sprintf(command, "mkdir -p %s/tmp", bkpinfo->tmpdir);
  system(command);

  sprintf(command, "cp -f %s/%s %s", mountpt, "tmp/mondo-restore.cfg", output_cfg_file);
  run_program_and_log_output(command, FALSE);

  sprintf(orig_fname, "%s/tmp/mountlist.txt", mountpt);
  if (does_file_exist(orig_fname))
    {
      sprintf(command, "cp -f %s %s", orig_fname, output_mountlist_file);
      run_program_and_log_output(command, FALSE);
    }
  sprintf(command, "umount %s", mountpt);
  run_program_and_log_output(command, FALSE);
  if (!does_file_exist(output_cfg_file) || (!does_file_exist(output_mountlist_file) && does_file_exist(orig_fname)))
    {
      log_it("Failed to extract %s and/or %s from ramdisk", output_cfg_file, output_mountlist_file);
      return(1);
    }
  else
    {
      return(0);
    }
}





void find_pathname_of_executable_preferably_in_RESTORING(char *out_path, char*fname)
{
  sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
  if (does_file_exist(out_path))
    {
      sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
      if (does_file_exist(out_path))
        {
          sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
          if (does_file_exist(out_path))
            {
              sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
              if (does_file_exist(out_path))
                {
                  strcpy(out_path,fname);
                }
            }
        }
    }
}





int get_next_raidtab_line(FILE*fin,char*label,char*value)
{
  char incoming[MAX_STR_LEN];
  char *p;
  label[0]=value[0]='\0';
  if (feof(fin)) { return(1); }
  for(fgets(incoming,MAX_STR_LEN-1,fin); !feof(fin); fgets(incoming,MAX_STR_LEN-1,fin))
    {
      strip_spaces(incoming);
      p=strchr(incoming,' ');
      if (strlen(incoming)<3 || incoming[0]=='#' || !p) {continue;}
      *(p++)='\0';
      strcpy(label,incoming);
      strcpy(value,p);
      return(0);
    }
  return(1);
}






int get_cfg_file_from_archive(struct s_bkpinfo *bkpinfo)
{
  char device[MAX_STR_LEN], command[MAX_STR_LEN], cfg_file[MAX_STR_LEN], mounted_cfgf_path[MAX_STR_LEN], tmp[MAX_STR_LEN];
  int retval=0;
  char mountpt[MAX_STR_LEN], ramdisk_fname[MAX_STR_LEN], mountlist_file[MAX_STR_LEN];
  bool try_plan_B;

  log_to_screen("I'm thinking...");
  sprintf(mountpt, "%s/mount.bootdisk", bkpinfo->tmpdir);
  device[0]='\0';
  chdir(bkpinfo->tmpdir);
  strcpy(cfg_file, "tmp/mondo-restore.cfg");
  unlink(cfg_file); // cfg_file[] is missing the '/' at the start, FYI, by intent
  unlink("tmp/filelist.full");
  unlink("tmp/biggielist.txt");
  sprintf(command, "mkdir -p %s", mountpt);
  run_program_and_log_output(command, FALSE);
  
  unlink("tmp/mondo-restore.cfg");

  sprintf(cfg_file, "%s/tmp/mondo-restore.cfg", bkpinfo->tmpdir);
  sprintf(mountlist_file, "%s/tmp/mountlist.txt", bkpinfo->tmpdir);
  log_it ("mountpt=%s", mountpt);
  make_hole_for_file(cfg_file);

/* Floppy? */
  sprintf(tmp, "mkdir -p %s", mountpt);
  run_program_and_log_output(tmp, FALSE);
  if (!run_program_and_log_output("dd if=/dev/fd0u1722 of=/dev/null bs=1k count=1 2> /dev/null", FALSE))
    {
      sprintf(command, "mount /dev/fd0u1722 %s", mountpt);
 	if (run_program_and_log_output( command, FALSE ) )
          {
            try_plan_B=TRUE;
            log_it("Warning - error mounting floppy");
          }
        else
   	  {
  	    try_plan_B=TRUE;
  	    log_it("Mounted floppy OK but I don't trust it because the archives might contain more up-to-date config file than the floppy does.");
          }
// NB: If busybox does not support 'mount -o loop' then Plan A WILL NOT WORK.
      log_it("Processing floppy (plan A?)");
      sprintf(ramdisk_fname, "%s/mindi.rdz", mountpt);
      if (!does_file_exist(ramdisk_fname))
        { sprintf(ramdisk_fname, "%s/initrd.img", mountpt); }
      if (!does_file_exist(ramdisk_fname))
        { fatal_error("Cannot find ramdisk file on mountpoint. Are you sure that's a boot floppy in the drive?"); }
      if (extract_config_file_from_ramdisk( bkpinfo, ramdisk_fname, cfg_file, mountlist_file ))
        {
          log_it("Warning - failed to extract config file from ramdisk");
        }
      sprintf(command, "umount %s", mountpt);
      unlink(ramdisk_fname);
    }
  if (!does_file_exist(cfg_file))
    {
      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
        { try_plan_B=TRUE; }
      else
        {
          log_it("Calling mount_cdrom now :)");
          if (!mount_cdrom(bkpinfo))
            { try_plan_B = FALSE; }
          else
            { try_plan_B = TRUE; }
 	  if (what_number_cd_is_this(bkpinfo)>1)
            {
              insist_on_this_cd_number(bkpinfo, (g_current_media_number=1));
            }
        }
      if (try_plan_B)
        {
          log_it("OK, switching to Plan B");
          chdir(bkpinfo->tmpdir);
          system("mkdir -p tmp");
          sprintf(command, "dd if=%s bs=%ld count=%ld 2> /dev/null | tar -zxv tmp/mountlist.txt tmp/mondo-restore.cfg tmp/biggielist.txt tmp/filelist.full", bkpinfo->media_device, TAPE_BLOCK_SIZE, 1024L*1024*32/TAPE_BLOCK_SIZE);
          run_program_and_log_output(command, FALSE);
          if (!does_file_exist("tmp/mondo-restore.cfg"))
            { fatal_error("Cannot find config info on tape/CD/floppy"); }
        }
      else
        {
          sprintf(command, "mount /mnt/cdrom/images/mindi-boot.2880.img -o loop %s", mountpt);
          sprintf(mounted_cfgf_path, "%s/%s", mountpt, cfg_file);
          if (!does_file_exist(mounted_cfgf_path))
            {
              log_it("OK, plan C...");
              sprintf(command, "tar -zxvf /mnt/cdrom/images/all.tar.gz tmp/mountlist.txt tmp/mondo-restore.cfg tmp/biggielist.txt tmp/filelist.full"); // add -b TAPE_BLOCK_SIZE if you _really_ think it's necessary
              run_program_and_log_output(command, TRUE);
              if (!does_file_exist("tmp/mondo-restore.cfg"))
                { fatal_error("Please reinsert the disk/CD and try again."); }
            }
        }
    }
  if (does_file_exist("tmp/mondo-restore.cfg"))
    {
      sprintf(command, "mv -f tmp/mondo-restore.cfg %s", cfg_file);
      run_program_and_log_output(command, FALSE);
    }
  run_program_and_log_output(command, FALSE);
  run_program_and_log_output("umount /mnt/cdrom", FALSE);
  if (!does_file_exist(cfg_file))
    { fatal_error("Unable to recover configuration file from boot disk"); }
  else
    { log_to_screen("Recovered mondo-restore.cfg"); }
  sprintf(command, "cp -f %s %s/tmp/mondo-restore.cfg", cfg_file, bkpinfo->tmpdir);
  run_program_and_log_output(command, FALSE);
  sprintf(command, "cp -f %s /tmp/mondo-restore.cfg", cfg_file);
  run_program_and_log_output(command, FALSE);
  sprintf(command, "cp -f %s /tmp/mountlist.txt", mountlist_file);
  run_program_and_log_output(command, FALSE);
  return(retval);
}





int interactive_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int retval=0, res=0, ptn_errs=0, fmt_errs=0;
  bool done, /*restore_some,*/ restore_all;
  char tmp[MAX_STR_LEN], fstab_fname[MAX_STR_LEN], old_restpath[MAX_STR_LEN];
  struct s_node *filelist;

  log_it("interactive_mode --- starting");
/* try to partition and format */
  while (get_cfg_file_from_archive(bkpinfo)) // also deletes tmp/filelist.full & tmp/biggielist.txt _and_ tries to restore them from start of tape, if available
    {
      if (!ask_me_yes_or_no("Failed to find config file/archives. Choose another source?"))
	{ fatal_error("Unable to find config file/archives. Aborting."); }
      interactively_obtain_media_parameters_from_user(bkpinfo, FALSE);
    }
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  if (strstr(call_program_and_get_last_line_of_output("cat /proc/cmdline"), "noresize"))
    { log_it("Marco Bano - you're a pain in the butt. I hope you know that."); }
  else
    { resize_mountlist_proportionately_to_suit_new_drives(mountlist); }
  for(done=FALSE;!done;)
    {
      res=edit_mountlist(mountlist,raidlist);
      log_it("Finished editing mountlist.");
      if (res) { free_global_stuff();free ( bkpinfo ); finish(1); }
      log_it("Proceeding...");
      save_mountlist_to_disk(mountlist,MOUNTLIST_FNAME);
      save_raidlist_to_raidtab(raidlist,RAIDTAB_FNAME);
      mvaddstr_and_log_it(1,30,"Restoring Interactively");
      if (bkpinfo->differential)
        {
          log_to_screen("Because this is a differential backup, disk");
	  log_to_screen("partitioning and formatting will not take place.");
          done=TRUE;
        }
      else
        {
          if (ask_me_yes_or_no("Do you want to erase and partition your hard drives?"))
            {
	      if (partition_table_contains_Compaq_diagnostic_partition(mountlist))
		{ offer_to_abort_because_Compaq_Proliants_suck(); done=TRUE; }
	      else
		{
		  twenty_seconds_til_yikes();
		  ptn_errs=partition_everything(mountlist);
		  if (!ptn_errs) { fmt_errs=format_everything(mountlist,FALSE); }
		  else { log_to_screen("Because partitioning failed, I shall not attempt to format devices."); }
		  if (!ptn_errs && !fmt_errs) { done=TRUE; }
		}
	    }
          else
            {
              mvaddstr_and_log_it(g_currentY++,0,"User opted not to partition the devices");
              if (ask_me_yes_or_no("Do you want to format your hard drives?"))
                {
                  fmt_errs=format_everything(mountlist,TRUE);
                  if (!fmt_errs) { done=TRUE; }
	    	}
              else
                {
/*	          mvaddstr_and_log_it(g_currentY++,0,"User opted not to partition or format devices");*/
                  ptn_errs=fmt_errs=0;
                  done=TRUE;
                }
            }
          if (fmt_errs)
            {
              mvaddstr_and_log_it(g_currentY++,0,"Errors occurred. Please repartition and format drives manually.");
              done=FALSE;
            }
          if (ptn_errs & !fmt_errs)
            {
              mvaddstr_and_log_it(g_currentY++,0,"Errors occurred during partitioning. Formatting, however, went OK.");
              done=TRUE;
            }
          if (!done)
            {
              if (!ask_me_yes_or_no("Re-edit the mountlist?")) {return(1);}
            }
        }
    }

/* mount */
  if (mount_all_devices(mountlist, TRUE))
    { unmount_all_devices(mountlist); return(1); }
/* restore */
  if ((restore_all=ask_me_yes_or_no("Do you want me to restore all of your data?")))
    {
      retval+=restore_everything(bkpinfo,"", "");
    }
  else if ((restore_all=ask_me_yes_or_no("Do you want me to restore _some_ of your data?")))
    {
      strcpy(old_restpath, bkpinfo->restore_path);
      for(done=FALSE; !done; )
        {
          filelist=process_filelist_and_biggielist(bkpinfo);
/* Now you have /tmp/tmpfs/filelist.restore-these and /tmp/tmpfs/biggielist.restore-these;
   the former is a list of regular files; the latter, biggiefiles and imagedevs.
*/        if (filelist)
            {
              strcpy(tmp, old_restpath);
              if (popup_and_get_string("Restore path", "Restore files to where? (NB: /mnt/RESTORING is where your filesystem is mounted now, by default)", tmp, MAX_STR_LEN))
                {
		  if (!strcmp(tmp, "/"))
		    { if (!ask_me_yes_or_no("Are you sure?")) { continue; } }
                  strcpy(bkpinfo->restore_path, tmp);
                  free_filelist(filelist);
                  retval+=restore_everything(bkpinfo, FILELIST_RESTTHESE, BIGGIELIST_RESTTHESE);
                }
              else
                {
                  strcpy(bkpinfo->restore_path, old_restpath);
                  free_filelist(filelist);
                }
              if (!ask_me_yes_or_no("Restore another subset of your backup?")) { done=TRUE; }
            }
          else
            {
/*              popup_and_OK("Either you clicked 'Cancel' or an error occurred."); */
              done=TRUE;
            }
	}
      strcpy(old_restpath, bkpinfo->restore_path);
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,0,"User opted not to restore any data.                                  ");
    }
  if (retval)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Errors occurred during the restore phase.            ");
    }
  if (ask_me_yes_or_no("Initialize the boot loader?"))
    {
      run_boot_loader(TRUE);
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,0,"User opted not to initialize the boot loader.");
    }
  /*  modify_rclocal_one_time("/mnt/RESTORING/etc"); */
  protect_against_braindead_sysadmins();
  retval+=unmount_all_devices(mountlist);
  /*  if (restore_some || restore_all || */
  if (ask_me_yes_or_no("Label your ext2 and ext3 partitions if necessary?"))
    {
      mvaddstr_and_log_it(g_currentY,0,"Using e2label to label your ext2,3 partitions");
      if (does_file_exist("/tmp/fstab.new"))
        { strcpy(fstab_fname, "/tmp/fstab.new"); }
      else
        { strcpy(fstab_fname, "/tmp/fstab"); }
      sprintf(tmp,"label-partitions-as-necessary %s < %s",MOUNTLIST_FNAME, fstab_fname);
      res=run_program_and_log_output(tmp, TRUE);
      if (res) 
	{
	  log_to_screen("label-partitions-as-necessary returned an error"); 
	  mvaddstr_and_log_it(g_currentY++,74,"Failed.");
	}
      else
	{
	  mvaddstr_and_log_it(g_currentY++,74,"Done.");
	}
      retval+=res;
    }
  if (retval)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Warning - errors occurred during the restore phase.");
    }
  return(retval);
}





bool is_file_in_list(char*f, char*list_fname, char*preamble)
{
  char command[MAX_STR_LEN], file[MAX_STR_LEN], tmp[MAX_STR_LEN];
//  int i;

  if (strncmp(preamble, f, strlen(preamble))==0)
    { strcpy(file, f+strlen(preamble)); }
  else
    { strcpy(file, f); }
  if (file[0]=='/' && file[1]=='/')
    {
      strcpy(tmp,file);
      strcpy(file,tmp+1);
    }
  sprintf(tmp,"Checking to see if f=%s, file=%s, is in the list of biggiefiles", f, file);
  log_it(tmp);
  sprintf(command,"cat %s | grep -x \"%s\"", list_fname, file);
  if (run_program_and_log_output(command, FALSE))
    { return(FALSE); }
  else
    { return(TRUE); }
}




int iso_fiddly_bits(struct s_bkpinfo *bkpinfo, bool nuke_me_please)
{
  char mount_isodir_command[MAX_STR_LEN], tmp[MAX_STR_LEN],
	command[MAX_STR_LEN];
  int retval=0, i;
  bool already_mounted=FALSE;

  g_ISO_restore_mode=TRUE;
  read_cfg_var(MONDO_CFG_FILE, "iso-dev", g_isodir_device);
  if (!get_isodir_info(g_isodir_device, g_isodir_format, bkpinfo->isodir, nuke_me_please)) {return(1);}
  system("umount /mnt/cdrom 2> /dev/null"); /* just in case */
  if (bkpinfo->disaster_recovery)
    {
      strcpy(bkpinfo->isodir, "/tmp/isodir");
      sprintf(command, "mkdir -p %s", bkpinfo->isodir);
      run_program_and_log_output(command, TRUE);
      log_it("Setting isodir to %s", bkpinfo->isodir);
    }
  if (is_this_device_mounted(g_isodir_device))
    {
      log_to_screen("WARNING - isodir is already mounted");
      already_mounted=TRUE;
    }
  else
    {
      sprintf(mount_isodir_command,"mount %s", g_isodir_device);
      if (strlen(g_isodir_format)>1)
        { sprintf(mount_isodir_command+strlen(mount_isodir_command)," -t %s", g_isodir_format); }
      strcat(mount_isodir_command," -o ro /tmp/isodir");
      run_program_and_log_output("df -m", FALSE);
      sprintf(tmp, "The 'mount' command is '%s'. PLEASE report this command to be if you have problems, ok?", mount_isodir_command);
      log_it(tmp);
      if (run_program_and_log_output(mount_isodir_command, FALSE))
        { popup_and_OK("Cannot mount the device where the ISO files are stored."); return(1); }
      log_to_screen("I have mounted the device where the ISO files are stored.");
    }
  if (!IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type)) { mount_cdrom(bkpinfo); }
  i=what_number_cd_is_this(bkpinfo); /* has the side-effect of calling mount_cdrom() */
  sprintf(tmp,"CD #%d has been mounted via loopback mount",i);
  log_it(tmp);
  if (i<0)
    { popup_and_OK("Cannot find ISO images in the directory you specified."); retval=1; }
  return(retval);
}


int iso_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, bool nuke_me_please)
{
  char c;
  int retval=0;

  if (iso_fiddly_bits(bkpinfo, nuke_me_please))
    { log_it("iso_mode --- returning w/ error"); return(1); }
  else
    {
      c=which_restore_mode();
      if (c=='I' || c=='N' || c=='C')
	{ interactively_obtain_media_parameters_from_user(bkpinfo, FALSE); }
      if (c=='I') { retval+=interactive_mode(bkpinfo,mountlist,raidlist); }
      else if (c=='N') { retval+=nuke_mode(bkpinfo,mountlist,raidlist); }
      else if (c=='C') { retval+=compare_mode(bkpinfo,mountlist,raidlist); }
      else
	{ log_to_screen("OK, I shan't restore/compare any files."); }
    }
  if (is_this_device_mounted("/mnt/cdrom")) { system("umount /mnt/cdrom"); }
//  if (! already_mounted)
//    {
      if (system("umount /tmp/isodir 2> /dev/null")) { log_to_screen("WARNING - unable to unmount device where the ISO files are stored."); }
//    }
  return(retval);
}



/*            MONDO - saving your a$$ since Feb 18th, 2000            */



void kill_petris(void)
{
  char command[MAX_STR_LEN];
  sprintf(command,"kill `ps ax | grep petris | grep -v grep | cut -d' ' -f2` 2> /dev/null");
  system(command);
}



int load_mountlist(struct mountlist_itself *mountlist, char *fname)
{
  FILE*fin;
  char incoming[MAX_STR_LEN], siz[128], tmp[MAX_STR_LEN];
  int items,j;
  if (!(fin=fopen(fname,"r")))
    {
      log_it("Unable to open mountlist - '%s'", fname);
      log_to_screen("Cannot open mountlist");
      return(1);
    }
  items=0;
  fgets(incoming,MAX_STR_LEN-1,fin);
  log_it("Loading mountlist...");
  while(!feof(fin))
    {
      sscanf(incoming,"%s %s %s %s",mountlist->el[items].device, mountlist->el[items].mountpoint, mountlist->el[items].format, siz);
      /*      if (!isalpha(siz[0])) {strcpy(siz,"1111");} */
      mountlist->el[items].size = atol(siz);
      if (mountlist->el[items].device[0]!='\0' && mountlist->el[items].device[0]!='#')
	{
	  if (items >= ARBITRARY_MAXIMUM)
	    {
	      log_to_screen("Too many lines in mountlist.. ABORTING");
      free_global_stuff();
      //      free ( bkpinfo );
	      finish(1);
	    }
	  for(j=0; j<items && strcmp(mountlist->el[j].device, mountlist->el[items].device); j++);
	  if (j<items)
	    {
	      strcat(mountlist->el[items].device, "_dup");
	      sprintf(tmp,"Duplicate entry in mountlist - renaming to %s",mountlist->el[items].device);
	      log_it(tmp);
	    }
	  sprintf(tmp,"%s %s %s %ld",mountlist->el[items].device, mountlist->el[items].mountpoint, mountlist->el[items].format, mountlist->el[items].size);
	  log_it(tmp);
	  items++;
	}
      fgets(incoming,MAX_STR_LEN-1,fin);
    }
  fclose(fin);
  mountlist->entries=items;
  /*  mvaddstr_and_log_it(g_currentY++,74,"Done."); */
  log_it("Mountlist loaded successfully.");
  sprintf(tmp,"%d entries in mountlist",items);
  log_it(tmp);
  return(0);
}




int load_raidtab_into_raidlist(struct raidlist_itself *raidlist, char*fname)
{
  FILE*fin;
  char tmp[MAX_STR_LEN], label[MAX_STR_LEN], value[MAX_STR_LEN];
  int items, v;
  if (length_of_file(fname)<5)
    {
      log_it("Raidtab is very small or non-existent. Ignoring it.");
      raidlist->entries=0;
      return(0);
    }
  if (!(fin=fopen(fname,"r")))
    {
      log_it("Cannot open raidtab");
      return(1);
    }
  items=0;
  log_it("Loading raidtab...");
  get_next_raidtab_line(fin,label,value);
  while(!feof(fin))
    {
      /* find the 'raiddev' entry, indicating the start of the block of info */
      initialize_raidrec(&raidlist->el[items]);
      v=0;
      while(!feof(fin) && strcmp(label,"raiddev"))
	{
	  strcpy(raidlist->el[items].additional_vars.el[v].label, label);
	  strcpy(raidlist->el[items].additional_vars.el[v].value, value);
	  v++;
	  get_next_raidtab_line(fin,label,value);
	  log_it(tmp);
	}
      raidlist->el[items].additional_vars.entries = v;
      if (feof(fin)) {continue;}
      strcpy(raidlist->el[items].raid_device, value);
      for(get_next_raidtab_line(fin,label,value); !feof(fin) && strcmp(label,"raiddev"); get_next_raidtab_line(fin,label,value))
	{ process_raidtab_line(fin,&raidlist->el[items],label,value); }
      items++;
    }
  fclose(fin);
  raidlist->entries=items;
  log_it("Raidtab loaded successfully.");
  sprintf(tmp,"%d RAID devices in raidtab",items);
  log_it(tmp);
  return(0);
}






int modify_rclocal_one_time(char*path)
{
  char rclocal_fname[MAX_STR_LEN], newfile_fname[MAX_STR_LEN],
    tmp[MAX_STR_LEN];
  sprintf(rclocal_fname,"%s/rc.local",path);
  system("chmod -R 1777 /mnt/RESTORING/tmp");
  return(0); /* remove this line to open the floodgates... */
  if (! does_file_exist(rclocal_fname))
    {
      sprintf(rclocal_fname,"%s/rc.d/rc.local",path);
    }
  if (! does_file_exist(rclocal_fname))
    {
      return(1);
    }
  sprintf(newfile_fname,"%s/rc.local.mondorescue",path);
  sprintf(tmp,"cat %s | grep mondorescue > /dev/null 2> /dev/null",rclocal_fname);
  if (system(tmp))
    {
      sprintf(tmp,"echo \"[ -e %s ] && %s\n\" >> %s",newfile_fname,newfile_fname,rclocal_fname);
      system(tmp);
    }
  sprintf(tmp,"echo -en \"#!/bin/sh\
\\n\
\\n\
cat %s | grep -v mondorescue > %s\\n\
chmod -R 1777 /tmp\\n\
yes | rm -f %s\\n\
\" > %s",rclocal_fname,rclocal_fname,newfile_fname,newfile_fname);
  sprintf(tmp,"chmod +x \"%s\"",newfile_fname);
  system(tmp);
  return(0);
}



int mount_all_devices(struct mountlist_itself *p_external_copy_of_mountlist, bool writeable)
{
  int retval=0,lino,res;
  char tmp[MAX_STR_LEN], these_failed[MAX_STR_LEN];
  struct mountlist_itself internal_copy_of_mountlist;
  struct mountlist_itself *mountlist;

  mountlist = &internal_copy_of_mountlist;
  memcpy((void*)mountlist, (void*)p_external_copy_of_mountlist, sizeof(struct mountlist_itself));
  sort_mountlist_by_mountpoint(mountlist, 0);
  these_failed[0]='\0';
  mvaddstr_and_log_it(g_currentY,0,"Mounting devices         ");
  open_progress_form("Mounting devices", "I am now mounting all the drives.", "This should not take long.", "",mountlist->entries);
  for(lino=0; lino < mountlist->entries; lino++)
    {
      if (is_this_device_mounted(mountlist->el[lino].device))
	{
	  sprintf(tmp,"%s is already mounted",mountlist->el[lino].device);
	  log_to_screen(tmp);
	}
      else if (strcmp(mountlist->el[lino].mountpoint,"lvm") && strcmp(mountlist->el[lino].mountpoint,"raid") && strcmp(mountlist->el[lino].mountpoint,"image"))
	{
	  sprintf(tmp,"Mounting %s",mountlist->el[lino].device);
	  update_progress_form(tmp);
	  res=mount_device(mountlist->el[lino].device, mountlist->el[lino].mountpoint, mountlist->el[lino].format, writeable);
	  retval+=res;
          if (res) { strcat(these_failed,mountlist->el[lino].device); strcat(these_failed," "); }
	}
      g_current_progress++;
    }
  close_progress_form();
  run_program_and_log_output("df -m", TRUE);
  if (retval)
    {
      sprintf(tmp,"Could not mount devices %s- shall I abort?",these_failed);
      if (!ask_me_yes_or_no(tmp)) 
	{
	  retval=0;
	  log_to_screen("Continuing, although some devices failed to be mounted");
	  mvaddstr_and_log_it(g_currentY++,74,"Done.");
	}
      else
	{
	  mvaddstr_and_log_it(g_currentY++,74,"Failed.");
	  log_to_screen("Unable to mount some or all of your partitions.");
	}
    }
  else
    {
      log_to_screen("All partitions were mounted OK.");
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  run_program_and_log_output("df -m", TRUE);
  return(retval);
}




int mount_cdrom(struct s_bkpinfo *bkpinfo)
{
  char mount_cmd[MAX_STR_LEN];
  int i,res;
#ifdef __FreeBSD__
  char mdd[32];
  char *mddev = mdd;
#endif
  assert(bkpinfo!=NULL);
  if (!run_program_and_log_output("mount | grep cdrom", FALSE))
    {
      log_it("mount_cdrom() - CD already mounted. Fair enough.");
      return(0);
    }

  if (bkpinfo->backup_media_type == nfs)
    {
      log_it("Mounting for NFS thingy");

#ifdef __FreeBSD__
      sprintf (mount_cmd, "/mnt/isodir/%s/%d.iso", bkpinfo->isodir, g_current_media_number);
      mddev = make_vn (mount_cmd);
      sprintf (mount_cmd, "mount_cd9660 -r %s /mnt/cdrom", mddev);
#else
      sprintf(mount_cmd, "mount %s/%d.iso -t iso9660 -o loop,ro /mnt/cdrom", bkpinfo->isodir, g_current_media_number);
#endif  

    }
  else

#ifdef __FreeBSD__
      sprintf (mount_cmd, "%s/%d.iso", bkpinfo->isodir, g_current_media_number);
      mddev = make_vn (mount_cmd);
      sprintf (mount_cmd, "mount_cd9660 -r %s /mnt/cdrom", mddev);
#else
  if (bkpinfo->backup_media_type == iso)
    {
      sprintf(mount_cmd, "mount %s/%d.iso -t iso9660 -o loop,ro /mnt/cdrom", bkpinfo->isodir, g_current_media_number); 
    }
#endif

  else if (strstr(bkpinfo->media_device, "/dev/"))

#ifdef __FreeBSD__
    { sprintf(mount_cmd, "mount_cd9660 -r %s /mnt/cdrom", bkpinfo->media_device); }
#else
    { sprintf(mount_cmd, "mount %s -t iso9660 -o ro /mnt/cdrom", bkpinfo->media_device); }
#endif

  else
    {
      if (bkpinfo->disaster_recovery && does_file_exist("/tmp/CDROM-LIVES-HERE"))
        { strcpy(bkpinfo->media_device, last_line_of_file("/tmp/CDROM-LIVES-HERE")); }
      else
        { find_cdrom_device( bkpinfo->media_device ); }

#ifdef __FreeBSD__
      sprintf(mount_cmd, "mount_cd9660 -r %s /mnt/cdrom", bkpinfo->media_device);
#else
      sprintf(mount_cmd, "mount %s -t iso9660 -o ro /mnt/cdrom", bkpinfo->media_device);
#endif

    }
  log_it("(mount_cdrom) --- command = %s", mount_cmd);
  for(i=0;i<2;i++)
    {
      res=run_program_and_log_output(mount_cmd, FALSE);
      if (!res)
	{
	  break;
	}
      else
	{
	  log_it("Failed to mount CD-ROM drive.");
	  sleep(5);
	  run_program_and_log_output( "sync", FALSE );
	}
    }
  if (res) { log_it("Failed, despite %d attempts", i); }
  else { log_it("Mounted CD-ROM drive OK"); }
  return(res);
}





int mount_device(char*device, char*mpt, char*format, bool writeable)
{
  int res=0;
  char tmp[MAX_STR_LEN],command[MAX_STR_LEN],mountdir[MAX_STR_LEN], readwrite_sz[MAX_STR_LEN], mountpoint[MAX_STR_LEN];
  if (!strcmp(mpt, "/1"))
    { strcpy(mountpoint, "/"); log_it("Mommm! SME is being a dildo!"); }
  else
    { strcpy(mountpoint, mpt); }
  if (!strcmp(mountpoint,"lvm")) { return(0); }
  if (!strcmp(mountpoint,"image")) { return(0); }
 
  sprintf(tmp,"Mounting device %s   ",device);
  log_it(tmp);
  if (writeable)
    { readwrite_sz[0]='\0';} else { strcpy(readwrite_sz, "-o ro"); }
  if (!strcmp(mountpoint,"swap"))
    {
      sprintf(command,"swapon %s",device);
    }
  else
    {
      if (!strcmp(mountpoint,"/"))
        { strcpy(mountdir,"/mnt/RESTORING"); }
      else
        { sprintf(mountdir,"/mnt/RESTORING%s",mountpoint); }
      sprintf(command,"mkdir -p %s 2>> %s",mountdir,MONDO_LOGFILE);
      system(command);
      sprintf(command,"mount %s -t %s %s %s 2>> %s",device,format,readwrite_sz,mountdir,MONDO_LOGFILE);
    }
  res=system(command);
  if (res)
    {
      sprintf(tmp,"Unable to mount device %s (type %s) at %s",device,format,mountdir);
      log_it(tmp);
      if (!strcmp(mountpoint,"swap"))
        { log_to_screen(tmp); }
      else
	{
	  log_it("Retrying w/o the '-t' switch");
	  sprintf(command,"mount %s %s 2>> %s",device,mountdir,MONDO_LOGFILE);
	  res=system(command);
	  if (res==0)
	    { log_it("That's OK. I called mount w/o a filesystem type and it worked fine in the end."); }
	  else
	    { log_to_screen(tmp); }
        }
    }
  return(res);
}







int nuke_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int retval=0,res;
  char tmp[MAX_STR_LEN];

  log_it("nuke_mode --- starting");
  
  if (bkpinfo->backup_media_type == nfs && !is_this_device_mounted(bkpinfo->nfs_mount))
    {
            sprintf(bkpinfo->isodir, "/tmp/isodir");
	    run_program_and_log_output("mkdir -p /tmp/isodir", TRUE);
	    sprintf(tmp, "mount %s -t nfs /tmp/isodir", bkpinfo->nfs_mount);
	    run_program_and_log_output(tmp, TRUE);
    }

  while(get_cfg_file_from_archive(bkpinfo)) // also deletes tmp/filelist.full & tmp/biggielist.txt _and_ tries to restore them from start of tape, if available
    {
      if (!ask_me_yes_or_no("Failed to find config file/archives. Choose another source?"))
	{ fatal_error("Could not find config file/archives. Aborting."); }
      interactively_obtain_media_parameters_from_user(bkpinfo, FALSE);
    }
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  if (strstr(call_program_and_get_last_line_of_output("cat /proc/cmdline"), "noresize"))
    { log_it("Marco Bano - you're a pain in the butt. I hope you know that."); }
  else
    { resize_mountlist_proportionately_to_suit_new_drives(mountlist); }
  save_mountlist_to_disk(mountlist,MOUNTLIST_FNAME);
  mvaddstr_and_log_it(1,30,"Restoring Automatically");
  if (bkpinfo->differential)
    {
      log_to_screen("Because this is a differential backup, disk");
      log_to_screen("partitioning and formatting will not take place.");
      res=0;
    }
  else
    {     
      if (partition_table_contains_Compaq_diagnostic_partition(mountlist))
	{ offer_to_abort_because_Compaq_Proliants_suck(); }
      else
	{
	  twenty_seconds_til_yikes();
	  res=partition_everything(mountlist);
	  retval+=res;
	  if (!res)
	    {
	      res+=format_everything(mountlist,FALSE);
	    }
	}
    }
  retval+=res;
  if (res)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Failed to partition and/or format your hard drives.");
      if (ask_me_yes_or_no("Try in interactive mode instead?"))
	{ retval=interactive_mode(bkpinfo,mountlist,raidlist); }
      return(retval);
    }
  retval=mount_all_devices(mountlist, TRUE);
  if (retval) { unmount_all_devices(mountlist); return(retval);}
  retval+=restore_everything(bkpinfo,"", "");
  retval+=run_boot_loader(FALSE);
  protect_against_braindead_sysadmins();
  retval+=unmount_all_devices(mountlist);
  mvaddstr_and_log_it(g_currentY,0,"Using e2label to label your ext2,3 partitions");
  sprintf(tmp,"label-partitions-as-necessary %s < /tmp/fstab",MOUNTLIST_FNAME);
  res=run_program_and_log_output(tmp, TRUE);
  if (res)
    {
      log_to_screen("label-partitions-as-necessary returned an error");
      mvaddstr_and_log_it(g_currentY++,74,"Failed.");
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  retval+=res;
  if (retval) {log_to_screen("Errors occurred during the nuke phase.");}
  else {success_message();}
  I_have_just_nuked=TRUE;
  return(retval);
}





void protect_against_braindead_sysadmins()
{
  run_program_and_log_output("touch /mnt/RESTORING/var/log/pacct", FALSE);
  run_program_and_log_output("touch /mnt/RESTORING/var/account/pacct", FALSE);
  if (run_program_and_log_output("ls /mnt/RESTORING/tmp", FALSE))
    {
      run_program_and_log_output("chmod -R 1777 /mnt/RESTORING/tmp", FALSE);
    }
  run_program_and_log_output("mkdir -p /mnt/RESTORING/var/run/console", FALSE);
  run_program_and_log_output("chmod 777 /mnt/RESTORING/dev/null", FALSE);
  run_program_and_log_output("cd /mnt/RESTORING; for i in `ls home/`; do echo \"Moving $i's spurious files to $i/.disabled\"; mkdir $i/.disabled ; mv -vf $i/.DCOP* $i/.MCOP* $i/.*authority $i/.kde/tmp* $i/.kde/socket* $i/.disabled/ ; done", TRUE);
  run_program_and_log_output("rm -vf /mnt/RESTORING/var/run/*.pid /mnt/RESTORING/var/lock/subsys/*", TRUE);
}




struct s_node *process_filelist_and_biggielist(struct s_bkpinfo *bkpinfo)
{
  struct s_node *filelist;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN];
  pid_t pid;

  if (does_file_exist(FILELIST_FULL) && does_file_exist(BIGGIELIST_TXT))
    {
      log_it("Filelist and biggielist already recovered from media. Yay!");
    }
  else
    {
      getcwd(tmp,MAX_STR_LEN);
      chdir(bkpinfo->tmpdir);
      log_to_screen("Extracting filelist and biggielist from media...");
      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
        {
          sprintf(command, "tar -zxf %s tmp/biggielist.txt tmp/filelist.full tmp/mondo-restore.cfg", bkpinfo->media_device);
          run_program_and_log_output(command, TRUE);
        }
      else
        {
	  insist_on_this_cd_number(bkpinfo, 1);
          run_program_and_log_output("tar -zxvf /mnt/cdrom/images/all.tar.gz tmp/biggielist.txt tmp/filelist.full tmp/mondo-restore.cfg", TRUE);
          if (!does_file_exist("tmp/biggielist.txt"))
            { fatal_error("all.tar.gz did not include tmp/biggielist.txt"); }
          if (!does_file_exist("tmp/filelist.full"))
            { fatal_error("all.tar.gz did not include tmp/filelist.full"); }
        }
      sprintf(command, "cp -f tmp/mondo-restore.cfg %s", MONDO_CFG_FILE);
      run_program_and_log_output(command, FALSE);
      chdir(tmp);
    }
  if (!does_file_exist(BIGGIELIST_TXT)) { fatal_error("/tmp/biggielist.txt not found"); }
  if (!does_file_exist(FILELIST_FULL)) { fatal_error("filelist.full does not exist"); }

  log_it("Forking");
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error"); break;
      case 0:
        log_to_screen("Pre-processing filelist");
        if (!does_file_exist(BIGGIELIST_TXT))
          {
            sprintf(command,"> %s",BIGGIELIST_TXT);
            system(command);
          }

        sprintf(command,"cat %s | grep -vx \"/dev/.*\" > %s", BIGGIELIST_TXT, BIGGIELIST_POT);
        system(command);
        sprintf(command,"cat %s | grep  -x \"/dev/.*\" > %s", BIGGIELIST_TXT, FILELIST_IMAGEDEVS);
	system(command);
        sprintf(command,"cat %s %s | sort | uniq > %s", FILELIST_FULL, BIGGIELIST_POT, FILELIST_POTENTIAL);
	system(command);
        exit(0);
        break;
      default:
        open_evalcall_form("Pre-processing filelist");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
            usleep(100000);
            update_evalcall_form(0);
          }
    }
  close_evalcall_form();
  /*
    popup_and_OK("Hit ENTER to continue (test msg)");
    log_it("Continuing after fork");
  */
  if (!does_file_exist(FILELIST_POTENTIAL)) { log_it("filelist.potential does not exist"); }
/* filelist.potential contains filelist.full and biggielist.txt (but not the imagedevs) */
  filelist=load_filelist(FILELIST_POTENTIAL);
  if (edit_filelist(filelist))
    {
      log_it("User hit 'cancel'. Freeing filelist and aborting.");
      free_filelist(filelist);
      return(NULL);
    }
  save_filelist(filelist,FILELIST_RESTTHESE);
  unlink(FILELIST_POTENTIAL);
  log_it("Forking");
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error"); break;
      case 0: 
        log_to_screen("Post-processing filelist");
        sprintf(command,"mv -f %s /tmp/tmpfs/FLRT", FILELIST_RESTTHESE);
        log_it(command);
        system(command);
        sprintf(command,"cat /tmp/tmpfs/FLRT %s | sort | uniq -d > %s", BIGGIELIST_POT, BIGGIELIST_RESTTHESE);
        log_it(command);
        system(command);
        sprintf(command,"cat /tmp/tmpfs/FLRT %s | sort | uniq -u > %s", BIGGIELIST_RESTTHESE, FILELIST_RESTTHESE);
        log_it(command);
        system(command);
        unlink("/tmp/tmpf/FLRT");
        log_it("Child process has finished");
        exit(0);
        break;
      default:
        open_evalcall_form("Post-processing filelist");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
/*            usleep(100000); */
            sleep(1);
            update_evalcall_form(0);
          }
    }
  log_it("Continuing after fork");
  ask_about_these_imagedevs(FILELIST_IMAGEDEVS,IMAGEDEVS_RESTTHESE);
  close_evalcall_form();
  if (length_of_file(IMAGEDEVS_RESTTHESE) > 2)
    { 
      sprintf(command,"cat %s >> %s", IMAGEDEVS_RESTTHESE, BIGGIELIST_RESTTHESE);
      system(command);
    }
/* so, in the end, you have /tmp/tmpfs/filelist.restore-these and /tmp/tmpfs/biggielist.restore-these */
  return(filelist);
}






void process_raidtab_line(FILE*fin, struct raid_device_record *raidrec, char*label, char*value)
{
  char tmp[MAX_STR_LEN], labelB[MAX_STR_LEN], valueB[MAX_STR_LEN];
  struct list_of_disks *disklist;
  int index, v;
  if (!strcmp(label,"raid-level"))
    {
      if (!strcmp(value,"linear"))
	{ raidrec->raid_level = -1; }
      else
	{ raidrec->raid_level = atoi(value); }
    }
  else if (!strcmp(label,"nr-raid-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"nr-spare-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"nr-parity-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"nr-failed-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"persistent-superblock"))
    { raidrec->persistent_superblock = atoi(value); }
  else if (!strcmp(label,"chunk-size"))
    { raidrec->chunk_size = atoi(value); }
  else if (!strcmp(label,"device"))
    {
      get_next_raidtab_line(fin,labelB,valueB);
      if (!strcmp(labelB,"raid-disk")) {disklist=&raidrec->data_disks; }
      else if (!strcmp(labelB,"spare-disk")) {disklist=&raidrec->spare_disks; }
      else if (!strcmp(labelB,"parity-disk")){disklist=&raidrec->parity_disks;}
      else if (!strcmp(labelB,"failed-disk")){disklist=&raidrec->failed_disks;}
      else
	{ disklist=NULL; }
      if (!disklist)
	{ sprintf(tmp,"Ignoring '%s %s' pair of disk %s",labelB,valueB,label); log_it(tmp); }
      else
	{ index=atoi(valueB); add_disk_to_raid_device(disklist,value,index); }
    }
  else
    {
      v = raidrec->additional_vars.entries;
      strcpy(raidrec->additional_vars.el[v].label, label);
      strcpy(raidrec->additional_vars.el[v].value, value);
      raidrec->additional_vars.entries = ++v;
    }
}







int read_cfg_file_into_bkpinfo( char* cfg_file, struct s_bkpinfo *bkpinfo)
{
  char value[MAX_STR_LEN], tmp[MAX_STR_LEN];
  t_bkptype media_specified_by_user;

  media_specified_by_user = bkpinfo->backup_media_type; // or 'none', if not specified

//  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
//  read_cfg_var(MONDO_CFG_FILE, "total-slices", tmp);
  if (0==read_cfg_var(cfg_file, "backup-media-type", value))
    {
      if (!strcmp(value, "cdstream")) { bkpinfo->backup_media_type = cdstream; }
      else if (!strcmp(value, "cdr")) { bkpinfo->backup_media_type = cdr; }
      else if (!strcmp(value, "cdrw")) { bkpinfo->backup_media_type = cdrw; }
      else if (!strcmp(value, "iso")) { bkpinfo->backup_media_type = iso; }
      else if (!strcmp(value, "nfs")) { bkpinfo->backup_media_type = nfs; }
      else if (!strcmp(value, "tape")) { bkpinfo->backup_media_type = tape; }
      else if (!strcmp(value, "udev")) { bkpinfo->backup_media_type = udev; }
      else
        {
          fatal_error("UNKNOWN bkp-media-type");
        }
    }
  else
    {
      fatal_error("backup-media-type not specified!");
    }
  if (bkpinfo->disaster_recovery)
    {
      if (bkpinfo->backup_media_type == cdstream)
        {
          sprintf(bkpinfo->media_device, "/dev/cdrom");
//          bkpinfo->media_size[0] = -1;
          bkpinfo->media_size[0] = 1999*1024;
          bkpinfo->media_size[1] = 650; /* good guess */
        }
      else if (bkpinfo->backup_media_type == tape || bkpinfo->backup_media_type == udev)
        {
          if (read_cfg_var(cfg_file, "media-dev", value)) { fatal_error("Cannot get tape device name from cfg file"); }
          strcpy(bkpinfo->media_device, value);
          read_cfg_var(cfg_file, "media-size", value);
          bkpinfo->media_size[1] = atol(value);
          sprintf(tmp,"Backup medium is TAPE --- dev=%s",bkpinfo->media_device);
          log_it(tmp);
        }
      else
        {
          strcpy(bkpinfo->media_device,"/dev/cdrom"); /* we don't really need this var */
//          bkpinfo->media_size[0]=-1; /* 650, probably, but we don't need this var anyway */
//          bkpinfo->media_size[1]=-1; /* 650, probably, but we don't need this var anyway */
           bkpinfo->media_size[0]= 1999*1024; /* 650, probably, but we don't need this var anyway */
           bkpinfo->media_size[1]=1999*1024; /* 650, probably, but we don't need this var anyway */
          log_it("Backup medium is CD-R[W]");
        }
    }
  else
    {
      log_it("Not in Disaster Recovery Mode. No need to derive device name from config file.");
    }
  read_cfg_var(cfg_file, "use-lzo", value);
  if (strstr(value,"yes"))
    {
      bkpinfo->use_lzo=TRUE;
      strcpy(bkpinfo->zip_exe, "lzop");
      strcpy(bkpinfo->zip_suffix, "lzo");
    }
  else
    {
      read_cfg_var(cfg_file, "use-comp", value);
      if (strstr(value,"yes"))
        {
          bkpinfo->use_lzo=FALSE;
          strcpy(bkpinfo->zip_exe, "bzip2");
          strcpy(bkpinfo->zip_suffix, "bz2");
        }
      else
        {
          bkpinfo->zip_exe[0] = bkpinfo->zip_suffix[0] = '\0';
        }
    }

  value[0]='\0';
  read_cfg_var(cfg_file, "differential", value);
  if (!strcmp(value, "yes") || !strcmp(value, "1")) { bkpinfo->differential = TRUE; }
  log_it("differential var = '%s'", value);
  if (bkpinfo->differential) { log_it("THIS IS A DIFFERENTIAL BACKUP"); }
  else { log_it("This is a regular (full) backup"); }

  read_cfg_var(MONDO_CFG_FILE, "please-dont-eject", tmp);
  if (tmp[0]) { bkpinfo->please_dont_eject_when_restoring = TRUE; log_it("Ok, I shan't eject when restoring! Groovy."); }

  if (bkpinfo->backup_media_type == nfs)
    {
      read_cfg_var(MONDO_CFG_FILE, "nfs-server-mount", bkpinfo->nfs_mount);
      read_cfg_var(MONDO_CFG_FILE, "nfs-server-path", bkpinfo->nfs_remote_dir);
      /*
	if (does_file_exist ("/tmp/NFS-SERVER-PATH"))
	  {
	    strcpy (isodir_device, last_line_of_file ("/tmp/NFS-SERVER-MOUNT"));
	    strcpy (isodir_format, "nfs");
	    strcpy (bkpinfo->isodir, last_line_of_file ("/tmp/NFS-SERVER-PATH"));
	  }
      */
 	log_it("nfs_mount is %s", bkpinfo->nfs_mount);
	log_it("nfs_remote_dir is %s", bkpinfo->nfs_remote_dir);
    }
  else if (bkpinfo->backup_media_type == iso)
    {
      if (!bkpinfo->disaster_recovery)
        {
          read_cfg_var(MONDO_CFG_FILE, "isodir", bkpinfo->isodir);
        }
      else
        {
          strcpy(bkpinfo->isodir, "/tmp/isodir");
        }
      read_cfg_var(MONDO_CFG_FILE, "iso-dev", g_isodir_device);
      log_it("isodir=%s; iso-dev=%s", bkpinfo->isodir, g_isodir_device);
      if (is_this_device_mounted(g_isodir_device))
	{ log_it("NB: isodir is already mounted"); }
      else
	{
	  sprintf(tmp, "mkdir -p %s", bkpinfo->isodir);
	  run_program_and_log_output(tmp, TRUE);
	  sprintf(tmp, "mount %s %s", g_isodir_device, bkpinfo->isodir);
	  if (run_program_and_log_output(tmp, TRUE))
	    { fatal_error( "Unable to mount isodir"); }
	}
    }

/* Also present in config file:-
	keymap-lives-here
	tapedev-has-data-disks
	bootloader.device
	bootloader.name
	nfs-dev
	nfs-server-ipaddr
*/

  if (media_specified_by_user != none) { bkpinfo->backup_media_type = media_specified_by_user; }
  return(0);

}





int restore_to_live_filesystem(struct s_bkpinfo *bkpinfo)
{
  int retval=0;
// , res;
  char old_restpath[MAX_STR_LEN];
  struct mountlist_itself the_mountlist;
  struct raidlist_itself the_raidlist;
  struct s_node *filelist;
 
  log_it("restore_to_live_filesystem() - starting");
//  unlink("/tmp/mountlist.txt");
//  unlink("/tmp/filelist.full");
//  unlink("/tmp/biggielist.txt");
  strcpy(bkpinfo->restore_path, "/");
  if (!g_restoring_live_from_cd)
    {
      popup_and_OK("Please insert tape/CD/boot floppy, then hit 'OK' to continue.");
      sleep(1);
    }
  interactively_obtain_media_parameters_from_user(bkpinfo, FALSE);
  log_it( "bkpinfo->media_device = %s", bkpinfo->media_device );
  if ( !bkpinfo->media_device[0] ) { log_it( "Warning - failed to find media dev"); }
  open_evalcall_form("Thinking...");

  while (get_cfg_file_from_archive(bkpinfo)) // also deletes tmp/filelist.full & tmp/biggielist.txt _and_ tries to restore them from start of tape, if available
    {
      if (!ask_me_yes_or_no("Failed to find config file/archives. Choose another source?"))
	{ fatal_error("Unable to find config file/archives. Aborting."); }
      interactively_obtain_media_parameters_from_user(bkpinfo, FALSE);
    }
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  close_evalcall_form();
  retval=load_mountlist(&the_mountlist,MOUNTLIST_FNAME);
  load_raidtab_into_raidlist(&the_raidlist,RAIDTAB_FNAME);
  filelist=process_filelist_and_biggielist(bkpinfo);
  if (filelist)
    {
      strcpy(old_restpath, bkpinfo->restore_path);
      if (popup_and_get_string("Restore path", "Restore files to where? (NB: / is where your filesystem is mounted now, by default)", bkpinfo->restore_path, MAX_STR_LEN))
        {
          free_filelist(filelist);
          retval+=restore_everything(bkpinfo, FILELIST_RESTTHESE, BIGGIELIST_RESTTHESE);
          strcpy(bkpinfo->restore_path, old_restpath);
        }
      else
        {
          free_filelist(filelist);
        }
      strcpy(bkpinfo->restore_path, old_restpath);
    }
  if (!bkpinfo->please_dont_eject_when_restoring)
    {
      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
        { log_it("I probably don't need to unmount or eject the CD-ROM but I'm doing it anyway."); }
      run_program_and_log_output("umount /mnt/cdrom", FALSE);
      eject_device(bkpinfo->media_device);
    }
  return(0);
}




int restore_a_biggiefile_from_CD(struct s_bkpinfo *bkpinfo, long bigfileno, char*biggielist_subset_fname)
{
  FILE*fin,*fout,*fbzip2;
  char checksum[MAX_STR_LEN], outfile_fname[MAX_STR_LEN], tmp[MAX_STR_LEN], command[MAX_STR_LEN], *p, suffix[MAX_STR_LEN], *bigblk;
  //, fifo[MAX_STR_LEN];
  int retval=0,finished=FALSE;
  long sliceno, siz;
  struct s_filename_and_lstat_info biggiestruct;

  if(!(bigblk = malloc(TAPE_BLOCK_SIZE))) { fatal_error("Cannot malloc bigblk"); }
  if (!(fin=fopen(slice_fname(bigfileno,0,ARCHIVES_PATH,""),"r")))
    { log_to_screen("Cannot even open bigfile's info file");return(1); }
  if (fread((void*)&biggiestruct, 1, sizeof(biggiestruct), fin) < sizeof(biggiestruct)) { log_it("Warning - unable to get biggiestruct of bigfile #%d", bigfileno+1); }
  fclose(fin);
  strcpy(checksum, biggiestruct.checksum);
  if (!checksum[0]) {sprintf(tmp,"Warning - bigfile %ld does not have a checksum",bigfileno+1);log_it(tmp); p=checksum;}
  sprintf(outfile_fname,"%s%s",bkpinfo->restore_path, biggiestruct.filename);

  /* skip file if we have a selective restore subset & it doesn't match */
  if (biggielist_subset_fname[0]!='\0' && !is_file_in_list(outfile_fname, biggielist_subset_fname, bkpinfo->restore_path))
    {
      sprintf(tmp,"Skipping %s (name isn't in biggielist subset)",outfile_fname);
      log_it(tmp);
      return(0);
    }
  /* otherwise, continue */
  sprintf(tmp,"Reassembling big file %ld (%s)",bigfileno+1,outfile_fname);
  log_it(tmp);
  if (does_file_exist(outfile_fname))
    {
      if (strstr(outfile_fname,"/dev/"))
        { sprintf(tmp,"%s already exists; that's cool: it's a /dev entry, which means this bigfile is an image of a disk partition", outfile_fname); }
      else
        { sprintf(tmp,"%s already exists; that's weird; I'll overwrite but I shan't delete it", outfile_fname); }
      log_it(tmp);
    }
  else
    {
      make_hole_for_file(outfile_fname);
    }

  /*
    last slice is zero-length and uncompressed; when we find it, we stop.
    We DON'T wait until there are no more slices; if we did that,
    We might stop at end of CD, not at last slice (which is 0-len and uncompd)
  */

  //  make_fifo(fifo, "/tmp/mondorestore.fifo.");
  if (!(fout=fopen(outfile_fname,"w"))) {fatal_error("RABFCD - Cannot openout outfile_fname");}

  for(sliceno=1,finished=FALSE; !finished; )
    {
      //      log_it("bigfile %ld, sliceno %ld", bigfileno+1, sliceno); 
      if (!does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"")) && !does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"lzo")) && !does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"bz2")))
	{
	  log_it("Cannot find a data slice or terminator slice on CD %d", g_current_media_number);
	  g_current_media_number++;
	  sprintf(tmp,"Asking for CD #%d so that I may read slice #%ld\n",g_current_media_number,sliceno);
	  log_it(tmp);
	  insist_on_this_cd_number(bkpinfo, g_current_media_number);
	  sprintf(tmp,"Restoring from CD #%d",g_current_media_number);
	  log_to_screen(tmp);
	}
      else
	{
	  strcpy(tmp, slice_fname(bigfileno,sliceno,ARCHIVES_PATH,""));
	  if (does_file_exist(tmp) && length_of_file(tmp)==0)
	    {
	      log_it("End of bigfile # %ld (slice %ld is the terminator)",bigfileno+1, sliceno);
	      finished=TRUE;
              continue;
	    }
	  else
	    {
	      if (does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"lzo")))
		{ strcpy(command,"lzop"); strcpy(suffix,"lzo"); }
	      else if (does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"bz2")))
		{ strcpy(command,"bzip2"); strcpy(suffix,"bz2"); }
	      else if (does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"")))
		{ strcpy(command,""); strcpy(suffix,""); }
	      else
		{ log_to_screen("OK, that's pretty fsck0red..."); return(1); }
	    }
          if (command[0]!='\0')
            {
	      sprintf(command+strlen(command)," -dc %s 2>> %s",slice_fname(bigfileno,sliceno,ARCHIVES_PATH,suffix), MONDO_LOGFILE); 
	    }
          else
            {
	      sprintf(command, "cat %s 2>> %s", slice_fname(bigfileno,sliceno,ARCHIVES_PATH,suffix), MONDO_LOGFILE); 
	    }
	  sprintf(tmp, "Working on file #%ld, slice #%ld    ",bigfileno+1,sliceno);
          log_it(tmp);
	  //	  log_it("command = '%s'", command);
	  newtDrawRootText(0,22,tmp); newtRefresh();
          strip_spaces(tmp);
	  update_progress_form(tmp);
	  if (!(fbzip2=popen(command,"r"))) { fatal_error("Can't run popen command"); }
	  while(!feof(fbzip2))
	    {
	      siz=fread(bigblk,1,TAPE_BLOCK_SIZE,fbzip2);
	      if (siz>0) { fwrite(bigblk,1,siz,fout); }
	    }
	  pclose(fbzip2);
	  
          sliceno++;
          g_current_progress++;
        }
    }
  fclose(fout);
  chmod(outfile_fname, biggiestruct.properties.st_mode);
  chown(outfile_fname, biggiestruct.properties.st_uid, biggiestruct.properties.st_gid);
  free(bigblk);
  return(retval);
}





int restore_a_biggiefile_from_stream(struct s_bkpinfo *bkpinfo, char*orig_bf_fname, long biggiefile_number, char*orig_checksum, long long biggiefile_size, char*biggielist_subset_fname)
{
  FILE*pout,*fin;
  char tmp[MAX_STR_LEN],
    command[MAX_STR_LEN],
    biggiefile_fname[MAX_STR_LEN];
  long current_slice_number=0;
  int retval=0,res=0,ctrl_chr='\0';
  long long slice_siz;
  bool dummy_restore=FALSE;
  struct s_filename_and_lstat_info biggiestruct;

/* open out to biggiefile to be restored (or /dev/null if biggiefile is not to be restored) */
  if (biggielist_subset_fname[0]!='\0' && !is_file_in_list(orig_bf_fname,biggielist_subset_fname, bkpinfo->restore_path))
    {
      dummy_restore=TRUE;
      sprintf(biggiefile_fname,"/dev/null");
      sprintf(tmp,"Skipping big file %ld (%s) - not in biggielist subset",biggiefile_number+1,orig_bf_fname);
      log_it(tmp);
    }
  else
    {
      sprintf(biggiefile_fname,"%s%s",bkpinfo->restore_path, orig_bf_fname);
      sprintf(tmp,"Reassembling big file %ld (%s)",biggiefile_number+1,orig_bf_fname);
      log_it(tmp);
      if (does_file_exist(biggiefile_fname))
        {
          if (strstr(biggiefile_fname,"/dev/"))
            { sprintf(tmp,"%s already exists; that's cool: it's a /dev entry, which means this bigfile is an image of a disk partition", biggiefile_fname); }
          else
            { sprintf(tmp,"%s already exists; that's weird; I'll overwrite but I shan't delete it", biggiefile_fname); }
          log_it(tmp);
        }
      else
        {
          make_hole_for_file(biggiefile_fname);
        }
    }
  if (!bkpinfo->zip_exe[0])
    {
      sprintf(command, "cat > \"%s\"", biggiefile_fname);
    }
  else
    {
      sprintf(command,"%s -dc > \"%s\" 2>> %s",bkpinfo->zip_exe, biggiefile_fname, MONDO_LOGFILE);
    }
  sprintf(tmp,"Pipe command = '%s'",command);
  log_it(tmp);

/* restore biggiefile, one slice at a time */
  if (!(pout=popen(command,"w")))
    {
      fatal_error("Cannot pipe out");
    }
  for(res=read_header_block_from_stream(&slice_siz, tmp, &ctrl_chr); ctrl_chr!=BLK_STOP_A_BIGGIE; res=read_header_block_from_stream(&slice_siz, tmp, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) { wrong_marker(BLK_START_AN_AFIO_OR_SLICE,ctrl_chr); }
      sprintf(tmp,"Working on file #%ld, slice #%ld    ",biggiefile_number+1,current_slice_number);
      log_it(tmp);
      newtDrawRootText(0,21,tmp); newtRefresh();
      strip_spaces(tmp);
      update_progress_form(tmp);
      if (current_slice_number==0)
        {
          res=read_file_from_stream_to_file(bkpinfo,"/tmp/biggie-blah.txt",slice_siz);
          fin=fopen("/tmp/biggie-blah.txt", "r");
          if (fread((void*)&biggiestruct, 1, sizeof(biggiestruct), fin) < sizeof(biggiestruct)) { log_it("Warning - unable to get biggiestruct of bigfile #%d", biggiefile_number+1); }
          fclose(fin);
/*
          strcpy(checksum, biggiestruct.checksum);
          if (!checksum[0]) {log_it(tmp,"Warning - bigfile %ld does not have a checksum",biggiefile_number);}
*/
       }
      else
        {
          res=read_file_from_stream_to_stream(bkpinfo,pout,slice_siz);
        }
      retval+=res;
      res=read_header_block_from_stream(&slice_siz, tmp, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) { wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE,ctrl_chr); }
      current_slice_number++;
      g_current_progress++;
    }
  pclose(pout);
  log_it("biggiestruct.filename = %s", biggiestruct.filename);
  log_it("biggiestruct.checksum = %s", biggiestruct.checksum);
  chmod(biggiefile_fname, biggiestruct.properties.st_mode);
  chown(biggiefile_fname, biggiestruct.properties.st_uid, biggiestruct.properties.st_gid);
  return(retval);
}





int restore_a_tarball_from_CD(char *tarball_fname, int current_tarball_number, char*filelist_subset_fname)
{
  int retval=0,res;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN], filelist_name[MAX_STR_LEN], executable[MAX_STR_LEN];

  system("mkdir -p /mnt/RESTORING/tmp");

  sprintf(filelist_name,"/mnt/cdrom/archives/filelist.%d",current_tarball_number);
  if (length_of_file(filelist_name) <= 2)
    {
      log_it("There are _zero_ files in filelist '%s'", filelist_name);
      log_it("This is a bit silly (ask Hugo to fix mondo-makefilelist, please)");
      log_it("but it's non-critical. It's cosmetic. Don't worry about it.");
      return(0);
    }
  if (count_lines_in_file(filelist_name)<=0 || length_of_file(tarball_fname)<=0)
    {
      log_it("count_lines_in_file(%s) = %ld", filelist_subset_fname, count_lines_in_file(filelist_subset_fname));
      log_it("length_of_file(%s) = %ld", tarball_fname, length_of_file(tarball_fname));
      sprintf(tmp,"Unable to restore fileset #%d (CD I/O error)",current_tarball_number);
      log_to_screen(tmp);
      return(1);
    }
  if (filelist_subset_fname[0]!='\0')
    {
      if (!does_file_exist(filelist_name)) { fatal_error("Filelist_name not found"); }
      if (!does_file_exist(filelist_subset_fname)) { fatal_error("FIlelist_subset_name not found"); }
      sprintf(tmp, "cat %s %s | sort | uniq -d | grep \"\" > /dev/null", filelist_name, filelist_subset_fname);
      if (system(tmp))
        {
          sprintf(tmp, "Skipping fileset %d", current_tarball_number);
          log_it(tmp);
          return(0); /* skipping it cos it doesn't have any of our files */
        }
    }
  if (strstr(tarball_fname,".bz2"))
    { strcpy(executable,"bzip2"); }
  else
    { strcpy(executable,"lzop"); }
  sprintf(tmp,"which %s > /dev/null 2> /dev/null",executable);
  if (system(tmp))
    { log_to_screen("compression program not found - oh no!"); finish(1); }
  if (filelist_subset_fname[0]!='\0')
    // -c %ld, (1024L*1024L)/TAPE_BLOCK_SIZE
    { sprintf(command,"afio -i -b %ld -M 4m -P %s -Z -w %s %s",TAPE_BLOCK_SIZE,
	      executable, filelist_subset_fname, tarball_fname); }
  else
    { sprintf(command,"afio -i -b %ld -M 4m -P %s -Z %s",TAPE_BLOCK_SIZE, 
	      executable, tarball_fname); }
  res=run_program_and_log_output(command, TRUE);
  retval+=res;
  if (retval)
    {
      log_it("Errors occurred while processing fileset #%d",current_tarball_number);
    }
  else
    {
      log_it("Fileset #%d processed OK", current_tarball_number);
    }
  return(retval);
}




int restore_a_tarball_from_stream(struct s_bkpinfo*bkpinfo, char *tarball_fname, int current_tarball_number, char*filelist_subset_fname, long long size)
{
  int retval=0, res=0 /*, stat_val*/;
  /*FILE*pafio;*/
/*  pid_t pid, child_pid; */
  char tmp[MAX_STR_LEN], command[MAX_STR_LEN] , afio_fname[MAX_STR_LEN];

/* to do it with a file... */
  sprintf(tmp,"Restoring from fileset #%d (%ld KB) on media #%d",current_tarball_number,(long) size>>10,g_current_media_number);
  log_it(tmp);
  system("mkdir -p /mnt/RESTORING/tmp");
/* Use RAMDISK's /tmp; saves time; oh wait, it's too small
   Well, pipe from tape to afio, then; oh wait, can't do that either: bug in 
   afio or someting; oh darn.. OK, use tmpfs :-) */
  sprintf(afio_fname, "/tmp/tmpfs/afio.tmp.%d", current_tarball_number);
  res=read_file_from_stream_to_file(bkpinfo,afio_fname,size);
  if (res) { log_it("Warning - error reading afioball from tape"); }
  if (!bkpinfo->zip_exe[0])
    {
      if (filelist_subset_fname[0]!='\0')
        { sprintf(command,"afio -i -b %ld -w %s %s 2>> %s",TAPE_BLOCK_SIZE, filelist_subset_fname, afio_fname, MONDO_LOGFILE); }
      else
        { sprintf(command,"afio -i -b %ld %s 2>> %s",TAPE_BLOCK_SIZE, afio_fname, MONDO_LOGFILE); }
    }
  else
    {
      if (filelist_subset_fname[0]!='\0')
        { sprintf(command,"afio -i -M 4m -b %ld -P %s -Z -w %s %s 2>> %s",TAPE_BLOCK_SIZE,bkpinfo->zip_exe, filelist_subset_fname, afio_fname, MONDO_LOGFILE); }
      else
        { sprintf(command,"afio -i -M 4m -b %ld -P %s -Z %s 2>> %s",TAPE_BLOCK_SIZE,bkpinfo->zip_exe, afio_fname, MONDO_LOGFILE); }
    }
  log_it(command);
  res=system(command);
  if (res) { log_it("Warning - errors reported by afio"); }
  unlink(afio_fname);
  return(retval);
}






int restore_all_biggiefiles_from_CD(struct s_bkpinfo *bkpinfo, char *biggielist_subset_fname)
{
  int retval=0,res;
  long noof_biggiefiles, bigfileno=0, total_slices;
  char tmp[MAX_STR_LEN];
  bool just_changed_cds=FALSE, finished;


  read_cfg_var(MONDO_CFG_FILE, "total-slices", tmp);
  total_slices = atol(tmp);
  sprintf(tmp,"Reassembling large files      ");
  mvaddstr_and_log_it(g_currentY,0,tmp);
  if (length_of_file(BIGGIELIST) < 6)
    {log_it("OK, no biggielist; not restoring biggiefiles");return(0);}
  noof_biggiefiles=count_lines_in_file(BIGGIELIST);
  if (noof_biggiefiles<=0)
    {log_it("OK, no biggiefiles in biggielist; not restoring biggiefiles");return(0);}
  sprintf(tmp,"OK, there are %ld biggiefiles in the archives",noof_biggiefiles);
  log_it(tmp);
  open_progress_form("Reassembling large files", "I am now reassembling all the large files." , "Please wait. This may take some time.", "", total_slices);
  for(bigfileno=0,finished=FALSE;!finished;)
    {
      sprintf(tmp,"Thinking about restoring bigfile %ld",bigfileno+1);
      log_it(tmp);
      if (!does_file_exist(slice_fname(bigfileno,0,ARCHIVES_PATH,"")))
	{
	  log_it("...but its first slice isn't on this CD. Perhaps this was a selective restore?");
          log_it("Cannot find bigfile #%ld first slice on CD #%d", bigfileno+1, g_current_media_number);
          log_it("Slicename would have been %s", slice_fname(bigfileno+1,0,ARCHIVES_PATH,""));
// I'm not positive 'just_changed_cds' is even necessary...
	  if (just_changed_cds)
            {
              just_changed_cds = FALSE;
              log_it("I'll continue to scan this CD for bigfiles to be restored.");
            }
	  else if (does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST"))
	    {
              insist_on_this_cd_number(bkpinfo, ++g_current_media_number);
	      sprintf(tmp,"Restoring from CD #%d",g_current_media_number);
	      log_to_screen(tmp);
              just_changed_cds = TRUE;
	    }
          else
	    {
	      log_it("There was no bigfile #%ld. That's OK." ,bigfileno+1);
	      log_it("I'm going to stop restoring bigfiles now.");
	      finished=TRUE;
	    }
	}
      else
	{
          just_changed_cds = FALSE;
	  sprintf(tmp,"Restoring big file %ld",bigfileno+1);
	  update_progress_form(tmp);
	  res=restore_a_biggiefile_from_CD(bkpinfo, bigfileno,biggielist_subset_fname);
	  retval+=res;
	  bigfileno++;
	}
    }
/*  if (bigfileno < noof_biggiefiles)
    { sprintf(tmp,"Warning - bigfileno=%ld but noof_biggiefiles=%ld\n",bigfileno,noof_biggiefiles); }
  else
    {
      sprintf(tmp,"%ld biggiefiles in biggielist.txt; %ld biggiefiles processed today.",noof_biggiefiles, bigfileno);
      log_it(tmp);
    }
*/
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}







int restore_all_tarballs_from_CD(struct s_bkpinfo *bkpinfo, char *filelist_subset_fname)
{
  int retval=0, res, attempts, current_tarball_number=0;
  long max_val;
  char tmp[MAX_STR_LEN], tarball_fname[MAX_STR_LEN], progress_str[MAX_STR_LEN], comment[MAX_STR_LEN];

  mvaddstr_and_log_it(g_currentY,0,"Restoring from archives");
  log_it("Insisting on 1st CD, so that I can have a look at LAST-FILELIST-NUMBER");
  if (g_current_media_number!=1) { log_it("OK, that's jacked up."); g_current_media_number=1;}
  insist_on_this_cd_number(bkpinfo, g_current_media_number);
  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
  max_val=atol(tmp)+1;
  sprintf(progress_str,"Restoring from CD #%d",g_current_media_number);
  log_to_screen(progress_str);
//  popup_and_OK("Let's try it");
  open_progress_form("Restoring from archives", "Restoring data from the archives." , "Please wait. This may take some time.",progress_str,max_val);
  for(;;)
    {
      insist_on_this_cd_number(bkpinfo, g_current_media_number);
      update_progress_form(progress_str);
      sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.bz2",current_tarball_number);
      if (!does_file_exist(tarball_fname)) {sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.lzo",current_tarball_number);}
      if (!does_file_exist(tarball_fname)) {sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.",current_tarball_number);}
      if (!does_file_exist(tarball_fname))
	{
	  if (current_tarball_number == 0)
	    {
	      log_to_screen("No tarballs. Strange. Maybe you only backed up freakin' big files?");
	      return(0);
	    }
	  if (!does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST") || system("find /mnt/cdrom/archives/slice* > /dev/null 2> /dev/null")==0)
	    {
	      break;
	    }
	  g_current_media_number++;
	  sprintf(progress_str,"Restoring from CD #%d",g_current_media_number);
	  log_to_screen(progress_str);
	}
      else
        {
          sprintf(progress_str,"Restoring from fileset #%d on CD #%d",current_tarball_number,g_current_media_number);
          for(res=999,attempts=0; attempts<2 && res!=0; attempts++)
            { res=restore_a_tarball_from_CD(tarball_fname,current_tarball_number,filelist_subset_fname); }
          sprintf(tmp,"CD #%d, fileset #%d - restore ", g_current_media_number, current_tarball_number);
          if (res) { strcat(tmp,"FAILED despite"); } else if (attempts>1) { strcat(tmp,"succeeded after"); } else { strcat(tmp,"succeeded"); }
          if (attempts>1) { sprintf(tmp+strlen(tmp)," %d attempts",attempts); }
          strcpy(comment, tmp);
          if (attempts>1) { log_to_screen(comment); }
          // else { log_it(comment); }
          retval+=res;
          current_tarball_number++;
          g_current_progress++;
        }
    }
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}





int restore_all_biggiefiles_from_stream(struct s_bkpinfo *bkpinfo, char *biggielist_subset_fname)
{
  long noof_biggiefiles, current_bigfile_number=0, total_slices;
  int retval=0,res=0, ctrl_chr;
  char tmp[MAX_STR_LEN], biggie_fname[MAX_STR_LEN],
     biggie_cksum[MAX_STR_LEN], *p;
  long long biggie_size;

  read_cfg_var(MONDO_CFG_FILE, "total-slices", tmp);
  total_slices = atol(tmp);
  sprintf(tmp,"Reassembling large files      ");
  mvaddstr_and_log_it(g_currentY,0,tmp);
  res=read_header_block_from_stream(&biggie_size, biggie_fname, &ctrl_chr);
  if (ctrl_chr != BLK_START_BIGGIEFILES) { wrong_marker(BLK_START_BIGGIEFILES,ctrl_chr); }
  noof_biggiefiles=atol(biggie_fname);
  sprintf(tmp,"OK, there are %ld biggiefiles in the archives",noof_biggiefiles);
  log_it(tmp);
  open_progress_form("Reassembling large files", "I am now reassembling all the large files." , "Please wait. This may take some time.", "", total_slices);
  for(res=read_header_block_from_stream(&biggie_size, biggie_fname, &ctrl_chr); ctrl_chr!=BLK_STOP_BIGGIEFILES; res=read_header_block_from_stream(&biggie_size, biggie_fname, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_A_BIGGIE) { wrong_marker(BLK_START_A_BIGGIE,ctrl_chr); }
      p=strrchr(biggie_fname,'/');
      if (!p) {p=biggie_fname;} else {p++;}
      sprintf(tmp,"Restoring big file %ld (%lld K)",current_bigfile_number+1, biggie_size/1024);
      update_progress_form(tmp);
      res=restore_a_biggiefile_from_stream(bkpinfo,biggie_fname,current_bigfile_number,biggie_cksum,biggie_size,biggielist_subset_fname);
      retval+=res;
      current_bigfile_number++;
      g_current_progress++;
    }
  if (current_bigfile_number!=noof_biggiefiles && noof_biggiefiles!=0)
    { sprintf(tmp,"Warning - bigfileno=%ld but noof_biggiefiles=%ld\n",current_bigfile_number,noof_biggiefiles); }
  else
    { sprintf(tmp,"%ld biggiefiles in biggielist.txt; %ld biggiefiles processed today.",noof_biggiefiles, current_bigfile_number); }
  log_it(tmp);
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}








int restore_all_tarballs_from_stream(struct s_bkpinfo *bkpinfo, char *filelist_subset_fname)
{
  int retval=0, res, current_afioball_number=0, ctrl_chr;
  long max_val /*, total_noof_files */;
  char tmp[MAX_STR_LEN], progress_str[MAX_STR_LEN],
    tmp_fname[MAX_STR_LEN];
  long long tmp_size;

  mvaddstr_and_log_it(g_currentY,0,"Restoring from archives");
  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
  max_val = atol(tmp)+1;
  chdir(bkpinfo->restore_path); /* I don't know why this is needed _here_ but it seems to be. -HR, 02/04/2002 */
  run_program_and_log_output("pwd", TRUE);
  sprintf(progress_str,"Restoring from media #%d",g_current_media_number);
  log_to_screen(progress_str);
  open_progress_form("Restoring from archives", "Restoring data from the archives." , "Please wait. This may take some time.",progress_str,max_val);

  log_it("hey");
  res=read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr);
  if (res) { log_it("Warning - error reading afioball from tape"); }
  retval+=res;
  if (ctrl_chr != BLK_START_AFIOBALLS) { wrong_marker(BLK_START_AFIOBALLS,ctrl_chr); }
  log_it("ho");
  for(res=read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr); ctrl_chr!=BLK_STOP_AFIOBALLS; res=read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr))
    {
      update_progress_form(progress_str);
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) { wrong_marker(BLK_START_AN_AFIO_OR_SLICE,ctrl_chr); }
      sprintf(tmp,"Restoring from fileset #%d (name=%s, size=%ld K)", current_afioball_number, tmp_fname, (long) tmp_size>>10);
      /*log_it(tmp);*/
      res=restore_a_tarball_from_stream(bkpinfo,tmp_fname,current_afioball_number,filelist_subset_fname,tmp_size);
      retval+=res;
      if (res)
        {
	  sprintf(tmp,"Fileset %d - errors occurred",current_afioball_number);
	  log_to_screen(tmp);
	}
      res=read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) { wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE,ctrl_chr); }
      current_afioball_number++;
      g_current_progress++;
      sprintf(progress_str,"Restoring from fileset #%d on media #%d",current_afioball_number, g_current_media_number);
    }
  log_it("All done with afioballs");
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}




int restore_everything(struct s_bkpinfo*bkpinfo, char *regular_files_to_restore, char*biggie_files_to_restore)
{
  int resA, resB;
  char cwd[MAX_STR_LEN], newpath[MAX_STR_LEN], tmp[MAX_STR_LEN];

  log_it("restore_everything() --- starting");
  g_current_media_number=1;
  getcwd(cwd,MAX_STR_LEN-1);
  sprintf(tmp, "mkdir -p %s", bkpinfo->restore_path);
  run_program_and_log_output(tmp, FALSE);
  chdir(bkpinfo->restore_path);
  getcwd(newpath,MAX_STR_LEN-1);
  log_it("restoring everything");
  if (!system("which petris > /dev/null 2> /dev/null"))
    {
      newtDrawRootText(0,21,"Press ALT-<left cursor> twice to play Petris :-)"); newtRefresh();
    }
  mvaddstr_and_log_it (g_currentY, 0, "Preparing to read your archives");
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      mount_cdrom(bkpinfo);
      mvaddstr_and_log_it (g_currentY++, 0, "Restoring OS and data from streaming media");
      if (bkpinfo->backup_media_type == cdstream)
        { openin_cdstream(bkpinfo); }
      else
        { openin_tape(bkpinfo); }
      resA=restore_all_tarballs_from_stream(bkpinfo,regular_files_to_restore);
      resB=restore_all_biggiefiles_from_stream(bkpinfo,biggie_files_to_restore);
      if (bkpinfo->backup_media_type == cdstream)
        { closein_cdstream(bkpinfo); }
      else
        { closein_tape(bkpinfo); }
    }
  else
    {
      mvaddstr_and_log_it (g_currentY++, 0, "Restoring OS and data from CD       ");
      mount_cdrom(bkpinfo);
      resA=restore_all_tarballs_from_CD(bkpinfo,regular_files_to_restore);
      resB=restore_all_biggiefiles_from_CD(bkpinfo,biggie_files_to_restore);
    }
  chdir(cwd);
  if (resA+resB)
    {
      log_to_screen("Errors occurred while data was being restored.");
    }
  if (length_of_file("/etc/raidtab") > 0)
    {
      log_it("Copying local raidtab to restored filesystem");
      run_program_and_log_output("cp -f /etc/raidtab /mnt/RESTORING/etc/raidtab", FALSE);
    }
  kill_petris();
  log_it("restore_everything() --- leaving");
  return(resA+resB);
}






int restore_live_from_monitas_server(struct s_bkpinfo *bkpinfo, char*monitas_device, char*restore_this_directory, char*restore_here)
/* NB: bkpinfo hasn't been populated yet, except for ->tmp which is "/tmp" */
{
// res, 
  int retval=0, i, j;
  struct mountlist_itself the_mountlist;
  struct raidlist_itself the_raidlist;
//  struct s_node *filelist;
  char tmp[MAX_STR_LEN+1], command[MAX_STR_LEN+1];
  char datablock[256*1024], datadisks_fname[MAX_STR_LEN+1];
  long k, length;
  FILE*fout;
  long long llt;

  sprintf(tmp, "restore_here = '%s'", restore_here);
  log_it(tmp);
  log_it("restore_live_from_monitas_server() - starting");
  unlink("/tmp/mountlist.txt"); unlink("/tmp/filelist.full");
  unlink("/tmp/biggielist.txt");
  if (restore_here[0]=='\0')
    { strcpy(bkpinfo->restore_path, "/mnt/RESTORING"); }
  else
    { strcpy(bkpinfo->restore_path, restore_here); }
  log_it("FYI FYI FYI FYI FYI FYI FYI FYI FYI FYI FYI");
  sprintf(tmp, "FYI - data will be restored to %s", bkpinfo->restore_path);
  log_it(tmp);
  log_it("FYI FYI FYI FYI FYI FYI FYI FYI FYI FYI FYI");
  sprintf(datadisks_fname, "/tmp/mondorestore.datadisks.%d", (int)(random()%32768));
  chdir(bkpinfo->tmpdir);

  sprintf(command, "cat %s", monitas_device);
  g_tape_stream=popen(command, "r"); // for compatibility with openin_tape()
  fout = fopen(datadisks_fname, "w");
  for (i = 0; i < 32; i++)
    {
      for (j = 0; j < 4; j++)
        {
          for(length=k=0; length<256*1024; length+=k)
            {
              k=fread(datablock+length, 1, 256 * 1024 - length, g_tape_stream);
            }
          fwrite (datablock, 1, length, fout);
          g_tape_posK += length;
        }
    }
  fclose(fout);
  sprintf(command, "tar -zxvf %s tmp/mondo-restore.cfg tmp/mountlist.txt tmp/filelist.full tmp/biggielist.txt", datadisks_fname);
  run_program_and_log_output(command, TRUE);
  read_header_block_from_stream (&llt, tmp, &i);
  read_header_block_from_stream (&llt, tmp, &i);

  unlink(datadisks_fname);
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  strcpy(bkpinfo->media_device, monitas_device);
  retval=load_mountlist(&the_mountlist,MOUNTLIST_FNAME);
  load_raidtab_into_raidlist(&the_raidlist,RAIDTAB_FNAME);
  sprintf(command, "cat %s | grep -x \"%s.*\" > %s", FILELIST_FULL, restore_this_directory, FILELIST_RESTTHESE);
  if (system(command)) { retval++; log_to_screen("Error(s) occurred while processing filelist and wildcard"); }
  sprintf(command, "cat %s | grep -x \"%s.*\" > %s", BIGGIELIST_TXT, restore_this_directory, BIGGIELIST_RESTTHESE);
  if (system(command)) { log_it("Error(s) occurred while processing biggielist and wildcard"); }
  sprintf(command, "touch %s", BIGGIELIST_RESTTHESE);
  run_program_and_log_output(command, FALSE);
  retval+=restore_everything(bkpinfo, FILELIST_RESTTHESE, BIGGIELIST_RESTTHESE);
  log_it("--------End of restore_live_from_monitas_server--------");
  return(retval);
}







int run_boot_loader(bool offer_to_hack_scripts)
{
  int res, retval=0;
  char device[MAX_STR_LEN], tmp[MAX_STR_LEN], name[MAX_STR_LEN];

  read_cfg_var(MONDO_CFG_FILE, "bootloader.device", device);
  read_cfg_var(MONDO_CFG_FILE, "bootloader.name", name);
  sprintf(tmp,"run_boot_loader: device='%s', name='%s'",device,name);
  log_it(tmp);
  if (!strcmp(name,"LILO"))
    { res=run_lilo(offer_to_hack_scripts); }
  else if (!strcmp(name,"GRUB"))
    { res=run_grub(offer_to_hack_scripts, device); }
  else if (!strcmp(name,"RAW"))
    { res=run_raw_mbr(offer_to_hack_scripts, device); }
  else
    {
      log_to_screen("Unable to determine type of boot loader. Defaulting to LILO.");
      res=run_lilo(offer_to_hack_scripts);
    }
  retval+=res;
  if (res) { log_to_screen("Your boot loader returned an error"); }
  else { log_to_screen("Your boot loader ran OK"); }
  // FIXME - move this to end of nuke_mode() and interactive_mode()
  sprintf(tmp,"make-me-bootable /tmp/mountlist.txt");
  res=run_program_and_log_output(tmp, TRUE);
  retval+=res;
  if (res) { log_to_screen("Errors occurred while making partition(s) bootable"); }
  else { log_to_screen("Partition(s) made bootable OK"); }
  return(retval);
}


#define FIXED_BY_MONDO ".fixed-by-Mondo"


int fix_grubinstall_script(char*old_fname, char*new_fname)
{
  char command[MAX_STR_LEN];

  sprintf(command, "cat %s | sed 's/sh\\]d\\[a\\-z\\]/imsh\\]d\\[a\\-z,\\]/' > %s 2>> %s", old_fname, new_fname, MONDO_LOGFILE);
  log_it("command = %s", command);
  if (system(command))
    {
      log_it("...failed");
      return(1);
    }
  else
    {
      log_it("...succeeded");
      chmod(new_fname, 0x744);
      return(0);
    }
}



int run_grub(bool offer_to_run_stabgrub, char*bd)
{
  char command[MAX_STR_LEN], boot_device[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];
  //  char restore_path[MAX_STR_LEN] = "/mnt/RESTORING";
  int res,done;

  strcpy(boot_device, bd);
  find_pathname_of_executable_preferably_in_RESTORING(tmp, "grub-install");

  if (!run_program_and_log_output("which grub-MR", FALSE))
    { sprintf(command, "grub-MR %s /tmp/mountlist.txt", boot_device); }
  else 
    { strcpy(command, "chroot /mnt/RESTORING grub-install '(hd0)'"); }

  if (offer_to_run_stabgrub && ask_me_yes_or_no("Did you change the mountlist?"))
/* interactive mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Modifying fstab and grub.conf, and running GRUB...                             ");
      for(done=FALSE; !done; )
	{
	  popup_and_get_string("Boot device", "Please confirm/enter the boot device. If in doubt, try /dev/hda",boot_device, MAX_STR_LEN/4);
	  sprintf(command, "stabgrub-me %s", boot_device);
	  res = run_program_and_log_output(command, TRUE);
	  if (res)
	    { done = ask_me_yes_or_no("GRUB failed. Re-try?"); }
	  else
	    { done = TRUE; }
	  if (!run_program_and_log_output("which vi", FALSE))
	    {
	      popup_and_OK("You will now check fstab and grub.conf");
	      newtSuspend();
	      system("vi /mnt/RESTORING/etc/fstab");
	      system("vi /mnt/RESTORING/etc/grub.conf");
	      newtResume();
//             newtCls();
	    }
	}
    }
  else
    
/* nuke mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Running GRUB...                                                 ");
      res = run_program_and_log_output(command, TRUE);
      if (res)
	{
	  log_it("grub-MR failed; trying grub-install");
	  strcpy(command, "chroot /mnt/RESTORING grub-install '(hd0)'");
	  if ((res=run_program_and_log_output(command, TRUE)))
	    {
	      log_it("Failed. Trying with grub-install %s", boot_device);
	      sprintf(command, "chroot /mnt/RESTORING %s %s", "grub-install", boot_device);
	      res = run_program_and_log_output(command, TRUE);
	    }
	}
    }
  if (res)
    {
      mvaddstr_and_log_it(g_currentY++,74,"Failed.");
      log_to_screen("GRUB ran w/error(s). See /tmp/mondo-restore.log for more info.");
      log_it("Type:-");
      log_it("    mount-me");
      log_it("    chroot /mnt/RESTORING");
      log_it("    grub-install '(hd0)'");
      log_it("    unmount-me");
      log_it("If you're really stuck, please e-mail the mailing list.");
    }
  else
    {  
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  return(res);
}



int run_lilo(bool offer_to_run_stablilo)
{
  char command[MAX_STR_LEN];
  int res,done;

  if (offer_to_run_stablilo && ask_me_yes_or_no("Did you change the mountlist?"))

/* interactive mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Modifying fstab and lilo.conf, and running LILO...                             ");
      sprintf(command,"stablilo-me");
      res=run_program_and_log_output(command, TRUE);
      if (res)
        {
          popup_and_OK("You will now edit fstab and lilo.conf, to make sure they match your new mountlist.");
          for(done=FALSE;!done;)
            {
              newtSuspend();
              system("vi /mnt/RESTORING/etc/fstab");
              system("vi /mnt/RESTORING/etc/lilo.conf");
              newtResume();
//              newtCls();
              if (ask_me_yes_or_no("Edit them again?")) {continue;}
              res = run_program_and_log_output("chroot /mnt/RESTORING lilo -L", TRUE);
              if (res) { res = run_program_and_log_output("chroot /mnt/RESTORING lilo", TRUE); }
              if (res)
                {
                  if (!ask_me_yes_or_no("LILO failed. Re-edit system files?"))
		    {
		      done = TRUE;
		    }
                }
              else
	        {
	          done = TRUE;
	        }
            }
	}
      else
	{
	  log_to_screen("lilo.conf and fstab were modified OK");
	}
    }
  else

/* nuke mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Running LILO...                                                 ");
      res = run_program_and_log_output("chroot /mnt/RESTORING lilo -L", TRUE);
      if (res) { res = run_program_and_log_output("chroot /mnt/RESTORING lilo", TRUE); }
      if (res)
        {
          mvaddstr_and_log_it(g_currentY++,74,"Failed.");
          log_to_screen("Failed to re-jig fstab and/or lilo. Edit/run manually, please.");
        }
      else
       {  
          mvaddstr_and_log_it(g_currentY++,74,"Done.");
        }
    }
  return(res);
}




int run_raw_mbr(bool offer_to_hack_scripts, char*bd)
{
  char command[MAX_STR_LEN], boot_device[MAX_STR_LEN];
//  char tmp[MAX_STR_LEN];
  int res,done;

  strcpy(boot_device, bd);
  sprintf(command, "raw-MR %s /tmp/mountlist.txt", boot_device);
  log_it("run_raw_mbr() --- command='%s'", command);

  if (offer_to_hack_scripts && ask_me_yes_or_no("Did you change the mountlist?"))
/* interactive mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Modifying fstab and restoring MBR...                           ");
      for(done=FALSE; !done; )
	{
	  if (!run_program_and_log_output("which vi", FALSE))
	    {
	      popup_and_OK("You will now edit fstab");
	      newtSuspend();
	      system("vi /mnt/RESTORING/etc/fstab");
	      newtResume();
//              newtCls();
	    }
	  popup_and_get_string("Boot device", "Please confirm/enter the boot device. If in doubt, try /dev/hda",boot_device, MAX_STR_LEN/4);
	  sprintf(command, "stabraw-me %s", boot_device);
	  res = run_program_and_log_output(command, TRUE);
	  if (res)
	    {
	      done = ask_me_yes_or_no("Modifications failed. Re-try?");
	    }
	  else
	    {
	      done = TRUE;
	    }
	}
    }
  else
    
/* nuke mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Restoring MBR...                                               ");
      res = run_program_and_log_output(command, TRUE);
    }
  if (res)
    {
      mvaddstr_and_log_it(g_currentY++,74,"Failed.");
      log_to_screen("MBR+fstab processed w/error(s). See /tmp/mondo-restore.log for more info.");
    }
  else
    {  
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  return(res);
}


void save_disklist_to_file(char*listname, struct list_of_disks *disklist, FILE*fout)
{
  int i;
  for(i=0; i<disklist->entries; i++)
    {
      fprintf(fout,"    device                %s\n",disklist->el[i].device);
      fprintf(fout,"    %-21s %d\n",listname,disklist->el[i].index);
    }
}



void save_additional_vars_to_file(struct additional_raid_variables *vars, FILE*fout)
{
  int i;
  for(i=0; i<vars->entries; i++)
    {
      fprintf(fout,"    %-21s %s\n",vars->el[i].label, vars->el[i].value);
    }
}



int save_mountlist_to_disk(struct mountlist_itself *mountlist, char*fname)
{
  FILE*fout;
  int i;

  log_it("save_mountlist_to_disk() --- saving to %s", fname);
  if (!(fout=fopen(fname,"w"))) {log_it("WMTD - Cannot openout mountlist");return(1);}
  for(i=0; i< mountlist->entries; i++)
    {
      fprintf(fout,"%-15s %-15s %-15s %8ld\n",mountlist->el[i].device, mountlist->el[i].mountpoint, mountlist->el[i].format, mountlist->el[i].size);
    }
  fclose(fout);
  return(0);
}







int save_raidlist_to_raidtab(struct raidlist_itself *raidlist, char*fname)
{
  FILE*fout;
  int current_raid_device;
  if (raidlist->entries <= 0)
    {
      unlink(fname);
      log_it("Deleting raidtab (no RAID devs anyway)");
      return(0);
    }
  if (!(fout=fopen(fname,"w"))) {log_it("Failed to save raidlist");return(1);}
  for(current_raid_device=0; current_raid_device < raidlist->entries; current_raid_device++)
    {
      save_raidrec_to_file(&raidlist->el[current_raid_device],fout);
    }
  fclose(fout);
  return(0);
}





void save_raidrec_to_file(struct raid_device_record *raidrec, FILE*fout)
{
  fprintf(fout,"raiddev %s\n",raidrec->raid_device);
  if (raidrec->raid_level==-1)
    { fprintf(fout,"    raid-level            linear\n"); }
  else
    { fprintf(fout,"    raid-level            %d\n",raidrec->raid_level); }
  fprintf(fout,"    chunk-size            %d\n",raidrec->chunk_size);
  fprintf(fout,"    nr-raid-disks         %d\n",raidrec->data_disks.entries); 
  fprintf(fout,"    nr-spare-disks        %d\n",raidrec->spare_disks.entries);
  if (raidrec->parity_disks.entries > 0)
    {fprintf(fout,"    nr-parity-disks       %d\n",raidrec->parity_disks.entries);}
//  if (raidrec->failed_disks.entries > 0)
//    {fprintf(fout,"    nr-failed-disks       %d\n",raidrec->failed_disks.entries);}
  fprintf(fout,"    persistent-superblock %d\n",raidrec->persistent_superblock);
  save_additional_vars_to_file(&raidrec->additional_vars,fout);
  fprintf(fout,"\n");
  save_disklist_to_file("raid-disk",&raidrec->data_disks, fout);
  save_disklist_to_file("spare-disk",&raidrec->spare_disks, fout);
  save_disklist_to_file("parity-disk",&raidrec->parity_disks, fout);
  save_disklist_to_file("failed-disk",&raidrec->failed_disks, fout);
  fprintf(fout,"\n");
}



void sort_mountlist_by_device(struct mountlist_itself *mountlist)
{
  int diff,lino=-999;
  while (lino < mountlist->entries)
    {
      for(lino=1; lino < mountlist->entries; lino++)
	{
	  diff=strcmp_inc_numbers(mountlist->el[lino-1].device,mountlist->el[lino].device);
	  if (diff>0)
	    {
	      swap_mountlist_entries(mountlist,lino-1,lino);
	      break;
	    }
	}
    }
}



void set_signals(int on)
/*
Purpose:Turn on/off signal-trapping
Params:	on - turn on or off (true=on, false=off)
Return: None
*/
{
  int signals[]= { SIGKILL, SIGPIPE, SIGTERM, SIGHUP, SIGTRAP, SIGABRT, SIGINT, SIGSTOP, 0 };
  int i;
  for (i=0; signals[i]; i++)
    {
      if (on)
        { signal(signals[i], terminate_daemon); }
      else
        { signal(signals[i], termination_in_progress); }
    }
}





void setup_global_filenames(struct s_bkpinfo *bkpinfo)
{
  char*temppath;

  temppath=bkpinfo->tmpdir;
  sprintf(BIGGIELIST_TXT, "%s/tmp/biggielist.txt", temppath);
  sprintf(FILELIST_FULL, "%s/tmp/filelist.full", temppath);
  sprintf(BIGGIELIST_POT, "%s/tmp/biggielist.pot", temppath);
  sprintf(FILELIST_POTENTIAL, "%s/tmp/filelist.potential", temppath);
  sprintf(FILELIST_IMAGEDEVS, "%s/tmp/filelist.imagedevs", temppath);
  sprintf(FILELIST_RESTTHESE, "%s/tmp/filelist.restore-these", temppath);
  sprintf(BIGGIELIST_RESTTHESE, "%s/tmp/biggielist.restore-these", temppath);
  sprintf(IMAGEDEVS_POT, "%s/tmp/imagedevs.pot", temppath);
  sprintf(IMAGEDEVS_RESTTHESE, "%s/tmp/imagedevs.restore-these", temppath);
  if (bkpinfo->disaster_recovery)
    {
      sprintf(MONDO_CFG_FILE, "/tmp/mondo-restore.cfg");
      sprintf(MOUNTLIST_FNAME, "/tmp/mountlist.txt");
    }
  else
    {
      sprintf(MONDO_CFG_FILE, "%s/tmp/mondo-restore.cfg", temppath);
      sprintf(MOUNTLIST_FNAME, "%s/tmp/mountlist.txt", temppath);
    }
}



void sort_mountlist_by_mountpoint(struct mountlist_itself *mountlist, bool reverse)
{
  int diff,lino=-999;
  while(lino < mountlist->entries)
    {
      for(lino=1; lino < mountlist->entries; lino++)
	{
	  diff=strcmp(mountlist->el[lino-1].mountpoint,mountlist->el[lino].mountpoint);
	  if ((diff>0 && !reverse) || ((diff<0 && reverse)))
	    {
	      swap_mountlist_entries(mountlist,lino-1,lino);
	      break;
	    }
	}
    }
}



void streamline_changes_file(char*output_file,char*input_file)
{
  FILE*fin,*fout;
  char incoming[MAX_STR_LEN];
  if (!(fin=fopen(input_file,"r"))) {return;}
  if (!(fout=fopen(output_file,"w"))) {fatal_error("cannot open output_file");}
  for(fgets(incoming,MAX_STR_LEN-1,fin);!feof(fin);fgets(incoming,MAX_STR_LEN-1,fin))
    {
      if(strncmp(incoming,"etc/adjtime",11) \
      && strncmp(incoming,"etc/mtab",8) \
      && strncmp(incoming,"tmp/",4) \
      && strncmp(incoming,"boot/map",8) \
      && !strstr(incoming,"incheckentry") \
      && strncmp(incoming,"etc/mail/statistics",19) \
      && strncmp(incoming,"var/",4))
        {
          fprintf(fout,"%s",incoming); /* don't need \n here, for some reason.. */
        }      
    }
  fclose(fout);
  fclose(fin);
}






void success_message(void)
{
  int i;
  char tmp[MAX_STR_LEN];

  if (ask_me_yes_or_no("Have you contributed to the Mondo project financially or in some other way, yet?"))
    {
      log_to_screen("Thank you for supporting Mondo. It goes from strength to strength,");
      log_to_screen("thanks to the support of users like you.");
    }
  else
    {
      if (ask_me_yes_or_no("Are you or your company willing to consider contributing to Mondo in some way?"))
        {
          popup_and_OK("To support the project which has just performed a valuable service for you, please visit http://www.mondorescue.com; click on 'Download' and then 'PayPal'.");
        }
      else
        {
          log_to_screen("Free Software, like freedom itself, must be supported or it will be lost.");
          log_it("To your credit, you were honest: you said no, you wouldn't be contributing");
          log_it("to this project, ever. However, that makes you a freeloader. I bet you're");
          log_it("the sort of person who likes to sneak into movie theatres...");
          popup_and_OK("If you ever change your mind, you may support this product by going to http://www.mondrescue.com and clicking on 'Download', followed by 'PalPal'.");
        }
    }

  strcpy(tmp, call_program_and_get_last_line_of_output("date +%S"));
  i=atoi(tmp) % 32;
  if (i!=25)
    {
      strcpy(tmp,"Mondo has restored your system. Please remove the backup media and reboot.");
    }
  else
    {
      strcpy(tmp,"M0nd0 h45 r3570r3d j00r 5y573m. P13453 r3m0v3 7h3 b4ckup m3d14 4nd r3b007.");
    }
  popup_and_OK(tmp);
}




void swap_mountlist_entries(struct mountlist_itself *mountlist, int a, int b)
{
  char device[64], mountpoint[64], format[64];
  long size;
  strcpy(device,                     mountlist->el[a].device);
  strcpy(mountpoint,                 mountlist->el[a].mountpoint);
  strcpy(format,                     mountlist->el[a].format);
  size=                              mountlist->el[a].size;
  strcpy(mountlist->el[a].device,    mountlist->el[b].device);
  strcpy(mountlist->el[a].mountpoint,mountlist->el[b].mountpoint);
  strcpy(mountlist->el[a].format,    mountlist->el[b].format);
  mountlist->el[a].size=             mountlist->el[b].size;
  strcpy(mountlist->el[b].device,    device);
  strcpy(mountlist->el[b].mountpoint,mountpoint);
  strcpy(mountlist->el[b].format,    format);
  mountlist->el[b].size=             size;
}





void terminate_daemon(int sig)
{
   log_to_screen("Mondorestore is terminating in response to a signal from the OS");
   finish(254);
}




void twenty_seconds_til_yikes()
{
  int i;
  char tmp[MAX_STR_LEN];
  open_progress_form("CAUTION", "Be advised: I am about to ERASE your hard disk(s)!", "You may press Ctrl+Alt+Del to abort safely.", "", 20);
  for(i=0;i<20;i++)
    {
      g_current_progress=i;
      sprintf(tmp,"You have %d seconds left to abort.",20-i);
      update_progress_form(tmp);
      sleep(1);
    }
  close_progress_form();
}






void termination_in_progress(int sig)
{
  log_it("Termination in progress");
  usleep(1000);
  pthread_exit(0);
}


int unmount_all_devices(struct mountlist_itself *p_external_copy_of_mountlist)
{
  struct mountlist_itself internal_copy_of_mountlist;
  struct mountlist_itself *mountlist;
  int retval=0,lino,res=0,i;
  char command[MAX_STR_LEN],tmp[MAX_STR_LEN];

  mountlist = &internal_copy_of_mountlist;
  memcpy((void*)mountlist, (void*)p_external_copy_of_mountlist, sizeof(struct mountlist_itself));
  sort_mountlist_by_mountpoint(mountlist, 0);

  run_program_and_log_output("df -m", TRUE);
  mvaddstr_and_log_it(g_currentY,0,"Unmounting devices      ");
  open_progress_form("Unmounting devices", "Unmounting all devices that were mounted," , "in preparation for the post-restoration reboot.", "", mountlist->entries);
  chdir("/");
  for(i=0; i<10 && run_program_and_log_output("ps ax | grep buffer | grep -v \"grep buffer\"", TRUE)==0; i++)
    {
      sleep(1);
      log_it("Waiting for buffer() to finish");
    }
  system("sync");
  if (system("cp -f /tmp/mondo-restore.log /mnt/RESTORING/tmp/ 2> /dev/null")) { log_it("Error. Failed to copy log to PC's /tmp dir."); }
  if (system("cp -f /tmp/mondo-restore.log /mnt/RESTORING/root/ 2> /dev/null")) { log_it("Error. Failed to copy log to PC's /root dir."); }
  if (does_file_exist("/tmp/DUMBASS-GENTOO"))
    { run_program_and_log_output("mkdir -p /mnt/RESTORING/mnt/.boot.d", TRUE); }
  for(lino=mountlist->entries-1;lino>=0;lino--)
    {
      if (!strcmp(mountlist->el[lino].mountpoint,"lvm"))
        { continue; }
      sprintf(tmp,"Unmounting device %s  ",mountlist->el[lino].device);
      /*      log_it(tmp); */
      update_progress_form(tmp);
      if (is_this_device_mounted(mountlist->el[lino].device))
        {
          if (!strcmp(mountlist->el[lino].mountpoint,"swap"))
            {
	      sprintf(command,"swapoff %s",mountlist->el[lino].device); 
	    }
          else
	    {
	      if (!strcmp(mountlist->el[lino].mountpoint, "/1"))
		{
		  sprintf(command, "umount %s/", "/mnt/RESTORING");
		  log_it("Well, I know a certain kitty-kitty who'll be sleeping with Mommy tonight...");
		}
	      else
		{
		  sprintf(command, "umount %s%s", "/mnt/RESTORING", mountlist->el[lino].mountpoint);
		}
	    }
	  log_it("The 'umount' command is '%s'", command);
	  res = run_program_and_log_output(command, TRUE);
        }
      else
        {
          strcat(tmp,"...not mounted anyway :-) OK");
          res=0;
        }
      g_current_progress++;
      if (res)
	{
	  strcat(tmp,"...Failed");
	  retval++;
	  log_to_screen(tmp);
	}
      else
	{
	  log_it(tmp);
	}
    }
  close_progress_form();
  if (retval) { mvaddstr_and_log_it(g_currentY++,74,"Failed."); }
  else        { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  if (retval)
    {
      log_to_screen("Unable to unmount some of your partitions.");
    }
  else
    {
      log_to_screen("All partitions were unmounted OK.");
    }
  return(retval);
}






/* ----------------------------------------------------------------------- */


int main(int argc, char*argv[])
{
  int retval=0, res, c;
  struct mountlist_itself the_mountlist;
  struct raidlist_itself the_raidlist;
  char tmp[MAX_STR_LEN];
  struct s_bkpinfo *bkpinfo;

  g_current_media_number = 1;
  malloc_global_string ( BIGGIELIST_TXT );
  malloc_global_string ( FILELIST_FULL );
  malloc_global_string ( BIGGIELIST_POT );
  malloc_global_string ( FILELIST_POTENTIAL );
  malloc_global_string ( FILELIST_IMAGEDEVS );
  malloc_global_string ( FILELIST_RESTTHESE );
  malloc_global_string ( BIGGIELIST_RESTTHESE );
  malloc_global_string ( IMAGEDEVS_POT );
  malloc_global_string ( IMAGEDEVS_RESTTHESE );
  malloc_global_string ( MONDO_CFG_FILE );
  malloc_global_string ( MOUNTLIST_FNAME );
  malloc_global_string ( g_mondo_home );
  if (!(bkpinfo = malloc(sizeof(struct s_bkpinfo)))) { fatal_error("Cannot malloc bkpinfo"); }
  strcpy( MOUNTLIST_FNAME, "/tmp/mountlist.txt" );
  sprintf (tmp, "%s.orig", MOUNTLIST_FNAME);
  if (!does_file_exist(tmp)) 
    {
      sprintf(tmp, "cp -f %s %s.orig", MOUNTLIST_FNAME, MOUNTLIST_FNAME); run_program_and_log_output(tmp, FALSE); 
    }

  g_text_mode = FALSE; // newt :-)
  register_pid(getpid(), "mondo");
	  srandom((int)(time(NULL)));
  set_signals(TRUE);
  strcpy(g_mondo_home, "Hi");

  bkpinfo->backup_media_type = none; // just in case
  sprintf(tmp,"-------------- Mondo Restore v%s -------------", VERSION);
  log_it(tmp);
  strcpy(g_mondo_home, call_program_and_get_last_line_of_output("which mondorestore"));
  reset_bkpinfo(bkpinfo);
  bkpinfo->restore_data = TRUE; // Well, duh :-)
  bkpinfo->disaster_recovery = am_I_in_disaster_recovery_mode();
  if (bkpinfo->disaster_recovery)
    { log_it("I am in disaster recovery mode\n"); }
  else
    { log_it("I am in normal, live mode\n"); }
  system("mkdir -p /var/log");
  system("umount /mnt/cdrom > /dev/null 2> /dev/null");
  system("mkdir -p /tmp/tmpfs"); /* just in case... */
  system("ln -sf /var/log/mondo-archive.log /tmp/mondo-restore.log");
  system("rm -Rf /tmp/tmpfs/mondo.tmp.*");
  sprintf(bkpinfo->tmpdir, "/tmp/tmpfs/mondo.tmp.%d", (int)(random()%32768));
  sprintf(tmp, "mkdir -p %s", bkpinfo->tmpdir);
  system(tmp);
  setup_global_filenames(bkpinfo);
  setup_newt_stuff();

  if (argc==2 && strcmp(argv[1],"--edit-mountlist")==0)
    {
      if (!bkpinfo->disaster_recovery)
        {
          strcpy(MOUNTLIST_FNAME, "/tmp/mountlist.txt");
          log_it("I guess you're testing edit_mountlist()");
        }
      retval=load_mountlist(&the_mountlist,MOUNTLIST_FNAME);
      load_raidtab_into_raidlist(&the_raidlist,RAIDTAB_FNAME);
      if (retval) { log_to_screen("Warning - load_raidtab_into_raidlist returned an error"); }
      res=edit_mountlist(&the_mountlist, &the_raidlist);
      if (res) { finish(1); }
      save_mountlist_to_disk(&the_mountlist,MOUNTLIST_FNAME);
      save_raidlist_to_raidtab(&the_raidlist,RAIDTAB_FNAME);
      log_to_screen("I have finished editing the mountlist for you.");
      free_global_stuff();
      free ( bkpinfo );
      finish(0);
    }
  else if (!bkpinfo->disaster_recovery)
    {
//      unmount_supermounts_if_necessary();
      mount_boot_if_necessary();
      if (strcmp(argv[argc-1], "--live-from-cd")==0)
        { g_restoring_live_from_cd=TRUE; }
      if (argc==5 && strcmp(argv[1], "--monitas-live")==0)
        { retval = restore_live_from_monitas_server(bkpinfo, argv[2], argv[3], argv[4]); }
      else
        { retval = restore_to_live_filesystem(bkpinfo); }
      sprintf(tmp, "rm -Rf %s", bkpinfo->tmpdir);
      system(tmp);
      unmount_boot_if_necessary();
//      remount_supermounts_if_necessary();
      free_global_stuff();
  free ( bkpinfo );
      finish(retval);
    }
  log_it("FYI, MOUNTLIST_FNAME=%s", MOUNTLIST_FNAME);
  if (argc==3 && strcmp(argv[1], "--monitas-memorex")==0)
    { log_to_screen("Uh, that hasn't been implemented yet."); finish(1); }
  strcpy(bkpinfo->restore_path, "/mnt/RESTORING");
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  retval=load_mountlist(&the_mountlist,MOUNTLIST_FNAME);
  load_raidtab_into_raidlist(&the_raidlist,RAIDTAB_FNAME);
  if (retval) { log_to_screen("Warning - load_raidtab_into_raidlist returned an error"); }
  if (argc==2 && strcmp(argv[1],"--nuke")==0)
    { retval=nuke_mode(bkpinfo,&the_mountlist,&the_raidlist); }
  else if (argc==2 && strcmp(argv[1],"--interactive")==0)
    { retval+=catchall_mode(bkpinfo,&the_mountlist,&the_raidlist); } /* user chooses mode & we go with that */

//    { retval=interactive_mode(bkpinfo,&the_mountlist,&the_raidlist); }

  else if (argc==2 && strcmp(argv[1],"--compare")==0)
    { retval=compare_mode(bkpinfo,&the_mountlist,&the_raidlist); }
  else if (argc==2 && strcmp(argv[1],"--iso")==0)
    { retval=iso_mode(bkpinfo,&the_mountlist,&the_raidlist, FALSE); }
  else if (argc==2 && strcmp(argv[1],"--mbr")==0)
    {
      retval=mount_all_devices(&the_mountlist, TRUE);
      if (!retval)
        {
	  //          protect_against_braindead_sysadmins();
          retval+=run_boot_loader(FALSE);
          retval+=unmount_all_devices(&the_mountlist);
        }
       if (retval)
         {
           log_to_screen("Failed to write Master Boot Record");
        }
    }
  else if (argc==2 && strcmp(argv[1],"--isonuke")==0)
    { retval=iso_mode(bkpinfo,&the_mountlist,&the_raidlist, TRUE); }
  else if (argc!=1)
    {
      log_to_screen("Invalid paremeters");
      finish(1);
    }
  else
    { retval+=catchall_mode(bkpinfo,&the_mountlist,&the_raidlist); } /* user chooses mode & we go with that */

// I_have_just_nuked is set true by nuke_mode() just before it returns
  if ( I_have_just_nuked || does_file_exist("/POST-NUKE-ANYWAY"))
    {
      if (!system("which post-nuke > /dev/null 2> /dev/null"))
        {
          log_it("post-nuke found; running...");
          if (mount_all_devices(&the_mountlist, TRUE))
            {
              log_to_screen("Unable to re-mount partitions for post-nuke stuff");
            }
          else
            {
              log_it("Re-mounted partitions for post-nuke stuff");
              sprintf(tmp, "post-nuke %s %d", bkpinfo->restore_path, retval);
              newtSuspend();
              log_it("Calling '%s'", tmp);
              res=system(tmp);
              newtResume();
//              newtCls();
              log_it("post-nuke returned w/ res=%d", res);
            }
          unmount_all_devices(&the_mountlist);
          log_it("I've finished post-nuking.");
        }
    }

/* clean up at the end */
  if (retval)
    {
      if (c=='C') { mvaddstr_and_log_it(g_currentY++,0,"Run complete. See /tmp/changed.files for list of files that have changed."); }
      else { mvaddstr_and_log_it(g_currentY++,0,"Run complete. Errors were reported. Please review the logfile."); }
    }
  else
    {
      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
        { mvaddstr_and_log_it(g_currentY++,0,"Run complete. Please remove media+floppy and reboot."); }
      else
	{
	  system("sync");
	  if (is_this_device_mounted("/mnt/cdrom")) { res=run_program_and_log_output("umount /mnt/cdrom", FALSE); }
	  else { res=0; }
	  /*	 if (res) { log_to_screen("WARNING - failed to unmount CD-ROM drive"); } */
          if (!bkpinfo->please_dont_eject_when_restoring)
            {
              res=run_program_and_log_output("eject /mnt/cdrom", FALSE);
            }
          if (res) { log_to_screen("WARNING - failed to eject CD-ROM disk"); }
	  mvaddstr_and_log_it(g_currentY++,0,"Run complete. Please remove media and reboot.");
	}
    }
  sprintf(tmp,"Mondo-restore is exiting (retval=%d)                                      ",retval);
  log_to_screen(tmp);
  log_it("END OF LOG");
  unlink("/tmp/mondo-run-prog.tmp");
  set_signals(FALSE);
  sprintf(tmp, "rm -Rf %s", bkpinfo->tmpdir);
  system(tmp);
  log_to_screen("Restore log copied to /tmp/mondo-restore.log on your hard disk");

  free_global_stuff();
  free ( bkpinfo );

  finish(retval);
  exit(retval);
}


/* end of mondo-restore.c */
