/***************************************************************************
                          mondo-archive.c  -  description
                             -------------------
    begin                : Fri Apr 19 16:40:35 EDT 2002
    copyright            : (C) 2002 by Stan Benoit
    email                : troff@nakedsoul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/** change log ******
05/01
- added 'nice(20)' to main()

01/15/2003
- re-run g_erase_tmpdir_and_scratchdir via system() at very end

11/30/2002
- if user goes root with 'su' instead of 'su -' then
  workaround it by setting PATH correctly

11/13
- wipe mondoarchive.log at very beginning

10/04
- cleaned up code

09/10
- if changed.files.N exists then copy to changes.files for display

09/09
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- added popup list of changed files
- removed 'beta-quality' warnings
- if kernel not found and mondo in graphics mode then popup and ask
  for kernel path+filename

August 2002
	fixed tmp[] 'too small' bug
	unmount and eject CD at end of verify cycle
	moved interactively_obtain...() to libmondo-stream.c
	wrote stuff to autodetect tape+cdrw+etc.
	renamed from main.c to mondo-archive.c
July 2002
	added before+after warnings that this code is beta-quality
	abort if running from ramdisk
	remount floppy at end & unmount at start if Mandrake
	took out #debug stuff
	add 2> /dev/null to 'find' command
	add support for bkpinfo->nonbootable_backup
April 2002
	add main function begin comment and debug conditional
        compilation - Stan Benoit
	add debug statements to build a run tree. Stan Benoit
**** end change log **********/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <pthread.h>

#include "../common/config.h"
#include <stdio.h>
#include <stdlib.h>
#include "../common/my-stuff.h"
#include "../common/mondostructures.h"
#include "../common/libmondo.h"
#include "mondo-cli-EXT.h"


extern bool am_I_in_disaster_recovery_mode(void);
extern void set_signals(int);
extern int g_current_media_number;
extern void register_pid(pid_t, char*);
extern int g_currentY;
extern bool g_text_mode;
//extern int g_fd_in, g_fd_out;


extern char g_boot_mountpt[MAX_STR_LEN];
extern bool g_remount_cdrom_at_end, g_remount_floppy_at_end;
bool g_skip_floppies;
long diffs;
//char g_startdir[MAX_STR_LEN];	
char g_mondo_home[MAX_STR_LEN];
pid_t g_main_pid;
//char command[MAX_STR_LEN];
char g_tmpfs_mountpt[MAX_STR_LEN];
char g_erase_tmpdir_and_scratchdir[MAX_STR_LEN];


/*-----------------------------------------------------------*/



int
main (int argc, char *argv[])
{
  struct s_bkpinfo *bkpinfo;
  /** init varaibles **/
  char tmp[MAX_STR_LEN];
  int res,retval;
  char say_at_end[MAX_STR_LEN];	

  /* Make sure I'm root; abort if not */
  if (getuid () != 0)
    {
      fprintf (stderr, "Please run as root.\r\n");
      exit (127);
    }
 
/* Initialize variables */
  res = 0;
  retval = 0;
  diffs = 0;
  say_at_end[0] = '\0';
  unlink(MONDO_LOGFILE);
  if (!(bkpinfo = malloc(sizeof(struct s_bkpinfo)))) { fatal_error("Cannot malloc bkpinfo"); }
  strcpy(tmp, getenv("PATH"));
  strcat(tmp, ":/sbin:/usr/sbin:/usr/local/sbin");
  setenv("PATH", tmp, 1);

/*
  strcpy(tmp, argv[1]);
  center_string(tmp, 40);
  printf("%s --> '%s'\n", argv[1], tmp);
  exit(0);
*/

/* Configure the bkpinfo structure, global file paths, etc. */
  printf ("Initializing...\n");
  unmount_supermounts_if_necessary();
  mount_boot_if_necessary();
  log_it("Unmounting old ramdisks if necessary");
  run_program_and_log_output("umount `mount | grep shm | grep mondo | cut -d' ' -f3`", TRUE);
  log_it ("Mondo Archive v%s --- http://www.mondorescue.com",
	   VERSION);
  if (argc==2 && (!strcmp(argv[argc-1], "-v") || !strcmp(argv[argc-1], "-V") || !strcmp(argv[argc-1], "--version")))
    { printf("mondoarchive v%s\nSee man page for help\n", VERSION); exit(0); }
  printf ("See %s for details of backup run.\n", MONDO_LOGFILE);
  if (pre_param_configuration(bkpinfo)) { fatal_error("Failed to pre-param initialize"); }
  set_signals(TRUE);
  g_main_pid = getpid();
  register_pid(g_main_pid, "mondo");
  nice(20);

/* Process command line, if there is one. If not, ask user for info. */
  if (argc==1)
    {
      g_text_mode = FALSE;
      setup_newt_stuff ();
      res = interactively_obtain_media_parameters_from_user(bkpinfo, TRUE); /* yes, archiving */
    }
  else
    {
      res = handle_incoming_parameters (argc, argv, bkpinfo);
      setup_newt_stuff (); // FIXME: should it do this even if (global) g_text_mode is FALSE?
    }




/* Finish configuring global structures */
  res+=post_param_configuration (bkpinfo);
  if (res)
    {
      fprintf (stderr,
	       "Bad parameters. Type 'man mondoarchive' to see manual. Mondo will now exit.\n");
      finish (res);
    }

  log_it ("Mondo Archive v%s --- http://www.mondorescue.com",
           VERSION);
  sprintf(g_erase_tmpdir_and_scratchdir, "rm -Rf %s %s", bkpinfo->tmpdir, bkpinfo->scratchdir);

  clean_up_KDE_desktop_if_necessary();

/* If we're meant to backup then backup */
  if (bkpinfo->backup_data)
    {
      res = backup_data(bkpinfo);
      retval += res;
      if (res)
	{ strcat (say_at_end, "Data archived. Please check the logs, just as a precaution. "); }
      else
	{ strcat (say_at_end, "Data archived OK. "); }
    }

/* If we're meant to verify then verify */
  if (bkpinfo->verify_data)
    {
      res = verify_data(bkpinfo);
      if (res<0)
        {
          sprintf(tmp, "%d differences found.", -res);
          log_to_screen(tmp);
          res=0;
        }
      retval += res;
    }

/* Offer to write floppy disk images to physical disks */
  if (bkpinfo->backup_data && !g_skip_floppies)
    {
      res = offer_to_write_boot_floppies_to_physical_disks(bkpinfo);
      retval += res;
    }
  if (!retval)
    {
      mvaddstr_and_log_it (g_currentY++, 0,
			   "Backup and/or verify ran to completion. Everything appears to be fine.");
    }
  else
    {
      mvaddstr_and_log_it (g_currentY++, 0,
			 "Backup and/or verify ran to completion. However, errors did occur.");
    }
/*  sleep(3); */

  if (does_file_exist ("/root/images/mindi/mindi.iso"))
    {
      log_to_screen
	("/root/images/mindi/mindi.iso, a boot/utility CD, is available if you want it");
    }
  if (length_of_file ("/tmp/changed.files") > 2)
    {
      if (g_text_mode) { log_to_screen("Type 'less /tmp/changed.files' to see which files don't match the archives"); }
      else
        {
          log_it("Type 'less /tmp/changed.files' to see which files don't match the archives");
          log_it("Calling popup_changelist_from_file()");
          popup_changelist_from_file("/tmp/changed.files");
          log_it("Returned from popup_changelist_from_file()");
        }
    }
  else
    {
      unlink ("/tmp/changed.files");
    }
  log_to_screen (say_at_end);
  sprintf (tmp, "umount %s/tmpfs", bkpinfo->tmpdir);
  run_program_and_log_output (tmp, TRUE);
  run_program_and_log_output (g_erase_tmpdir_and_scratchdir, TRUE);
  if (!g_text_mode)
    {
      popup_and_OK
	("Mondo Archive has finished its run. Please press ENTER to return to the shell prompt.");

      newtFinished ();
      printf ("See %s for details of backup run.\n", MONDO_LOGFILE);
    }

  run_program_and_log_output("rm -f /var/cache/mondo-archive/last-backup.aborted", FALSE);
  set_signals(FALSE);
  if (!retval) { printf("Mondoarchive ran OK.\n"); }
  else { printf("Errors occurred during backup. Please check logfile.\n"); }
  remount_supermounts_if_necessary();
  unmount_boot_if_necessary();
  clean_up_KDE_desktop_if_necessary();
  register_pid(0,"mondo");
  run_program_and_log_output("rm -Rf /tmp.mondo.* /mondo.scratch.*", FALSE);
  system(g_erase_tmpdir_and_scratchdir);
  free((void*)bkpinfo);
  exit (retval);
  return EXIT_SUCCESS;
}
