/* newt-specific.c

  subroutines which do display-type things
  and use the newt library to do them

07/02
- popup_and_get_string() now accepts maxsize as last arg

04/24
- cleaned up a few uninitialized strings (valgrind)

04/22
- line 1176 - 'read from' (instead of 'restore from')

03/15/2003
- fixed potentially infinite loop in log_to_screen (Tom Mortell)

12/04/2002
- changed "Pick file" to "Non-matching files"

11/28
- finish() now unregisters Mondo's pid

10/28
- unmount tmpfs if fatal_error

10/04
- more XMondo-related work
- added some =NULL's in a few places

09/01 - 09/30
- write log_to_screen()'s string to stdout if in text mode
- update_progress_form_FULL(), update_evalcall_form(),
  popup_and_*(), ask_me_yes_or_no() now write
  XMondo-friendly info to stdout if in text mode
- if fatal error then popup and say what the fatal error is
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- added popup_list_from_file(char*source_file, char*topic, void*call_if_entry_selected(void*));

08/07
- added some functions to let user choose backup dev + format

07/27
- created
*/

#include "my-stuff.h"
#include "mondostructures.h"
#include "newt-specific.h"
#include "libmondo-string-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-tools-EXT.h"
#include "libmondo-fork-EXT.h"
#include "libmondo-gui-EXT.h"
#include "lib-common-externs.h"


newtComponent g_progressForm=NULL, g_blurb1=NULL, g_blurb2=NULL, g_blurb3=NULL, g_label=NULL,
  g_timeline=NULL, g_percentline=NULL, g_scale=NULL;
char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN], g_blurb_str_1[MAX_STR_LEN] =
  "", g_blurb_str_2[MAX_STR_LEN] = "", g_blurb_str_3[MAX_STR_LEN] = "";
newtComponent g_isoform_main =
  NULL, g_isoform_header=NULL, g_isoform_scale=NULL, g_isoform_timeline=NULL,
  g_isoform_pcline=NULL;
long g_isoform_starttime;
int g_isoform_old_progress = -1;
char g_isoform_header_str[MAX_STR_LEN];
int g_mysterious_dot_counter;

int g_currentY = 3;		/* purpose */
int g_current_media_number;

long g_maximum_progress = 999;	/* purpose */
long g_current_progress = -999;	/* purpose */
long g_start_time = 0;		/* purpose */
bool g_text_mode = TRUE;
char g_xmondo_stdin[MAX_STR_LEN], g_xmondo_stdout[MAX_STR_LEN];
bool g_called_by_xmondo=FALSE;
//int g_fd_in=-1, g_fd_out=-1;
extern pid_t g_mastermind_pid;
extern char g_tmpfs_mountpt[MAX_STR_LEN];


void get_input_from_xmondo(char*res);



void get_input_from_xmondo(char*res)
{
  FILE*fin;

  system("sync");
  sleep(1);
  fin = fopen(g_xmondo_stdin, "r");
  fgets(res, MAX_STR_LEN, fin);
  fclose(fin);
  strip_spaces(res);
  log_it("Output = '%s'", res);
}




/*************************************************************************
 * ask_me_yes_or_no() -- Hugo Rabson   													         *
 *                                                                       *
 * Purpose:   Prompt user to push the 'yes' or 'no' button in response   *
 *            to a question.                                             *
 * Called by: ...                                                        *
 * Params:    prompt                         string to be displayed      *
 * Returns:   TRUE if user pushes 'yes'; otherwise, FALSE                *
 *************************************************************************/
int
ask_me_yes_or_no (char *prompt)
{

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];
  int i;

  if (g_text_mode)
    {
      while(1)
        {
          system("sync");
          printf ("---promptdialogYN---1--- %s\n---promptdialogYN---Q--- [yes] [no] ---\n--> ", prompt);
          if (g_called_by_xmondo)
            { get_input_from_xmondo(tmp); }
          else
            { fgets(tmp, sizeof(tmp), stdin); }
          i = strlen(tmp);
          if (i>0 && tmp[i-1]<32) { tmp[i-1]='\0'; }
          if (strstr ("yesYES", tmp))
            {
              return (TRUE);
            }
          else if (strstr ("NOno", tmp))
            {
              return (FALSE);
	    }
          else
            {
              system("sync");
              printf("Please enter either YES or NO (or yes or no, or y or n, or...)\n");
            }
        }
    }
  else
    {
      return (popup_with_buttons (prompt, "Yes", "No"));
    }
}


/*************************************************************************
 * ask_me_OK_or_cancel() -- Hugo Rabson													         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:    prompt                         string to be displayed      *
 * Returns:   TRUE if user pushes 'yes'; otherwise, FALSE                *
 *************************************************************************/
int
ask_me_OK_or_cancel (char *prompt)
{

	/** buffer ************************************************************/
  char tmp[MAX_STR_LEN];
  int i;

  if (g_text_mode)
    {
      system("sync");
      printf ("---promptdialogOKC---1--- %s\n---promptdialogOKC---Q--- [OK] [Cancel] ---\n--> ", prompt);
          if (g_called_by_xmondo)
            { get_input_from_xmondo(tmp); }
          else
            { fgets(tmp, sizeof(tmp), stdin); }
      i = strlen(tmp);
      if (i>0 && tmp[i-1]<32) { tmp[i-1]='\0'; }
      if (strstr ("okOKOkYESyes", tmp))
	{
	  return (TRUE);
	}
      else
	{
	  return (FALSE);
	}
    }
  else
    {
      return (popup_with_buttons (prompt, " Okay ", "Cancel"));
    }
}




/*************************************************************************
 * close_evalcall_form() -- Hugo Rabson													         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
close_evalcall_form (void)
{
  if (g_isoform_main == NULL)
    {
      return;
    }
  update_evalcall_form (100);
  usleep (500000);
  if (g_text_mode)
    {
      log_it ("Closing evalcall form");
      return;
    }
  newtPopHelpLine ();
  newtFormDestroy (g_isoform_main);
  newtPopWindow ();
  g_isoform_main = NULL;
  g_isoform_old_progress = -1;
}


/*************************************************************************
 * close_progress_form() -- Hugo Rabson													         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
close_progress_form ()
{
  if (g_current_progress == -999)
    {
      log_it ("Trying to close the progress form when it ain't open!");
      return;
    }
  g_current_progress = g_maximum_progress;
  update_progress_form ("Complete");
  sleep (1);
  if (g_text_mode)
    {
      log_it ("Closing progress form");
      return;
    }
  newtPopHelpLine ();
  newtFormDestroy (g_progressForm);
  newtPopWindow ();
  g_progressForm = NULL;
  g_current_progress = -999;
}





/*************************************************************************
 * fatal_error() -- Hugo Rabson                                          *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
fatal_error (char *error_string)
{
	/** buffers ******************************************************/
  char fatalstr[MAX_STR_LEN] = "-------FATAL ERROR---------";
  char tmp[MAX_STR_LEN];

	/** end vars *****************************************************/

   sprintf(tmp, "umount %s", g_tmpfs_mountpt);
   run_program_and_log_output(tmp, TRUE);
   log_it("---FATALERROR--- %s\n", error_string);

   if (g_mastermind_pid)
    {
      sprintf(tmp, "kill %ld", (long int)g_mastermind_pid);
      system(tmp);
    }

  if (!g_text_mode)
    {
      log_it (fatalstr);
      log_it (error_string);
      //      popup_and_OK (error_string);
      newtFinished ();
    }
  
  printf ("---FATALERROR--- %s\n", error_string);
  if (strstr (error_string, "Mindi"))
    {
      printf ("Last 12 lines of mindi.log:\n");
      system ("tail -n12 /var/log/mindi.log");
    }
  system("cat /var/log/mondo-archive.log | gzip -9 > /tmp/MA.log.gz 2> /dev/null");
  printf("Please contact the mailing list. See http://www.mondorescue.com\n");
  printf("for more information on how to do that.\n");
  printf("Enclose your compressed logfile or we CANNOT HELP.\n");
  printf("Log file: %s\n", MONDO_LOGFILE);
  if (does_file_exist("/tmp/MA.log.gz"))
    { printf("FYI, I have gzipped the log and saved it to /tmp/MA.log.gz\n"); }
  printf ("Mondo has aborted.\n");
  register_pid(0, "mondo");

  exit (1);
}



/*************************************************************************
 * finish() -- Hugo Rabson                                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
finish (int signal)
{
//  char tmp[MAX_STR_LEN];

  /*  if (signal==0) { popup_and_OK("Please press <enter> to quit."); } */

  /* newtPopHelpLine(); */

  register_pid(0, "mondo");
  chdir("/");
  run_program_and_log_output("umount /mnt/cdrom", FALSE);
  if (!g_text_mode)
    {
      newtFinished ();
    }
  /* system("clear"); */
  printf ("Type 'less %s' to see the output log\n", MONDO_LOGFILE);
  exit (signal);
}






/*************************************************************************
 * log_file_end_to_screen() -- Hugo Rabson         							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
log_file_end_to_screen (char *filename, char *grep_for_me)
{

	/** buffers ***********************************************************/
  char command[MAX_STR_LEN + 1];
	char tmp[MAX_STR_LEN + 1];

	/** pointers **********************************************************/
  FILE *fin;

	/** int ***************************************************************/
  int i = 0;



  if (!does_file_exist (filename))
    {
      return;
    }
  if (grep_for_me[0] != '\0')
    {
      sprintf (command, "cat %s | grep \"%s\" | tail -n%d", filename,
	       grep_for_me, NOOF_ERR_LINES);
    }
  else
    {
      sprintf (command, "cat %s | tail -n%d", filename, NOOF_ERR_LINES);
    }
  fin = popen (command, "r");
  if (fin)
    {
      for (i = 0; i < NOOF_ERR_LINES; i++)
	{
	  for (err_log_lines[i][0] = '\0';
	       strlen (err_log_lines[i]) < 2 && !feof (fin);)
	    {
	      fgets (err_log_lines[i], MAX_STR_LEN, fin);
	      strip_spaces (err_log_lines[i]);
	      if (!strncmp (err_log_lines[i], "root:", 5))
		{
		  strcpy (tmp, err_log_lines[i] + 6);
		  strcpy (err_log_lines[i], tmp);
		}
	      if (feof (fin))
		{
		  break;
		}
	    }
	}
      pclose (fin);
    }
  refresh_log_screen ();
}


/*************************************************************************
 * log_to_screen() -- Hugo Rabson                  							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
log_to_screen (char *op)
{

	/** int ***************************************************************/
  int i	= 0;
	int j = 0;

	/** buffers ***********************************************************/
  char output[MAX_STR_LEN];


  strcpy (output, op);
  i = strlen (output);
  if (output[i - 1] < 32)
    {
      output[i - 1] = '\0';
    }
  log_it (output);
  for (i = 1; i < NOOF_ERR_LINES; i++)
    {
      strcpy (err_log_lines[i - 1],
	      "                                                                                ");
      strcpy (err_log_lines[i - 1], err_log_lines[i]);
    }
  output[80] = '\0';
  while (strlen(output)>0 && output[strlen (output) - 1] < 32)
    {
      output[strlen (output) - 1] = '\0';
    }
  for (j = 0; j < strlen (output); j++)
    {
      if (output[j] < 32)
	{
	  output[j] = ' ';
	}
    }
  strcpy (err_log_lines[NOOF_ERR_LINES - 1], output);
  if (g_text_mode)
    {
      printf("%s\n", output);
    }
  else
    {
      refresh_log_screen ();
    }
}



/*************************************************************************
 * mvaddstr_and_log_it() -- Hugo Rabson           							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
mvaddstr_and_log_it (int y, int x, char *output)
{
  log_it (output);
  if (g_text_mode)
    {
      printf ("%s\n", output);
    }
  else
    {
      newtDrawRootText (x, y, output);
      newtRefresh ();
    }
}




/*************************************************************************
 * open_evalcall_form() -- Hugo Rabson            							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
open_evalcall_form (char *ttl)
{

	/** buffers **********************************************************/
  char tmp[MAX_STR_LEN], title[MAX_STR_LEN];

	/** initialize *******************************************************/
  g_isoform_old_progress = -1;
  g_mysterious_dot_counter = 0;


  strcpy (title, ttl);
  strcpy (g_isoform_header_str, title);
  if (g_text_mode)
    {
      log_it (title);
    }
  else
    {
      strcpy(tmp, title);
      center_string(tmp, 80);
      newtPushHelpLine (tmp);
    }
  center_string (g_isoform_header_str, 36);
  g_isoform_starttime = get_time ();
  if (g_text_mode)
    {
      log_it (g_isoform_header_str);
    }
  else
    {
      g_isoform_header = newtLabel (1, 1, g_isoform_header_str);
      g_isoform_scale = newtScale (3, 3, 34, 100);
      newtOpenWindow (20, 6, 40, 7, title);      // "Please Wait");
      g_isoform_main = newtForm (NULL, NULL, 0);
      g_isoform_timeline = newtLabel (1, 5, "This is the timeline");
      g_isoform_pcline = newtLabel (1, 6, "This is the pcline");
      newtFormAddComponents (g_isoform_main, g_isoform_timeline,
			     g_isoform_pcline, g_isoform_header,
			     g_isoform_scale, NULL);
      newtRefresh ();
    }
  update_evalcall_form (0);
}



/*************************************************************************
 * open_progress_form() -- Hugo Rabson            							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
open_progress_form (char *title, char *b1, char *b2, char *b3, long max_val)
{

	/** buffers **********************************************************/
  char b1c[MAX_STR_LEN];
	char blurb1[MAX_STR_LEN];
	char blurb2[MAX_STR_LEN];
	char blurb3[MAX_STR_LEN];

	/** initialize *******************************************************/
  g_mysterious_dot_counter = 0;


  strcpy (blurb1, b1);
  strcpy (blurb2, b2);
  strcpy (blurb3, b3);
  strcpy (b1c, b1);
  center_string (b1c, 80);
  if (max_val <= 0)
    {
      max_val = 1;
    }
  g_start_time = get_time ();
  g_maximum_progress = max_val;
  g_current_progress = 0;
  strcpy (g_blurb_str_1, blurb1);
  strcpy (g_blurb_str_2, blurb2);
  strcpy (g_blurb_str_3, blurb3);
  if (g_text_mode)
    {
      log_it (blurb1);
      log_it (blurb2);
      log_it (blurb3);
    }
  else
    {
      g_blurb1 = newtLabel (2, 1, blurb1);
      g_blurb2 = newtLabel (2, 2, blurb2);
      g_blurb3 = newtLabel (2, 4, blurb3);
      newtOpenWindow (10, 4, 60, 11, title);
      g_scale = newtScale (3, 6, 54, g_maximum_progress);
      g_progressForm = newtForm (NULL, NULL, 0);
      g_percentline = newtLabel (10, 9, "This is the percentline");
      g_timeline = newtLabel (10, 8, "This is the timeline");
      newtFormAddComponents (g_progressForm, g_percentline, g_timeline,
			     g_scale, g_blurb1, g_blurb2, g_blurb3, NULL);
      newtPushHelpLine (b1c);
      newtRefresh ();
    }
  update_progress_form_full (blurb1, blurb2, blurb3);
}






/*************************************************************************
 * popup_and_OK() -- Hugo Rabson                   							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
popup_and_OK (char *prompt)
{

	/** buffers **********************************************************/
  char tmp[MAX_STR_LEN];


  log_it (prompt);
  if (g_text_mode)
    {
      printf
	("---promptpopup---1--- %s\n---promptpopup---Q--- [OK] ---\n--> ", prompt);
          if (g_called_by_xmondo)
            { get_input_from_xmondo(tmp); }
          else
            { fgets(tmp, sizeof(tmp), stdin); }
    }
  else
    {
      popup_with_buttons (prompt, " OK ", "");
    }
}

/*************************************************************************
 * popup_and_get_string() -- Hugo Rabson          							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
bool
popup_and_get_string (char *title, char *b, char *output, int maxsize)
{

	/** newt *************************************************************/
  newtComponent myForm;
	newtComponent b_1;
	newtComponent b_2;
	newtComponent b_res;
	newtComponent text;
	newtComponent type_here;

	/** pointers **********************************************************/
  char *entry_value;

	/** buffers ***********************************************************/
	char blurb[MAX_STR_LEN];
	char original_contents[MAX_STR_LEN];


  if (g_text_mode)
    {
      printf ("---promptstring---1--- %s\n---promptstring---2--- %s\n---promptstring---Q---\n-->  ", title, b);
          if (g_called_by_xmondo)
            { get_input_from_xmondo(output); }
          else
            { fgets(output, maxsize, stdin); }
      return (TRUE);
    }
  strcpy (blurb, b);
  text = newtTextboxReflowed (2, 1, blurb, 48, 5, 5, 0);
  strcpy (original_contents, output);
  output[0] = '\0';
  type_here =
    newtEntry (2, newtTextboxGetNumLines (text) + 2, original_contents, 50,
	       &entry_value, NEWT_FLAG_RETURNEXIT);
  b_1 = newtButton (6, newtTextboxGetNumLines (text) + 4, "  OK  ");
  b_2 = newtButton (18, newtTextboxGetNumLines (text) + 4, "Cancel");
  newtOpenWindow (8, 5, 54, newtTextboxGetNumLines (text) + 9, title);
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, text, type_here, b_1, b_2, NULL);
  center_string (blurb, 80);
  newtPushHelpLine (blurb);
  b_res = newtRunForm (myForm);
  strcpy (output, entry_value);
  newtPopHelpLine ();
  newtFormDestroy (myForm);
  newtPopWindow ();
  if (b_res == b_2)
    {
      strcpy (output, original_contents);
      return (FALSE);
    }
  else
    {
      return (TRUE);
    }
}


/*************************************************************************
 * popup_with_buttons() -- Hugo Rabson            							         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
int
popup_with_buttons (char *p, char *button1, char *button2)
{

	/** buffers ************************************************************/
  char prompt[MAX_STR_LEN];

	/** newt ***************************************************************/
  newtComponent myForm;
	newtComponent b_1;
	newtComponent b_2;
	newtComponent b_res;
	newtComponent text;



  if (g_text_mode)
    {
      fatal_error ("popup_with_buttons doesn't like text mode");
    }
  strcpy (prompt, p);
  text = newtTextboxReflowed (1, 1, prompt, 40, 5, 5, 0);
  b_1 =
    newtButton (20 -
		((button2[0] !=
		  '\0') ? strlen (button1) + 2 : strlen (button1) / 2),
		newtTextboxGetNumLines (text) + 3, button1);
  if (button2[0] != '\0')
    {
      b_2 = newtButton (24, newtTextboxGetNumLines (text) + 3, button2);
    }
  else
    {
      b_2 = NULL;
    }
  newtOpenWindow (25, 5, 46, newtTextboxGetNumLines (text) + 7, "Alert");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, text, b_1, b_2, NULL);
  center_string (prompt, 80);
  newtPushHelpLine (prompt);
  b_res = newtRunForm (myForm);
  newtPopHelpLine ();
  newtFormDestroy (myForm);
  newtPopWindow ();
  if (b_res == b_1)
    {
      return (TRUE);
    }
  else
    {
      return (FALSE);
    }
}





/*************************************************************************
 * refresh_log_screen() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
refresh_log_screen ()
{

	/** int ************************************************************/
  int i = 0;


  if (g_text_mode)
    {
      return;
    }
  for (i = NOOF_ERR_LINES - 1; i >= 0; i--)
    {
      newtDrawRootText (0, i + 23 - NOOF_ERR_LINES,
"                                                                                ");
    }
  newtRefresh ();
  for (i = NOOF_ERR_LINES - 1; i >= 0; i--)
    {
      newtDrawRootText (0, i + 23 - NOOF_ERR_LINES, err_log_lines[i]);
    }
  newtRefresh ();
}



/*************************************************************************
 * setup_newt_stuff() -- Hugo Rabson                                     *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
setup_newt_stuff ()
{

	/** int ************************************************************/
  int i	= 0;

  for (i = 0; i < NOOF_ERR_LINES; i++)
    {
      err_log_lines[i][0] = '\0';
    }
  if (!g_text_mode)
    {
      newtInit ();
      newtCls ();
      newtPushHelpLine
	("Welcome to Mondo Rescue, by Hugo Rabson and the Internet. All rights reversed.");
      /*  newtDrawRootText(28,0,"Welcome to Mondo Rescue"); */
      newtDrawRootText (18, 0, WELCOME_STRING);
      newtRefresh ();
    }
}


/*************************************************************************
 * update_evalcall_form_ratio() -- ?????????                             *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
update_evalcall_form_ratio (int num, int denom)
{

	/** long *************************************************************/
  long current_time = 0;
	long time_taken = 0;
	long time_total_est = 0;
	long time_remaining = 0;

	/** buffers ***********************************************************/
  char timeline_str[MAX_STR_LEN];
	char pcline_str[MAX_STR_LEN];
	char taskprogress[MAX_STR_LEN];

	/** int ***************************************************************/
  int percentage = 0;
	int i = 0;
	int j = 0;


  timeline_str[0]='\0';
  pcline_str[0]='\0';

  

//  log_it("update_eval_call_form called");
  if (num * 100 < denom)
    {
      percentage = 1;
    }
  else
    {
      percentage = (num * 100 + denom / 2) / denom ;
    }
  current_time = get_time ();
  time_taken = current_time - g_isoform_starttime;
  if (num)
    {
      time_total_est = time_taken * denom / num;
      time_remaining = time_total_est - time_taken;
    }
  else
    {
      time_remaining = 0;
    }
  if (!g_text_mode)
    {
      newtLabelSetText (g_isoform_header, g_isoform_header_str);
    }
  g_mysterious_dot_counter = (g_mysterious_dot_counter + 1) % 27;
  if ((percentage < 3 && g_isoform_old_progress < 3)
      || percentage > g_isoform_old_progress)
    {
      g_isoform_old_progress = percentage;
      sprintf (timeline_str,
	       "%2ld:%02ld taken            %2ld:%02ld remaining",
	       time_taken / 60, time_taken % 60, time_remaining / 60,
	       time_remaining % 60);
      if (percentage < 3)
	{
	  sprintf (pcline_str, " Working");
	  for (j = 0; j < g_mysterious_dot_counter; j++)
	    {
	      strcat (pcline_str, ".");
	    }
	  for (; j < 27; j++)
	    {
	      strcat (pcline_str, " ");
	    }
	  sprintf (pcline_str + strlen (pcline_str), " %c",
		   special_dot_char (g_mysterious_dot_counter));
	}
      else
	{
	  sprintf (pcline_str, " %3d%% done              %3d%% to go",
		   percentage, 100 - percentage);
	}
      if (g_text_mode)
	{
	  sprintf (taskprogress, "TASK:  [");
	  for (i = 0; i < percentage; i += 5)
	    {
	      strcat (taskprogress, "*");
	    }
	  for (; i < 100; i += 5)
	    {
	      strcat (taskprogress, ".");
	    }
	  if (percentage >= 3)
	    {
	      sprintf (taskprogress + strlen (taskprogress),
		       "] %3d%% done; %2ld:%02ld to go", percentage,
		       time_remaining / 60, time_remaining % 60);
              printf ("---evalcall---1--- %s\n", g_isoform_header_str);
	      printf ("---evalcall---2--- %s\n", taskprogress);
              printf ("---evalcall---E---\n");
	    }
	}
      else
	{
	  newtScaleSet (g_isoform_scale, percentage);
          assert(g_isoform_pcline!=NULL);
	  newtLabelSetText (g_isoform_pcline, pcline_str);
	  if (percentage >= 3)
	    {
              assert (g_isoform_timeline != NULL);
	      newtLabelSetText (g_isoform_timeline, timeline_str);
	    }
	}
    }
  if (!g_text_mode)
    {
//      log_it("refreshing");
      newtRefresh ();
    }
}




/*************************************************************************
 * update_evalcall_form() -- Hugo Rabson                                 *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
update_evalcall_form (int curr)
{
  update_evalcall_form_ratio (curr, 100);
}



/*************************************************************************
 * update_progress_form() -- Hugo Rabson                                 *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
void
update_progress_form (char *blurb3)
{
  /*  log_it("update_progress_form --- called"); */
  if (g_current_progress == -999)
    {
      /* log_it("You're trying to update progress form when it ain't open. Aww, that's OK. I'll let it go. It's a bit naughty but it's a nonfatal error. No prob, Bob."); */
      return;
    }
  strcpy (g_blurb_str_3, blurb3);
  update_progress_form_full (g_blurb_str_1, g_blurb_str_2, g_blurb_str_3);
}

/*************************************************************************
 * update_progress_form_full() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
update_progress_form_full (char *blurb1, char *blurb2, char *blurb3)
{
	/** long ******************************************************/
  long current_time = 0;
	long time_taken = 0;
	long time_remaining = 0;
	long time_total_est = 0;

	/** int ********************************************************/
  int percentage = 0;
	int i = 0;

	/** buffers ****************************************************/
  char percentline_str[MAX_STR_LEN];
	char timeline_str[MAX_STR_LEN];
	char taskprogress[MAX_STR_LEN];
	char tmp[MAX_STR_LEN];

	//  assert(g_timeline!=NULL);
  percentline_str[0] = '\0';
  current_time = get_time ();
  time_taken = current_time - g_start_time;
  if (g_maximum_progress == 0)
    {
      percentage = 0;
    }
  else
    {
      if (g_current_progress > g_maximum_progress)
	{
	  sprintf (tmp,
		   "update_progress_form_full(%s,%s,%s) --- g_current_progress=%ld; g_maximum_progress=%ld",
		   blurb1, blurb2, blurb3, g_current_progress,
		   g_maximum_progress);
	  log_it (tmp);
	  g_current_progress = g_maximum_progress;
	}
      percentage = (int) ((g_current_progress * 100L) / g_maximum_progress);
    }
  if (percentage < 1)
    {
      percentage = 1;
    }
  if (percentage > 100)
    {
      percentage = 100;
    }
  if (g_current_progress)
    {
      time_total_est = time_taken * (long) g_maximum_progress / (long) (g_current_progress);
      time_remaining = time_total_est - time_taken;
    }
  else
    {
      time_remaining = 0;
    }
  g_mysterious_dot_counter = (g_mysterious_dot_counter + 1) % 27;
  sprintf (timeline_str,
	   "%2ld:%02ld taken               %2ld:%02ld remaining  ",
	   time_taken / 60, time_taken % 60, time_remaining / 60,
	   time_remaining % 60);
  /*
     if (percentage<2)
     {
     log_it("percentage < 2");
     sprintf(percentline_str," Working");
     for(j=0;j<g_mysterious_dot_counter; j++) {strcat(percentline_str,".");}
     for(;j<27;j++) {strcat(percentline_str," ");}
     sprintf(percentline_str+strlen(percentline_str)," %c",special_dot_char(g_mysterious_dot_counter));
     }
     else
     { */
  sprintf (percentline_str, " %3d%% done                 %3d%% to go",
	   percentage, 100 - percentage);
  /* } */
  if (g_text_mode)
    {
      printf("---progress-form---1--- %s\n", blurb1);
      printf("---progress-form---2--- %s\n", blurb2);
      printf("---progress-form---3--- %s\n", blurb3);
      printf("---progress-form---E---\n");
      sprintf (taskprogress, "TASK:  [");
      for (i = 0; i < percentage; i += 5)
	{
	  strcat (taskprogress, "*");
	}
      for (; i < 100; i += 5)
	{
	  strcat (taskprogress, ".");
	}
      if (percentage>100) { log_it("percentage = %d", percentage); }
      sprintf (taskprogress + strlen (taskprogress),
	       "] %3d%c", percentage, '%');
      sprintf (taskprogress + strlen (taskprogress),
		" done; %2ld:%02ld to go",
		time_remaining / 60, time_remaining % 60);
      printf("---progress-form---4--- %s\n", taskprogress);
    }
  else
    {
      center_string (blurb1, 54);
      center_string (blurb2, 54);
      center_string (blurb3, 54);
      newtLabelSetText (g_blurb1, blurb1);
      newtLabelSetText (g_blurb2, blurb2);
      newtLabelSetText (g_blurb3, blurb3);
      newtScaleSet (g_scale, g_current_progress);
      if (percentage >= 2)
	{
	  newtLabelSetText (g_timeline, timeline_str);
	}
      newtLabelSetText (g_percentline, percentline_str);
      newtRefresh ();
    }
}















/*************************************************************************
 * which_backup_media_type() -- Hugo Rabson                              *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
t_bkptype 
which_backup_media_type (bool restoring)
{

	/** char *************************************************************/
	  t_bkptype output;


	/** newt *************************************************************/
  char title_sz[MAX_STR_LEN];
  char minimsg_sz[MAX_STR_LEN];
  newtComponent b1;
	newtComponent b2;
	newtComponent b3;
	newtComponent b4;
	newtComponent b5;
	newtComponent b6;
	newtComponent b7;
	newtComponent b8;
	newtComponent b_res;
	newtComponent myForm;

  newtDrawRootText (18, 0, WELCOME_STRING);
  if (restoring)
    {
      strcpy(title_sz, "Please choose the backup media from which you want to read data.");
      strcpy(minimsg_sz, "Read from:");
    }
  else
    {
      strcpy(title_sz, "Please choose the backup media to which you want to archive data.");
      strcpy(minimsg_sz, "Backup to:");
    }
  newtPushHelpLine (title_sz);
  newtOpenWindow (23, 3, 34, 17, minimsg_sz);
  b1 = newtButton ( 1, 1, "CD-R disks ");
  b2 = newtButton (17, 1, "CD-RW disks");
  b3 = newtButton ( 1, 5, "Tape drive ");
  b4 = newtButton (17, 5, "CD streamer");
  b5 = newtButton ( 1, 9, "Uni'l strmr");
  b6 = newtButton (17, 9, " NFS mount ");
  b7 = newtButton ( 1,13, " Hard disk ");
  b8 = newtButton (17,13, "    Exit   ");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, b1, b3, b5, b7, b2, b4, b6, b8, NULL);
  b_res = newtRunForm (myForm);
  newtFormDestroy (myForm);
  newtPopWindow ();
  if (b_res == b1)      { output = cdr; }
  else if (b_res == b2) { output = cdrw; }
  else if (b_res == b3) { output = tape; }
  else if (b_res == b4) { output = cdstream; }
  else if (b_res == b5) { output = udev; }
  else if (b_res == b6) { output = nfs; }
  else if (b_res == b7) { output = iso; }
  else { output = none; }
  newtPopHelpLine ();
  return (output);
}






/*************************************************************************
 * which_compression_level) -- Hugo Rabson                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
int 
which_compression_level ()
{

	/** char *************************************************************/
	  t_bkptype output;


	/** newt *************************************************************/

  newtComponent b1;
	newtComponent b2;
	newtComponent b3;
	newtComponent b4;
	newtComponent b5;
	newtComponent b_res;
	newtComponent myForm;

  newtDrawRootText (18, 0, WELCOME_STRING);
  newtPushHelpLine
    ("   Please specify the level of compression that you want.");
  newtOpenWindow (23, 3, 34, 13, "How much compression?");
  b1 = newtButton ( 4, 1, "Maximum");
  b2 = newtButton (18, 1, "Average");
  b3 = newtButton ( 4, 5, "Minumum");
  b4 = newtButton (18, 5, " None  ");
  b5 = newtButton ( 4, 9, "         Exit        ");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, b1, b3, b2, b4, b5, NULL);
  b_res = newtRunForm (myForm);
  newtFormDestroy (myForm);
  newtPopWindow ();
  if (b_res == b1)      { output = 9; }
  else if (b_res == b2) { output = 4; }
  else if (b_res == b3) { output = 1; }
  else if (b_res == b4) { output = 0; }
  else if (b_res == b5) { output = -1; }
  newtPopHelpLine ();
  return (output);
}






int load_filelist_into_array(struct s_filelist *filelist, char *source_file)
{
  int i;
  bool done;
  char tmp[MAX_STR_LEN];
  FILE*fin;
  struct s_filelist_entry dummy_fle;

  if (!(fin=fopen(source_file, "r"))) { log_it("Can't open %s; therefore, cannot popup list", source_file); return(1); }
log_it("Loading %s", source_file);
  for(filelist->entries = 0; filelist->entries <= ARBITRARY_MAXIMUM; filelist->entries++)
    {
god_i_hate_gotos:
      if (feof(fin)) { break; }
      fgets(tmp, MAX_STR_LEN, fin);
      i = strlen(tmp);
      if (i<2) { goto god_i_hate_gotos; }
      if (tmp[i-1]<32) { tmp[--i]='\0'; }
      if (i<2) { goto god_i_hate_gotos; }
      if (!does_file_exist(tmp)) { goto god_i_hate_gotos; }
      filelist->el[filelist->entries].severity = severity_of_difference(tmp, NULL);
      strcpy(filelist->el[filelist->entries].filename, tmp);
      if (feof(fin)) { break; }
    }
  fclose(fin);
  if (filelist->entries >= ARBITRARY_MAXIMUM)
    {
      log_to_screen ("Arbitrary limits suck, man!");
      return(1);
    }
  for(done=FALSE;!done;)
    {
      done = TRUE;
      for(i=0; i<filelist->entries-1; i++)
        {
//          if (strcmp(filelist->el[i].filename, filelist->el[i+1].filename) > 0)
          if (filelist->el[i].severity < filelist->el[i+1].severity || (filelist->el[i].severity==filelist->el[i+1].severity && strcmp(filelist->el[i].filename, filelist->el[i+1].filename)>0))
            {
              memcpy((void*)&dummy_fle, (void*)&(filelist->el[i]), sizeof(struct s_filelist_entry));
              memcpy((void*)&(filelist->el[i]), (void*)&(filelist->el[i+1]), sizeof(struct s_filelist_entry));
               memcpy((void*)&(filelist->el[i+1]), (void*)&dummy_fle, sizeof(struct s_filelist_entry));
              log_it("Swapping %s and %s", filelist->el[i].filename, filelist->el[i+1].filename);
              done = FALSE;
            }
        }
    }
  return(0);
}




/*************************************************************************
 * filelist_entry_to_string() -- Hugo Rabson                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:                                                               *
 * Returns:                                                              *
 *************************************************************************/
char*filelist_entry_to_string(struct s_filelist_entry *flentry)
{
  static char comment[MAX_STR_LEN];

  if (flentry->severity==0) { strcpy(comment, "0   "); }
  else if (flentry->severity==1) { strcpy(comment, "low "); }
  else if (flentry->severity==2) { strcpy(comment, "med "); }
  else { strcpy(comment, "high"); }
  strcat(comment, "  ");
  strcat(comment, flentry->filename);
  comment[64] = '\0';
  return(comment);
}




void popup_changelist_from_file(char*source_file)
{
  char reason[MAX_STR_LEN];
  newtComponent myForm;
	newtComponent bClose;
	newtComponent bSelect;
	newtComponent b_res;
	newtComponent fileListbox;
	newtComponent headerMsg;

	/** ???? *************************************************************/
  void *curr_choice;
  void *keylist[ARBITRARY_MAXIMUM];

	/** int **************************************************************/
  int i	= 0;
	int currline = 0;
	int finished = FALSE;

	/** buffers **********************************************************/
	char tmp[MAX_STR_LEN];
	char differ_sz[MAX_STR_LEN];

  struct s_filelist *filelist;

  if (g_text_mode) { log_it("Text mode. Therefore, no popup list."); return; }
  log_it("Examining file %s", source_file);
  i = count_lines_in_file(source_file);
  if (i < 1) { log_it("No lines in file. Therefore, no popup list."); return; }
  else if (i >= ARBITRARY_MAXIMUM) { popup_and_OK("Too many files differ for me to list here."); return; }
  filelist = (struct s_filelist*)malloc(sizeof(struct s_filelist));
  fileListbox =
    newtListbox (2, 2, 12, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
  newtListboxClear (fileListbox);

  if (load_filelist_into_array(filelist, source_file)) { log_it("Can't open %s; therefore, cannot popup list", source_file); return; }
  for(i=0; i<filelist->entries; i++)
    {
      keylist[i] = (void *) i;
      newtListboxAppendEntry (fileListbox, filelist_entry_to_string(&(filelist->el[i])), keylist[i]);
    }
  sprintf(differ_sz, "  %d files differ. Hit 'Select' to pick a file. Hit 'Close' to quit the list.", i);
  newtPushHelpLine(differ_sz);
  bClose = newtCompactButton (10, 15, " Close  ");
  bSelect = newtCompactButton (30, 15, " Select ");
  sprintf (tmp, "%-10s               %-20s", "Priority", "Filename");
  headerMsg = newtLabel (2, 1, tmp);
  newtOpenWindow (5, 4, 70, 16, "Non-matching files");
  myForm = newtForm (NULL, NULL, 0);
  newtFormAddComponents (myForm, headerMsg, fileListbox, bClose, bSelect, NULL);
  while (!finished)
    {
      b_res = newtRunForm (myForm);
      if (b_res == bClose)
	{
          finished = TRUE;
        }
      else
        {
          curr_choice = newtListboxGetCurrent (fileListbox);
	  for (i = 0; i < filelist->entries && keylist[i] != curr_choice;
	       i++);
	  if (i == filelist->entries && filelist->entries > 0)
	    {
	      log_to_screen ("I don't know what that button does!");
	    }
	  else
	    {
	      currline = i;
	      if (filelist->entries > 0)
		    {
			severity_of_difference(filelist->el[currline].filename, reason);
			sprintf(tmp, "%s --- %s", filelist->el[currline].filename, reason);
			popup_and_OK(tmp);
		    }
	    }
	}
    }
  newtFormDestroy (myForm);
  newtPopWindow ();
  newtPopHelpLine ();
}



































