 /***************************************************************************
libmondo-verify.c  -  description
-----------------

begin: Fri Apr 19 16:40:35 EDT 2002
copyright : (C) 2002 Mondo  Hugo Rabson
email	  : Hugo Rabson <hugo@firstlinux.net>
edited by : by Stan Benoit 4/2002
email     : troff@nakedsoul.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* mondo-verify


09/01 - 09/30/2002
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- eject_device() added
- cleaned up 'changed file' feedback a little bit

08/01 - 08/31
- make sure to prefix bkpinfo->restore_path to local biggiefile fname when
  comparing it to the archived copy of biggiefile; otherwise, biggiefile
  not found & checksum missing & so on
- exclude "incheckentry xwait()" from changed.files
- cleaned up some log_it() calls

07/01 - 07/31
- renamed libmondo-verify.c
- say 'bigfile' not 'biggiefile'
- exclude /dev/ * from changed.files

01/01 - 06/30
- remove /tmp/changed.files.* dead files
- don't pclose() tape after calling closein_tape(): the latter does it already
- fixed bug in verify_cd_image()'s CD-mounting code
- don't write to screen "old cksum.. curr cksum.."
- changed the gawks to awks for the benefit of Debian
- handles files >2GB in size
- fixed bug in /tmp/changed.files-generator
- re-enabled a lot of CD-verification code
- afioballs are saved in %s/tmpfs/ now (%s=tmpdir)
- changed some labels to make them more user-friendly
- don't chdir() anywhere before verifying stuff
- changed files are now detected by verify_tape_backup() and listed in
  /tmp/changed.files
- replaced &> with > .. 2>
- still implementing improved tape support


Started late Dec, 2001

-----------------------------------------------------------------------------
*/



#include "my-stuff.h"
#include "mondostructures.h"
#include "libmondo-verify.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-fork-EXT.h"
#include "libmondo-stream-EXT.h"
#include "libmondo-devices-EXT.h"
#include "libmondo-tools-EXT.h"
#include "lib-common-externs.h"




/** initialize *********************************************************/
int g_last_afioball_number = -1;
long last_bigfile_num = -1;
long last_slice_num = -1;



/*************************************************************************
 * generate_list_of_changed_files() -- Hugo Rabson                       *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
long
generate_list_of_changed_files (char *changedfiles_fname,
				char *ignorefiles_fname, char *stderr_fname)
{
	/** buffer ***********************************************************/
  char command[MAX_STR_LEN*2];
	char afio_found_changes[MAX_STR_LEN];

	/** int **************************************************************/
  int res = 0;

	/** long *************************************************************/
  long afio_diffs = 0;


  sprintf (afio_found_changes, "%s.afio", ignorefiles_fname);
  system ("sync");
  sprintf (command,
	   "cat %s | grep \"afio: \" | awk '{j=substr($0,8); i=index(j,\": \");printf \"/%%s\\n\",substr(j,1,i-2);}' | sort | uniq | grep -v \"incheckentry.*xwait\" | grep -vx \"/afio:.*\" | grep -vx \"/dev/.*\" > %s",
	   stderr_fname, afio_found_changes);
  log_it (command);
  res = system (command);
  if (res)
    {
      log_it ("Warning - failed to think");
    }
  exclude_nonexistent_files (afio_found_changes);
  afio_diffs = count_lines_in_file (afio_found_changes);
  sprintf (command,
	   "cat %s %s %s | sort | uniq -c | awk '{ if ($1==\"2\") {print $2;};}' | grep -v \"incheckentry xwait()\" > %s",
	   ignorefiles_fname, afio_found_changes, afio_found_changes,
	   changedfiles_fname);
  log_it (command);
  system (command);
  return (afio_diffs);
}



/*************************************************************************
 * verify_afioballs_on_CD() -- Hugo Rabson                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_afioballs_on_CD (struct s_bkpinfo *bkpinfo, char *mountpoint)
{

	/** buffers **********************************************************/
  char tmp[MAX_STR_LEN];

	/** int **************************************************************/
  int set_number = 0;
	int retval = 0;
	int total_sets = 0;
	int percentage = 0;


  for (set_number = 0;
       set_number < 9999
       &&
       !does_file_exist (vfy_tball_fname (bkpinfo, mountpoint, set_number));
       set_number++);
  if (!does_file_exist (vfy_tball_fname (bkpinfo, mountpoint, set_number)))
    {
      return (0);
    }
  if (g_last_afioball_number != set_number - 1)
    {
      if (set_number==0)
        { log_it("Weird error on line 166 (or so) of libmondo-verify.c but it's really a cosmetic error, nothing more"); }
      else
        {
          retval++;
          sprintf (tmp, "Warning - missing set(s) between %d and %d\n",
    	       g_last_afioball_number, set_number - 1);
          log_to_screen (tmp);
        }
    }
  sprintf (tmp, "Verifying ISO #%d's tarballs", g_current_media_number);
  open_evalcall_form (tmp);
  for (total_sets = set_number;
       does_file_exist (vfy_tball_fname (bkpinfo, mountpoint, total_sets));
       total_sets++);
  for (; does_file_exist (vfy_tball_fname (bkpinfo, mountpoint, set_number));
       set_number++)
    {
      percentage =
	(set_number - g_last_afioball_number) * 100 / (total_sets -
						       g_last_afioball_number);
      update_evalcall_form (percentage);
      retval +=
	verify_an_afioball_from_CD (bkpinfo,
				    vfy_tball_fname (bkpinfo, mountpoint,
						     set_number));
    }
  g_last_afioball_number = set_number - 1;
  close_evalcall_form ();
  return (retval);
}


/*************************************************************************
 * verify_all_slices_on_CD() -- Hugo Rabson                              *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_all_slices_on_CD (struct s_bkpinfo *bkpinfo, char *mtpt)
{

	/** buffer ***********************************************************/
  char tmp[MAX_STR_LEN];
	char mountpoint[MAX_STR_LEN];

	/** long *************************************************************/
  long bigfile_num = 0;
	long slice_num = -1;


  sprintf (tmp, "Verifying ISO#%d's big files", g_current_media_number);
  open_evalcall_form (tmp);
  sprintf (mountpoint, "%s/archives", mtpt);
  if (last_bigfile_num == -1)
    {
      bigfile_num = 0;
      slice_num = 0;
    }
  else if (slice_num == 0)
    {
      bigfile_num = last_bigfile_num + 1;
      slice_num = 0;
    }
  else
    {
      bigfile_num = last_bigfile_num;
      slice_num = last_slice_num + 1;
    }
  while (does_file_exist
	 (slice_fname
	  (bigfile_num, slice_num, mountpoint, bkpinfo->zip_suffix))
	 ||
	 does_file_exist (slice_fname
			  (bigfile_num, slice_num, mountpoint, "")))
    {
      if (slice_num == 0)
	{
	  log_it ("ISO=%d  bigfile=%ld --START--",
		   g_current_media_number, bigfile_num);
	  slice_num++;
	}
      else
	if (does_file_exist
	    (slice_fname (bigfile_num, slice_num, mountpoint, "")))
	{
	  log_it ("ISO=%d  bigfile=%ld ---END---",
		   g_current_media_number, bigfile_num);
	  bigfile_num++;
	  slice_num = 0;
	}
      else
	{
	  log_it ( "ISO=%d  bigfile=%ld  slice=%ld  \r",
		   g_current_media_number, bigfile_num, slice_num);
	  slice_num++;
	}
    }
  last_bigfile_num = bigfile_num;
  last_slice_num = slice_num - 1;
  if (last_slice_num < 0)
    {
      last_bigfile_num--;
    }
  close_evalcall_form ();
  return (0);
}






/*************************************************************************
 * verify_an_afioball() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_an_afioball (struct s_bkpinfo *bkpinfo, char *tarball_fname)
{
	/** buffers **********************************************************/
  char command[MAX_STR_LEN*2];
	char outfile[MAX_STR_LEN];
	char tmp[MAX_STR_LEN];

	/** pointers ********************************************************/
  FILE *pin;

	/** long ************************************************************/
  long diffs = 0;
  /*  getcwd(old_pwd,MAX_STR_LEN-1); */


  log_it ("Verifying fileset '%s'", tarball_fname);
  /*  chdir("/"); */
  sprintf (outfile, "%s/afio.log", bkpinfo->tmpdir);
/* if programmer forgot to say which compression thingy to use then find out */
  if (strstr (tarball_fname, ".lzo") && strcmp (bkpinfo->zip_suffix, "lzo"))
    {
      log_it ("OK, I'm going to start using lzop.");
      strcpy (bkpinfo->zip_exe, "lzop");
      strcpy (bkpinfo->zip_suffix, "lzo");
      bkpinfo->use_lzo = TRUE;
    }
  if (strstr (tarball_fname, ".bz2") && strcmp (bkpinfo->zip_suffix, "bz2"))
    {
      log_it ("OK, I'm going to start using bzip2.");
      strcpy (bkpinfo->zip_exe, "bzip2");
      strcpy (bkpinfo->zip_suffix, "bz2");
      bkpinfo->use_lzo = FALSE;
    }
  sprintf (command, "afio -r -P %s -Z %s > %s 2> /tmp/mondo-verify.err",
	   bkpinfo->zip_exe, tarball_fname, outfile);
  /*  log_it(command); */
  system (command);
  sprintf (command, "cat %s | cut -d':' -f2 | sort | uniq", outfile);
  pin = popen (command, "r");
  if (pin)
    {
      for (fgets (tmp, MAX_STR_LEN, pin); !feof (pin);
	   fgets (tmp, MAX_STR_LEN, pin))
	{
	  if (!diffs)
	    {
	      log_it ("'%s' - differences found", tarball_fname);
	    }
	  diffs++;
	  log_it (strip_afio_output_line (tmp));
	}
      pclose (pin);
    }
  /*  chdir(old_pwd); */
  sprintf (tmp, "cat %s >> %s", "/tmp/mondo-verify.err", MONDO_LOGFILE);
  system (tmp);
  unlink ("/tmp/mondo-verify.err");
  return (0);
}





/*************************************************************************
 * verify_an_afioball_from_CD() -- Hugo Rabson                           *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_an_afioball_from_CD (struct s_bkpinfo *bkpinfo, char *tarball_fname)
{

	/** int **************************************************************/
  int res = 0;

  log_it ("Verifying %s", tarball_fname);
  if (!does_file_exist (tarball_fname))
    {
      fatal_error ("Cannot verify nonexistent afioball");
    }
  res = verify_an_afioball (bkpinfo, tarball_fname);
  return (res);
}


/*************************************************************************
 * verify_an_afioball_from_stream() -- Hugo Rabson                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_an_afioball_from_stream (struct s_bkpinfo *bkpinfo, char *orig_fname,
			      long long size)
{

	/** int ***************************************************************/
  int retval = 0;
	int res = 0;

	/** buffers ***********************************************************/
  char tmp[MAX_STR_LEN];
	char tarball_fname[MAX_STR_LEN];

	/** pointers **********************************************************/
	char  *p;


  p = strrchr (orig_fname, '/');
  if (!p)
    {
      p = orig_fname;
    }
  else
    {
      p++;
    }
  sprintf (tmp, "mkdir -p %s/tmpfs", bkpinfo->tmpdir);
  system (tmp);
  sprintf (tarball_fname, "%s/tmpfs/temporary-%s", bkpinfo->tmpdir, p);
  sprintf (tmp, "Temporarily copying file from tape to '%s'", tarball_fname);
/*  log_it(tmp); */
  read_file_from_stream_to_file (bkpinfo, tarball_fname, size);
  res = verify_an_afioball (bkpinfo, tarball_fname);
  if (res)
    {
      sprintf (tmp, "Afioball '%s' no longer matches your live filesystem",
	       p);
      log_it (tmp);
      retval++;
    }
  unlink (tarball_fname);
  return (retval);
}


/*************************************************************************
 * verify_a_biggiefile_from_stream() -- Hugo Rabson                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_a_biggiefile_from_stream (struct s_bkpinfo *bkpinfo, char *biggie_fname,
			       long long size)
{

	/** int **************************************************************/
  int retval = 0;
	int res = 0;
	int current_slice_number = 0;
  /***********************/
	int ctrl_chr = '\0';     /* hugo why is this a int??  */

  /** char *************************************************************/
	char test_file[MAX_STR_LEN];
	char biggie_cksum[MAX_STR_LEN];
	char orig_cksum[MAX_STR_LEN];
	char tmp[MAX_STR_LEN];
	char slice_fnam[MAX_STR_LEN];
	
	/** pointers *********************************************************/
	char *p;

	/** long long ********************************************************/
  long long slice_siz;

  p = strrchr (biggie_fname, '/');
  if (!p)
    {
      p = biggie_fname;
    }
  else
    {
      p++;
    }
  sprintf (test_file, "%s/temporary-%s", bkpinfo->tmpdir, p);
  sprintf (tmp,
	   "Temporarily copying biggiefile %s's slices from tape to '%s'", p,
	   test_file);
/*  log_it(tmp); */
  for (res = read_header_block_from_stream (&slice_siz, slice_fnam, &ctrl_chr);
       ctrl_chr != BLK_STOP_A_BIGGIE;
       res = read_header_block_from_stream (&slice_siz, slice_fnam, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE)
	{
	  wrong_marker (BLK_START_AN_AFIO_OR_SLICE, ctrl_chr);
	}
      res = read_file_from_stream_to_file (bkpinfo, test_file, slice_siz);
      unlink (test_file);
      res = read_header_block_from_stream (&slice_siz, slice_fnam, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE)
	{
	  log_it ("test_file = %s", test_file);
	  wrong_marker (BLK_STOP_AN_AFIO_OR_SLICE, ctrl_chr);
	}
      current_slice_number++;
      retval += res;
    }
  strcpy (biggie_cksum, slice_fnam);
  if (biggie_cksum[0] != '\0')
    {
      strcpy (orig_cksum, calc_checksum_of_file (biggie_fname));
      if (strcmp (biggie_cksum, orig_cksum))
	{
	  sprintf (tmp, "orig cksum=%s; curr cksum=%s", biggie_cksum,
		   orig_cksum);
	  log_it (tmp);
	  sprintf (tmp, "%s has changed on live filesystem", biggie_fname);
	  log_to_screen (tmp);
	}
    }
  return (retval);
}



/*************************************************************************
 * verify_afioballs_from_stream() -- Hugo Rabson                           *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_afioballs_from_stream (struct s_bkpinfo *bkpinfo)
{
	/** int ***********************************************************/
  int retval = 0;
	int res = 0;
	int current_afioball_number = 0;
	int ctrl_chr = 0;
	int total_afioballs = 0;

	/** buffers ******************************************************/
  char tmp[MAX_STR_LEN];
	char fname[MAX_STR_LEN];

	/** long long ****************************************************/
  long long size = 0;



	log_to_screen ("Verifying regular archives on tape");
  total_afioballs = get_last_filelist_number (bkpinfo) + 1;
  open_progress_form ("Verifying filesystem",
		      "I am verifying archives against your live filesystem now.",
		      "Please wait. This may take a couple of hours.", "",
		      total_afioballs);
  res = read_header_block_from_stream (&size, fname, &ctrl_chr);
  if (ctrl_chr != BLK_START_AFIOBALLS)
    {
      wrong_marker (BLK_START_AFIOBALLS, ctrl_chr);
    }
  for (res = read_header_block_from_stream (&size, fname, &ctrl_chr);
       ctrl_chr != BLK_STOP_AFIOBALLS;
       res = read_header_block_from_stream (&size, fname, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE)
	{
	  wrong_marker (BLK_START_AN_AFIO_OR_SLICE, ctrl_chr);
	}
      sprintf (tmp, "Verifying fileset #%d", current_afioball_number);
      /*log_it(tmp); */
      update_progress_form (tmp);
      res = verify_an_afioball_from_stream (bkpinfo, fname, size);
      if (res)
	{
	  sprintf (tmp, "Afioball %d differs from live filesystem",
		   current_afioball_number);
	  log_to_screen (tmp);
	}
      retval += res;
      current_afioball_number++;
      g_current_progress++;
      res = read_header_block_from_stream (&size, fname, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE)
	{
	  wrong_marker (BLK_STOP_AN_AFIO_OR_SLICE, ctrl_chr);
	}
    }
  log_it ("All done with afioballs");
  close_progress_form ();
  return (retval);
}

/*************************************************************************
 * verify_biggiefiles_from_stream() -- Hugo Rabson                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_biggiefiles_from_stream (struct s_bkpinfo *bkpinfo)
{

	/** int *************************************************************/
  int retval = 0;
	int res = 0;
	int ctrl_chr = 0;

	/** long ************************************************************/
  long noof_biggiefiles = 0;
	long current_biggiefile_number = 0;

	/** buffers *********************************************************/
  char tmp[MAX_STR_LEN];
	char orig_fname[MAX_STR_LEN], logical_fname[MAX_STR_LEN];
	char comment[MAX_STR_LEN];

	/** pointers ********************************************************/
	char *p;

	/** long long size **************************************************/
  long long size = 0;

  sprintf (comment, "Verifying all bigfiles.");
  log_to_screen (comment);
  sprintf (tmp, "%s/biggielist.txt", bkpinfo->tmpdir);
  noof_biggiefiles = count_lines_in_file (tmp);
  res = read_header_block_from_stream (&size, orig_fname, &ctrl_chr);
  if (ctrl_chr != BLK_START_BIGGIEFILES)
    {
      wrong_marker (BLK_START_BIGGIEFILES, ctrl_chr);
    }
  open_progress_form ("Verifying big files", comment,
		      "Please wait. This may take some time.", "",
		      noof_biggiefiles);
  for (res = read_header_block_from_stream (&size, orig_fname, &ctrl_chr);
       ctrl_chr != BLK_STOP_BIGGIEFILES;
       res = read_header_block_from_stream (&size, orig_fname, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_A_BIGGIE)
	{
	  wrong_marker (BLK_START_A_BIGGIE, ctrl_chr);
	}
      p = strrchr (orig_fname, '/');
      if (!p)
	{
	  p = orig_fname;
	}
      else
	{
	  p++;
	}
      sprintf (comment, "Verifying bigfile #%ld (%ld K)",
	       current_biggiefile_number, (long) size >> 10);
      update_progress_form (comment);
      sprintf( logical_fname, "%s/%s", bkpinfo->restore_path, orig_fname);
      res = verify_a_biggiefile_from_stream (bkpinfo, logical_fname, size);
      retval += res;
      current_biggiefile_number++;
      g_current_progress++;
    }
  close_progress_form ();
  return (retval);
}



/*************************************************************************
 * verify_cd_image() -- Hugo Rabson                                      *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_cd_image (struct s_bkpinfo *bkpinfo)
{

	/** int *************************************************************/
  int retval = 0;

	/** buffers *********************************************************/
  char mountpoint[MAX_STR_LEN];
	char command[MAX_STR_LEN*2];
	char tmp[MAX_STR_LEN];
	char fname[MAX_STR_LEN];


  sprintf (mountpoint, "%s/cdrom", bkpinfo->tmpdir);
  sprintf (fname, "%s/%s/%d.iso", bkpinfo->isodir, bkpinfo->nfs_remote_dir,
	   g_current_media_number);

  mkdir (mountpoint, 1777);
  sync ();
  if (!does_file_exist (fname))
    {
      sprintf (tmp,
	       "%s not found; assuming you backed up to CD; verifying CD...",
	       fname);
      log_it (tmp);
      if (bkpinfo->manual_cd_tray)
	{
	  popup_and_OK ("Please push CD tray closed."); 
	}
      if (find_and_mount_actual_cd (bkpinfo, mountpoint))
	{
	  log_to_screen ("failed to mount actual CD");
	  return (1);
	}
    }
  else
    {
      sprintf (tmp, "%s found; verifying ISO...", fname);
      sprintf (command, "mount -o loop,ro -t iso9660 %s %s", fname,
	       mountpoint);
      if (run_program_and_log_output (command, TRUE))
	{
	  sprintf (tmp, "%s failed; unable to mount ISO image\n", command);
	  log_to_screen (tmp);
	  return (1);
	}
    }
  log_it ("OK, I've mounted the ISO/CD (%s)", fname);
  sprintf (tmp, "%s/archives/NOT-THE-LAST", mountpoint);
  if (!does_file_exist (tmp))
    {
      log_it
	("This is the last CD. I am therefore setting bkpinfo->verify_data to FALSE.");
      bkpinfo->verify_data = FALSE;
/*
   (a) It's an easy way to tell the calling subroutine that we've finished &
   there are no more CD's to be verified; (b) It stops the post-backup verifier
   from running after the per-CD verifier has run too.
*/
    }
  verify_afioballs_on_CD (bkpinfo, mountpoint);
  verify_all_slices_on_CD (bkpinfo, mountpoint);
  sprintf (command, "umount %s", mountpoint);
  if (system (command))
    {
      sprintf (tmp, "%s failed; unable to unmount ISO image\n", command);
      log_to_screen (tmp);
      retval++;
    }
  else
    {
      log_it ("OK, I've unmounted the ISO file\n");
    }
  if (!does_file_exist (fname))
    {
      if (eject_device(bkpinfo->media_device))
	{
	  log_it ("Failed to eject CD-ROM drive");
	}
    }
  return (retval);
}



/*************************************************************************
 * verify_tape_backups() -- Hugo Rabson                                  *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
verify_tape_backups (struct s_bkpinfo *bkpinfo)
{

	/** int *************************************************************/
  int retval = 0;

	/** buffers *********************************************************/
  char tmp[MAX_STR_LEN];
  char changed_files_fname[MAX_STR_LEN];

	/** long ************************************************************/
  long diffs = 0;



  log_it ("verify_tape_backups --- starting");
  log_to_screen ("Verifying backups");
  openin_tape (bkpinfo);
/* verify archives themselves */
  retval += verify_afioballs_from_stream (bkpinfo);
  retval += verify_biggiefiles_from_stream (bkpinfo);
/* find the final blocks */
  system ("sync");
  sleep (2);
  closein_tape (bkpinfo);
/* close tape; exit */
//  fclose(g_tape_stream); <-- not needed; is handled by closein_tape()
  system("rm -f /tmp/changed.files.[0-9]* 2> /dev/null");
  sprintf (changed_files_fname, "/tmp/changed.files.%d", (int)(random()%32767));
  sprintf (tmp,
	   "cat %s | grep \"afio: \" | cut -d'\"' -f2 | sort -u | awk '{print \"/\"$0;};' | tr -s '/' '/' | grep -v \"incheckentry.*xwait\" | grep -vx \"/afio:.*\" > %s",
	   MONDO_LOGFILE, changed_files_fname);
  log_it ("Running command to derive list of changed files");
  log_it (tmp);
  if (system (tmp))
    {
      if (does_file_exist(changed_files_fname) && length_of_file(changed_files_fname)>2)
        { log_to_screen("Warning - unable to check logfile to derive list of changed files"); }
      else
        { log_to_screen("No differences found. Therefore, no 'changed.files' text file."); }
    }
  diffs = count_lines_in_file (changed_files_fname);
  if (diffs > 0)
    {
      sprintf (tmp, "cp -f %s %s", changed_files_fname, "/tmp/changed.files");
      run_program_and_log_output(tmp, FALSE);
      sprintf (tmp,
	       "%ld files differed from live filesystem; type less %s or less %s to see",
	       diffs, changed_files_fname, "/tmp/changed.files");
      log_it (tmp);
      log_to_screen ("See /tmp/changed.files for a list of nonmatching files.");
      log_to_screen ("The files probably changed on filesystem, not on backup media.");
      //      retval++;
    }
  return (retval);
}




/*************************************************************************
 * vfy_tball_fname() -- Hugo Rabson                                      *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
char *
vfy_tball_fname (struct s_bkpinfo *bkpinfo, char *mountpoint, int setno)
{
	/** buffers ********************************************************/
  static char output[MAX_STR_LEN];


  sprintf (output, "%s/archives/%d.afio.%s", mountpoint, setno,
	   bkpinfo->zip_suffix);
  return (output);
}






