/* libmondo-tools.c                                  misc tools


05/08
- changed grep -m1 to grep | head -n1 for Debian users

04/24
- reset_bkpinfo() --- reset all media_size[] array

04/22
- post_param_configuration() --- store iso-dev and isodir

04/05
- re-enable tmpfs ramdisk/mountpt _but_ make sure size=100m
- in post_param_configuration(), use cdrecord in preference
  to dvdrecord now

03/27/2003
- disabled tmpfs ramdisk/mountpt

12/10/2002
- added g_loglevel
- fixed minor bug in clean_up_KDE_desktop_if_necessary()
- log versions of newt, slang, ncurses
- isodir defaults to / if disaster recovery

11/01 - 11/30
- unmount all CD devices at start
- added clean_up_KDE_desktop_if_necessary()
- don't use lilo.conf.anaconda; abort instead
- mount/unmount /boot partition for Gentoo 1.2 users
- call mindi --makemountlist as part of testing sanity of distro
- added a couple of chmod 700's (one for scratchdir, one for tmpdir)
  to post_param_configuration()

10/01 - 10/31
- added checking of / and /root's free space to some_basic_sanity_checks()
- moved some subroutines here from common/libmondo-archive

09/01 - 09/30
- don't write log_it()'s string to stdout, even if text mode
- tell user the kernel is bad if it has no ramdisk support but allow
  it if they want to use the failsafe kernel for booting
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- if mkfs.vfat not found but mkfs.msdos found then create a softlink
  from the former to the latter

08/01 - 08/31
- if /etc/lilo.conf not found not /etc/lilo.conf.anaconda found
  then create a softlink from the former to the latter, to work
  around RH7.3's b0rken LILO support
- handle unknown media size

07/27
- created
*/

#include "my-stuff.h"
#include "mondostructures.h"
#include "lib-common-externs.h"
#include "libmondo-tools.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-fork-EXT.h"


extern bool g_text_mode; // true=write text-only; false=gtk/newt/Qt
bool g_remount_cdrom_at_end, g_remount_floppy_at_end;
extern int g_currentY;
extern char g_mondo_home[MAX_STR_LEN];	
extern char g_tmpfs_mountpt[MAX_STR_LEN];
char g_boot_mountpt[MAX_STR_LEN];
extern int g_current_media_number;
extern bool am_I_in_disaster_recovery_mode(void);
int g_loglevel=3;






void clean_up_KDE_desktop_if_necessary(void)
{
  char tmp[MAX_STR_LEN];

  strcpy(tmp, "for i in `find /root /home -type d -name Desktop -maxdepth 2`; do \
file=$i/.directory; if [ -f \"$file\" ] ; then mv -f $file $file.old ; \
cat $file.old | awk '{if (index($0, \"rootimagesmindi\")) { while (length($0)>2) { getline;} ; } \
else { print $0;};}' > $file ; fi ; done");
  run_program_and_log_output(tmp, TRUE);
}



int find_and_store_mondoarchives_home(char *home_sz)
{
  char tmp[MAX_STR_LEN];
 
  strcpy (home_sz,
	  call_program_and_get_last_line_of_output
	  ("find /usr/{local,share} -name mondo -follow -type d -maxdepth 2 2> /dev/null | grep -v \"1\\.[2-9]x\""));

  if (home_sz[0] == '\0')
    {
      strcpy (home_sz,
	      call_program_and_get_last_line_of_output
	      ("find /usr -type d -name mondo -follow -maxdepth 3 | grep -v \"1\\.[2-9]x\""));
    }
  if (home_sz[0] == '\0')
    {
      return(1);
    }
  else
    {
      sprintf (tmp, "%s/restore-scripts", home_sz);
      if (!does_file_exist (tmp))
        {
          home_sz[0] = '\0';
          return(1);
        }
      else
        {
          return(0);
        }
    }
}






/*************************************************************************
 * get_time() -- Hugo Rabson 					         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
long
get_time ()
{

#if 0

	/** pointers *****************************************************/
  FILE *fin;

	/** buffers ******************************************************/
  char incoming[MAX_STR_LEN];

	/** end vars *****************************************************/

  fin = popen ("date +%s", "r");
  fgets (incoming, MAX_STR_LEN - 1, fin);
  pclose (fin);
  return (atol (incoming));
#else
  return time ((void *) 0);
#endif
}








/*************************************************************************
 * initialize_raidrec() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
initialize_raidrec (struct raid_device_record *raidrec)
{
  raidrec->raid_device[0] = '\0';
  raidrec->raid_level = 0;
  raidrec->chunk_size = 4;
  raidrec->persistent_superblock = 1;
  raidrec->data_disks.entries = 0;
  raidrec->spare_disks.entries = 0;
  raidrec->parity_disks.entries = 0;
  raidrec->failed_disks.entries = 0;
  raidrec->additional_vars.entries = 0;
}






void insmod_crucial_modules(void)
{
  system("insmod dos &> /dev/null");
  system("insmod fat &> /dev/null");
  system("insmod vfat &> /dev/null");
}







/*************************************************************************
 * log_it() -- Hugo Rabson                                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
log_it (char *incoming, ...)
{
	/** pointers *****************************************************/
  FILE *fout;

	/** buffers ******************************************************/
  char output[MAX_STR_LEN*4];

	/** int    *******************************************************/
  int i;

	/** end vars ****************************************************/

  va_list ap;

  va_start(ap, incoming);  
  vsprintf(output, incoming, ap);
  i = strlen (output);
  if (i <= 0)
    {
      return;
    }
  if (output[i - 1] < 32)
    {
      output[i - 1] = '\0';
    }
/*
  if (g_text_mode)
    {
      printf ("%s\n", output);
    }
*/

  if (g_loglevel>0)
    {
      fout = fopen (MONDO_LOGFILE, "a");
      if (fout)
	{
	  fprintf (fout, "%s\n", output);
	  fclose (fout);
	}
    }
  va_end(ap);
}





/*************************************************************************
 * log_trace() --Stan Benoit                                             *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
log_trace (char *o)
{
	/** pointers *****************************************************/
  FILE *fout;

	/** buffers ******************************************************/
  char output[MAX_STR_LEN];

	/** int    *******************************************************/
  int i;

	/** end vars ****************************************************/


  if (o[0] == '\0')
    {
      return;
    }
  strcpy (output, o);
  i = strlen (output);
  if (i <= 0)
    {
      return;
    }
  if (output[i - 1] < 32)
    {
      output[i - 1] = '\0';
    }
  if (g_text_mode /* && !strstr(last_line_of_file(MONDO_LOGFILE),output) */ )
    {
      printf ("%s\n", output);
    }

  fout = fopen (MONDO_TRACEFILE, "a");
  if (fout)
    {
      fprintf (fout, "%s\n", output);
      fclose (fout);
    }
}




//void malloc_global_string(char**x)
//{
//  if (!(*x = (char*)malloc(MAX_STR_LEN))) { fatal_error("Unable to malloc"); }
//}





/*************************************************************************
 * post_param_configuration() -- Hugo Rabson                             *
 *                                                                       *
 * Purpose:   Finish configuring the backup record structure, after      *
 *            main() has derived as much information as possible from    *
 *            the command line (or, interactively, from the user).       *
 * Called by: main()                                                     *
 * Params:    bkpinfo                 backup information structure       *
 * Returns:   0=success; nonzero=failure                                 *
 * NB:        Also creates a few important directories...                *
 *************************************************************************/
int post_param_configuration (struct s_bkpinfo *bkpinfo)
{
  char extra_cdrom_params[MAX_STR_LEN];
  char mondo_mkisofs_sz[MAX_STR_LEN];
  char command[MAX_STR_LEN];
  int retval=0;
  char cdr_exe[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];

  bkpinfo->optimal_set_size = (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type)?5:16) * 1024;
  run_program_and_log_output ("cat /proc/cpuinfo", TRUE);
  run_program_and_log_output ("uname -a", TRUE);
  run_program_and_log_output ("cat /etc/*issue*", TRUE);
  run_program_and_log_output ("rpm -q newt newt-devel slang slang-devel ncurses ncurses-devel glibc", TRUE);
  sprintf(g_tmpfs_mountpt, "%s/tmpfs", bkpinfo->tmpdir);
  sprintf(command, "mkdir -p %s", g_tmpfs_mountpt);
  system(command);
  sprintf (command, "mkdir -p %s 2> /dev/null", bkpinfo->isodir);
  system (command);
  sprintf (command, "mkdir -p %s 2> /dev/null", bkpinfo->scratchdir);
  system (command);
  sprintf (command, "mkdir -p %s/tmpfs 2> /dev/null", bkpinfo->tmpdir);
  system (command);


  strcpy(tmp, call_program_and_get_last_line_of_output("free | grep \":\" | tr -s ' ' '\t' | cut -f2 | head -n1"));
  if (atol(tmp) > 459000)
    {
      sprintf(tmp, "mount /dev/shm -t tmpfs %s -o size=200m", g_tmpfs_mountpt);
      if (run_program_and_log_output(tmp, TRUE))
	{
	  g_tmpfs_mountpt[0] = '\0';
	  log_it("Failed to mount tmpfs");
	}
      else
	{
	  log_it("Tmpfs mounted OK");
	}
    }
  else
    {
      g_tmpfs_mountpt[0] = '\0';
    }

  if (bkpinfo->use_lzo)
    {
      strcpy (bkpinfo->zip_exe, "lzop");
      strcpy (bkpinfo->zip_suffix, "lzo");
    }
  else if (bkpinfo->compression_level!=0)
    {
      strcpy (bkpinfo->zip_exe, "bzip2");
      strcpy (bkpinfo->zip_suffix, "bz2");
    }
  else
    {
      bkpinfo->zip_exe[0] = bkpinfo->zip_suffix[0] = '\0';
    }
  if (bkpinfo->backup_media_type == cdrw || bkpinfo->backup_media_type == cdr)
    {
      extra_cdrom_params[0] = '\0';
      if (!bkpinfo->manual_cd_tray)
	{
	  strcat (extra_cdrom_params, "-waiti ");
	}
      if (bkpinfo->backup_media_type == cdrw)
	{
	  strcat (extra_cdrom_params, "blank=fast ");
	}
      if (find_home_of_exe("cdrecord"))
	{ strcpy(cdr_exe, "cdrecord"); }
      else if (find_home_of_exe("dvdrecord"))
	{ strcpy(cdr_exe, "dvdrecord"); }
      else
        { fatal_error("Please install either cdrecord or dvdrecord."); }
      if (bkpinfo->nonbootable_backup)
        { strcpy(mondo_mkisofs_sz, MONDO_MKISOFS_NONBOOT); }
      else if (bkpinfo->make_cd_use_lilo)
        { strcpy(mondo_mkisofs_sz, MONDO_MKISOFS_REGULAR_LILO); }
      else
        { strcpy(mondo_mkisofs_sz, MONDO_MKISOFS_REGULAR_SYSLINUX); }
      if (bkpinfo->manual_cd_tray)
	{
	  sprintf (bkpinfo->call_before_iso,
		   "%s -o %s/temporary.iso . 2>> _ERR_", mondo_mkisofs_sz, bkpinfo->tmpdir);
	  sprintf (bkpinfo->call_make_iso,
		   "%s -eject -v %s fs=4m dev=%s speed=%d %s/temporary.iso",
		   cdr_exe,
		   extra_cdrom_params, bkpinfo->media_device,
		   bkpinfo->cdrw_speed, bkpinfo->tmpdir);
	}
      else
	{
	  sprintf (bkpinfo->call_make_iso,
		   "%s . 2>> _ERR_ | %s -eject %s fs=4m dev=%s speed=%d -",
		   mondo_mkisofs_sz, cdr_exe, extra_cdrom_params, bkpinfo->media_device,
		   bkpinfo->cdrw_speed);
        }
    }
  if (bkpinfo->backup_data && bkpinfo->backup_media_type == tape)
    {
      sprintf (tmp,
	       "dd if=/dev/zero of=%s bs=%ld count=1 2> /dev/null",
	       bkpinfo->media_device, TAPE_BLOCK_SIZE);
      if (system (tmp))
	{
	  retval++;
	  fprintf (stderr,
		   "Cannot write to tape device. Is the tape set read-only?\n");
	}
    }
  if (bkpinfo->backup_media_type == iso)
    {
      log_it("doing ISO customization");
      log_it("isodir = %s", bkpinfo->isodir);
      sprintf(command, "mount | grep -w %s | head -n1 | cut -d' ' -f1", bkpinfo->isodir);
      log_it("command = %s", command);
      log_it("res of it = %s", call_program_and_get_last_line_of_output(command));
      sprintf(tmp, "%s/ISO-DEV", bkpinfo->tmpdir);
      write_one_liner_data_file(tmp, call_program_and_get_last_line_of_output(command));
      sprintf(tmp, "%s/ISODIR", bkpinfo->tmpdir);
      write_one_liner_data_file(tmp, bkpinfo->isodir);
    }

  log_it("Finished processing incoming params");
  if (retval)
    {
      fprintf (stderr, "Type 'man mondoarchive' for help.\n");
    }
  sprintf (tmp, "%s", MONDO_TMPISOS);	/* added #define 22 apr 2002 */
  if (does_file_exist (tmp))
    {
      unlink (tmp);
    }
  if (strlen (bkpinfo->tmpdir) < 2 || strlen (bkpinfo->scratchdir) < 2)
    {
      log_it ("tmpdir or scratchdir are blank/missing");
      retval++;
    }
  if (bkpinfo->include_paths[0] == '\0')
    {
      fatal_error ("Why no backup path?");
    }
  chmod(bkpinfo->scratchdir, 0x700);
  chmod(bkpinfo->tmpdir, 0x700);
  return(retval);
}



/*************************************************************************
 * pre_param_configuration() -- Hugo Rabson                              *
 *                                                                       *
 * Purpose:   Seed the PRNG. Make sure crucial kernel modules are loaded.*
 *            Reset the backup information structure. Check the sanity of*
 *            the user's Linux distribution & filesystem. Delete logfile.*
 * Called by: main()                                                     *
 * Params:    bkpinfo                 backup information structure       *
 * Returns:   0=success; nonzero=failure                                 *
 *************************************************************************/
int pre_param_configuration(struct s_bkpinfo *bkpinfo)
{
  int res=0;

  srandom ((int)(time (NULL)));
  insmod_crucial_modules();
  reset_bkpinfo (bkpinfo); // also sets defaults ('/'=backup path, 3=compression level)
  if (bkpinfo->disaster_recovery)
    { fatal_error("I am in disaster recovery mode\nPlease don't run mondoarchive."); }
  unlink (MONDO_TRACEFILE);
  run_program_and_log_output( "rm -Rf /tmp/changed.files*", FALSE);
  if (find_and_store_mondoarchives_home(g_mondo_home))
    { 
      fprintf (stderr,
 	       "Cannot find Mondo's homedir. I think you have >1 'mondo' directory on your hard disk. Please delete the superfluous 'mondo' directories and try again\n");
      res++;
      return(res);
    }
  res += some_basic_system_sanity_checks ();
  if (res)
    {
      log_it ("Your distribution did not pass Mondo's sanity test.");
    }
  g_current_media_number = 1;
  bkpinfo->postnuke_tarball[0] = bkpinfo->nfs_mount[0] = '\0';
  return(res);
}




/*************************************************************************
 * reset_bkpinfo() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
reset_bkpinfo (struct s_bkpinfo *bkpinfo)
{
  int i;

  memset(bkpinfo, 0, sizeof(struct s_bkpinfo));
  bkpinfo->manual_cd_tray = FALSE;
  bkpinfo->media_device[0] = '\0';
  for(i=0; i<=MAX_NOOF_MEDIA; i++) { bkpinfo->media_size[i] = -1; }
  bkpinfo->boot_loader = '\0';
  bkpinfo->boot_device[0] = '\0';
  bkpinfo->zip_exe[0] = '\0';
  bkpinfo->zip_suffix[0] = '\0';
  bkpinfo->restore_path[0] = '\0';
  bkpinfo->use_lzo = FALSE;
  bkpinfo->do_not_compress_these[0] = '\0';
  bkpinfo->verify_data = FALSE;
  bkpinfo->backup_data = FALSE;
  bkpinfo->restore_data = FALSE;
  bkpinfo->disaster_recovery = FALSE;
  if (am_I_in_disaster_recovery_mode()) { strcpy(bkpinfo->isodir, "/"); }
  else { strcpy (bkpinfo->isodir, "/root/images/mondo"); }
  bkpinfo->scratchdir[0] = '\0';
  bkpinfo->tmpdir[0] = '\0';
  bkpinfo->optimal_set_size = 0;
  bkpinfo->backup_media_type = none;
  bkpinfo->include_paths[0] = '\0';
  bkpinfo->exclude_paths[0] = '\0';
  bkpinfo->call_before_iso[0] = '\0';
  bkpinfo->call_make_iso[0] = '\0';
  bkpinfo->call_burn_iso[0] = '\0';
  bkpinfo->call_after_iso[0] = '\0';
  bkpinfo->image_devs[0] = '\0';
  bkpinfo->postnuke_tarball[0] = '\0';
  bkpinfo->kernel_path[0] = '\0';
  bkpinfo->nfs_mount[0] = '\0';
  bkpinfo->nfs_remote_dir[0] = '\0';
  bkpinfo->wipe_media_first = FALSE;
  bkpinfo->differential = FALSE;
  bkpinfo->cdrw_speed = 0;
  strcpy (bkpinfo->include_paths, "/");
  bkpinfo->compression_level = 3;
  bkpinfo->disaster_recovery = am_I_in_disaster_recovery_mode();
}




long free_space_on_given_partition(char*partition)
{
  char command[MAX_STR_LEN], out_sz[MAX_STR_LEN];
  long res;

  sprintf(command, "df -m %s &> /dev/null", partition);
  if (system(command))
    { return(-1); } // partition does not exist
  sprintf(command, "df -m %s | tail -n1 | tr -s ' ' '\t' | cut -f4", partition);
  strcpy(out_sz, call_program_and_get_last_line_of_output(command));
  if (strlen(out_sz)==0)
    { return(-1); } // error within df, probably
  res = atol(out_sz);
  return(res);
}




/*************************************************************************
 * some_basic_system_sanity_checks() -- Hugo Rabson                      *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
some_basic_system_sanity_checks ()
{

	/** buffers *************/
  char tmp[MAX_STR_LEN];
  //  char command[MAX_STR_LEN];

	/** int's ****************/
  int retval = 0;
  long Lres;


  mvaddstr_and_log_it (g_currentY, 0,
		       "Checking sanity of your Linux distribution");
  if (system("which mkfs.vfat &> /dev/null") && !system("which mkfs.msdos &> /dev/null"))
    {
      log_it("OK, you've got mkfs.msdos but not mkfs.vfat; time for the fairy to wave her magic wand...");
      run_program_and_log_output("ln -sf `which mkfs.msdos` /sbin/mkfs.vfat", FALSE);
    }
  strcpy (tmp,
	  call_program_and_get_last_line_of_output
	  ("free | grep Mem | head -n1 | tr -s ' ' '\t' | cut -f2"));
  if (atol (tmp) < 35000)
    {
      retval++;
      log_to_screen ("You must have at least 32MB of RAM to use Mondo.");
    }
  if (atol (tmp) < 66000)
    {
      log_to_screen
	("WARNING! You have very little RAM. Please upgrade to 64MB or more.");
    }
  if ((Lres = free_space_on_given_partition("/root"))==-1)
    { Lres = free_space_on_given_partition("/"); }
  log_it("Free space on given partition = %ld MB", Lres);
  if (Lres < 50)
    { fatal_error("Your / (or /root) partition has <50MB free. Please adjust your partition table to something saner."); } 
  if (system ("mke2fs -V > /dev/null 2> /dev/null"))
    {
      retval++;
      log_to_screen
	("Unable to find mke2fs in system path.");
      fatal_error
        ("Please use \"su -\", not \"su\" to become root. OK? ...and please don't e-mail the mailing list or me about this. Just read the message. :)");
    }
  if (run_program_and_log_output ("cat /proc/devices | grep ramdisk", FALSE))
    {
      if (!ask_me_yes_or_no("Your kernel has no ramdisk support. That's mind-numbingly stupid but I'll allow it if you're planning to use a failsafe kernel. Are you?"))
        {
          retval++;
          log_to_screen
            ("Please recompile your kernel to include ramdisk support.");
        }
    }
  retval += whine_if_not_found ("mke2fs");
  retval += whine_if_not_found ("afio");
//  retval += whine_if_not_found ("buffer");
  retval += whine_if_not_found ("mkisofs");
  if (system("which dvdrecord > /dev/null 2> /dev/null")) { retval += whine_if_not_found ("cdrecord"); }
  retval += whine_if_not_found ("bzip2");
  retval += whine_if_not_found ("awk");
  retval += whine_if_not_found ("md5sum");
  retval += whine_if_not_found ("strings");
  retval += whine_if_not_found ("mindi");
  run_program_and_log_output("umount `mount | grep cdr | cut -d' ' -f3 | tr '\n' ' '`", TRUE);
  strcpy (tmp,
	  call_program_and_get_last_line_of_output
	  ("mount | grep \"cdr[om|w]\""));
  if (strcmp ("", tmp))
    {
      retval++;
      fatal_error ("Your CD-ROM drive is mounted. Please unmount it.");
    }
  if (!does_file_exist ("/etc/modules.conf"))
    {
      retval++;
      log_to_screen ("Please find out what happened to /etc/modules.conf");
    }
/* 
[ "`bzip2 -V | grep Version | tr -s '#' '|' | sed s/Version/#/ | cut -d'#' -f2 | sed s/,/' '/ | cut -d' ' -f2 | grep -x "0\.[8-9][0-9].*"`"
` ] && FatalError "Your bzip2 is woefully out of date (ver=$bzip_ver)" 
*/

      /*
  if (!does_file_exist("/etc/lilo.conf") && does_file_exist("/etc/lilo.conf.anaconda"))
    {
      run_program_and_log_output("ln -sf /etc/lilo.conf.anaconda /etc/lilo.conf", FALSE);
      log_to_screen("Your Linux distribution is in breach of the de facto standard of saving");
      log_to_screen("LILO's configuration file as /etc/lilo.conf; I have fixed the problem by");
      log_to_screen("creating a softlink, '/etc/lilo.conf' to point to the real config file.");
    }
      */
  run_program_and_log_output("cat /etc/fstab", TRUE);
  run_program_and_log_output("cat /etc/raidtab", TRUE);
  if (run_program_and_log_output("mindi --makemountlist /tmp/mountlist.txt.test", TRUE))
    {
      log_to_screen("Mindi --makemountlist failed for some reason. Bad fstab file?");
      retval++;
    }

  if (retval)
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Failed.");
    }
  else
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Done.");
    }
  return (retval);
}









/*************************************************************************
 * read_cfg_var() -- Hugo Rabson                                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
read_cfg_var (char *config_file, char *label, char *value)
{
	/** buffer *******************************************************/
  char command[MAX_STR_LEN*2];
  char tmp[MAX_STR_LEN];

	/** end vars ****************************************************/
  if (!does_file_exist (config_file))
    {
      sprintf (tmp, "(read_cfg_var) Cannot find %s config file", config_file);
      log_to_screen (tmp);
      value[0] = '\0';
      return (1);
    }
  else
    {
      sprintf (command, "cat %s | grep \"%s .*\" | cut -d' ' -f2,3,4,5",
	       config_file, label);
      strcpy (value, call_program_and_get_last_line_of_output (command));
      if (strlen (value) == 0)
	{
	  return (1);
	}
      else
	{
	  return (0);
	}
    }
}




void remount_supermounts_if_necessary()
{
  if (g_remount_cdrom_at_end)
    {
      run_program_and_log_output ("mount /mnt/cdrom", FALSE);
    }
  if (g_remount_floppy_at_end)
    {
      run_program_and_log_output ("mount /mnt/floppy", FALSE);
    }
}







void unmount_supermounts_if_necessary()
{
  if (run_program_and_log_output ("mount | grep cdrom | grep super", FALSE) == 0)
    {
      g_remount_cdrom_at_end = TRUE;
      run_program_and_log_output ("umount /mnt/cdrom", FALSE);
    }
  if (run_program_and_log_output ("mount | grep floppy | grep super", FALSE) == 0)
    {
      g_remount_floppy_at_end = TRUE;
      run_program_and_log_output ("umount /mnt/floppy", FALSE);
    }
}





void mount_boot_if_necessary()
{
  char tmp[MAX_STR_LEN];
  char command[MAX_STR_LEN];

  g_boot_mountpt[0] = '\0';
  strcpy(tmp, call_program_and_get_last_line_of_output("cat /etc/fstab | grep -vx \"#.*\" | grep -w  \"/boot\" | tr -s ' ' '\t' | cut -f1"));
  if (tmp[0])
    {
      log_it("/boot is at %s according to /etc/fstab", tmp);
      if (strstr(tmp, "LABEL="))
        { log_it("...ignored cos it's a label :-)"); }
      else
        {
          sprintf(command, "mount | grep -w \"%s\"", tmp);
          if (run_program_and_log_output(command, TRUE))
            {
	      strcpy(g_boot_mountpt, tmp);
              sprintf(tmp, "%s (your /boot partition) is not mounted. I'll mount it before backing up", g_boot_mountpt);
	      log_it(tmp);
	      sprintf(tmp, "mount %s", g_boot_mountpt);
	      if (run_program_and_log_output(tmp, TRUE))
		{ fatal_error("Unable to mount /boot for backup purposes"); }
            }
        }
    }
}



void unmount_boot_if_necessary()
{
  char tmp[MAX_STR_LEN];

  if (g_boot_mountpt[0])
    {
      sprintf(tmp, "umount %s", g_boot_mountpt);
      if (run_program_and_log_output(tmp, TRUE))
	{ log_it("WARNING - unable to unmount /boot"); }
    }
}




/*************************************************************************
 * write_cfg_var() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
write_cfg_var (char *config_file, char *label, char *value)
{
	/** buffers ******************************************************/
  char command[MAX_STR_LEN*2];
  char tempfile[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];


	/** end vars ****************************************************/
  if (!does_file_exist (config_file))
    {
      sprintf (tmp, "(write_cfg_file) Cannot find %s config file",
	       config_file);
      log_to_screen (tmp);
      return(1);
    }
  strcpy (tempfile,
	  call_program_and_get_last_line_of_output
	  ("mktemp -q /tmp/mojo-jojo.blah.XXXXXX"));
  if (does_file_exist (config_file))
    {
      sprintf (command, "cat %s | grep -vx \"%s .*\" > %s", config_file,
	       label, tempfile);
      system (command);
    }
  sprintf (command, "echo \"%s %s\" >> %s", label, value, tempfile);
  system (command);
  sprintf (command, "mv -f %s %s", tempfile, config_file);
  system (command);
  unlink (tempfile);
  return (0);
}

