%define _prefix /usr/local

Summary:	A program which a Linux user can utilize to create a rescue/restore CD/tape.
Summary(fr):	Un programme pour les utilisateurs de Linux pour cr�r un CD/tape de sauvegarde/restauration
Summary(it):	Un programma per utenti Linux per creare un CD/tape di rescue
Name:		mondo
Version:        1.66
Release:	1
License:	GPL
Group:		Applications/Archiving
Url:		http://www.mondorescue.org
Source:		%{name}-%{version}.tgz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
Requires:	mindi >= 0.80, mindi < 0.90, bzip2 >= 0.9, afio, mkisofs, binutils, syslinux >= 1.52, newt >= 0.50, slang >= 1.4.2
BuildRequires:	newt-devel >= 0.50, slang-devel >= 1.4.2, ncurses-devel >= 5.1-2
Prefix:		/usr/local
Autoreq:	0

%description
Objective
"""""""""
To produce a program which any Red Hat/Mandrake user can utilize to create
a rescue/restore CD (or CDs, if their installation is >2Gb approx.). Also
works for tapes and NFS.

%description -l fr
Objectif
""""""""
Mondo a pour but de fournir un programme utilisable par n'importe quel
utilsateur de RedHat/Mandrake pour cr�r un CD de sauvegarde/restauration
(ou plusieurs CDs, si son installation d�asse les 2Go environ). Cela
functionne avec des systemes d'entrainement de bande magnetique, et NFS,
aussi.

%description -l it
Scopo
"""""
Mondo e' un programma che permette a qualsiasi utente RedHat/Mandrake 
di creare un cd di rescue/restore (o piu' cd qualora l'installazione 
dovesse occupare piu' di 2Gb circa). Funziona con gli azionamenti di
nastro, ed il NFS, anche.

%prep
%{__rm} -rf $RPM_BUILD_ROOT

%setup -q

%configure

%build
%{__make} clean
%{__make} VERSION=%{version}

%install
%{__mkdir} -p $RPM_BUILD_ROOT%{_datadir}/mondo
%{__mkdir} -p $RPM_BUILD_ROOT%{_bindir}
%{__mkdir} -p $RPM_BUILD_ROOT%{_mandir}/man1
for fname in mondoarchive mondorestore mondo/mondo-makefilelist ; do
    %{__install} -m 755 $fname $RPM_BUILD_ROOT%{_bindir}
    %{__install} -m 755 $fname $RPM_BUILD_ROOT%{_datadir}/mondo
done

%{__mkdir} -p $RPM_BUILD_ROOT/usr/share/man/man1
%{__install} -m 755 mondo/do-not-compress-these       $RPM_BUILD_ROOT%{_datadir}/mondo
%{__install} -m 755 mondo/autorun                     $RPM_BUILD_ROOT%{_datadir}/mondo
%{__install} -m 755 mondo/mondoarchive/mondoarchive.1 $RPM_BUILD_ROOT/usr/share/man/man1
%{__cp} -Rf mondo/restore-scripts  $RPM_BUILD_ROOT%{_datadir}/mondo
%{__cp} -Rf mondo/post-nuke.sample $RPM_BUILD_ROOT%{_datadir}/mondo
#%{__install} -d -m 755 mondo/restore-scripts             $RPM_BUILD_ROOT%{_datadir}/mondo/restore-scripts
#%{__install} -d -m 755 mondo/post-nuke.sample            $RPM_BUILD_ROOT%{_datadir}/mondo/post-nuke.sample

# Make a link
cd $RPM_BUILD_ROOT%{_bindir}
%{__ln_s} -f %{_datadir}/mondo/mondoarchive .
%{__ln_s} -f %{_datadir}/mondo/mondorestore .
%{__ln_s} -f %{_datadir}/mondo/mondo-makefilelist .

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc ChangeLog mondoarchive.1* mondo/docs/en/*
%dir %{_datadir}/mondo
%{_bindir}/mondorestore
%{_bindir}/mondoarchive
%{_bindir}/mondo-makefilelist
%{_datadir}/mondo/mondorestore
%{_datadir}/mondo/post-nuke.sample/*
%{_datadir}/mondo/restore-scripts/*
%{_datadir}/mondo/do-not-compress-these
%{_datadir}/mondo/mondoarchive
%{_datadir}/mondo/autorun
%{_datadir}/mondo/mondo-makefilelist
#%{_mandir}/man1/mondoarchive.1*
/usr/share/man/man1/mondoarchive.1*

%changelog
* Thu Aug 28 2003 Anonymous <root@vanillaice> 1.66
- line 451, 4458 of call_mindi_to_supply_boot_disks() --
  was ignoring user-specified boot loader --- FIXED
- fixed bug in extract_config_file_from_ramdisk() which
  affected tape+floppy users
- unmount CD-ROM before burning (necessary for RH8/9)
- fixed bug in grub-MR (Christian)
- make user remove CD/floppy before restoring interactively from tape
- fixed bug in am_I_in_disaster_recovery_mode()
- make sure NFS (backup) share is mounted in Nuke Mode

* Thu Jul 24 2003 Hugo Rabson <hugorabson@msn.com> 1.66
- fixed 'default boot loader' detection bug (Joshua Oreman)
- fixed mondoarchive -Vi multi-CD verify bug (Tom Mortell)
- commented out call to interrogate_..._cdrw_...()
- fixed RAID-related bug in where_is_root_mounted()
- ISO tweaks
- fixed silly bug in load_filelist() which stopped
  funny German filenames from being handled properly
- added rudimentary support for SME

* Sun May 18 2003 Hugo Rabson <hugorabson@msn.com> 1.65
- resolve boot device (-f) if softlink
- fix iso support
- post_param_configuration() --- store iso-dev and isodir
- added post-nuke-sample.tgz to package
- ran thru Valgrind & fixed some minor memory leaks
- improved which_boot_loader()
- when burning or comparing to a CD, defeat autorun if it is
  running, to avoid confusing mondoarchive and the user
- modified Makefile to build restore-scripts.tgz and
  post-nuke-sample.tgz from scratch instead of storing
  tarballs within mondo-1.xx.tgz tarball
- when booting, type 'nuke noresize' to nuke w/o resizing
  mountlist to fill your drives
- run nice(20) to prioritize mondoarchive at start
- scan next CD before writing to it, in case user forgot
  to remove previously toasted CD
- fixed support for subdir-within-NFS-mount
- fixed "Can't backup if ramdisk not mounted" bug

* Wed Apr 09 2003 Hugo Rabson <hugorabson@msn.com> 1.64
- cleaned up find_cdrom_device()
- fixed insist_on_this_cd_number()
- fixed NFS live restore
- fixed am_i_in_disaster_recovery_mode()
- only ask for NFS mount dir once at boot-time
- fixed post-nuke support
- at restore-time, only sort mountlist internally, 
  in mount_all_devices() and unmount_all_devices() 
- fixed cosmetic bug in label-partitions-as-necessary
- fixed fstab-hacking scripts

* Sun Mar 23 2003 Hugo Rabson <hugorabson@msn.com> 1.63
- make-me-bootable fix (Juraj Ziegler)
- afio uses 4MB buffer instead of 16MB when restoring
- commented out sort_... call (BB) re: LVM/RAID
- fixed problem w/ multi-ISO verify cycle (Tom Mortell)
- removed duplicate entry from makefile
- if root is /dev/root then assume not a ramdisk
- fixed potentially infinite loop in log_to_screen (Tom Mortell)
- reject relative paths if -d flag (Alessandro Polverini)

* Wed Feb 12 2003 Hugo Rabson <hugorabson@msn.com> 1.62
- mount_cdrom() better at handling multiple CD drives
- exclude /media/cdrecorder,cdrom,floppy from backup
- sensibly_set_tmpdir_and_scratchdir() --- exclude smb and smbfs
- better location for manpage
- adjusted block size of tarball at start of tape, to help
  users w/ broken tape driver firmware
- sort -u fstab after modifying it
- if backup type is nfs then don't estimate noof media
- fixed Makefile (Mikael Hultgren)
- updated manpage
- fixed read_cfg_file_into_bkpinfo()'s setting of ISO size (Troff)
- cleaned up 'where are the ISOs?' question (Troff)
- added -e (do not eject when restoring) flag
- LVM-on-RAID patch (Brian Borgeson)

* Mon Dec 16 2002 Hugo Rabson <hugo@firstlinux.net> 1.61
- log newt, slang, ncurses info
- updated man page
- handle %% chars in issue.net properly (Heiko Schlittermann)
- fixed serious NFS restore bug
- cleaned up spec file; it should cause fewer problems now (Jesse Keating)
- changed various strcpy() calls to strncpy() calls
- added mondo-makefilelist to makefile (Mikael Hultgren)

* Mon Dec 02 2002 Hugo Rabson <hugo@firstlinux.net> 1.60
- new stable branch opened
- fixed bug in multithreading
- use new grub-MR instead of grub-install
- wipe only the partition table (not the MBR) when partitioning drives
- ignore lilo.conf.anaconda when looking for lilo.conf file
- accepts '-l RAW' to backup/restore original boot sector instead
  of running grub or lilo to init it after restoring
- fixed&updated stabgrub-me script; software RAID + GRUB work now
- mount/unmount /boot partition for Gentoo 1.2 users
- re-enabled extra tape checksums
- disabled spurious warnings
- unmount/remount supermounts at start/end of live restore, if nec.
- cleaned up mondo's tape block handling (now, TAPE_BLOCK_SIZE=128K
  and I've added INTERNAL_TAPE_BLK_SIZE=32K variable for buffering)
- added Makefile
- added -l RAW, to backup and restore original MBR
- cleaned up iso_mode() and nfs restoring
- create /mnt/RESTORING/mnt/.boot.d for Gentoo users
- made mondorestore CD bootable for ArkLinux users
- if user runs as 'su' not 'su -' then work around

* Sun Nov 17 2002 Hugo Rabson <hugo@firstlinux.net> 1.51
- pop-up list of changed files, at end of verification phase
- better handling of changed.files list at restore-time
- lots of CD-related fixes
- added '-N' flag --- to let user exclude all NFS-related mounts&devices
- better handling of 'kill'
- restructuring of code to ease integration of mondo w/XMondo
- fixed obscure bug in find_and_mount_actual_cd()
- if / or /root has <50MB free then abort & complain
- fixed install.sh
- fixed .spec file
- updated documentation
- commented code
- updated man page
- added -v / --version flag
- replace convoluted grep with wc (KP)
- fixed bug affecting restoration of bigfiles from CD's created w/0 compression
- fixed BurnProof-related bug
- better at figuring out which is the best partition for temp/scratchdir
- added do-not-compress-these (text file) to RPM
- do not compress files of types listed in do-not-compress-these
- dropped -U from call to afio - saves 20-30% runtime (Cosgrove)
- added Cosgrove's do-not-compress-these list
- included various patches from KP
- chmod tmpdir, scratchdir to 700 before using
- restore from specified backup device, even if its own cfg file disagrees
- fixed multi-tape bug
- fixed "Can't find first ISO when verifying nonbootable ISO" bug
- multithreaded make_afioballs_and_images()
- tmpdir and scratchdir are set sensibly whether mondoarchive is called with
  command-line parameters or not
- fixed bug in strip_spaces() which stopped it from handling
  small strings correctly - affected mountlist editor
- create a repaired copy of grub-install which is RAID-friendly;
  use it when initializing boot sector with run_grub()
- fixed bug in mondo-makefilelist

* Sun Sep 08 2002 Hugo Rabson <hugo@firstlinux.net> 1.50
- if restoring, don't try to find SCSI node of CD-ROM drive; find /dev entry
- during selective restore, skip filesets which don't contain relevant archives
- set /dev/null's perms to 777, just in case devfs-enabled kernel mangles it
- remove /var/run/*.pid after restoring
- move spurious lockfiles from /home/* to /home/*/.disabled
- ask user to confirm the tape/CD device name
- lots of multitape-related fixes
- added code to autodetect the hardware of the user, if possible
- if isodir does not exist then abort
- more sanity-checking for -d flag
- doubled 'biggiefile' threshold... to 32MB
- exclude /root/images/mindi
- fixed multi-imagedev bug (Emmanuel Druon)
- unmount/remount /mnt/floppy before/after backing up, if Mandrake
- restructured the source files
- fixed serious bug in line 1546 - should have been !=, not ==; stopped
  mondorestore from correctly restoring big files
- added '#include <signal.h>' to my-stuff.h
- exclude "incheckentry xwait()" from changed.files
- fixed minor bug in find_cdrom_device()
- fixed bug in friendly_sizestr...
- insist on tape #1 when start verifying
- added internal buffering, replacing the external 'buffer' exe
- if differential backup then don't permit formatting or fdisking,
  whether Interactive or Nuke mode
- if mondorestore is run on live filesystem (or from ramdisk) without
  parameters then mondorestore will ask which backup media (tape, CD, etc.)
  was used; it will read the config file from the media and proceed from there
- if tape streamer is softlink then resolve it first
- incorporate post-nuke tarball
- if user doesn't specify tape size, proceed anyway; behave intelligently
  in the event of end-of-tape
- prefix bkpinfo->restore_path to biggiefile fname before generating
  checksum & comparing to archived biggiefile
- if /etc/lilo.conf not found not /etc/lilo.conf.anaconda found
  then create a softlink from the former to the latter, to work
  around RH7.3's b0rken LILO support
- LFS support (mharris, michele, hugo)
- fixed verify bug --- CD#1 was being verified again & again & ...
- differential mode fixed; supported again
- ask user for boot loader + device if not detectible
- list up to 512 files in file selection window at once (was 128)
- better handling of bigfiles' checksums, perms and owns
- delete final filelist if <=2 bytes long
- if kernel not found and mondo in graphics mode then popup and ask
  for kernel path+filename

* Sun Jul 14 2002 Hugo Rabson <hugo@firstlinux.net> 1.45-1
- 1.5x branch forked off from 1.4x branch










