/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class PropertyManager {


	private static Properties sProperties = new Properties();

	public static PropertyManager sPropertyManager;
	
	private static PropertyManager getInstance() {
		if (sPropertyManager == null) {
			sPropertyManager = new PropertyManager();
		}
		return sPropertyManager;
	}
	
	private PropertyManager() {
		super();
		try {
			loadProps();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void loadProps() throws Exception {
		FileInputStream aFileInputStream = new FileInputStream("bin/applicationProperties.xml");
		sProperties.loadFromXML(aFileInputStream);
		try {
			sProperties.loadFromXML(new FileInputStream(new File(System.getProperty("user.home"), "monajat_properties.xml")));
		} catch (Exception e) {
		}
	}
	
	public static void reloadUserProperties() {
		try {
			sProperties.loadFromXML(new FileInputStream(new File(System.getProperty("user.home"), "monajat_properties.xml")));
		} catch (Exception e) {
		}
	}
	
	public static String getProperty(String pKey){
		try {
			return getInstance().getProperties().getProperty(pKey);
		} catch(Exception e) {
			return "";
		}
	}

	private Properties getProperties() {
		return sProperties;
	}

}
