/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import monajat.gui.main.help.MonajatAbout;
import monajat.util.Language_util.LanguageResource;

public class MonajatPopupMenu extends PopupMenu {

	private static final long serialVersionUID = 1L;
	
	public MonajatPopupMenu() {
		super();
		MenuItem messageItem = new MenuItem(LanguageResource.getString("About"));
		messageItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new MonajatAbout();
			}
		});
		add(messageItem);

		MenuItem preferencesItem = new MenuItem(LanguageResource.getString("Preferences"));
		preferencesItem.addActionListener(new ActionListener() {
			MonajatPreferences aPreferences;
			public void actionPerformed(ActionEvent e) {
				try {
					aPreferences = new MonajatPreferences();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
				GuiFontSetter.adjustFont(aPreferences);
				aPreferences.setVisible(true);
			}
		});
		add(preferencesItem);
		
		MenuItem showItem = new MenuItem(LanguageResource.getString("Show prayer"));
		showItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MonajatTimer.showDoa();
			}
		});
		add(showItem);

		MenuItem fullMode = new MenuItem(LanguageResource.getString("Monajat"));
		fullMode.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new FullMode();
			}
		});
		add(fullMode);
		addSeparator();
		
		MenuItem closeItem = new MenuItem(LanguageResource.getString("Close"));
		closeItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		add(closeItem);
	}
	
}
