/*
 * $Id: mod_cband.h,v 1.1 2005/12/07 00:46:57 dembol Exp $
 *
 * mod_cband - A per-user, per-virtualhost and per-destination bandwidth limiter for the Apache HTTP Server Version 2
 *
 * Copyright (c) 2005 Lukasz Dembinski <dembol@cband.linux.pl>
 * All Rights Reserved
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *	     
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *		     
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *					 
 */

#include "httpd.h"
#include "http_main.h"
#include "http_core.h"
#include "http_config.h"
#include "http_request.h"
#include "http_protocol.h"
#include "http_log.h"
#include "apr_strings.h"
#include "apr_file_io.h"
#include "apr_file_info.h"
#include "apr_signal.h"
#include "apr_hash.h"
#include "apr_time.h"
#include "apr_thread_mutex.h"
#include "util_filter.h"
#include "util_cfgtree.h"
#include <sys/shm.h>
#include <unistd.h>

#include "libpatricia.c"

#define MAX_CLASS_STR_LEN		16
#define MAX_DST_LEN			16
#define MAX_VIRTUALHOST_NAME		0x100
#define MAX_PERIOD_LEN			0x20
#define MAX_TRAFFIC_LEN			0x100
#define MAX_REMOTE_HOSTS		0x100
#define MAX_HASH_TABLE_LEN		0x100
#define PERIOD_LEN			10
#define DEFAULT_REFRESH			15
#define DEFAULT_REFRESH_UNAVAILABLE	3
#define CBAND_HANDLER_ALL		0
#define CBAND_HANDLER_ME		1

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
/* union semun is defined by including <sys/sem.h> */
#else
/* according to X/OPEN we have to define it ourselves */
union semun {
    int val;                  /* value for SETVAL */
    struct semid_ds *buf;     /* buffer for IPC_STAT, IPC_SET */
    unsigned short *array;    /* array for GETALL, SETALL */
                              /* Linux specific part: */
    struct seminfo *__buf;    /* buffer for IPC_INFO */
};					            
#endif

typedef struct mod_cband_virtualhost_config_entry mod_cband_virtualhost_config_entry;
typedef struct mod_cband_user_config_entry mod_cband_user_config_entry;
typedef struct mod_cband_class_config_entry mod_cband_class_config_entry;

typedef struct {
    unsigned long long total_bytes; 			/* in bytes - total traffic */
    unsigned long long class_bytes[DST_CLASS]; 		/* in bytes - class traffic */
    unsigned long start_time;
    long score_flush_count;
    int was_request;
} mod_cband_scoreboard_entry;

typedef struct {
    int sem_id;
    unsigned long max_kbps, max_rps, max_delay;
    unsigned long over_kbps, over_rps, over_delay;
    unsigned long curr_kbps, curr_rps, curr_delay;
    unsigned long refuse_percent;
    unsigned long total_last_refresh;
    unsigned long total_last_time;
    mod_cband_scoreboard_entry total_usage;
    float total_TX;
    float total_conn;
} mod_cband_shmem_data;

struct mod_cband_virtualhost_config_entry {
    char *virtual_name;
    apr_port_t virtual_port;
    unsigned virtual_defn_line;
    char *virtual_limit_exceeded;
    char *virtual_scoreboard;
    char *virtual_user;
    unsigned long virtual_limit;  			/* in units of *_mult bytes - total limit  */
    unsigned long virtual_class_limit[DST_CLASS];	/* in units of *_mult bytes - class limits */
    unsigned long refresh_time;				/* in seconds */
    unsigned int virtual_limit_mult;
    unsigned int virtual_class_limit_mult[DST_CLASS];
    mod_cband_shmem_data *shmem_data;
    mod_cband_virtualhost_config_entry *next;
};

struct mod_cband_user_config_entry {
    char *user_name;
    char *user_limit_exceeded;
    char *user_scoreboard;
    unsigned long user_limit;  				/* in units of *_mult bytes - total limit  */
    unsigned long user_class_limit[DST_CLASS]; 		/* in units of *_mult bytes - class limits */
    unsigned long refresh_time;	
    unsigned int user_limit_mult;
    unsigned int user_class_limit_mult[DST_CLASS];
    mod_cband_shmem_data *shmem_data;			/* in seconds */
    mod_cband_user_config_entry *next;
};

struct mod_cband_class_config_entry {
    char *class_name;
    unsigned int class_nr;
    mod_cband_shmem_data *shmem_data;
    mod_cband_class_config_entry *next;
};

typedef struct {
    mod_cband_virtualhost_config_entry *next_virtualhost;
    mod_cband_user_config_entry *next_user;
    mod_cband_class_config_entry *next_class;
    apr_pool_t *p;
    char *default_limit_exceeded;
    patricia_tree_t *tree;
    unsigned long start_time;				/* in seconds */
    mod_cband_shmem_data *shmem_data;
    int sem_id;
    unsigned long score_flush_period;
} mod_cband_config_header;

