
/* libc */
#include <stdio.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
/* other libs */
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker.h>

/* globals */
int run = 1;
sighandler_t old_int;

void sigINT(int signum)
{
 run = 0;
 signal(signum, old_int);
 return;
}

int main(int argc, char** argv)
{
 int master = 0;
 btt_tracker* tracker = NULL;
 apr_pool_t* pool = NULL;

 if(argc < 2 || argc > 3 || (argc == 3 && (strcmp("-master", argv[2]))))
 {
  fprintf(stderr, "Usage: %s homedir [-master]\n", argv[0]);
  fflush(stderr);
  exit(1);
 }
 
 if(argc == 3)
  master = 1;

 if(apr_pool_initialize() != APR_SUCCESS)
 {
  fprintf(stderr, "apr_pool_initialize() failed!\n");
  fflush(stderr);
  exit(2);
 }
 
 if(apr_pool_create(&pool, NULL) != APR_SUCCESS)
 {
  fprintf(stderr, "apr_pool_create() failed!\n");
  fflush(stderr);
  exit(3);
 }

 if(!(tracker = btt_tracker_alloc(pool, argv[1], master)))
 {
  fprintf(stderr, "bt_tracker_alloc() failed!\n");
  fflush(stderr);
  exit(4);
 }
 
 if(!btt_tracker_connect(tracker, master))
 {
  fprintf(stderr, "bt_tracker_connect() failed!\n");
  fflush(stderr);
  exit(5);
 }
 
 if(master)
  tracker->s->start_t = time(NULL);

 if((old_int = signal(SIGINT, sigINT)) == SIG_ERR)
 {
  fprintf(stderr, "signal() failed!\n");
  exit(6);
 }
 
 printf("Fake tracker started %ld second(s) ago. (Master = %d)\nSend SIGINT (^C) to shutdown.\n", time(NULL) - tracker->s->start_t, master);
 
 while(run)
 {
  if(master)
   tracker->s->num_peers++;

  sleep(1);

  printf("Master Iterations: %d.\n", tracker->s->num_peers);
 }
 
 printf("Caught SIGINT, shutting down.\n");
 
 if(!btt_tracker_disconnect(tracker))
 {
  fprintf(stderr, "bt_tracker_disconnect() failed!\n");
  exit(7);
 }
 
 if(!btt_tracker_free(&tracker, master))
 {
  fprintf(stderr, "bt_tracker_free() failed!\n");
  exit(8);
 }
 
 printf("Tracker instance shut down successfully.\n");
 exit(0);
}
