#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    MoblinMedia.py: main function

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import MusicView
import VideoView
import PhotoView
import ToolBarView
import MediaPlugin
import EngManag

import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import dbus, dbus.glib, dbus.service
import pygst
pygst.require("0.10")
import gst
import fcntl
import gconf

if Constant.HildonSupport == True:
    import hildon
    #import osso

class OSSListener(dbus.service.Object):
    def __init__(self, app):
        self.app = app
        self.name = 'org.moblin.media'
        self.path = '/org/moblin/media'
        bus_name = dbus.service.BusName(self.name, bus=dbus.SessionBus())
        dbus.service.Object.__init__(self, bus_name, self.path)

    @dbus.service.method(dbus_interface='org.moblin.media', in_signature='', out_signature='')
    def top_application(self):
        self.app.top_application()

    @dbus.service.method(dbus_interface='org.moblin.media', in_signature='s', out_signature='s')
    def dbus_service_connect(self, name):	
        return name

    @dbus.service.method(dbus_interface='org.moblin.media', in_signature='ssi', out_signature='')
    def dbus_service_play(self, strUrl, strMimetype, intRepeat):	
	self.app.view['toolbar'].open_uri(strUrl)
        return


class App(gtk.Object):
    """
    A class which manage whole app view and funcion
    """
    __gsignals__ = {
        'song-ended':(gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, ()),
        }
    def __init__(self):
	self.__gobject_init__()
        self.mainloop = gobject.MainLoop()

        try:
            client = gconf.client_get_default()
            theme = client.get_string("/desktop/gnome/interface/gtk_theme")
            image_path = os.path.join('/usr/share/themes', theme, 'images')
            if os.path.isdir(theme_dir):
                self.image_path = os.path.join(theme_dir, 'images')
            else:
                self.image_path = '/usr/share/themes/mobilebasic/images'
        except:
            self.image_path = '/usr/share/themes/mobilebasic/images'

        try:
            client.notify_add("/desktop/gnome/interface/gtk_theme", self.theme_changed);
        except:
            pass

        if Constant.HildonSupport == True:
            self.wTree = gtk.glade.XML(Constant.MediaGladePath,root='wm_main_vb')
        else:
            self.wTree = gtk.glade.XML(Constant.MediaGladePath,root='mp_window_main')

        dic = {
                #"on_main_delete_event" : self.delete_event,
            #"on_music_bn_clicked" : self.setMusicMode,
            "on_music_bn_clicked" : self.setMusicPath,
            "on_video_bn_clicked" : self.setVideoPath,
            "on_photo_bn_clicked" : self.setPhotoPath,
            }

        self.wTree.signal_autoconnect(dic)

        # some constants of App
        self.STATE_NULL = 0
        self.STATE_READY = 2
        self.STATE_PAUSED = 3
        self.STATE_PLAYING = 4

        # If this is the first time the application has run as this user
        # then intialize the media directory and link in all the sample content
        if not os.path.isdir(Constant.MediaStreamPath):
            os.mkdir(Constant.MediaStreamPath)
            os.mkdir(os.path.join(Constant.MediaStreamPath, 'video'))
            os.mkdir(os.path.join(Constant.MediaStreamPath, 'audio'))
            os.mkdir(os.path.join(Constant.MediaStreamPath, 'photo'))

        self.EngManag=EngManag.EngManag()
        if self.EngManag.GetEngList():
            for i in self.EngManag.GetEngList():
                self.service = i.GetService()
                DBusName = i.GetDBusName()
                iface = dbus.Interface(self.service, DBusName)
                iface.connect_to_signal("StatusChange", self.on_status_changed)
                iface.connect_to_signal("UpdateMediaInfo", self.on_update_media_info)
                iface.connect_to_signal("UpdatePos", self.on_update_pos)
                iface.connect_to_signal("ErrorOccur", self.on_error_occur)
		iface.connect_to_signal("EOSOccur", self.on_eos_occur)
        else:
            GeneralFunc.error_msg('no engine available', True)
        
        # init some state variables
        self.state = self.STATE_NULL

        # init some gui variable
        self.mainview_box = self.wTree.get_widget('wm_mainview_vb')

        self.main_notebook = self.wTree.get_widget('wm_main_nbk')
        self.main_notebook.set_show_tabs(False)

        self.toolbar_box = self.wTree.get_widget('wm_toolbar_vb')

        # three main buttons
        self.music_button = self.wTree.get_widget("wm_l_music_bn")
        self.video_button = self.wTree.get_widget("wm_l_video_bn")
        self.photo_button = self.wTree.get_widget("wm_l_photo_bn")

        # set three main button images
        self.music_button_image = self.wTree.get_widget("wm_music_img")
        self.video_button_image = self.wTree.get_widget("wm_video_img")
        self.photo_button_image = self.wTree.get_widget("wm_photo_img")

        # get refer to three vbox under three main buttons
        self.music_ebox = self.wTree.get_widget('wm_music_eb')
        self.video_ebox = self.wTree.get_widget('wm_video_eb')
        self.photo_ebox = self.wTree.get_widget('wm_photo_eb')

        # media type
        self.media_type = None
        # media file length
        self.media_file_length = 0
        # current view
        self.cur_mode = None
        # current media syncing state
	self.pb_mode = Constant.PB_NORMAL
	# current playing view
	self.cur_playing_mode  = None
        # for fullscreen
        self.fs_mode = False

        # init plugins
        self.plugins = MediaPlugin.MediaPlugin()
        
        # init three main views
        self.view = {}
        self.view['audio'] = MusicView.MusicView(self)
        self.view['video'] = VideoView.VideoView(self)
        self.view['photo'] = PhotoView.PhotoView(self)
        self.view['toolbar'] = ToolBarView.ToolBarView(self, 'video')
        # pack toolbar view to toolbar box
        self.toolbar_box.pack_start(self.view['toolbar'].cur_view)

        # append three mode windows
        self.music_page = self.wTree.get_widget('wm_main_music_eb')
        self.music_page.add(self.view['audio'].view_nbk)
        self.video_page = self.wTree.get_widget('wm_main_video_eb')
        self.video_page.add(self.view['video'].view_nbk)
        self.photo_page = self.wTree.get_widget('wm_main_photo_eb')
        self.photo_page.add(self.view['photo'].view_nbk)

        # read url
        self.read_url()

        # init program
        if Constant.HildonSupport == True:
            #osso_c = osso.Context("org.moblin.moblinmedia", "0.4.0", False)
            self.program = hildon.Program()
            self.window = hildon.Window()
            self.window.set_title('Media')
            self.create_menu(self.window)

            self.program.add_window(self.window)
            vbox = self.wTree.get_widget("wm_main_vb")
            self.window.add(vbox)
            self.window.connect('delete_event', self.exit, 'WM destroy')
            self.window.show_all()
        else:
            self.window = self.wTree.get_widget("mp_window_main")
            self.window.connect('delete_event', self.exit, 'WM destroy')
            self.window.show_all()
            
        # init ui
        self.init_ui()
        self.update_all_ui()

        self.setPhotoMode(None)
	self.view['photo'].ThumbnailView.MakeAllImageThumbnail(os.path.join(Constant.MediaStreamPath,"photo"))
	self.view['photo'].get_photo_playback().goThumbnail()
        self.update_ui()

        # run from command line
        options, args = GeneralFunc.parse_command_line()
        if options.mode != None:
            if options.mode in Constant.MediaType.keys():
                self.cur_mode = options.mode
        if options.uri != None:
            self.cur_mode = GeneralFunc.get_media_type(options.uri)
            if self.cur_mode in Constant.MediaType.keys():
                self.service.OpenUri(options.uri)
                self.service.Play()
                
        # for test
	
	# connect custom signal with child handlers
	self.connect('song-ended', self.view['audio'].on_song_ended)

        self.osso_listener = OSSListener(self)

    def create_menu(self, window):
        menu_file = gtk.Menu ()
        window.set_menu (menu_file)
        item_Open    = gtk.MenuItem ("Open File...")
        #item_separator = gtk.SeparatorMenuItem ()
        item_OpenURI    = gtk.MenuItem ("Open Location...")
        item_separator2 = gtk.SeparatorMenuItem ()
        item_FullScreen    = gtk.MenuItem ("Full Screen")
        #item_separator3 = gtk.SeparatorMenuItem ()
        #item_UnFullScreen    = gtk.MenuItem ("UnFull Screen")
        item_separator4 = gtk.SeparatorMenuItem ()
        item_Exit     = gtk.MenuItem ("Quit")
        menu_file.append (item_Open)
        #menu_file.append (item_separator)
        menu_file.append (item_OpenURI)
        menu_file.append (item_separator2)
        menu_file.append (item_FullScreen)
        #menu_file.append (item_separator3)
        #menu_file.append (item_UnFullScreen)
        menu_file.append (item_separator4)
        menu_file.append (item_Exit)
        item_Open.connect ('activate', self.on_file_open )
        item_OpenURI.connect ('activate', self.on_file_open_uri )
        item_FullScreen.connect('activate', self.on_full_screen )
        #item_UnFullScreen.connect('activate', self.on_unfull_screen )
        item_Exit.connect ('activate', self.on_file_quit)
        menu_file.show_all ()

    def init_ui(self):

        widget = self.wTree.get_widget('wm_ctrlbox_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_box_bg'])
        widget = self.wTree.get_widget('wm_toolbar_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['toolbar_bg'])

        # set button relief property
        self.music_button.set_relief(gtk.RELIEF_NONE)
        self.video_button.set_relief(gtk.RELIEF_NONE)
        self.photo_button.set_relief(gtk.RELIEF_NONE)

    def update_ui(self):
        if self.cur_mode in Constant.MediaType.keys():
            if self.cur_mode == 'audio':
                self.music_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_music_on.png'))
                self.video_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_video_off.png'))
                self.photo_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_photos_off.png'))
                self.music_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_focus'])
                self.video_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_unfocus'])
                self.photo_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_unfocus'])
            elif self.cur_mode == 'video':
                self.music_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_music_off.png'))
                self.video_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_video_on.png'))
                self.photo_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_photos_off.png'))
                self.music_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_unfocus'])
                self.video_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_focus'])
                self.photo_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_unfocus'])

            elif self.cur_mode == 'photo':
                self.music_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_music_off.png'))
                self.video_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_video_off.png'))
                self.photo_button_image.set_from_file(os.path.join(self.image_path,'mb_media_tab_photos_on.png'))
                self.music_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_unfocus'])
                self.video_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_unfocus'])
                self.photo_ebox.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['ctrl_ebox_focus'])

    def update_all_ui(self):
        self.view['audio'].update_ui(False)
        self.view['video'].update_ui(False)
        self.view['photo'].update_ui(False)
        self.update_ui()
        
    def run(self):
        self.mainloop.run()
        
    def exit_interrupt(self):
        self.service.Stop()
        if os.path.isfile('/tmp/moblinmedia'):
            os.remove('/tmp/moblinmedia')
        self.mainloop.quit()

    def exit(self, widget, event, data=None):
        self.service.Stop()
        if os.path.isfile('/tmp/moblinmedia'):
            os.remove('/tmp/moblinmedia')
        self.mainloop.quit()

    def on_file_quit(self, args):
        self.url_file.close()
        self.service.Stop()
        if os.path.isfile('/tmp/moblinmedia'):
            os.remove('/tmp/moblinmedia')
        self.mainloop.quit()

    def on_file_open(self, button):
        if self.view['toolbar']:
            self.view['toolbar'].on_file_open(None)
            
    def get_fs_mode(self):
	    return self.fs_mode

    def set_fs_mode(self , on ) :
	self.fs_mode = on
	self.ctrl_box = self.wTree.get_widget('wm_ctrlbox_eb')
	self.toolbar_box = self.wTree.get_widget('wm_toolbar_vb')		
        if on :
            if not self.state in [self.STATE_READY]:
	        self.window.fullscreen()
                self.ctrl_box.hide()
                self.toolbar_box.hide()
        else :
	    self.window.unfullscreen()
            self.ctrl_box.show()
            self.toolbar_box.show()

    def on_full_screen( self, args ):           
        self.set_fs_mode( True )                
        if self.media_type in Constant.MediaType.keys():
            self.view[self.media_type].set_fs_mode( True )

    def on_unfull_screen( self, args ):         
        self.set_fs_mode( False )               
        if self.media_type in Constant.MediaType.keys():
            self.view[self.media_type].set_fs_mode( False )

    def read_url(self):
        self.url_list_count = 0
        self.url_file = file(os.environ["HOME"] + "/.moblin_media_history", 'a+')
        if(self.url_file> 0):
            while True:
                self.line= self.url_file.readline()
                self.line = self.line.rstrip('\n')
                #print self.line
                if(self.line < 0):
                    print "file read error"
                if(len(self.line) == 0):
                    break
                Constant.MediaUrlList.insert(0, self.line)
                self.url_list_count = self.url_list_count + 1
        else:
            print "open history_url file failed\n"
	    
    def get_pb_mode(self):
	return self.pb_mode
    
    def set_pb_mode(self, mode):
	self.pb_mode = mode

    def on_status_changed(self, prev, new, pending):
        if prev == self.STATE_PAUSED and new == self.STATE_READY:
	    self.pb_mode = Constant.PB_NORMAL
	    self.view['toolbar'].update_button(self.cur_mode, self.media_type)
	    self.view['toolbar'].set_stop_button_state(False)
            self.set_fs_mode(False)
            self.service.SetPosition(0)
            # should set seekbar here
            if self.media_type in ['audio', 'video']:
                self.view[self.media_type].playback_set_seekbar_value(0)
                
	if new in [self.STATE_PAUSED, self.STATE_PLAYING]:
	    if self.pb_mode == Constant.PB_NORMAL:
		self.view['toolbar'].set_stop_button_state(True)
        
        if new == self.STATE_PLAYING:
            self.view['toolbar'].set_play_pause_img(os.path.join(self.image_path,'pause.png'))
        else:
            self.view['toolbar'].set_play_pause_img(os.path.join(self.image_path,'mb_media_btn_play.png'))

        self.state = new

    def on_update_media_info(self, key, value ):
        if self.media_type == 'audio':
            if key == "title":
                self.view['audio'].playback_set_title_lb( "%s" % value )
            if key == "album":
                self.view['audio'].playback_set_album_lb( "%s" % value )
            if key == "artist":
                self.view['audio'].playback_set_artist_lb( "%s" % value )
            if key == "album_year":
                self.view['audio'].playback_set_album_year_lb( "%s" % value )
            if key == "image":
                self.view['audio'].set_album_img('/tmp/cover.jpg')

        if self.media_type in ['audio', 'video']:
            if key == "duration":
                if value == -1:
                    self.media_file_length = 0
                if self.media_file_length == 0:
                    self.media_file_length = value

                (hours, mins, secs) = GeneralFunc.get_hour_min_sec(value)
                self.view[self.media_type].playback_set_seekbar_range(0, value)
                self.view[self.media_type].playback_set_seekbar_increments(1, 0)
                self.view[self.media_type].playback_set_length_lb(GeneralFunc.format_time(hours, mins, secs))

    def on_update_pos(self , cur_value ):
        if cur_value <= self.media_file_length:
            if self.media_type in ['audio', 'video']:
                self.view[self.media_type].playback_set_seekbar_value(cur_value)

    def on_surface_expose(self, widget,event):
        pass

    def on_dialog_close( self , dialog ):
        dialog.destroy()

    def on_dialog_response( self , dialog ,response_id ):
        dialog.destroy()

    def on_error_occur( self, msg ):
        dialog = gtk.MessageDialog(None, 0 , gtk.MESSAGE_ERROR , gtk.BUTTONS_CLOSE , msg )
        dialog.connect( "close" , self.on_dialog_close )
        dialog.connect( "response" , self.on_dialog_response )
        dialog.show()   
	
    def on_eos_occur( self ):
	if self.media_type == 'audio':
	    self.emit('song-ended')  
	print 'in on_eos_occur******************8'

    def on_file_open_uri(self, arg):
        self.url_xml=gtk.glade.XML('url.glade','url_dialog')
        self.url_dialog = self.url_xml.get_widget("url_dialog")

        self.url_combo = self.url_xml.get_widget("houd_uri_combo")
        self.url_entry = self.url_xml.get_widget("houd_uri_entry")
        self.url_combo.set_popdown_strings(Constant.MediaUrlList)               
        if (gtk.RESPONSE_OK == self.url_dialog.run()):
            self.url_text = self.url_entry.get_text()
            Constant.MediaUrlList.insert(0, self.url_text)
            self.url_file.write(self.url_text + '\n');
            self.view['toolbar'].open_uri(self.url_text)
        self.url_dialog.destroy()

    def setMusicPath(self, button):
        self.setPhotoMode(None)
        self.view['photo'].ThumbnailView.MakeAllImageThumbnail(os.path.join(Constant.MediaStreamPath,"audio"))
        self.view['photo'].get_photo_playback().goThumbnail()
        self.cur_mode = 'audio'
        self.view['toolbar'].pm_pl_to_thumb_bn.show()
        self.view['toolbar'].pm_pl_to_thumb_bn.set_sensitive(True)
        self.update_ui()

    def setVideoPath(self, button):
	self.setPhotoMode(None)
	self.view['photo'].ThumbnailView.MakeAllImageThumbnail(os.path.join(Constant.MediaStreamPath,"video"))
	self.view['photo'].get_photo_playback().goThumbnail()
	self.cur_mode = 'video'
        self.update_ui()

    def setPhotoPath(self, button):
        self.cur_mode = 'photo'
	self.setPhotoMode(None)
	self.view['photo'].ThumbnailView.MakeAllImageThumbnail(os.path.join(Constant.MediaStreamPath,"photo"))
	self.view['photo'].get_photo_playback().goThumbnail()
        self.update_ui()

    def setMusicMode(self, button):
        self.cur_mode = 'audio'
        if self.media_type == 'audio':
            self.view['audio'].update_ui(True)
        else:
            self.view['audio'].update_ui(False)
        self.main_notebook.set_current_page(0)
        self.view['toolbar'].change_mode('audio', self.media_type)
        self.update_ui()

    def setVideoMode(self, button):
        self.cur_mode = 'video'
        if self.media_type == 'video':
            self.view['video'].update_ui(True)
        else:
            self.view['video'].update_ui(False)
        self.main_notebook.set_current_page(1)
        self.view['toolbar'].change_mode('video', self.media_type)
        self.update_ui()

    def setPhotoMode(self, button):
        self.cur_mode = 'photo'
        self.main_notebook.set_current_page(2)
        self.view['toolbar'].change_mode('photo', self.media_type)
        self.view['photo'].update_ui(True)
        self.update_ui()

    def set_mediatype(self, mediatype):
        if mediatype in Constant.MediaType.keys():
            self.media_type = mediatype
            if self.view[mediatype].is_first_load() == True:
                self.view[mediatype].mark_default_flag()
        else:
            pass

    def get_mediatype(self):
        return self.media_type

    def Play_Pause(self, button):
        if self.state == self.STATE_PAUSED or self.state == self.STATE_READY:
            self.Play()
        elif self.state == self.STATE_PLAYING:
            self.Pause()

    def Play(self):
        self.service.Play()
        self.update_ui()

    def Pause(self):
        self.service.Pause()
        self.update_ui()

    def Stop(self, button):
        self.service.Stop()
        if self.media_type == 'video':
            self.view['video'].playback_set_seekbar_value(0)
        elif self.media_type == 'audio':
            self.view['audio'].playback_set_seekbar_value(0)
        self.update_ui() 

    def Rewind(self, button, rate):
	self.service.FastRewind(rate)

    def Forward(self, button, rate):
	self.service.FastForward(rate)

    def Load(self, media_type, filename):
        if media_type in ['audio', 'video']:
            surface = self.view[media_type].get_render_surface()
            if None != surface.window:
                self.pb_mode = Constant.PB_NORMAL
                self.service.FastForward(0)
                self.service.SetWindow(surface.window.xid)
                # load file
                print 'current eng is :',self.CurrentEng.GetName()
                self.service.OpenUri(filename)
                self.service.Play()
            else:
                print 'error in get render surface\n'
        else:
            # load a picture
            pass

    def SetPosition(self, position):
        self.service.SetPosition(position)

    def SetGeometry(self, width, height):
        self.service.SetGeometry(width, height)

    def top_application(self):
        self.window.present()

    def theme_changed(self, client, connection_id, entry, args):
        if (entry.get_value().type == gconf.VALUE_STRING):
            self.image_path = os.path.join('/usr/share/themes', entry.get_value().get_string(), 'images')


if __name__ == '__main__':
    gtk.gdk.threads_init()
    app = App()
    try:
        app.run()
    except:
        app.exit_interrupt()






