/* GNOME Volume Applet
 * Copyright (C) 2004 Ronald Bultje <rbultje@ronald.bitfreak.net>
 *
 * load.c: applet boilerplate code
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include "applet.h"

void *volume_initialize(HildonStatusBarItem *item, GtkWidget **button)
{
  MoblinVolumeApplet *obj = moblin_volume_applet_new();

  if(!obj)
  {
    g_error("Failed to initialize the volume applet\n");
    return NULL;
  }

  moblin_volume_applet_setup (obj->applet);
  obj->item = item;
  *button = obj->button = GTK_WIDGET(obj->applet);

  return obj;
}

void volume_update(void *data, gint value1, gint value2, const gchar *str)
{

}

void volume_destroy(void *data)
{
}

gint volume_get_priority(void *data)
{
	return 1;
}

void volume_entry (HildonStatusBarPluginFn_st *fn)
{
	if (fn == NULL)
	{
		g_error("bad setup call\n");
		return;
	}

	fn->initialize = volume_initialize;
	fn->destroy = volume_destroy;
	fn->update = volume_update;
	fn->get_priority = volume_get_priority;
}
