#include <string.h>
#include <unistd.h>
#include <libosso.h>
#include <locale.h>
#include <libintl.h>
#include <gst/gst.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>

int
main(int argc, char *argv[])
{
osso_context_t *osso_context;
char applet[1024];

	setlocale (LC_ALL, "");

	bindtextdomain (PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (PACKAGE, "UTF-8");
	textdomain (PACKAGE);

	gst_init(NULL, NULL);

	gtk_init (&argc, &argv);

	if(argc != 2)
	{
		printf("Usage: %s <appletname>\n", argv[0]);
		return -1;
	}

	sprintf(applet, "%s/%s.so", HCP_LIB_DIR, argv[1]);
	if(!g_file_test ((applet), G_FILE_TEST_EXISTS))
	{
		fprintf(stderr, "%s does not exist\n", applet);
		return -1;
	}

	osso_context = osso_initialize(argv[0], PACKAGE_VERSION, TRUE, NULL);
	if (!osso_context) 
	{
		fprintf(stderr, "%s failed to initialize\n", argv[0]);
		return -1;
	}

	sprintf(applet, "%s.so", argv[1]);
	if(osso_cp_plugin_execute(osso_context, applet, NULL, TRUE) != OSSO_OK)
	{
		fprintf(stderr, "%s failed to launch\n", applet);
		return -1;
	}
	return 0;
}
