/*
 *  Moblin Background Management Application
 *  Source: capplets/background/wp-database.c
 *  Author: Todd Brandt <todd.e.brandt@intel.com>
 *  Copyright 2007-2008 Intel Corp (moblin.org)
 *
 *  Based on capplets/background/gnome-wp-database.c from 
 *  gnome-control-center-2.18.1: Rodney Dawes <dobey@ximian.com>
 *  Copyright 2003-2006 Novell, Inc. (www.novell.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#include "wp-capplet.h"
#include <glib/gstdio.h>
#include <fcntl.h>

const gchar *extlist[] = {
	".jpg",
	".jpeg",
	".gif",
	".png",
	".bmp",
	NULL
};

static gboolean
valid_ext(const gchar *filename)
{
gchar **tmp, *ext;

	if((ext = g_strrstr(filename, ".")) == NULL)
		return FALSE;
	for(tmp = (gchar**)extlist; *tmp; tmp++)
	{
	    g_debug("tmp = %s, ext = %s", *tmp, ext);
	    if(!g_strcasecmp(ext, *tmp))
	    {
		return TRUE;
	    }
	}
	return FALSE;
}

static void
load_images_from_path(MoblinWPCapplet * capplet,
	const gchar * path)
{
  GDir *dir;
  const gchar *filename;

	dir = g_dir_open(path, 0, NULL);
	while((filename = (gchar *)g_dir_read_name(dir)) != NULL)
	{
	    MoblinWPItem *wp;
	    gchar *imagepath;

	    if(!valid_ext(filename)) continue;
	    imagepath = g_build_filename (path, filename, NULL);
	    /* Make sure we don't already have this one */
	    if(g_hash_table_lookup (capplet->wphash, imagepath) != NULL)
	    {
		g_free(imagepath);
		continue;
	    }
	    wp = g_new0 (MoblinWPItem, 1);
	    wp->filename = imagepath;
	    wp->fileinfo = NULL;
	    wp->name = g_strdup(filename);
	    g_hash_table_insert (capplet->wphash, wp->filename, wp);
	}
	g_dir_close(dir);
}

void 
load_images (MoblinWPCapplet * capplet)
{
  gchar *path;
  const gchar *thumb;
  GSList *list, *p;
  GConfEntry *e;
  int found = 0;

    if(!gconf_client_dir_exists(capplet->client, 
	BGKEY(BG_THUMBPATHS), NULL))
    {
	g_warning("Gconf dir does not exist: %s\n",
		BGKEY(BG_THUMBPATHS));
	return;
    }

    if((list = gconf_client_all_entries(capplet->client,
	BGKEY(BG_THUMBPATHS), NULL)) == NULL)
    {
	g_warning("Gconf dir has no contents: %s\n",
		BGKEY(BG_THUMBPATHS));
	return;
    }

    for(p = list; p != NULL; p = g_slist_next(p))
    {
	e = (GConfEntry *)p->data;
	thumb = gconf_value_get_string(e->value);
	if(g_str_has_prefix(thumb, "[HOME]")) {
	    path = g_build_filename (g_get_home_dir(),
		&thumb[6], NULL);
	} else {
	    path = thumb;
	}
	if (g_file_test(path, G_FILE_TEST_EXISTS)&&
	    g_file_test(path, G_FILE_TEST_IS_DIR))
	{
	    found = 1;
	    load_images_from_path (capplet, path);
	}
	if(path != thumb)
	    g_free (path);
	gconf_entry_free(e);
    }

    if(!found)
	g_warning("Gconf dir has no viable search paths: %s\n",
	    BGKEY(BG_THUMBPATHS));

    g_slist_free(list);
}
