/*
 *  Moblin Background Management Application
 *  Source: capplets/background/wp-capplet.c
 *  Author: Todd Brandt <todd.e.brandt@intel.com>
 *  Copyright 2007-2008 Intel Corp (moblin.org)
 *
 *  Based on capplets/background/gnome-wp-capplet.c from
 *  gnome-control-center-2.18.1: Rodney Dawes <dobey@ximian.com>
 *  Copyright 2003-2006 Novell, Inc. (www.novell.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef _MOBLIN_WP_CAPPLET_H_
#define _MOBLIN_WP_CAPPLET_H_

#include <config.h>
#include <gnome.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <libgnomevfs/gnome-vfs-mime-utils.h>
#include <libgnomeui/gnome-thumbnail.h>
#include <gconf/gconf-client.h>
#include <libxml/parser.h>
#include <glade/glade.h>
#include <glade/glade-build.h>
#include <moko-finger-scroll.h>

typedef struct _MoblinWPCapplet MoblinWPCapplet;

#include "wp-info.h"
#include "wp-item.h"
#include "wp-utils.h"
#include "wp-database.h"

#define NUM_GCONF_CALLBACKS 2
struct _MoblinWPCapplet {
  GtkWidget * window;

  guint gconf_cb_ids[NUM_GCONF_CALLBACKS];

  /* The Tree View */
  GtkWidget * mokoscroll;
  GtkWidget * treeview;
  GtkTreeModel * model;
  GtkWidget * jumpfirst;
  GtkWidget * jumplast;
  GtkWidget * jumpslider;
  GtkWidget * vbox_quick;

  /* Widget for Color Options */
  GtkWidget * pc_picker;

  /* GConf Client */
  GConfClient * client;

  /* Thumbnailing and Icon Theme stuff */
  GnomeThumbnailFactory * thumbs;

  /* Hash Table of Wallpapers */
  GHashTable * wphash;

  GThread *lthread;
};

void moblin_wp_main_quit (MoblinWPCapplet * capplet);

#endif

