#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    GeneralFunc.py: This module define some common funcions

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
from optparse import OptionParser
import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import string

def get_hour_min_sec(sec):
    hours = int(sec / 3600)
    mins = int((sec % 3600) / 60)
    secs = int(sec % 60)
    return (hours, mins, secs)

def format_time(hours, mins, secs):
    if hours == 0:
        time_str = '%.2d:%.2d' % (mins, secs)
    else:
        time_str = '%.2d:%.2d:%.2d' % (hours, mins, secs)

    return time_str

def parse_command_line():
    parser = OptionParser(add_help_option=False)
    parser.add_option("--uri", dest="uri", help="Media file URI")
    parser.add_option("--mode", dest="mode", help="Media type, music, video or photo")
    parser.add_option("--help", help="show this help message and exit",
                    dest = "help", action="store_true", default=False)
    (options, args) = parser.parse_args()

    # validate options
    if not options and not args:
        return options, args
    if options.help:
        parser.print_help()
        sys.exit(0)
    if options.mode:
        if(not((options.mode == "music") or (options.mode == "video") or (options.mode == "photo"))):
            parser.error("no such media mode, only support music, video and photo")

    return options, args

def get_media_type(filename):
    strlist = string.split(filename, '.')
    if strlist[-1].lower() in Constant.MediaType['audio']:
        return 'audio'
    elif strlist[-1].lower() in Constant.MediaType['video']:
        return 'video'
    elif strlist[-1].lower() in Constant.MediaType['photo']:
        return 'photo'
    else:
        return 'video'

def set_image_fit(image, filename):
    size = ()
    size = image.get_size_request()
    pb = gtk.gdk.pixbuf_new_from_file(filename)
    width = pb.get_width()
    height = pb.get_height()
    if ((width > size[0]) or (height > size[1])):
        if(width * size[1] > height * size[0]):
            pb = pb.scale_simple( size[0] , height*size[0]/width, gtk.gdk.INTERP_BILINEAR )
        else:
            pb = pb.scale_simple( width*size[1]/height, size[1], gtk.gdk.INTERP_BILINEAR )
    image.set_from_pixbuf(pb)

def on_err_dialog_close(dialog):
    dialog.destroy()

def on_err_dialog_response(dialog, response_id):
    dialog.destroy()

def error_msg(msg):
    dialog = gtk.MessageDialog(None, 0 , gtk.MESSAGE_ERROR , gtk.BUTTONS_CLOSE , msg )
    dialog.connect( "close" , on_err_dialog_close )
    dialog.connect( "response", on_err_dialog_response )
    dialog.show()	
