///////////////////////////////////////////////////////////////////////////////
// $Id: maplayer.h,v 1.6 2004/09/29 20:08:08 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    maplayer.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the map layer class
*/

#ifndef MAPLAYER_H
#define MAPLAYER_H

// Qt includes
#include <qmemarray.h>

// forward declarations
class QFile;
class QPixmap;
class QPoint;
class QRect;
class TileCache;
class TileGroup;

///////////////////////////////////////////////////////////////////////////////

//! The map layer represents a layer of the background of a level
/*!
*/
class MapLayer {
public:
	static const int MAX_VERSION;

	MapLayer();
	~MapLayer();
	
	static int byteSize(int version, int rows, int cols);

	void setTileGroup(TileGroup* group);

	TileGroup* tileGroup() const { return m_tileGroup; }

	void setGroupIndex(uint index) { m_groupIndex = index; }

	uint groupIndex() const { return m_groupIndex; }

	void setCurrentTile(uint tileindex) {
		m_currentTile = tileindex;
	}

	void setImageParameters(int alpha, int brightness);
	
	void getImageParameters(int& alpha, int& brightness) const
	{
		alpha      = m_alpha;
		brightness = m_brightness;
	}

	void setBackground(bool background) { m_background = background; }
	
	bool isBackground() const { return m_background; }
	
	QPixmap* pixmap(int row, int col);

	void drawTile(int row, int col);

	void init(int rows, int cols);

	void resize(int rows, int cols);

	int numRows() const { return m_rows; }

	int numCols() const { return m_cols; }

	bool isModified() const { return m_modified; }

	void clearModified() { m_modified = false; }

	bool isVisible() const { return m_visible; }

	void setVisible(bool on) { m_visible = on; }

	bool readFromDevice(QIODevice* device, int version);
	bool writeToDevice(QIODevice* device) const;

	bool copyData(const QRect& area, const MapLayer& source,
	              const QPoint& destpoint);

protected:
	TileGroup* m_tileGroup;
	TileCache* m_tileCache;
	uint m_groupIndex;
	uint m_currentTile;

	int m_rows;
	int m_cols;
	int m_alpha;
	int m_brightness;
	
	bool m_background;

	bool m_modified;
	bool m_visible;

	QMemArray<uchar> m_tileField;
	QMemArray<QPixmap*> m_pixField;
	
private:
	bool importFromDevice(QIODevice* device, int version);

private:
	MapLayer(const MapLayer&);
	MapLayer& operator=(const MapLayer&);
};

#endif

// End of file
