///////////////////////////////////////////////////////////////////////////////
// $Id: mapdrag.h,v 1.1 2004/04/04 15:29:07 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2004
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    mapdrag.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the map drag object class
*/

#ifndef MAPDRAG_H
#define MAPDRAG_H

// Qt includes
#include <qdragobject.h>

// forward declarations
class MapDocument;
class QImageDrag;

///////////////////////////////////////////////////////////////////////////////

//! The map drag object handles DND and clipboard IO for maps
/*!
*/
class MapDrag : public QDragObject {
public:
	MapDrag(MapDocument* doc, QWidget* source=0, const char* name=0);
	~MapDrag();

	const char* format(int i = 0) const;

	bool provides(const char* format) const;

	QByteArray encodedData(const char* format) const;

	static bool canDecode(QMimeSource* source);

	static bool decode(QMimeSource* source, MapDocument* doc);

private:
	MapDocument* m_doc;
	QImageDrag* m_imageDrag;
};

#endif

// End of file
