/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef UDM_SQLDBMS_H
#define UDM_SQLDBMS_H

#define UDM_SQL_HAVE_GROUPBY     1
#define UDM_SQL_HAVE_TRUNCATE    2
#define UDM_SQL_HAVE_SUBSELECT   4
#define UDM_SQL_HAVE_LIMIT       8


extern void DecodeHexStr (char *src, UDM_PSTR *dst, size_t size);
char           *UdmDBEscStr(int DBType,char *to,const char *from,size_t len);
char           *UdmSQLEscStr(UDM_DB *db, char *to, const char *from, size_t l);
extern __C_LINK int __UDMCALL _UdmSQLQuery(UDM_DB *db, UDM_SQLRES *R, const char *query, const char *file, const int line);
extern __C_LINK size_t __UDMCALL UdmSQLNumRows(UDM_SQLRES *res);
size_t		UdmSQLNumCols(UDM_SQLRES *res);
size_t		UdmSQLLen(UDM_SQLRES * res,size_t i,size_t j);
extern __C_LINK const char * __UDMCALL UdmSQLValue(UDM_SQLRES * res,size_t i,size_t j);
extern __C_LINK int __UDMCALL UdmSQLFetchRowSimple(UDM_DB *,UDM_SQLRES *res, UDM_PSTR *pstr);
extern __C_LINK int __UDMCALL UdmSQLStoreResultSimple(UDM_DB *,UDM_SQLRES *res);
extern __C_LINK int __UDMCALL UdmSQLFreeResultSimple(UDM_DB *,UDM_SQLRES *res);
extern __C_LINK void __UDMCALL UdmSQLFree(UDM_SQLRES*);
void		UdmSQLClose(UDM_DB *db);
extern int UdmSQLBegin(UDM_DB *db);
extern int UdmSQLCommit(UDM_DB *db);

/*
extern int UdmOracle8Prepare(UDM_DB *db, const char *query);
extern int UdmOracle8Bind(UDM_DB *db, int position, void *data, size_t size, int type);
extern int UdmOracle8Exec(UDM_DB *db);
*/

#define UdmSQLQuery(db, R, query) _UdmSQLQuery(db, R, query, __FILE__, __LINE__)


#define UDM_SQLMON_DISPLAY_FIELDS	1
#define UDM_SQLMON_MSG_ERROR		1
#define UDM_SQLMON_MSG_PROMPT		2

typedef struct udm_sqlmon_param_st
{
  int flags;
  int colflags[10];
  size_t nqueries;
  size_t ngood;
  size_t nbad;
  FILE *infile;
  FILE *outfile;
  char *(*gets)(struct udm_sqlmon_param_st *prm, char *str, size_t size);
  int (*display)(struct udm_sqlmon_param_st *, UDM_SQLRES *sqlres);
  int (*prompt)(struct udm_sqlmon_param_st *, int msgtype, const char *msg);
  void* context_ptr;
} UDM_SQLMON_PARAM;

extern __C_LINK int __UDMCALL UdmSQLMonitor(UDM_AGENT *A, UDM_ENV *E, UDM_SQLMON_PARAM *prm);
extern __C_LINK const char* __UDMCALL UdmIndCmdStr(enum udm_indcmd cmd);

#endif
