      DOUBLE PRECISION FUNCTION XMNCLC(NFUN,P,NPAR,NPAR2,X,Y)
C
      IMPLICIT NONE
C
#include "mnusr.inc"
C
      INTEGER NFUN, NPAR, NPAR2
      DOUBLE PRECISION  P(*), COEF(30)
      REAL X, Y
C
      DOUBLE PRECISION  DPX,   POW,  DELX
     +                 ,ZBINC, Z2PI, ZS2PI, Z4L2, ZSPID2, ZS2
     +                 ,DZ1,   DZ2,  DZ3,   VAL,    VAL1, VAL2
     +                 ,ZA1,   ZA2,  ZF1,   ZF2,  ZB
     +                 ,CB1,   CB2,  ALFSAV, DEXPMX
      DOUBLE PRECISION  DXBIN
      DOUBLE PRECISION  DERF
      double precision  xmnargus
      REAL    DENLAN
      INTEGER I,NPAR1
*
      save cb1, cb2
C
C          ZBINC =  2.0 * SQRT( LN(2) / PI )
C          Z2PI  =  2.0 * PI
C          ZS2PI =  1 / SQRT(2*PI)
C          Z4L2  = -4.0 * LN(2)
C          ZSPID2=  SQRT(PI/2)
C          ZS2=     SQRT(2)
C
      DATA ZBINC  /  0.939437278699651D0 /
      DATA Z2PI   /  6.283185307179586D0 /
      DATA ZS2PI  /  0.398942280401433D0 /
      DATA Z4L2   / -2.772588722239781D0 /
      DATA ZSPID2 /  1.253314137315500D0 /
      DATA ZS2    /  1.414213562373095D0 /
      DATA DEXPMX / 50.0D0 /
      DATA ALFSAV / -1.0D31 /
C
      XMNCLC = 0.0D0
      DPX    = DBLE( X )
      DXBIN  = DBLE(XBINNM)
C
      GOTO (100,200,300,400,500,600,700,800,900,1000,1100,1200
     + ,1300,1400,1500,1600,1700,1800,1900,2000,2100,2200,2300
     + ,2400,2500,2600,2700,2800,2900,3000,3100,3200,3300,3400
     + ,3500,3600),NFUN
      RETURN
C
C     NFUN = 1   POLYNOMIAL
C
 100  CONTINUE
      POW = 1.0
      VAL = P(1)
      DO 110 I = 2, NPAR-1
          POW = POW * (DPX-P(NPAR))
          VAL = VAL + P(I) * POW
110   CONTINUE
      XMNCLC = DXBIN * VAL
      RETURN
C
C     NFUN = 2   EXPONENTIALLY FALLING
C
 200  CONTINUE
      VAL = -P(2) * ( DPX - P(3) )
      IF(DABS(VAL).LE.DEXPMX) XMNCLC = P(1) * DXBIN * DEXP( VAL )
      RETURN
C
C     NFUN = 3  2 STRAIGHT LINES SMOOTHLY JOINED BY A QUADRATIC
C
 300  CONTINUE
      DELX = P(5) - P(4)
      IF ( DPX .LE. P(4) ) THEN
          XMNCLC = P(1) + P(2) * (DPX - P(4))
      ELSE
          IF (DPX .GE. P(5)) THEN
              XMNCLC = P(1) + P(3) * ( DPX - P(5) ) +
     +               0.5 * DELX * ( P(2) + P(3) )
          ELSE
              POW  = (P(3) - P(2)) / ( DELX*2.0 )
              XMNCLC = P(1) + P(2) * ( DPX - P(4) ) +
     +               POW  * ( DPX - P(4) )**2
          ENDIF
      ENDIF
      XMNCLC = DXBIN * XMNCLC
      RETURN
C
C     NFUN = 4  CHEBYSHEV POLYNOMIAL WITH OVERALL NORMALIZATION
C
 400  CONTINUE
      DELX = DBLE((2.0*X - XMINNM - XMAXNM) / (XMAXNM - XMINNM))
      IF(DABS(DELX).GT.1.0D0) RETURN
      XMNCLC  = 1.0D0
      COEF(1) = 1.0D0
      DO 410 I = 2, NPAR
          IF(I.EQ.2) THEN
              COEF(2) = DELX
          ELSE
              COEF(I) = 2.0D0*DELX * COEF(I-1) - COEF(I-2)
          ENDIF
          XMNCLC = XMNCLC + P(I) * COEF(I)
 410  CONTINUE
      XMNCLC = P(1) * DXBIN * XMNCLC
      RETURN
C
C     NFUN = 5  LEGENDRE POLYNOMIAL
C
 500  CONTINUE
      DELX = DBLE((2.0*X - XMINNM - XMAXNM) / (XMAXNM - XMINNM))
      IF(ABS(DELX).GT.1.0) RETURN
      CALL XMNLEG( COEF, NPAR, DELX )
      XMNCLC = 1.0D0
      DO 510 I = 2, NPAR
          XMNCLC = XMNCLC + P(I) * COEF(I)
 510  CONTINUE
      XMNCLC = P(1) * DXBIN * XMNCLC
      RETURN
c
C     NFUN = 6 GAUSSIAN IN TERMS OF SIGMA
C
600   CONTINUE
      VAL = DXBIN * ZS2PI
      IF(P(3) .NE. 0.) THEN
          DELX = DPX - P(2)
          DZ1  = 1. / P(3)
          DZ2  = -0.5D0 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * DZ1 * VAL * P(1)
      ENDIF
      RETURN
C
C     NFUN = 7 GAUSSIAN IN TERMS OF FWHM
C
700   CONTINUE
      VAL = DXBIN * ZBINC
      IF(P(3) .NE. 0.) THEN
          DELX = DPX - P(2)
          DZ1  = 1. / P(3)
          DZ2  = Z4L2 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * DZ1 * VAL * P(1)
      ENDIF
      RETURN
C
C     NFUN = 8  LANDAU DISTRIBUTION CERN LIBRARY ROUTINE
C
800   CONTINUE
      DELX  = ( DPX - P(2) ) / P(3)
      IF(DELX.GT.-5.0) XMNCLC = DXBIN * P(1) * DBLE(DENLAN(SNGL(DELX)))
      RETURN
C
C     NFUN = 9  .... BREIT WIGNER
C
900   CONTINUE
      VAL = DXBIN / Z2PI
      XMNCLC = VAL * P(1) * P(3) / ( (DPX-P(2))**2 + P(3)**2/4. )
      RETURN
C
C     NFUN = 10  (X-A) * GAUSSIAN IN TERMS OF SIGMA
C
1000  CONTINUE
      VAL = DXBIN * ZS2PI
      IF(P(3) .NE. 0) THEN
          DELX = DPX - P(2)
          DZ1  = 1.0 / P(3)
          DZ2  = -0.5D0 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX)
     1     XMNCLC = DEXP(DZ2) * DZ1 * VAL * P(1) * (DPX - P(4))
      ENDIF
      RETURN
C
C     NFUN = 11  (X-A) * GAUSSIAN IN TERMS OF FWHM
C
1100  CONTINUE
      VAL = DXBIN * ZBINC
      IF(P(3) .NE. 0) THEN
          DELX = DPX - P(2)
          DZ1  = 1.0 / P(3)
          DZ2  = Z4L2 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX)
     1     XMNCLC = DEXP(DZ2) * DZ1 * VAL * P(1) * (DPX - P(4))
      ENDIF
      RETURN
C
C     NFUN = 12  PHASE SPACE LEPTON SPECTRUM
C
1200  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF ( VAL.LT.(1.0-DELX) ) THEN
          XMNCLC = P(1) * DXBIN * VAL * (1.0 - DELX - VAL) / (1 - VAL)
      ENDIF
      RETURN
C
C     NFUN = 13  V-A LEPTON SPECTRUM FOR B-->C
C
1300  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF ( VAL.LT.(1.0-DELX) ) THEN
          XMNCLC = P(1) * DXBIN * VAL**2 *
     +           ( (1. - DELX - VAL)**2 / (1-VAL)**3 ) *
     +           (2.*VAL**2 - VAL * (5.+DELX) + 3.*(1.+DELX) )
      ENDIF
      RETURN
C
C     NFUN = 14  V+A LEPTON SPECTRUM  B-->C
C
1400  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF( VAL.LT.(1.0-DELX) ) THEN
          XMNCLC = P(1) * DXBIN * VAL**2 * (1 - DELX - VAL)**2 / (1-VAL)
      ENDIF
      RETURN
C
C     NFUN = 15  LEPTON SPECTRUM FROM SPIN 0 - SPIN 0 TRANSITION
C
1500  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF ( VAL.LT.(1.0-DELX) ) THEN
          XMNCLC = P(1) * DXBIN * VAL**2 *
     +           (1. - DELX - VAL)**2 / (1-VAL)**2 *
     +           (1. + DELX - VAL)
      ENDIF
      RETURN
C
C     NFUN = 16  PHASE SPACE HADRON SPECTRUM
C
1600  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF ( VAL**2 .GE. 4. * DELX ) THEN
          XMNCLC = P(1) * DXBIN * DSQRT( VAL**2 - 4.*DELX )
      ENDIF
      RETURN
C
C     NFUN = 17  V-A OR V+A HADRON SPECTRUM
C
1700  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF ( VAL**2 .GE. 4.*DELX ) THEN
          XMNCLC = P(1) * DXBIN * DSQRT( VAL**2 - 4.*DELX ) *
     +           (3. * VAL * (1.+DELX) - 4.*DELX - 2.*VAL**2)
      ENDIF
      RETURN
C
C     NFUN = 18  HADRON SPECTRUM FROM SPIN 0 - SPIN 0 TRANSITION
C
1800  VAL  = DPX * P(4) / P(3)
      DELX = P(2)**2
      IF ( VAL**2 .GE. 4.*DELX ) THEN
          XMNCLC = P(1) * DXBIN * SQRT( VAL**2 - 4.*DELX ) *
     +           (2.*VAL**2 - 5.*DELX - 3.*DELX**2)
      ENDIF
      RETURN
C
C     NFUN = 19 TWO GAUSSIANS WITH AREA AND RATIO OF AREAS
C     AND MEAN AND DIFFERNENCE IN MEANS
C     AREAS ARE PARAMETERS 1 AND 4, MEANS ARE PARAMETERS 2 AND 5,
C     SIGMA ARE 3 AND 6
C
1900  CONTINUE
      VAL = DXBIN * ZS2PI
      DELX = DPX - P(2)
      IF(P(3) .NE. 0.) THEN
          DZ1  = 1.0D0 / P(3)
          DZ2  = -0.5D0 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = XMNCLC + DEXP(DZ2)*DZ1*VAL
     1     * P(1) * (1.0 - P(4))
      ENDIF
      DELX = DPX - P(2) - P(5)
      IF(P(3).NE.0. .AND. P(6).NE.0.) THEN
          DZ1  = 1.0D0 / (P(3) * P(6))
          DZ2  = -0.5D0 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = XMNCLC + DEXP(DZ2)*DZ1*VAL
     1     * P(1) * P(4)
      ENDIF
      RETURN
C
C     NFUN = 20 TWO GAUSSIANS WITH AREA AND RATIO OF AREAS
C     AND MEAN AND DIFFERNENCE IN MEANS
C     AREAS ARE PARAMETERS 1 AND 4, MEANS ARE PARAMETERS 2 AND 5,
C     FWHM ARE 3 AND 6
C
2000  CONTINUE
      VAL = DXBIN * ZBINC
      DELX = DPX - P(2)
      IF(P(3) .NE. 0.) THEN
          DZ1  = 1.0D0 / P(3)
          DZ2  = Z4L2 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = XMNCLC + DEXP(DZ2)*DZ1*VAL
     1     * P(1) * (1.0D0 - P(4))
      ENDIF
      DELX = DPX - P(2) - P(5)
      IF(P(3).NE.0.0D0 .AND. P(6).NE.0.0D0) THEN
          DZ1  = 1.0D0 / (P(3) * P(6))
          DZ2  = Z4L2 * ( DELX*DZ1 )**2
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = XMNCLC + DEXP(DZ2)*DZ1*VAL
     1     * P(1) * P(4)
      ENDIF
      RETURN
C
C     NFUN = 21 BIFURCATED GAUSSIAN IN TERMS OF SIGMA
C
 2100 CONTINUE
      VAL = DXBIN * ZS2PI
      DELX = DPX - P(2)
      IF(DELX .LE. 0.0D0) THEN
        IF(P(3) .NE. 0.0D0) THEN
            DZ1  = 1.0D0 / P(3)
            DZ2  = -0.5D0 * ( DELX*DZ1 )**2
            ZA1 = (2.0D0*P(1)*P(3))/(P(3) + P(4))
            IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * DZ1 * VAL * ZA1
        ENDIF
      ELSE
        IF(P(4) .NE. 0.0D0) THEN
            DZ1  = 1.0D0 / P(4)
            DZ2  = -0.5D0 * ( DELX*DZ1 )**2
            ZA2 = 2.0D0*P(1)*P(4)/(P(3)+P(4))
            IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * DZ1 * VAL * ZA2
        ENDIF
      ENDIF
      RETURN
C
C     NFUN = 22 BIFURCATED GAUSSIAN IN TERMS OF FWHM
C
2200  CONTINUE
      VAL = DXBIN * ZBINC
      DELX = DPX - P(2)
      IF(DELX .LE. 0.0D0) THEN
        IF(P(3) .NE. 0.0D0) THEN
            DZ1  = 1.0D0 / P(3)
            DZ2  = Z4L2 * ( DELX*DZ1 )**2
            ZA1 = (2.0D0*P(1)*P(3))/(P(3) + P(4))
            IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * DZ1 * VAL * ZA1
        ENDIF
      ELSE
        IF(P(4) .NE. 0.0D0) THEN
            DZ1  = 1.0D0 / P(4)
            DZ2  = Z4L2 * ( DELX*DZ1 )**2
            ZA2 = 2.0D0*P(1)*P(4)/(P(3)+P(4))
            IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * DZ1 * VAL * ZA2
        ENDIF
      ENDIF
      RETURN
C
C     NFUN = 23 SUM OF 2 BIFURCATED GAUSSIANS (SIGMA)
C
2300  CONTINUE
      DELX = DPX - P(2)
      ZA1 = P(1) * (1.0 - P(5))
      ZA2 = P(1) * P(5)
      IF(DELX.LE.0.0) THEN
          ZF1 = P(3)
          ZF2 = P(6) * P(3)
          ZB  = 2.0D0 / (1.0D0 + P(4))
      ELSE
          ZF1 = P(4) * P(3)
          ZF2 = P(6) * ZF1
          ZB  = 2.0D0 * P(4) / (1.0D0 + P(4))
      ENDIF
      IF(ZF1 .NE. 0.0D0) THEN
          DZ1  = 1.0D0 / ZF1
          DZ2  = -0.5D0 * ( DELX*DZ1 )**2
          VAL = ZA1 * ZB * DXBIN * DZ1 * ZS2PI
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * VAL
      ENDIF
C
      IF(ZF2 .NE. 0.0D0) THEN
          DZ1  = 1.0D0 / ZF2
          DZ2  = -0.5D0 * ( DELX*DZ1 )**2
          VAL = ZA2 * ZB * DXBIN * DZ1 * ZS2PI
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = XMNCLC + DEXP(DZ2) * VAL
      ENDIF
C
      RETURN
C
C     NFUN = 24 SUM OF 2 BIFURCATED GAUSSIANS (FWHM)
C
2400  CONTINUE
      DELX = DPX - P(2)
      ZA1 = P(1) * (1.0 - P(5))
      ZA2 = P(1) * P(5)
      IF(DELX.LE.0.0) THEN
          ZF1 = P(3)
          ZF2 = P(6) * P(3)
          ZB  = 2.0 / (1.0 + P(4))
      ELSE
          ZF1 = P(4) * P(3)
          ZF2 = P(6) * ZF1
          ZB  = 2.0 * P(4) / (1.0 + P(4))
      ENDIF
      IF(ZF1 .NE. 0.0D0) THEN
          DZ1  = 1.0D0 / ZF1
          DZ2  = Z4L2 * ( DELX*DZ1 )**2
          VAL = ZA1 * ZB * DXBIN * DZ1 * ZBINC
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = DEXP(DZ2) * VAL
      ENDIF
C
      IF(ZF2 .NE. 0.0D0) THEN
          DZ1  = 1.0D0 / ZF2
          DZ2  = Z4L2 * ( DELX*DZ1 )**2
          VAL = ZA2 * ZB * DXBIN * DZ1 * ZBINC
          IF(DABS(DZ2).LE.DEXPMX) XMNCLC = XMNCLC + DEXP(DZ2) * VAL
      ENDIF
C
      RETURN
C
C     NFUN = 25 ARGUS BACKGROUND
C
2500  CONTINUE
      xmnclc = dxbin * xmnargus(p,npar,dpx,dexpmx)
C
      RETURN
C
C     NFUN = 26 POLYNOMIAL * EXPONENTIAL OF A POLYNOMIAL
C
2600  CONTINUE
      NPAR1 = NPAR - NPAR2 - 2
      DELX  = DPX - P(2)
      POW   = 1.0
      VAL1  = 1.0
      DO 2610 I = 3, NPAR1+2
          POW  = POW * DELX
          VAL1 = VAL1 + P(I) * POW
2610  CONTINUE
C
      POW  = 1.0
      VAL2 = 0.0
      DO 2620 I=NPAR1+3,NPAR
          POW  = POW * DELX
          VAL2 = VAL2 + P(I) * POW
2620  CONTINUE
      VAL = 0.0D0
      IF(DABS(VAL2).LE.DEXPMX) VAL = DEXP(VAL2)
C
      XMNCLC = P(1) * DXBIN * VAL1 * VAL
      RETURN
C
C     NFUN = 27 TRIGONOMETRIC FUNCTION
C
2700  CONTINUE
      XMNCLC = P(1) * DXBIN * DSIN(P(3)*DPX) +
     + P(2) * DXBIN * DCOS(P(3)*DPX)
      RETURN
C
C     NFUN = 28 Crystal Ball Photon Line Shape
C     Gives a Gaussian shape near the mean with a low energy tail
C
2800  CONTINUE
      IF(P(3).EQ.0.0D0 .OR. P(4).EQ.0.0D0) RETURN
      DELX = DPX - (P(2) - P(4)*P(3))
      IF(DELX.GT.0.0D0) THEN
          VAL = -0.5D0*((P(2)-DPX)/P(3))**2
          IF(VAL.GT.-dexpmx) XMNCLC = P(1) * DEXP(VAL)
      ELSE
          VAL1 = P(5) / P(4)
          VAL2 = (P(2)-DPX)/P(3) + VAL1 - P(4)
          VAL  = -0.5D0*P(4)**2
          IF(VAL.GT.-dexpmx) XMNCLC = P(1) *
     +     (VAL1**P(5)) * DEXP(VAL) / VAL2**P(5)
      ENDIF
C
      IF (P(4).NE.ALFSAV) THEN
        CB1= 0.0D0
        ALFSAV= P(4)
        VAL1  = -0.5D0*P(4)**2
        IF(VAL1.GT.-dexpmx) CB1= DEXP(VAL1)
        CB2= ZSPID2*( 1.D0+DERF(P(4)/ZS2) )
      ENDIF
      
      VAL  = 0.0D0
      VAL2 = P(4) * (P(5)-1.0D0)
      IF (VAL2.NE.0.0) VAL= DXBIN / P(3) / ( CB1*P(5)/VAL2 + CB2 )
C
      XMNCLC= XMNCLC * VAL
      RETURN
C
C     NFUN = 29 Power law function
C
2900  CONTINUE
      IF(P(3).NE.0.0D0) XMNCLC = P(1) * DXBIN * (DPX/P(3))**P(2)
      RETURN
C
C     NFUN = 30 Exponential for lifetimes - only if XX > 0.0
C
 3000 CONTINUE
      VAL = -P(2) * ( DPX - P(3) )
      IF(DPX.GE.P(3) .AND. -VAL.LE.DEXPMX)
     + XMNCLC = P(1) * DABS(P(2)) * DXBIN * DEXP( VAL )
      RETURN
C
C     NFUN = 31 Original CHEBYSHEV POLYNOMIAL
C
3100  CONTINUE
      DELX = DBLE((2.0*X - XMINNM - XMAXNM) / (XMAXNM - XMINNM))
      IF(DABS(DELX).GT.1.0D0) RETURN
      DO 3110 I = 1, NPAR
          IF(I.EQ.1) THEN
              COEF(1) = 1.0D0
          ELSEIF(I.EQ.2) THEN
              COEF(2) = DELX
          ELSE
              COEF(I) = 2.0D0*DELX * COEF(I-1) - COEF(I-2)
          ENDIF
          XMNCLC = XMNCLC + P(I) * COEF(I)
3110  CONTINUE
      XMNCLC = DXBIN * XMNCLC
      RETURN
C
C     NFUN = 32  Original LEGENDRE POLYNOMIAL
C
 3200 CONTINUE
      DELX = DBLE((2.0*X - XMINNM - XMAXNM) / (XMAXNM - XMINNM))
      IF(ABS(DELX).GT.1.0) RETURN
      CALL XMNLEG( COEF, NPAR, DELX )
      DO 3210 I = 1, NPAR
          XMNCLC = XMNCLC + P(I) * COEF(I)
 3210 CONTINUE
      XMNCLC = DXBIN * XMNCLC
      RETURN
C
C     NFUN = 33 POSITIVE GOING FERMI FUNCTION
C
3300  CONTINUE
      DELX = P(2) - DPX
      IF(P(3).NE.0.0D0) THEN
          IF(-DELX/P(3).LE.-DEXPMX) THEN
              XMNCLC = 0.0D0
          ELSEIF(-DELX/P(3).GT.DEXPMX) THEN
              XMNCLC = P(1)
          ELSE
              XMNCLC = P(1) / (1.0D0 + DEXP(DELX / P(3)))
          ENDIF
      ENDIF
      XMNCLC = DXBIN * XMNCLC
      RETURN
C
C     NFUN = 34 NEGATIVE GOING FERMI FUNCTION
C
3400  CONTINUE
      DELX = DPX - P(2)
      IF(P(3).NE.0.0D0) THEN
          IF(DELX/P(3).LT.-DEXPMX) THEN
              XMNCLC = P(1)
          ELSEIF(DELX/P(3).GT.DEXPMX) THEN
              XMNCLC = 0.0D0
          ELSE
              XMNCLC = P(1) / (1.0D0 + DEXP(DELX / P(3)))
          ENDIF
      ENDIF
      XMNCLC = DXBIN * XMNCLC
      RETURN
C
C     NFUN = 35 Threshold Function
C
 3500 CONTINUE
      DELX = DPX - P(2)
      IF(DELX.GT.0.0D0) THEN
         VAL1 = DELX**P(3)
         VAL2 = P(4)*DELX + P(5)*DELX*DELX
         IF(VAL2.LT.DEXPMX) THEN
             XMNCLC = P(1) * DXBIN * VAL1 * DEXP(VAL2)
         ENDIF
      ENDIF
      RETURN
C
C     NFUN = 36 Reversed Crystal Ball Photon Line Shape
C     Gives a Gaussian shape near the mean with a high energy tail
C
3600  CONTINUE
      IF(P(3).EQ.0.0D0 .OR. P(4).EQ.0.0D0) RETURN
      DELX = DPX - (P(2) + P(4)*P(3))
      IF(DELX.LT.0.0D0) THEN
          VAL = -0.5D0*((DPX-P(2))/P(3))**2
          IF(VAL.GT.-dexpmx) XMNCLC = P(1) * DEXP(VAL)
      ELSE
          VAL1 = P(5) / P(4)
          VAL2 = (-(P(2)-DPX)/P(3)) + VAL1 - P(4)
          VAL  = -0.5D0*P(4)**2
          IF(VAL.GT.-dexpmx) XMNCLC = P(1) *
     +     (VAL1**P(5)) * DEXP(VAL) / (VAL2**P(5))
      ENDIF
C
      IF (P(4).NE.ALFSAV) THEN
        CB1= 0.0D0
        ALFSAV= P(4)
        VAL1  = -0.5D0*P(4)**2
        IF(VAL1.GT.-80.0D0) CB1= DEXP(VAL1)
        CB2= ZSPID2*( 1.D0+DERF(P(4)/ZS2) )
      ENDIF
      
      VAL  = 0.0D0
      VAL2 = P(4) * (P(5)-1.0D0)
      IF (VAL2.NE.0.0) VAL= DXBIN / P(3) / ( CB1*P(5)/VAL2 + CB2 )
C
      XMNCLC= XMNCLC * VAL
      RETURN
C
      END
