//
// =========================================================================
//
//
//     MWater is a MMDB-based utility for moving the symmetry-mates of water
//  (solvent) molecules, contacting the protein chains, into symmetry
//  X,Y,Z of the primary cell. The newly generated molecules may be either
//  a) grouped into a single chain (original water molecules are left
//  untouched), or b) all molecules may be regrouped into chains surrounding
//  the protein chains plus (possibly) a chain of water molecules that do
//  not contact any of the protein's chains.
//     The newly generated molecules are arranged into residues having the
//  same sequence numbers and insertion codes, as their original ancestors.
//  The residue name, however, is user-defined and therefore may change.
//     MWater never removes or renames the original water molecules, however
//  it may rearrange them into different chains if option (b) is chosen from
//  above.
//
//  E. Krissinel,  10 December 2001
//
//
// -------------------------------------------------------------------------
//  SGI make:
//  cc -o mwater -I mmdb100/src mwater.cpp cparser.c ccplib.c \
//                  mmdb100/mmdb.a -lm -lC
//
//  where 'mmdb100' is path to MMDB
//
// -------------------------------------------------------------------------
//
//  Command line:
//
//   mwater xyzin pdbfile1 xyzout pdbfile2 <<eof
//   ? keyword  parameter(s)
//   ? keyword  parameter(s)
//   ? .......  .........
//   ? eof
//
// -------------------------------------------------------------------------
//
//   Input syntax:
//
//   Keyword    Parameter(s)
//  ~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//   molecule   selection of protein atoms; by default, selects all
//              but solvent molecules (ADE,CYT,GUA,INO,THY,URA,WAT,HOH,
//              TIP,H2O,DOD,MOH), which is equivalent to
//
//              molecule "(!ADE,CYT,GUA,INO,THY,URA,WAT,HOH,TIP,H2O,DOD,MOH)"
//
//   water      selection of water atom; by default selects all solvent
//              molecules, which is equivalent to
//
//              water (ADE,CYT,GUA,INO,THY,URA,WAT,HOH,TIP,H2O,DOD,MOH)
//
//   mindist    minimal contact distance (in A), default 0.73 (covalent
//              radius of oxygen). This distance is used for a) finding 
//              water molecules in the proximity of protein chains and
//              b) for checking that moved molecules do not overlap.
//
//   maxdist    maximal contact distance (in A), default 4.0. This
//              distance is the farest boundary for water-protein
//              distance still considered as 'proximity' or 'contact'.
//
//   wresidue   name of solvent residue to be assigned to the newly
//              generated molecules; default is HOH. None of original
//              water residues are renamed.
//
//   wchain     [auto|chID|rearrange]
//              ('auto' default). The chain ID that should be assigned
//              to *newly* generated water molecules. In 'auto' regime,
//              the chain ID is being picked automatically. In 'rearrange'
//              regime, *all* water molecules are rearranged over
//              newly generated chains by proximity to the protein
//              chains
//
//   sort       [off|source|target|distance]  [inc|dec]
//              ('off' and 'inc' default). This parameter specifies
//              the subject and order for sorting the contacts on
//              output. For example, 'sort source dec' means sorting
//              by decreasing index of the source atoms (index is
//              essentially the atom's serial number in a correct PDB
//              file). Subject 'off' (default) means no sorting.
//
//   cells      [off|0|1|2]
//              ('2' default). If cells is set to 'off', the program
//              seeks contacts only between the atoms found in the
//              coordinate file. Other values induce construction of
//              unit cell(s) and looking for contacts also between source
//              atoms and target atoms generated in the cell(s).
//                 0  generates only one (primary) unit cell, in which
//                    the source and target atoms are originally found
//                 1  generates the primary cell +/- 1 cell in all
//                    directions (27 cells in total)
//                 2  generates the primary cell +/- 2 cells in all
//                    directions (125 cells in total)
//
//   symmetry   input of the space group symmetry name, e.g. 'P 21 21 21'
//              (without quotation marks, spaces _are_ significant).
//              This parameter is mandatory if coordinate file does not
//              specify the space group symmetry.
//
//   geometry   a b c alpha beta gamma
//              input of the unit cell dimensions (space-separated
//              real numbers). This parameter is mandatory if coordinate
//              file does not specify the cell parameters.
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//   Specification of the selection sets (parameters for keywords
//   'source' and 'target'):
//
//   /mdl/chn/s1.i1-s2.i2/at[el]:aloc | selcode
//   /mdl/chn/*(res).ic/at[el]:aloc | selcode
//
//   where no spaces are allowed within the selection line (until the
//   optional " | selcode". The slashes separate the hierarchical levels
//   of models, chains, residues and atoms.
//
//   Notations:
//
//    mdl   - the model's serial number or 0 or '*' for any model
//            (default).
//    chn   - the chain ID or list of chain IDs like 'A,B,C' or
//            '*' for any chain (default).
//    s1,s2 - the starting and ending residue sequence numbers
//            or '*' for any sequence number (default).
//    i1,i2 - the residues insertion codes or '*' for any
//            insertion code. If the sequence number other than  
//            '*' is specified, then insertion code defaults to ""
//            (no insertion code), otherwise the default is '*'.
//    res   - residue name or list of residue names like 'ALA,SER'
//            or '*' for any residue name (default)
//    at    - atom name or list of atom names like 'CA,N1,O' or
//            '*' for any atom name (default)
//    el    - chemical element name or list of chemical element
//            names like 'C,N,O', or '*' for any chemical element
//            name (default)
//    aloc  - the alternative location indicator or list of
//            alternative locations like 'A,B,C', or '*' for any
//            alternate location. If the atom name and chemical
//            element name is specified (both may be '*'), then
//            the alternative location indicator defaults to ""
//            (no alternate location), otherwise the default is
//             '*'.
//
//   Values for chain IDs, residue names, atom names, chemical element
//   names and alternative location indicators may be negated by
//   prefix '!'. For example, '!A,B,C' for the list of chain names
//   means 'any chain ID but A,B,C'.
//
//    selcode - code for repeating selections:
//           OR   logical "or"  with previous selection (default)
//           AND  logical "and" with previous selection
//           XOR  logical "xor" with previous selection
//
//   selcode is useful only when you cannot achieve the desired
//   selection by single source/target statements.
//
//   Generally, any hierarchical element as well as the selection
//   code may be omitted, in which case it is replaced for
//   default (see above). This makes the following examples valid:
//
//    *                   select all atoms
//    /1                  select all atoms in model 1
//    A,B                 select all atoms in chains A and B in
//                        all models
//    /1//                select all atoms in chain without chainID
//                        in model 1
//    /*/,A,B/            select all atoms in chain without chainID,
//                        chain A and B in all models
//    33-120              select all atoms in residues 33. to 120.
//                        in all chains and models
//    A/33.A-120.B        select all atoms in residues 33.A to
//                        120.B in chain A only, in all models
//    A/33.-120.A/[C]     select all carbons in residues 33. to
//                        120.A in chain A, in all models
//    CA[C]               select all C-alphas in all
//                        models/chains/residues
//    A//[C]              select all carbons in chain A, in all models
//    (!ALA,SER)          select all atoms in any residues but
//                        ALA and SER, in all models/chains
//    /1/A/(GLU)/CA[C]    select all C-alphas in GLU residues of
//                        chain A, model 1
//    /1/A/*(GLU)./CA[C}: same as above
//    [C]:,A              select all carbons without alternative
//                        location indicator and carbons in alternate
//                        location A
//
//    NOTE: if a selection contains comma(s), the selection sentence must
// be embraced by quotation marks, which indicate to the input parser that
// the sentence is a single input parameter rather than a set of comma-
// separated arguments.
//
// -------------------------------------------------------------------------
//
//  Examples:
//
//  1. Generate symmetry-mated water molecules surrounding protein chains:
//
//     mwater  xyzin rnase.pdb xyzout wrnase.pdb <<eof
//     ? molecule  "(!HOH)"  ! only HOH water molecules are in the file
//     ? water     (HOH)     ! analyse all water molecules
//     ? symmetry  P 21 21 21
//     ? wresidue  WAT       ! name new residues as WAT
//     ? wchain    X         ! arrange new molecules into chain X
//     ? eof
//
//  2. Same as above, but rearrange all molecules into chains contacting
//     the protein's chains:
//
//     mwater  xyzin rnase.pdb xyzout wrnase.pdb <<eof
//     ? molecule  "(!HOH)"  ! only HOH water molecules are in the file
//     ? water     (HOH)     ! analyse all water molecules
//     ? symmetry  P 21 21 21
//     ? wresidue  HOH       ! name new residues as HOH
//     ? wchain    rearrange ! rearrange molecules into contacting chains
//     ? eof
//
//  3. Same as 2, but generate water molecules contacting chain A only:
//
//     mwater  xyzin rnase.pdb xyzout wrnase.pdb <<eof
//     ? molecule  A         ! consider protein chain A only
//     ? water     (HOH)     ! analyse all water molecules
//     ? symmetry  P 21 21 21
//     ? wresidue  HOH       ! name new residues as HOH
//     ? wchain    rearrange ! rearrange molecules into contacting chains
//     ? eof
// 
//
// =========================================================================
//


#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#define __CPlusPlus

#ifndef  __CCPLib__
#include "ccplib.h"
#endif

#ifndef  __MW_Class__
#include "mw_class.h"
#endif



// -------------------  Main program  --------------------------

int main ( int argc, char ** argv, char ** env )  {
CMWClass MWClass;
int rc;

  //  1.  General CCP4 initializations
  ccp4fyp         ( argc, argv );
  ccp4ProgramName ( argv[0] );
  ccp4rcs         ( argv[0] );

  //  2.  Make routine initializations, which must always be done
  //      before working with MMDB
  InitMatType();

  rc = MWClass.Job ( argc,argv );

  if (!rc)  ccperror ( 0,"Normal termination" );
  return  rc;

}

