//
//  =================================================================
//
//    10.10.01   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  MW_Class <interface>
//       ~~~~~~~~~
//  **** Classes    :  CMWClass ( mwater functional class )
//       ~~~~~~~~~~~~  
//
//  (C) E.Krissinel'  2001
//
//  =================================================================
//

#ifndef __MW_Class__
#define __MW_Class__

#ifndef  __MMDB_Manager__
#include "mmdb_manager.h"
#endif


//  =========================   CMWClass   ==========================


DefineClass(CMWClass);

class CMWClass : public CMMDBManager  {

  public :

    CMWClass ();
    ~CMWClass();

    int Job ( int argc, pstr * argv );

  protected :
    int       selMolecule,selWater;
    realtype  minDist,maxDist;
    int       sortmode,ncells;
    ChainID   wChainID;
    ResName   wResName;
    PPCAtom   Molecule,Water;
    int       nMolAtoms,nWatAtoms;
    PSContact contact;
    ivector   contstat;
    int       ncontacts;
    pstr *    symOpTitle;
    int       nSymOps;

    void  initMWClass     ();
    int   readCoorFile    ();
    int   parseInput      ();
    int   checkInput      ();
    void  printTMatrices  ();
    void  freeContacts    ();
    void  freeSymOpTitles ();
    void  findContacts    ();
    void  printContacts   ();
    void  generateWaters  ();
    void  arrangeWaters   ();
    void  writeCoorFile   ();
    long  makeGroupID     ( int i, int j, int k, int m );
    int   hesh4           ( int i, int j, int k, int m );
    void  parseGroupID    ( long group,
                            int & i, int & j, int & k, int & m );
    void  CopyAtom        ( PCAtom atom, PCChain chain,
                            const ResName rname, mat44 * TMatrix );

};


#endif
