//  $Id: mmdb_title.h,v 1.6 2005/12/19 16:51:28 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    30.03.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  MMDB_Title <interface>
//       ~~~~~~~~~
//  **** Project :  MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//  **** Classes :  CTitleContainer  (container of title classes)
//       ~~~~~~~~~  CObsLine
//                  CTitleLine
//                  CCaveat
//                  CCompound
//                  CSource
//                  CKeyWords
//                  CExpData
//                  CAuthor
//                  CRevData
//                  CSupersede
//                  CJournal
//                  CRemark
//                  CMMDBTitle       ( MMDB title section )
//
//  E. Krissinel 2000-2003
//
//  =================================================================
//

#ifndef __MMDB_Title__
#define __MMDB_Title__


#ifndef __Stream__
#include "stream_.h"
#endif

#ifndef  __MMDB_Defs__
#include "mmdb_defs.h"
#endif

#ifndef  __MMDB_Utils__
#include "mmdb_utils.h"
#endif

#ifndef  __MMDB_MMCIF__
#include "mmdb_mmcif.h"
#endif


//  ====================  CTitleContainer  ======================

DefineClass(CTitleContainer)
DefineStreamFunctions(CTitleContainer)

class CTitleContainer : public CClassContainer  {

  public :

    CTitleContainer  () : CClassContainer() {}
    CTitleContainer  ( RPCStream Object )
                        : CClassContainer ( Object ) {} 
    ~CTitleContainer () {}

    PCContainerClass MakeContainerClass ( int ClassID );

};


//  ==================  CObsLine  ========================

DefineClass(CObsLine)
DefineStreamFunctions(CObsLine)

class CObsLine : public CContainerClass  {

  public :

    Date   repDate;    //  date of replacement
    IDCode idCode;     //  ID code of replaced entry
    IDCode rIdCode[8]; //  ID codes of entries that replaced this one

    CObsLine ();
    CObsLine ( const pstr S );
    CObsLine ( RPCStream Object );
    ~CObsLine();

    void  PDBASCIIDump    ( pstr S, int N   );
    void  MakeCIF         ( PCMMCIFData CIF, int N );
    int   ConvertPDBASCII ( const pstr S );
    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
    int   GetClassID      () { return ClassID_ObsLine; }

    void  Copy  ( PCContainerClass ObsLine );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :
    
    void InitObsLine();

};


//  ====================  CTitleLine  =====================

DefineClass(CTitleLine)
DefineStreamFunctions(CTitleLine)

class CTitleLine : public CContString  {

  public :

    CTitleLine ();
    CTitleLine ( const pstr S );
    CTitleLine ( RPCStream Object );
    ~CTitleLine();

    int   ConvertPDBASCII ( const pstr S );
    void  PDBASCIIDump    ( pstr S, int N );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }
    int   GetClassID      () { return ClassID_TitleLine; }

//    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
//    void  MakeCIF         ( PCMMCIFData CIF, int N        );
//    void  Copy  ( PCContainerClass TitleLine );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitTitleLine();

};


//  ====================  CCaveat  =====================

DefineClass(CCaveat)
DefineStreamFunctions(CCaveat)

class CCaveat : public CContString  {

  public :

    IDCode idCode;   //  ID code of the entry

    CCaveat ();
    CCaveat ( const pstr S );
    CCaveat ( RPCStream Object );
    ~CCaveat();

    void  PDBASCIIDump    ( pstr S, int N );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }
    void  MakeCIF         ( PCMMCIFData CIF, int N );
    int   ConvertPDBASCII ( const pstr S );
    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
    int   GetClassID      () { return ClassID_CAVEAT; }

    void  Copy  ( PCContainerClass Caveat );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitCaveat();

};


//  ====================  CCompound  =====================

DefineClass(CCompound)
DefineStreamFunctions(CCompound)

class CCompound : public CContString  {

  public :

    CCompound ();
    CCompound ( const pstr S );
    CCompound ( RPCStream Object );
    ~CCompound();

    void  PDBASCIIDump    ( pstr S, int N );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }
    int   ConvertPDBASCII ( const pstr S );
    int   GetClassID      () { return ClassID_Compound; }

//    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
//    void  MakeCIF         ( PCMMCIFData CIF, int N        );
//    void  Copy  ( PCContainerClass Compound );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :
    
    void InitCompound();

};


//  ====================  CSource  =====================

DefineClass(CSource)
DefineStreamFunctions(CSource)

class CSource : public CContString  {

  public :

    CSource ();
    CSource ( const pstr S );
    CSource ( RPCStream Object );
    ~CSource();

    void  PDBASCIIDump    ( pstr S, int N );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }
    int   ConvertPDBASCII ( const pstr S );
    int   GetClassID      () { return ClassID_Source; }

//    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
//    void  MakeCIF         ( PCMMCIFData CIF, int N        );
//    void  Copy  ( PCContainerClass Source );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitSource();

};


//  ====================  CKeyWords  =====================

DefineClass(CKeyWords)
DefineStreamFunctions(CKeyWords)

class CKeyWords : public CStream  {

  public :

    int      nKeyWords;     // number of key words
    psvector KeyWord;       // key word array

    CKeyWords ();
    CKeyWords ( const pstr S );
    CKeyWords ( RPCStream Object );
    ~CKeyWords();

    void  Delete          ();

    void  PDBASCIIDump    ( RCFile f );
    void  MakeCIF         ( PCMMCIFData CIF );

    int   ConvertPDBASCII ( const pstr S );
    void  GetCIF          ( PCMMCIFData CIF );

    void  Copy  ( PCKeyWords KeyWords );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    Boolean Cont;

    void  Init();

};


//  ====================  CExpData  =====================

DefineClass(CExpData)
DefineStreamFunctions(CExpData)

class CExpData : public CContString  {

  public :

    CExpData ();
    CExpData ( const pstr S );
    CExpData ( RPCStream Object );
    ~CExpData();

    void  PDBASCIIDump    ( pstr S, int N );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }

    int   ConvertPDBASCII ( const pstr S );
    int   GetClassID      () { return ClassID_ExpData; }

//    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
//    void  MakeCIF         ( PCMMCIFData CIF, int N        );
//    void  Copy  ( PCContainerClass ExpData );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :
    
    void InitExpData();

};


//  ====================  CAuthor  =====================

DefineClass(CAuthor)
DefineStreamFunctions(CAuthor)

class CAuthor : public CContString  {

  public :

    CAuthor ();
    CAuthor ( const pstr S );
    CAuthor ( RPCStream Object );
    ~CAuthor();

    void  PDBASCIIDump    ( pstr S, int N   );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }

    int   ConvertPDBASCII ( const pstr S );
    int   GetClassID      () { return ClassID_Author; }

//    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
//    void  MakeCIF         ( PCMMCIFData CIF, int N        );
//    void  Copy  ( PCContainerClass Author );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitAuthor();

};


//  ====================  CRevData  =====================

DefineClass(CRevData)
DefineStreamFunctions(CRevData)

#define REVDAT_WARN_MODNUM   0x00000001
#define REVDAT_WARN_MODTYPE  0x00000002

class CRevData : public CContainerClass  {

  public :

    int     modNum;
    Date    modDate;
    char    modId[13];
    int     modType;
    RecName record[4];
    word    Warning;

    CRevData ();
    CRevData ( const pstr S );
    CRevData ( RPCStream Object );
    ~CRevData();

    void  PDBASCIIDump    ( pstr S, int N );
    void  MakeCIF         ( PCMMCIFData CIF, int N );

    int   ConvertPDBASCII ( const pstr S );
    void  GetCIF          ( PCMMCIFData CIF, int & Signal );

    int   GetClassID      () { return ClassID_RevData; }

    void  Copy  ( PCContainerClass RevData );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitRevData();

};


//  ==================  CSupersede  ========================

DefineClass(CSupersede)
DefineStreamFunctions(CSupersede)

class CSupersede : public CContainerClass  {

  public :

    Date   sprsdeDate;  //  date of supersede
    IDCode idCode;      //  ID code of the entry
    IDCode sIdCode[8];  //  ID codes of superseded entries

    CSupersede ();
    CSupersede ( const pstr S );
    CSupersede ( RPCStream Object );
    ~CSupersede();

    void  PDBASCIIDump    ( pstr S, int N );
    void  MakeCIF         ( PCMMCIFData CIF, int N );

    int   ConvertPDBASCII ( const pstr S );
    void  GetCIF          ( PCMMCIFData CIF, int & Signal );

    int   GetClassID      () { return ClassID_Supersede; }

    void  Copy  ( PCContainerClass Supersede );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :
    
    void InitSupersede();

};


//  ====================  CJournal  =====================

DefineClass(CJournal)
DefineStreamFunctions(CJournal)

class CJournal : public CContString  {

  public :

    CJournal ();
    CJournal ( const pstr S );
    CJournal ( RPCStream Object );
    ~CJournal();

    void  PDBASCIIDump    ( pstr S, int N );
    Boolean PDBASCIIDump1 ( RCFile f ) { return False; }

    int   ConvertPDBASCII ( const pstr S );
    int   GetClassID      () { return ClassID_Journal; }

//    void  GetCIF          ( PCMMCIFData CIF, int & Signal );
//    void  MakeCIF         ( PCMMCIFData CIF, int N        );
//    void  Copy  ( PCContainerClass Journal );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitJournal();

};


//  ====================  CRemark  =====================

DefineClass(CRemark)
DefineStreamFunctions(CRemark)

class CRemark : public CContainerClass  {

  public :

    int  remarkNum;  // remark id
    pstr Remark;     // remark line

    CRemark ();
    CRemark ( const pstr S );
    CRemark ( RPCStream Object );
    ~CRemark();

    void  PDBASCIIDump    ( pstr S, int N );
    void  MakeCIF         ( PCMMCIFData CIF, int N );

    int   ConvertPDBASCII ( const pstr S );
    void  GetCIF          ( PCMMCIFData CIF, int & Signal );

    int   GetClassID      () { return ClassID_Remark; }

    void  Copy  ( PCContainerClass RemarkClass );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected :

    void InitRemark();

};


//  =================  CMMDBTitle  =======================

DefineClass(CMMDBTitle)
DefineStreamFunctions(CMMDBTitle)

class CMMDBTitle : public CStream  {

  friend class CModel;
  friend class CChain;
  friend class CMMDBFile;

  public :

    CMMDBTitle ();
    CMMDBTitle ( RPCStream Object );
    ~CMMDBTitle();

    void  FreeMemory();

    // Fills the PDB file header
    void  SetHeader ( const pstr Classification, // any length is Ok
                      const pstr DepDate,    // DD-MMM-YYYY
                      const pstr ID_Code );  // not more than 11 chars

    // Interprets the ASCII PDB line belonging to the title section
    // and fills the corresponding fields.
    //   Returns zero if the line was converted, otherwise returns a
    // non-negative value of Error_XXXX.
    //   PDBString must be not shorter than 81 characters.
    int   ConvertPDBString ( pstr PDBString );

    // MakePDBString() makes the ASCII PDB HEADER line from the
    // class data. PDBString must be not shorter than 81 characters.
    void  MakePDBHeaderString ( pstr PDBString );

    // GetStructureTitle() returns the contents of TITLE record
    // unfolded into single line. If Title is missing, returns
    // contents of COMPND(:MOLECULE). If COMPND is missing, returns
    // HEADER. If Header is missing, returns PDB code. If no PDB
    // code is there, returns "Not available".
    pstr  GetStructureTitle ( pstr & S );

    PCTitleContainer GetRemarks();

    void  PDBASCIIDump ( RCFile      f   );
    void  MakeCIF      ( PCMMCIFData CIF );

    //   GetCIF(..) returns the same code as ConvertPDBString(..)
    // save for Error_WrongSection
    int   GetCIF       ( PCMMCIFData CIF );

    pstr   GetIDCode() { return idCode; }
    Boolean GetCol73() { return col73;  }
    void  TrimInput ( pstr PDBString );

    void  Copy  ( PCMMDBTitle TS );  // if TS is NULL, then empties
                                     // the class

    void  write ( RCFile f );    // writes header to PDB binary file
    void  read  ( RCFile f );    // reads header from PDB binary file

  protected :

    //   Header data
    pstr    classification;  // classification of the molecule
    Date    depDate;         // deposition date DD-MMM-YYYY
    IDCode  idCode;          // unique PDB identifier
    Boolean col73;           // True if columns 73-80 contain PDB ID

    CTitleContainer ObsData;     // obsoletion data
    CTitleContainer Title;       // title data
    CTitleContainer CAVEAT;      // error data
    CTitleContainer Compound;    // compound data
    CTitleContainer Source;      // source
    CKeyWords       KeyWords;    // key words
    CTitleContainer ExpData;     // experimental data
    CTitleContainer Author;      // author data
    CTitleContainer RevData;     // revision data
    CTitleContainer Supersede;   // supersede records
    CTitleContainer Journal;     // journal records
    CTitleContainer Remark;      // remark records

    void  Init();

};

extern void  TestHeader();
extern void  TestTitle (); // reads PDB title from file 'in.title'
                           // and rewrites it into 'out.title' and
                           // 'abin.title'

#endif

