//  $Id: mmdb_manager.cpp,v 1.7 2005/12/19 16:51:28 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    21.11.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  mmdb_manager  <implementation>
//       ~~~~~~~~~
//  **** Project :  MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//  **** Classes :  CMMDBManager  ( MMDB file manager class )
//       ~~~~~~~~~
//
//  E. Krissinel 2001-2003
//
//  =================================================================
//


#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __MMDB_Manager__
#include "mmdb_manager.h"
#endif


//  =====================   CMMDBManager   =======================

CMMDBManager::CMMDBManager() : CMMDBBondManager()  {
}

CMMDBManager::CMMDBManager ( RPCStream Object )
            : CMMDBBondManager(Object)  {
}

CMMDBManager::~CMMDBManager()  {}

void  CMMDBManager::Copy ( PCMMDBManager MMDB, word CopyMask )  {
int i;

  if (CopyMask & MMDBFCM_Flags)  Flags = MMDB->Flags;

  if (CopyMask & MMDBFCM_Title)  Title.Copy ( &(MMDB->Title) );
  if (CopyMask & MMDBFCM_Cryst)  Cryst.Copy ( &(MMDB->Cryst) );

  if (CopyMask & MMDBFCM_Coord)  {

    FreeCoordMemory    ();
    DeleteAllSelections();

    nAtoms = MMDB->nAtoms;
    AtmLen = nAtoms;
    if (nAtoms>0)  {
      Atom = new PCAtom[AtmLen];
      for (i=0;i<nAtoms;i++)  {
        if (MMDB->Atom[i])  {
          Atom[i] = newCAtom();
          Atom[i]->Copy ( MMDB->Atom[i] );
          // the internal atom references are installed
          // by residue classes when they are read in
          // model->chain below
          Atom[i]->SetAtomIndex ( i+1 );
        } else
          Atom[i] = NULL;
      } 
    }

    nModels = MMDB->nModels;
    if (nModels>0)  {
      Model = new PCModel[nModels];
      for (i=0;i<nModels;i++)  {
        if (MMDB->Model[i])  {
          Model[i] = newCModel();
          Model[i]->SetMMDBManager ( this,0 );
          Model[i]->_copy ( MMDB->Model[i] );
        } else
          Model[i] = NULL;
      } 
    }

    crModel = NULL;
    crChain = NULL;
    crRes   = NULL;

    if (MMDB->crModel)  {

      for (i=0;i<nModels;i++)
        if (Model[i])  {
          if (Model[i]->serNum==MMDB->crModel->serNum)  {
            crModel = Model[i];
            break;
          }
        }

      if (crModel && crModel->Chain && MMDB->crChain)
        for (i=0;i<crModel->nChains;i++)
          if (crModel->Chain[i])  {
            if (!strcmp(crModel->Chain[i]->chainID,
                        MMDB->crModel->Chain[i]->chainID))  {
              crChain = crModel->Chain[i];
              break;
            }
          }

      if (crChain && crChain->Residue && MMDB->crRes)
        for (i=0;i<crChain->nResidues;i++)
          if (crChain->Residue[i])  {
            if ((!strcmp(crChain->Residue[i]->name,
                         MMDB->crRes->name))                       &&
                (crChain->Residue[i]->seqNum==MMDB->crRes->seqNum) &&
                (!strcmp(crChain->Residue[i]->insCode,
                         MMDB->crRes->insCode)))  {
              crRes = crChain->Residue[i];
              break;
            }
          }
    }

    /*
    if ((MMDB->nSelections>0) && MMDB->Mask)  {
      nSelections = MMDB->nSelections;
      if (nSelections>0)  {
        Mask      = new PCMask [nSelections];
        SelAtom   = new PPCAtom[nSelections];
        nSelAtoms = new int    [nSelections];
        for (i=0;i<nSelections;i++)  {
          Mask[i] = new CMask();
          Mask[i]->CopyMask ( MMDB->Mask[i] );
          nSelAtoms[i] = MMDB->nSelAtoms[i];
          if (nSelAtoms[i]>0)  {
            SelAtom[i] = new PCAtom[nSelAtoms[i]];
            for (j=0;j<nSelAtoms[i];j++)
              SelAtom[i][j] = Atom[MMDB->SelAtom[i][j]->index];
          } else
            SelAtom[i] = NULL;
        }
      }
    }
    */

  }
 
  if (CopyMask & MMDBFCM_SA)  SA.Copy ( &(MMDB->SA) );
  if (CopyMask & MMDBFCM_SB)  SB.Copy ( &(MMDB->SB) );
  if (CopyMask & MMDBFCM_SC)  SC.Copy ( &(MMDB->SC) );
  if (CopyMask & MMDBFCM_Footnotes)
                       Footnote.Copy ( &(MMDB->Footnote) );

  if (CopyMask & MMDBFCM_Buffer)  {
    lcount = MMDB->lcount;
    strncpy ( S,MMDB->S,sizeof(S) );
  }

} 

void  CMMDBManager::Delete ( word DelMask )  {
PPCModel model;
PPCChain chain;
int      i,j,nm, nchains;

  if (DelMask & MMDBFCM_Flags)  Flags = 0;

  if (DelMask & MMDBFCM_Title)  Title.Copy ( NULL );
  if (DelMask & MMDBFCM_Cryst)  Cryst.Copy ( NULL );

  if (DelMask & MMDBFCM_Coord)  {
    FreeCoordMemory    ();
    DeleteAllSelections();
  }

  if (DelMask & MMDBFCM_SecStruct)  {
    GetModelTable ( model,nm );
    if (model)
      for (i=0;i<nm;i++)
        if (model[i])
          model[i]->RemoveSecStructure();
  }

  if (DelMask & MMDBFCM_HetInfo)  {
    GetModelTable ( model,nm );
    if (model)
      for (i=0;i<nm;i++)
        if (model[i])
          model[i]->RemoveHetInfo();
  }

  if (DelMask & MMDBFCM_ChainAnnot)  {
    nm = GetNumberOfModels();
    for (i=1;i<=nm;i++)  {
      GetChainTable ( i,chain,nchains );
      if (chain)
        for (j=0;j<nchains;j++)
          if (chain[j])
            chain[j]->FreeAnnotations();
    }
  }
 
  if (DelMask & MMDBFCM_SA)        SA.FreeContainer();
  if (DelMask & MMDBFCM_SB)        SB.FreeContainer();
  if (DelMask & MMDBFCM_SC)        SC.FreeContainer();
  if (DelMask & MMDBFCM_Footnotes) Footnote.FreeContainer();

  if (DelMask & MMDBFCM_Buffer)  {
    lcount = 0;
    S[0]   = char(0);
  }

}

PCTitleContainer CMMDBManager::GetRemarks()  {
  return Title.GetRemarks();
}


//  -------------------  Stream functions  ----------------------


void  CMMDBManager::write ( RCFile f )  {
byte Version=1;
  f.WriteByte ( &Version );
  CMMDBBondManager::write ( f );
}

void  CMMDBManager::read ( RCFile f )  {
byte Version;
  f.ReadByte ( &Version );
  CMMDBBondManager::read ( f );
}


MakeStreamFunctions(CMMDBManager)
