# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Basic spectrum definition.


class spectrum:
    """ Basic spectrum definition. """

    # ----
    def __init__(self):
        self.stored = []
        self.spectrum = []
    # ----


    # ----
    def setSpectrum(self, spectrum, store=False):
        """ Set new points to spectrum. """
        self.spectrum = spectrum
        if store:
            self.store()
    # ----


    # ----
    def getSpectrum(self):
        """ Get spectrum points. """
        return self.spectrum
    # ----


    # ----
    def getXRange(self):
        """ Get spectrum mass range. """
        if self.spectrum:
            minX = min(self.spectrum)[0]
            maxX = max(self.spectrum)[0]
            return (minX, maxX)
        else:
            return None
    # ----


    # ----
    def getLength(self):
        """ Get number of points in the spectrum. """
        return len(self.spectrum)
    # ----


    # ----
    def revert(self):
        """ Revert spectrum data to original. """
        self.spectrum = self.stored[:]
    # ----


    # ----
    def store(self):
        """ Store current spectrum data as main for undo. """
        self.stored = self.spectrum[:]
    # ----
